/**************************************************************************
 		p⢮ MY: (3"/5" )
		   p PDP-11

**************************************************************************/
#include	"pdp11dev.h"
#include	<string.h>
#include	<stdio.h>

/**************************************************************************
		⥬ ࠬ
**************************************************************************/

extern unsigned		_stklen 	= 128;
extern unsigned		_heaplen	= 1024;

byte		Buffer[01000];		// 䠩 p
byte far	*MEMORY	= NULL;		// p⨢ 
uns  far	*IRQ	= NULL;		// ᫮ pᮢ pp.
uns		IRQ_M	= 0;		// ᪠ p


char		*MY0Name     	= "MY:";	//
char		*MYxName     	= "MY0:";	//  p⢠  BOOT

/**************************************************************************
		p  設 PDP-11
**************************************************************************/

#define		BUS_CR	0172140		// ॣ /ﭨ
#define		BUS_DT	0172142		// ॣ 
#define		BUS_VEC	0170		//  뢠

uns	MY_CR;				//  ॣ /ﭨ
uns	MY_DT;				//  ॣ 

//    MY_CR
int	MY_DONE;			// ⮢ 樨
int	MY_TR;				// ॡ 
int	MY_ERR;				// 訡 樨

//  ஫
#define		CMD_RD		000	// ⥭
#define		CMD_WR		002	// 
#define		CMD_RDM		004	// ⥭  ⪮
#define		CMD_WRM		006	//   ⪮
#define		CMD_RDTR	010	// ⥭ ஦
#define		CMD_RDID	012	// ⥭ 
#define		CMD_FORM	014	// ଠ஢ ஦
#define		CMD_SEEK	016	//  ஦
#define		CMD_SET		020	//  ࠬ஢
#define		CMD_RDER	022	// ⥭ ॣ ﭨ
#define		CMD_LOAD	036	// 㧪

/**************************************************************************
		 ࠬ஢ 樨 (⠥  )
**************************************************************************/

byte	MY_DRV;				//  ன⢠, 
byte	MY_EA;				// ७  
uns	MY_BUFF;			//   
byte	MY_SECT;			//  ᥪ  1..10
byte	MY_TRK;				//  樫 0..79
uns	MY_WCNT;			// 稪 ᫮  ।

uns	Get_Word	(char far *P)	{
uns	D;
asm	{
	les	bx,P
	mov	ax,[es:bx]
	mov	D,ax
	}
return(D);
}	// Get_Word

void	Get_PARAMS(void)	{
MY_DRV  = MEMORY[MY_DT];
MY_EA   = MEMORY[MY_DT+1];
MY_BUFF = Get_Word(&MEMORY[MY_DT+2]);
MY_SECT = MEMORY[MY_DT+4];
MY_TRK  = MEMORY[MY_DT+5];
MY_WCNT = Get_Word(&MEMORY[MY_DT+6]);
}	// Get_PARAMS

/**************************************************************************
		㭪 p饭   p BIOS
**************************************************************************/

#define	DiskWrite	3		//    INT 13h
#define	DiskRead	2
#define	Retry		8		// - p p 訡

void	DiskReset(byte drv)	{
_DL = drv;
_AH = 0;
asm	int	13h     // Call Disk_I/O Reset
}	// DiskReset

int	BiosDisk	(byte cmd, byte drv, byte head,
			byte trk, byte sect, char far *Buffer)	{
int register	AH;
_DL = drv;		// p p⢠
_DH = head;		// 
_CH = trk;		// 樫
_CL = sect;		// ᥪ
_AH = cmd;		//    INT 13H
_AL = 1;		// ⮫쪮  ᥪ()
asm	{
	les	bx,Buffer
	int	13h		// Call Disk_I/O BIOS-function
	pushf
	pop	AX
}
AH = _AX;
if ((AH & 0x01) == 0)	return(0);	// ⮢ !!!
DiskReset(drv);
return(1);			// 訡 !
}	// BiosDisk

/**************************************************************************
		ࠧ ...
**************************************************************************/

void	cprintf	(char *str)	{
char	C;
while ((C = *str++) != NULL)	{
	_AH = 0x0E;
	_AL = C;
	asm	int	10h
	}
}	/* cprintf */

int	CmpName	(char far *Name)	{
if (!(_fstricmp(Name,MK_FP(_DS,MY0Name))))	{
	MY_DRV = 0;
	return 0;
	}
else	{
	MYxName[2] = Name[2];
	MY_DRV = Name[2] - '0';
	if ((!(_fstricmp(Name,MK_FP(_DS,MYxName)))) && (MY_DRV <= 7))
		return 0;
	}
return(1);
}	// CmpName

/**************************************************************************
		. 樨
**************************************************************************/

void	Call_TRAP(void)	{
*IRQ |= IRQ_M;
}	// Call_TRAP

void	Clr_TRAP(void)	{
*IRQ &= ~IRQ_M;
}	// Ctr_TRAP

void	Set_ENI(byte D)	{
if (D == 0)	{			//  ENI
	Clr_TRAP();
	MY_CR &= ~0100;
	}
else	{				// . ENI
	if ((MY_CR & 0100) != 0)	return;
	MY_CR |= 0100;
//	if (MY_DONE != 0)		Call_TRAP();
	}
}	// Set_ENI

void	Set_RDY(byte D)	{
if (D == 0)	{
	Clr_TRAP();
	MY_DONE = 0;
	}
else	{
	if (MY_DONE != 0)		return;
	MY_DONE = 1;
	if ((MY_CR & 0100) != 0)	Call_TRAP();
	}
}	// Set_RDY

void	Reset_MY(void)	{
MY_CR = 0;
MY_DT = 0;
MY_TR = 0;
Set_ENI(0);
Set_RDY(1);
}	// Reset_MY

/**************************************************************************
		饭  ॣࠬ MY:
**************************************************************************/

uns	Get_MYCR(void)	{
uns	D = MY_CR & 037400+0100+036;	// ⠥  MY_CR
if (MY_TR   != 0)	D |= 0200;	// ॡ 
if (MY_DONE != 0)	D |= 0040;	// ⮢ 樨
if (MY_ERR  != 0)	D |= 0100000;	// 訡 樨
return(D);
}	// Get_MYCR

void	Put_MYCR(uns D)	{
MY_CR  = D;
if ((MY_CR & 040000) != 0)	{	Reset_MY(); return;	}
if ((MY_CR & 001) != 0)	{		// GO !!!
	MY_ERR = 0;
//  樨; 訢 
	Set_RDY(0);
	MY_TR = 1;
	}
Set_ENI(D & 0100);
}	// Put_MYCR

void	Make_Data	(byte CMD, char far *BUFF)	{
MY_ERR = BiosDisk(CMD,MY_DRV&1,(MY_DRV>>2)&1,MY_TRK,MY_SECT,BUFF);
}	// Make_Data

void	fmove	(char far *dst, char far *src, uns bcnt)	{
while (bcnt--)	*dst++ = *src++;
}	// fmove

uns	Get_MYDT(void)	{
MY_TR = 0;
return(MY_DT);
}	// Get_MYDT

void	Put_MYDT(uns D)	{
//char	*BF;
MY_TR = 0;
MY_DT = D;
if (MY_DONE != 0)	return;		// ᪠ 樨  뫮 !!!
// ਭ ᫮ ; 稭 ࠧ 
switch (MY_CR & 036)	{
case CMD_RD:		// ⥭
		Get_PARAMS();
		while (MY_WCNT > 0)
		  if (MY_WCNT >= 256)	{
			Make_Data(DiskRead,&MEMORY[MY_BUFF]);
			MY_WCNT -= 256;
			MY_BUFF += 512;
			}
		  else	{
			Make_Data(DiskRead,Buffer);
			fmove(&MEMORY[MY_BUFF],MK_FP(_DS,Buffer),MY_WCNT*2);
			MY_BUFF += MY_WCNT*2;
			MY_WCNT = 0;
			}
		break;
case CMD_WR:		// 
		Get_PARAMS();
		while (MY_WCNT > 0)
		  if (MY_WCNT >= 256)	{
			Make_Data(DiskWrite,&MEMORY[MY_BUFF]);
			MY_WCNT -= 256;
			MY_BUFF += 512;
			}
		  else	{
			fmove(MK_FP(_DS,Buffer),&MEMORY[MY_BUFF],MY_WCNT*2);
			Make_Data(DiskWrite,Buffer);
			MY_BUFF += MY_WCNT*2;
			MY_WCNT = 0;
			}
		break;
case CMD_SEEK:		//  ஦
		MY_DRV  = MEMORY[MY_DT];
		MY_TRK  = MEMORY[MY_DT+1];
		MY_SECT = 1;
		Make_Data(DiskRead,Buffer);
		break;
case CMD_RDER:		// ⥭ ॣ ﭨ
		break;
// 믮 
case CMD_SET:		//  ࠬ஢
case CMD_RDM:		// ⥭  ⪮
case CMD_WRM:		//   ⪮
case CMD_RDTR:		// ⥭ ஦
case CMD_RDID:		// ⥭ 
case CMD_FORM:		// ଠ஢ ஦
case CMD_LOAD:		// 㧪
		break;
}
Set_RDY(1);				//  襭
}	// Put_MYDT

/**************************************************************************
		p⪠ pp뢠  p饭  FY:
**************************************************************************/

void interrupt	(* SysInt60)(void);	// ᫥. pp뢠

void	UnLoad	(void)	{		// p   !!!
cprintf("MY.EXE aborted.\r\n");
asm	cli
setvect(PDPvec,SysInt60);
freemem(*(unsigned*)MK_FP(_psp,0x2c));
freemem(_psp);
asm	sti
}	// UnLoad

void interrupt	FY_sys
	(uns BP,uns DI,uns SI,uns DS,
	 uns ES,uns DX,uns CX,uns BX,uns AX)	{

switch(AX >> 8)	{
	case	TRAP:			// ⥭  뢠
			if ((*IRQ & IRQ_M) == 0)	break;
			Clr_TRAP();
			DX = BUS_VEC;
			AX = 0;
			return;
	case	READW:			// ⥭ ᫮
	case	READB:			// ⥭ 
			switch(BX)	{
			case BUS_CR:	DX = Get_MYCR(); AX = 0; return;
			case BUS_DT:	DX = Get_MYDT(); AX = 0; return;
			}
			break;
	case	WRITEB:			//  
	case	WRITEW:			//  ᫮
			switch(BX)	{
			case BUS_CR:	Put_MYCR(DX); AX = 0; return;
			case BUS_DT:	Put_MYDT(DX); AX = 0; return;
			}
			break;
	case	BOOT:			// ⮢ 㧪
//			DiskReset(Drive);
			if (CmpName(MK_FP(ES,BX))) break;
			if (MEMORY == NULL)	AX = 0xFF; else
			if ((MY_ERR = BiosDisk(DiskRead,MY_DRV&1,
						(MY_DRV>>2)&1,
						MY_TRK,MY_SECT,
						MEMORY))
			!=0)	AX = 0xFF; else	AX = 0;
			return;
	case	INIT:			// 砫쭠 ⠭
			IRQ = MK_FP(ES,BX);	// ᫮ pᮢ pp.
			IRQ_M = DX;		// ᪠ p
			DX <<= 1;
	case	RESET:			// p p⢠
			Reset_MY();
//			DiskReset(MY_DRV&1);
			break;
	case	DMA:			// p   
			MEMORY = MK_FP(ES,BX);
			break;
	case ABORT:	UnLoad();	// p㧪   !!!
			break;
}	/*case*/

if (SysInt60 == NULL)	return;
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();
AX = _AX;
DX = _DX;
}	/* FY_sys */

void	main(void)	{

if ((SysInt60 = getvect(PDPvec)) != NULL)	{
	_BX = BUS_CR;
	_AH = READW;
	asm	int	60h
	if (_AL == 0)	{
		cprintf("MY.EXE already resident !\r\n");
		return;
		}
	}

setvect(PDPvec,FY_sys);
cprintf("MY.EXE DEC floppy disk device driver loaded.\r\n");

keep(0,(_SS + (_SP/16) - _psp));
}	/* main(MY) */
