/************************************************************************
	[OWA] HArd & Soft	  "" (0842) 31-42-30
			ᨥ ..
		  PDP11

		  ( -60)

************************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<alloc.h>
#include	<io.h>
#include	<fcntl.h>
#include	<ctype.h>
#include	<dos.h>

#include	"make_sys.h"
#include	"make_mk.h"

#define		CR	015
#define		LF	012

int	key = CR;
uns	Data = 0;
uns	Addr = 0;
char	Dmdf = 0;
char	Amdf = 0;
char	Rinp = 0;
char	str[80];

byte	M_data	= 0;
char	*HALT_msg[]	= {
		" QUIT COMMAND",
		" HALT INSTRUCTION",
		" VECTOR READ ERROR",
		" INTERRUPT STACK ERROR",
		" STOP INTERRUPT",
		" DEBUG STOP",
		};

uns	S,F;
long	fL;
int	handle;
byte	C;

void	StrUp(char *str)	{	// ப -  孨 ॣ
while (*str)	*str++ = toupper(*str);
}	// StrUp

void	TTOUT(char C)	{		// ᨬ -  ନ
int	D;
do	BUS_Get((READB<<8)+0xFF,TToutCSR,0,(uns near *)&D);
while 	((D & TTioREADY) == 0);
BUS_Put((WRITEW<<8)+0xFF,TToutDAT,0,C);
}	// TTOUT

char	TTIN(void)	{		//  ᨬ  
int	D;
do  {	do	BUS_Get((READB<<8)+0xFF,TTinCSR,0,(uns near *)&D);
	while 	((D & TTioREADY) == 0);
	BUS_Get((READB<<8)+0xFF,TTinDAT,0,(uns near *)&D);
    }
while(D == 0);
return(D);
}	// TTIN

void	putstr(char *str)	{	//  ப  ନ
while (*str != 0)	TTOUT(*str++);
}	// putstr

void	getstr(char *str)	{	//  ப  ନ
char	C;
do  {	TTOUT(C = toupper(TTIN()));	if (C == CR) C = 0;
	*str++ = C;
    }
while	(C);
TTOUT(LF);
}	// getstr

void	printMData(void)	{
uns	Data;
if (Rinp)	Data = MEMORY.W.REG[Addr];
else	if (BUS_GetW(Addr,&(int)Data))	{
		putstr("/ ** READ BUS ERROR\r\n@");
		Amdf = 0;
		return;
		}
sprintf(str,"/%06o ",Data);
putstr(str);
}	// printMData

void	PutMemData(void)	{
if (Dmdf == 0)	return;
Dmdf = 0;
if (Amdf == 0)	return;
if (Rinp)
	MEMORY.W.REG[Addr] = Data;
else	{
	if (BUS_PutW(Addr,Data))
		putstr(" ** WRITE BUS ERROR\r\n@");
	Amdf = 0;
	}
}	// PutMemData

void	printAData(void)	{
putstr("\r\n");
if (Rinp == 0)	sprintf(str,"%06o ",Addr);
else	if (Addr == 8)
		sprintf(str,"RS ");
	else    sprintf(str,"R%o ",Addr);
putstr(str);
printMData();
}	// printAData

char	ODT_flag	= 0;

void	PriD(uns Addr)	{
uns	i;
sprintf(str,"%06o/ ",Addr);	putstr(str);
for (i=0; i<3; i++)	{
	if (Addr > MEMTOP)
		putstr("****** ");
	else {	sprintf(str,"%06o ",MEMORY.W.WORD[Addr>>1]);
		putstr(str);
		}
	Addr += 2;
	}
putstr("\r\n");
}	// PriD

void	Debugger(void)	{
int	i;
for (i=0;i<6;)	{
	sprintf(str,"R%o: %06o    ",i,MEMORY.W.REG[i]);
	putstr(str);
	i++;
	if (!(i & 3)) putstr("\r\n");
	}
sprintf(str,"SP: %06o   PSW: %06o\r\n",MEMORY.W.REG[6],MEMORY.W.REG[8]);
putstr(str);
putstr("PC:    ");	PriD(MEMORY.W.REG[7]);
putstr("CODE:  ");	PriD(PC);
}	// Debugger

int	console(void)	{		// ⮢ ० ନ

Addr = 0;
Data = 0;
Amdf = 0;
Dmdf = 0;
Rinp = 0;

sprintf(str,"\r\n%06o\n\r@",MEMORY.W.REG[7]);
putstr(str);

while ((key = toupper(TTIN())) != 'Q')	{

if ((key>='0') && (key<='7'))
	{	TTOUT(key);
		if (Dmdf == 0)	Data = 0;
		Dmdf = 1;
		Data = Data*010+key-'0';
		if (Amdf == 0)	Rinp = 0;
	}
else	switch(key)	{
case '/':	if (Dmdf != 0)	Addr = Data & 0177776;
		Dmdf = 0;
		Amdf = 1;
		printMData();
		break;
case '-':
case '^':	PutMemData();
		if (Rinp == 0)
			Addr -= 2;
		else	if (Addr == 0)
				goto ret;	// Addr = 8;
			else	Addr -= 1;
		Amdf = 1;
		printAData();
		break;
case '+':
case LF:       PutMemData();
		if (Rinp == 0)
			Addr += 2;
		else	if (Addr < 8)
				Addr += 1;
			else	goto ret;	// Addr = 0;
		Amdf = 1;
		printAData();
		break;
case CR:
ret:		PutMemData();
		Amdf = 0;
		putstr("\r\n@");
		break;
case 'R':	TTOUT('R');
		Dmdf = 0;
		Amdf = 0;
		key = toupper(TTIN());
		TTOUT(key);
		if ((key>='0') && (key<='7'))	Addr = key-'0';
		else	if (key == 'S')	Addr = 8;
			else	{
				putstr("\r\n@\7");
				break;
			}
		TTOUT(' ');
		Rinp = 1;
		break;
case 'G':	if (Dmdf == 0)
			MEMORY.W.REG[7] = 0;
		else	MEMORY.W.REG[7] = Data & 0177776;
case 'L':
case 'B':
case 'P':	TTOUT(key);
		return(key);
case 'M':	TTOUT(key);
		putstr("\r\n ");
		putstr(HALT_msg[M_data]);
		putstr("\r\n@");
		Amdf = 0;
		break;
case 'D':	ODT_flag = ~ODT_flag;
		if (ODT_flag)
			putstr("DEBUG ON\r\n@");
		else	putstr("DEBUG OFF\r\n@");
		break;
/*
case 'A':	TTOUT(key);
		if (Dmdf)
			ODT_Addr = Data;
		else	ODT_Addr = -1;
		Dmdf = 0;
		putstr("\r\n@");
		break;
*/
default:	TTOUT(7);
	}
}
return(0);
}	// console

void	LoadTMS(void)	{
int	handle;
putstr("\r\nLOAD TMS FILE: ");
getstr(str);
BUS_Init();
if ((handle = open(str,O_BINARY)) == -1)	{
	putstr("OPEN ERROR\r\n"); return; }
if (read(handle,MEMORY.B.BYTE,(uns)filelength(handle)) == -1)	{
	putstr("READ ERROR\r\n"); return; }
close(handle);
MEMORY.W.REG[7] = 0200;
MEMORY.W.REG[8] = 0340;
}	// LoadTMS

byte	DeviceBOOT(char *str)	{
BUS_Init();
MEMORY.W.REG[7] = 0;
MEMORY.W.REG[8] = 0340;
StrUp(str);
putstr("\r\nBOOT ");
putstr(str);
putstr("\r\n\n");
if (BUS_Boot(str))	{
	putstr("DEVICE NOT AVAILABLE\r\n"); return(1); }
return(0);
}	// DeviceBOOT

/**********************************************************************
 *      MAIN -- 窠 室  ணࠬ
 */

void	main(int argc, char **argv)	{

printf("\n");

MEMORY.W.REG[6] = MEMTOP;		// ⥪ -  
MEMORY.W.REG[8] = I_bit;		// 뢠 饭

BUS_Load();			// . ନ
BUS_Init();			//  

putstr("\r\n=== PDP-11/03 processor hardware simulator V03.03a (8086)\r\n");
putstr("\r\n    <F10> - halt, <F9> - timer, <F10>,'Q' - quit to DOS\r\n");

if (argc > 1)	{
	strcpy(str,argv[1]);
	goto boot;	}

begin:
while ((C = console()) != 0)	{
	switch(C)	{
case 'L':	LoadTMS();
		break;
case 'B':	putstr("\r\nBOOT DEVICE: ");
		getstr(str);
boot:		Make_RESET();
		if (DeviceBOOT(str)) goto begin;
		goto start;
case 'G':	Make_RESET();
case 'P':
start:		M_data = Make_PDP();		// ࠢ -  !
		putstr("\r\n");
		putstr(HALT_msg[M_data]);
		putstr("\r\n");
		if (ODT_flag)	Debugger();
		if (M_data == ExitCode_QUIT)	goto quit;
		break;
	}
}
quit:
putstr("\r\n\n=== PDP-11/03 processor halted.\r\n");
BUS_Done();
BUS_UnLoad();

}	// main
