#define		ExitCode_QUIT	0	//  QUIT
#define		ExitCode_HALT	1	//  HALT
#define		ExitCode_VECT	2	// 訡 ⥭ p
#define		ExitCode_TRAP	3	// 訡 設 p pp뢠
#define		ExitCode_STOP	4	// 譨 HALT
#define		ExitCode_DEBUG	5	// ⠭  ⫠稪

#define		MEMTOP		0160000	// pp p⨢ 

#define		byte	unsigned char
#define		uns	unsigned

typedef uns	TypCPUREG[10];		// ॣ  PDP-11

typedef	struct	{
	TypCPUREG	REG;
	uns		WORD[MEMTOP/2];
	}	WORDMEM;		// +ॣ (16 )

typedef	struct	{
	TypCPUREG	REG;
	byte		BYTE[MEMTOP];
	}	BYTEMEM;		// +ॣ (8 )

typedef	union	{
	WORDMEM	W;
	BYTEMEM	B;
	}	TypMEMORY;




#define		I_bit		0200	//  pp襭 pp뢠
#define		T_bit		020	// T-
#define		N_bit		010	// N-
#define		Z_bit		004	// Z-
#define		V_bit		002	// V-
#define		C_bit		001	// C-
#define		NZ_bit		014	// N+Z
#define		VC_bit		003	// V+C
#define		NZV_bit		016	// N+Z+V
#define		NZVC_bit	017	//  

#define		V_ibm	0x800		// OF-flag
#define		N_ibm	0x80		// SF
#define		Z_ibm	0x40		// ZF
#define		C_ibm	0x01		// CF

extern	uns	PSW;		// ᫮ ﭨ pp (PDP11)

extern	uns	CODE;		//  
extern	uns	IRQ;		// p pp뢠 . p
extern	int	SRC,DST;	// p㬥 
extern	uns	DST_Addr;	// p p-p
//extern	uns	ODT_Addr;	// p ⠭
extern	byte	T_flag;		// T-

extern	uns	PC;		//    ⫠稪

extern	TypMEMORY	MEMORY;	// ॣ   ⨢ 

byte	Make_PDP(void);
