/************************************************************************
	[OWA] HArd & Soft	  "" (0842) 31-42-30
			ᨥ ..
		  PDP11

		  PDP-11

************************************************************************/
#include	"make_sys.h"
#include	"make_mk.h"
#include	"srcdst.h"
#include	"make_bit.h"

byte near	Make_TRAP10   (void)	{	// XXXXXXX ----    TRAP10   ------
_ES = FP_SEG(&MEMORY.B.BYTE);
_BX = FP_OFF(&MEMORY.B.BYTE);
_DX = FP_OFF(&MEMORY.B.REG);
_CX = CODE;
_AL = 010;
_AH = TRAP10;
asm	int	60h
return(_AL);
}	// Make_TRAP10

byte near	Make_BR   (void)	{	// 0004XXX ----    BR      ------
MEMORY.W.REG[7] += (signed char)CODE*2;
return(0);
}	// Make_BR

byte near	Make_BNE  (void)	{	// 0010XXX ----    BNE     ------
if ((byte)PSW & Z_bit)	return(0);
return(Make_BR());
}	// Make_BNE

byte near	Make_BEQ  (void)	{	// 0014XXX ----    BEQ     ------
if ((byte)PSW & Z_bit)	return(Make_BR());
return(0);
}	// Make_BEQ

byte near	Make_BGE  (void)	{	// 0020XXX ----    BGE     ------
if (((byte)PSW & N_bit) && ((byte)PSW & V_bit))	return(Make_BR());
if (((byte)PSW & N_bit) || ((byte)PSW & V_bit))	return(0);
return(Make_BR());
}	// Make_BGE

byte near	Make_BLT  (void)	{	// 0024XXX ----    BLT     ------
if (((byte)PSW & N_bit) && ((byte)PSW & V_bit))	return(0);
if (((byte)PSW & N_bit) || ((byte)PSW & V_bit))	return(Make_BR());
return(0);
}	// Make_BLT

byte near	Make_BGT  (void)	{	// 0030XXX ----    BGT     ------
if ((byte)PSW & Z_bit)	return(0);
if (((byte)PSW & N_bit) && ((byte)PSW & V_bit))	return(Make_BR());
if (((byte)PSW & N_bit) || ((byte)PSW & V_bit))	return(0);
return(Make_BR());
}	// Make_BGT

byte near	Make_BLE  (void)	{	// 0034XXX ----    BLE     ------
if ((byte)PSW & Z_bit)	return(Make_BR());
if (((byte)PSW & N_bit) && ((byte)PSW & V_bit))	return(0);
if (((byte)PSW & N_bit) || ((byte)PSW & V_bit))	return(Make_BR());
return(0);
}	// Make_BLE

byte near	Make_BPL  (void)	{	// 1000XXX ----    BPL     ------
if ((byte)PSW & N_bit)	return(0);
return(Make_BR());
}	// Make_BPL

byte near	Make_BMI  (void)	{	// 1004XXX ----    BMI     ------
if ((byte)PSW & N_bit)	return(Make_BR());
return(0);
}	// Make_BMI

byte near	Make_BHI  (void)	{	// 1010XXX ----    BHI     ------
if ((byte)PSW & Z_bit)	return(0);
if ((byte)PSW & C_bit)	return(0);
return(Make_BR());
}	// Make_BHI

byte near	Make_BLOS (void)	{	// 1014XXX ----    BLOS    ------
if ((byte)PSW & Z_bit)	return(Make_BR());
if ((byte)PSW & C_bit)	return(Make_BR());
return(0);
}	// Make_BLOS

byte near	Make_BVC  (void)	{	// 1020XXX ----    BVC     ------
if ((byte)PSW & V_bit)	return(0);
return(Make_BR());
}	// Make_BVC

byte near	Make_BVS  (void)	{	// 1024XXX ----    BVS     ------
if ((byte)PSW & V_bit)	return(Make_BR());
return(0);
}	// Make_BVS

byte near	Make_BCC  (void)	{	// 1030XXX ----    BCC     ------
if ((byte)PSW & C_bit)	return(0);
return(Make_BR());
}	// Make_BCC

byte near	Make_BCS  (void)	{	// 1034XXX ----    BCS     ------
if ((byte)PSW & C_bit)	return(Make_BR());
return(0);
}	// Make_BCS

byte near	Make_JSR  (void)	{	// 004RDD  ----    JSR     ------
uns register	R	= (CODE & 0700) >> 6;
if (!(CODE & 070))	return(04);
if ((_AL = (*Tabl_GetJmp[CODE & 077])())!=0)	return(_AL);
if ((_AL = Push_SP(MEMORY.W.REG[R]))!=0)		return(_AL);
MEMORY.W.REG[R] = MEMORY.W.REG[7];
MEMORY.W.REG[7] = DST_Addr;
return(0);
}	// Make_JSR

byte near	Make_MOV  (void)	{	// 01SSDD  ++0-    MOV     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST = SRC;
(byte)PSW &= ~NZV_bit;
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_MOV

byte near	Make_CMP  (void)	{	// 02SSDD  ++++    CMP     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
SRC -= DST;
Flag_NZVC;
return(0);
}	// Make_CMP

byte near	Make_BIT  (void)	{	// 03SSDD  ++0-    BIT     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
SRC &= DST;
Flag_NZ;
return(0);
}	// Make_BIT

byte near	Make_BIC  (void)	{	// 04SSDD  ++0-    BIC     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST &= ~SRC;
Flag_NZ;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_BIC

byte near	Make_BIS  (void)	{	// 05SSDD  ++0-    BIS     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST |= SRC;
Flag_NZ;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_BIS

byte near	Make_ADD  (void)	{	// 06SSDD  ++++    ADD     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST += SRC;
Flag_NZVC;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ADD

byte near	Make_MUL  (void)	{	// 070RSS  ++0+    MUL     ------
return(Make_TRAP10());	/*
uns register	R = (CODE & 0700) >> 6;
signed long register	L;
if ((_AL = (*Tabl_GetSRC_W[CODE & 077])())!=0)	return(_AL);
L = (signed int)MEMORY.W.REG[R];
L *= SRC;
(byte)PSW &= ~NZV_bit;
Check_bitW_NZ(L);
MEMORY.W.REG[R] = (uns)(L >> 16);		// . 
MEMORY.W.REG[R|1] = (uns)L;			// . 
return(0);
*/
}	// Make_MUL

byte near	Make_DIV  (void)	{	// 071RSS  ++++    DIV     ------
return(Make_TRAP10());	/*
uns register	R = (CODE & 0700) >> 6;
int register	D;
signed long register	L;
if ((_AL = (*Tabl_GetSRC_W[CODE & 077])())!=0)	return(_AL);
if (SRC == 0)	{			//  0    !!!
	(byte)PSW |= V_bit;
	return(0);
	}
L = MEMORY.W.REG[R];
L = (L<<16)|MEMORY.W.REG[R|1];
MEMORY.W.REG[R|1] = (uns)(L % SRC);		// ⮪
L /= SRC;				// ⭮
D = (uns)L;
MEMORY.W.REG[R] = D;
Check_bitW_NZ(D);
R = (uns)(L>>16);		// .  p
if ((R == 0) || (R == 0xFFFF))
	(byte)PSW &= ~V_bit;
else	(byte)PSW |= V_bit;
return(0);
*/
}	// Make_DIV

byte near	Make_ASH  (void)	{	// 072RSS  ++++    ASH     ------
return(Make_TRAP10());	/*
uns register	R = (CODE & 0700) >> 6;
int register	D;
if ((_AL = (*Tabl_GetSRC_W[CODE & 077])())!=0)	return(_AL);
D = MEMORY.W.REG[R] << SRC;
asm { 	pushf;	pop AX    }	A = _AX;
if (A & 1)		(byte)PSW |= C_bit; else (byte)PSW &= ~C_bit;
if (A & V_ibm)		(byte)PSW |= V_bit; else (byte)PSW &= ~V_bit;
MEMORY.W.REG[R] = D;
Check_bitW_NZ(D);
return(0);
*/
}	// Make_ASH

byte near	Make_ASHC (void)	{	// 073RSS  ++++    ASHC    ------
return(Make_TRAP10());	/*
uns register	R = (CODE & 0700) >> 6;
signed long register	L;
if ((_AL = (*Tabl_GetSRC_W[CODE & 077])())!=0)	return(_AL);
L = MEMORY.W.REG[R];
L = (L<<16)|MEMORY.W.REG[R|1];
L <<= SRC;
asm {	pushf
	pop AX
    }
A = _AX;
if (A & 1)		(byte)PSW |= C_bit; else (byte)PSW &= ~C_bit;
if (A & V_ibm)		(byte)PSW |= V_bit; else (byte)PSW &= ~V_bit;
Check_bitW_NZ(L);
MEMORY.W.REG[R] = (uns)(L >> 16);		// . 
MEMORY.W.REG[R|1] = (uns)L;			// . 
return(0);
*/
}	// Make_ASHC

byte near	Make_XOR (void)		{	// 074RSS  ++++    XOR    ------
uns register	R = (CODE & 0700) >> 6;
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST ^= MEMORY.W.REG[R];
Flag_NZ;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_XOR

byte near	Make_SOB  (void)	{	// 077RNN  ----    SOB     ------
if (--MEMORY.W.REG[(CODE & 0700)>>6])
	MEMORY.W.REG[7] -= ((CODE & 077)*2);
return(0);
}	// Make_SOB

byte near	Make_EMT  (void)	{	// 1040XXX ++++    EMT     ------
return(030);
}	// Make_EMT

byte near	Make_TRAP (void)	{	// 1044XXX ++++    TRAP    ------
return(034);
}	// Make_TRAP

byte near	Make_MOVB (void)	{	// 11SSDD  ++0-    MOVB    ------
if ((_AL = (*Tabl_GetSRC_B[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)		return(_AL);
DST = SRC;
(byte)PSW &= ~NZV_bit;
Check_bitB_NZ(DST);
if (CODE & 070)
	return ((*Tabl_PutDST_B[CODE])());
(int)MEMORY.W.REG[CODE] = (signed char)DST;
return(0);
}	// Make_MOVB

byte near	Make_CMPB (void)	{	// 12SSDD  ++++    CMPB    ------
if ((_AL = (*Tabl_GetSRC_B[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_B[CODE & 077])())!=0)	return(_AL);
(signed char)SRC -= (signed char)DST;
Flag_NZVC;
return(0);
}	// Make_CMPB

byte near	Make_BITB (void)	{	// 13SSDD  ++0-    BITB    ------
if ((_AL = (*Tabl_GetSRC_B[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_B[CODE & 077])())!=0)	return(_AL);
SRC &= DST;
Flag_NZ;
return(0);
}	// Make_BITB

byte near	Make_BICB (void)	{	// 14SSDD  ++0-    BICB    ------
if ((_AL = (*Tabl_GetSRC_B[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
DST &= ~SRC;
Flag_NZ;
return ((*Tabl_PutDST_B[CODE])());
}	// Make_BICB

byte near	Make_BISB (void)	{	// 15SSDD  ++0-    BISB    ------
if ((_AL = (*Tabl_GetSRC_B[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
DST |= SRC;
Flag_NZ;
return ((*Tabl_PutDST_B[CODE])());
}	// Make_BISB

byte near	Make_SUB  (void)	{	// 16SSDD  ++++    SUB     ------
if ((_AL = (*Tabl_GetSRC_W[(CODE & 07700) >> 6])())!=0)	return(_AL);
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST -= SRC;
Flag_NZVC;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_SUB

byte near	Make_HALT (void)	{	// 000000  ----    HALT    ------
return(0xFF);
}	// Make_HALT

byte near	Make_WAIT (void)	{	// 000001  ----    WAIT    ------
if ((byte)PSW == 0340)	return(1);
do if ((!((byte)PSW & I_bit)) && (IRQ & 0x3FFF))	return(0);
while (!(IRQ & HALTirq_M));
return(Make_HALT());
}	// Make_WAIT

byte near	Make_RTI  (void)	{	// 000002  ++++    RTI     ------
if ((_AL = Pop_SP())!=0)	return(_AL);
MEMORY.W.REG[7] = SRC;
if ((_AL = Pop_SP())!=0)	return(_AL);
(byte)PSW = (byte)SRC;
T_flag = (byte)PSW & T_bit;
return(0);
}	// Make_RTI

byte near	Make_BPT  (void)	{	// 000003  ++++    BPT     ------
return(014);
}	// Make_BPT

byte near	Make_IOT  (void)	{	// 000004  ++++    IOT     ------
return(020);
}	// Make_IOT

byte near	Make_RESET(void)	{	// 000005  0000    RESET   ------
return(BUS_System((RESET<<8),0,0,0,0));
}	// Make_RESET

byte near	Make_RTT  (void)	{	// 000006  ++++    RTT     ------
if ((_AL = Pop_SP())!=0)	return(_AL);
MEMORY.W.REG[7] = SRC;
if ((_AL = Pop_SP())!=0)	return(_AL);
(byte)PSW = (byte)SRC;
T_flag = 0;
return(0);
}	// Make_RTT

byte near	Make_MFPT (void)	{	// 000007  ----    MFPT    ------
return(Make_TRAP10());
}	// Make_MFPT

byte near	Make_JMP  (void)	{	// 0001SS  ----    JMP     ------
if ((CODE & 070) == 0)	return(4);
if ((_AL = (*Tabl_GetJmp[CODE & 077])())!=0)	return(_AL);
MEMORY.W.REG[7] = DST_Addr;
return(0);
}	// Make_JMP

byte near	Make_RTS  (void)	{	// 00020R  ----    RTS     ------
uns register	R = CODE & 07;
MEMORY.W.REG[7] = MEMORY.W.REG[R];
if ((_AL = Pop_SP())!=0)	return(_AL);
MEMORY.W.REG[R] = SRC;
return(0);
}	// Make_RTS

byte near	Make_CLC  (void)	{	// 00024C  ++++    CLC     ------
(byte)PSW &= ~(CODE & 0xF);
return(0);
}	// Make_CLC

byte near	Make_SEC  (void)	{	// 00026C  ++++    SEC     ------
(byte)PSW |= (CODE & 0xF);
return(0);
}	// Make_SEC

byte near	Make_SWAB (void)	{	// 0003DD  ++00    SWAB    ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
asm	{
	mov	dx,DST
	xchg	dl,dh
	mov	DST,dx
	}
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_SWAB

byte near	Make_CLR  (void)	{	// 0050DD  0100    CLR     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST = 0;
(byte)PSW &= ~NZVC_bit;
(byte)PSW |= Z_bit;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_CLR

byte near	Make_COM  (void)	{	// 0051DD  ++01    COM     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST = ~DST;
(byte)PSW &= ~NZV_bit;
Check_bitW_NZ(DST);
(byte)PSW |= C_bit;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_COM

byte near	Make_INC  (void)	{	// 0052DD  +++-    INC     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((uns)DST == 077777)		(byte)PSW |= V_bit;
DST++;
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_INC

byte near	Make_DEC  (void)	{	// 0053DD  +++-    DEC     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((uns)DST == 0100000)	(byte)PSW |= V_bit;
DST--;
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_DEC

byte near	Make_NEG  (void)	{	// 0054DD  ++++    NEG     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZVC_bit;
if ((uns)DST == 0100000)	(byte)PSW |= V_bit;
DST = -DST;
if (DST)	(byte)PSW |= C_bit;
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_NEG

byte near	Make_ADC  (void)	{	// 0055DD  ++++    ADC     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)PSW & C_bit)	{
	if ((uns)DST == 077777)		(byte)PSW |= V_bit;
	if ((uns)DST != 0177777)	(byte)PSW &= ~C_bit;
	(uns)DST = (uns)DST++;
	}
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ADC

byte near	Make_SBC  (void)	{	// 0056DD  ++++    SBC     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)PSW & C_bit)	{
	if ((uns)DST == 0100000)	(byte)PSW |= V_bit;
	if (DST != 0)			(byte)PSW &= ~C_bit;
	(uns)DST = (uns)DST--;
	}
Check_bitW_NZ(DST);
return ((*Tabl_PutDST_W[CODE])());
}	// Make_SBC

byte near	Make_TST  (void)	{	// 0057DD  ++00    TST     ------
if ((_AL = (*Tabl_GetDST_W[CODE & 077])())!=0)	return(_AL);
(byte)PSW &= ~NZVC_bit;
Check_bitW_NZ(DST);
return(0);
}	// Make_TST

byte near	Make_ROR  (void)	{	// 0060DD  ++++    ROR     ------
byte register	C1;
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
C1 = DST & 1;
(uns)DST >>= 1;
if ((byte)PSW & C_bit)	(uns)DST |= 0100000;
(byte)PSW &= ~NZVC_bit;
Check_bitW_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ROR

byte near	Make_ROL  (void)	{	// 0061DD  ++++    ROL     ------
byte register	C1 = 0;
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
if ((uns)DST & 0100000)	C1 = 1;
(uns)DST <<= 1;
if ((byte)PSW & C_bit)	(uns)DST |= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitW_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ROL

byte near	Make_ASR  (void)	{	// 0062DD  ++++    ASR     ------
byte register	C1;
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
C1 = DST & 1;
DST >>= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitW_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ASR

byte near	Make_ASL  (void)	{	// 0063DD  ++++    ASL     ------
byte register	C1 = 0;
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
if ((uns)DST & 0100000)		C1 = C_bit;
DST <<= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitW_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_W[CODE])());
}	// Make_ASL

byte near	Make_MARK (void)	{	// 0064NN  ----    MARK    ------
MEMORY.W.REG[6] = MEMORY.W.REG[7] + ((CODE & 077)*2);
MEMORY.W.REG[7] = MEMORY.W.REG[5];
if ((_AL = Pop_SP())!=0)	return(_AL);
MEMORY.W.REG[5] = SRC;
return(0);
}	// Make_MARK

byte near	Make_SXT  (void)	{	// 0067DD  -+0-    SXT     ------
if ((_AL = (*Tabl_GetDST_W[CODE &= 077])())!=0)	return(_AL);
DST = 0;
if ((byte)PSW & N_bit)	DST = ~DST;
(byte)PSW &= ~(Z_bit|V_bit);
if (DST==0)	(byte)PSW |= Z_bit;
return ((*Tabl_PutDST_W[CODE])());
}	// Make_SXT

byte near	Make_CLRB (void)	{	// 1050DD  0100    CLRB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)DST = 0;
(byte)PSW &= ~NZVC_bit;
(byte)PSW |= Z_bit;
return ((*Tabl_PutDST_B[CODE])());
}	// Make_CLRB

byte near	Make_COMB (void)	{	// 1051DD  ++01    COMB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)DST = ~(byte)DST;
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
(byte)PSW |= C_bit;
return ((*Tabl_PutDST_B[CODE])());
}	// Make_COMB

byte near	Make_INCB (void)	{	// 1052DD  +++-    INCB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)DST == 0177)	(byte)PSW |= V_bit;
(byte)DST = (byte)DST++;
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_B[CODE])());
}	// Make_INCB

byte near	Make_DECB (void)	{	// 1053DD  +++-    DECB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)DST == 0200)	(byte)PSW |= V_bit;
DST--;
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_B[CODE])());
}	// Make_DECB

byte near	Make_NEGB (void)	{	// 1054DD  ++++    NEGB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZVC_bit;
if ((byte)DST == 0200)	(byte)PSW |= V_bit;
(signed char)DST = -(signed char)DST;
Check_bitB_NZ(DST);
if ((byte)DST)	(byte)PSW |= C_bit;
return ((*Tabl_PutDST_B[CODE])());
}	// Make_NEGB

byte near	Make_ADCB (void)	{	// 1055DD  ++++    ADCB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)PSW & C_bit)	{
	if ((byte)DST == 0177)	(byte)PSW |= V_bit;
	if ((byte)DST != 0377)	(byte)PSW &= ~C_bit;
	(byte)DST = (byte)DST++;
	}
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_B[CODE])());
}	// Make_ADCB

byte near	Make_SBCB (void)	{	// 1056DD  ++++    SBCB    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
(byte)PSW &= ~NZV_bit;
if ((byte)PSW & C_bit)	{
	if ((byte)DST == 0200)	(byte)PSW |= V_bit;
	if (DST != 0)		(byte)PSW &= ~C_bit;
	(byte)DST = (byte)DST--;
	}
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_B[CODE])());
}	// Make_SBCB

byte near	Make_TSTB (void)	{	// 1057DD  ++00    TSTB    ------
if ((_AL = (*Tabl_GetDST_B[CODE & 077])())!=0)	return(_AL);
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
return(0);
}	// Make_TSTB

byte near	Make_RORB (void)	{	// 1060DD  ++++    RORB    ------
byte register	C = (byte)PSW & C_bit;
byte register	C1;
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
C1 = DST & 1;
(byte)DST >>= 1;
if (C)	(byte)DST |= 0200;
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_B[CODE])());
}	// Make_RORB

byte near	Make_ROLB (void)	{	// 1061DD  ++++    ROLB    ------
byte register	C = (byte)PSW & C_bit;
byte register	C1 = 0;
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
if ((byte)DST & 0200)	C1 = C_bit;
(byte)DST <<= 1;
if (C)	(byte)DST |= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_B[CODE])());
}	// Make_ROLB

byte near	Make_ASRB (void)	{	// 1062DD  ++++    ASRB    ------
byte register	C1;
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
C1 = DST & 1;
(signed char)DST >>= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_B[CODE])());
}	// Make_ASRB

byte near	Make_ASLB (void)	{	// 1063DD  ++++    ASLB    ------
byte register	C1 = 0;
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
if (DST & 0200)	C1 = C_bit;
(signed char)DST <<= 1;
(byte)PSW &= ~NZVC_bit;
Check_bitB_NZ(DST);
(byte)PSW |= C1;
(byte)PSW = (byte)PSW | Tabl_NCtoV[(byte)PSW & NZVC_bit];
return ((*Tabl_PutDST_B[CODE])());
}	// Make_ASLB

byte near	Make_MTPS (void)	{	// 1064SS  ++++    MTPS    ------
if ((_AL = (*Tabl_GetSRC_B[CODE & 077])())!=0)	return(_AL);
PSW &= T_bit;
PSW |= (byte)(SRC & ~T_bit);
return(0);
}	// Make_MTPS

byte near	Make_MFPS (void)	{	// 1067DD  ----    MFPS    ------
if ((_AL = (*Tabl_GetDST_B[CODE &= 077])())!=0)	return(_AL);
DST = (byte)PSW;
(byte)PSW &= ~NZV_bit;
Check_bitB_NZ(DST);
return ((*Tabl_PutDST_B[CODE])());
}	// Make_MFPS

