/***********************************************************************
	㦥 ।  p PDP-11
***********************************************************************/
#include	"pdp11dev.h"
#include	"pdp_bus.h"
#include	"make_def.h"

extern void BUS_Init(void);
extern void BUS_Done(void);
extern byte BUS_Boot(char *Name);

extern unsigned A;

/* ⥭ p pp뢠 */
#define GetBUS_Vector() 				\
	((BUS_Get((TRAP<<8)+0xFF,0,0,&A))?4:(byte)A)

/* ⥭  */
#define GetBUS_Command() 				\
	(PC=MEMORY.W.REG[7], 				\
	 MEMORY.W.REG[7]+=2, 				\
	 (PC < MEMTOP)   				\
	  ?(CODE=MEMORY.W.WORD[PC>>1],0) 		\
	  :BUS_Get((READW<<8)+004,PC,0,&CODE)		\
	)

/* MOV D,-(SP) */
#define Push_SP(D) 					\
	(A=MEMORY.W.REG[6]-=2, 				\
	 (A > MEMTOP)?4 				\
	  :(MEMORY.W.WORD[A>>1]=(uns)D,			\
	    MEMORY.W.REG[6]=A,0)			\
	)

/* MOV (SP)+,SRC */
#define Pop_SP() 					\
	(A = MEMORY.W.REG[6], 		     		\
	 MEMORY.W.REG[6]+=2,  				\
	 (A > MEMTOP)?4   				\
	  :(SRC=MEMORY.W.WORD[A>>1],0)			\
	)

/* ⥭ ᫮  p */
#define BUS_GetW(Addr,Data) 				\
	(A=Addr,(A < MEMTOP) 				\
	 ?(*Data=MEMORY.W.WORD[A>>1],0)   		\
	 :BUS_Get((READW<<8)+004,A,0,(uns *)Data)	\
	)

/* ⥭   p */
#define BUS_GetB(Addr,Data) 				\
	(A=Addr,(A < MEMTOP)   				\
	 ?(*Data=(signed char)MEMORY.B.BYTE[A],0)	\
	 :BUS_Get((READB<<8)+004,A,0,(uns *)Data)	\
	)

/*  ᫮ */
#define BUS_PutW(Addr,Data) 				\
	(A=Addr,(A < MEMTOP)	   			\
	 ?(MEMORY.W.WORD[A>>1]=Data,0)   		\
	 :BUS_Put((WRITEW<<8)+004,A,0,Data)		\
	)

/*   */
#define BUS_PutB(Addr,Data) 				\
	(A=Addr,(A < MEMTOP)   				\
	 ?(MEMORY.B.BYTE[A]=Data,0)    			\
	 :BUS_Put((WRITEB<<8)+004,A,0,Data)		\
	)

