/************************************************************************
	[OWA] HArd & Soft	  "" (0842) 31-42-30
			ᨥ ..
		  PDP11

		  
		⥬ ନ, ⠩  .

************************************************************************/
#include	"pdp11dev.h"
#include	"pdp_bus.h"
#include	"make_sys.h"
#include	<stdlib.h>

/************************************************************************
 *		p  設 PDP-11
 */

#define	TimInt	0x08			// p ⠩p
#define	KbInt	0x09			// p p
#define	KwHALT	0127			// ᪠- F11 (HALT)
#define	KwTIMER	0130			// ᪠- F12 (TIMER)
#define	KwHALT2	0x44			// ᪠- F10 (HALT)
#define	KwTIME2	0x43			// ᪠- F9 (TIMER)

#define	SysCLK	0xFFFF			// ⥫  ⠩ 18.2 
#define	TimCLK	23862			// ⥫  ⠩ 50 
#define SysTIM	20			// 20   稪 ६
#define	TimMAP	0x249			// 4  11 ⨪  ⥬

#define	BELL	007
#define	BS	010
#define	HT	011
#define	LF	012
#define	FF	014
#define	CR	015
#define	RUS	016
#define	LAT	017
#define	ESC	033

#define	Wx0	0
#define	Wy0	1
#define	Wx1	79
#define	Wy1	24
#define	WidX	Wx1-Wx0		// p . 
#define	WidY	Wy1-Wy0		//  . 

#define		Lamp_CH1	0xFE //0xB1	// ᨬ "窠 ."
#define		Lamp_CH0	0x07 //0xB0	// ᨬ "窠 몫."
#define		NormText	15	// LIGHTWHITE
#define		LIGHTGREEN	10
#define		GREEN		2

/************************************************************************
 *		. pp VT52 (OUTPUT)
 */

byte	MaxY	= 25;
char	RUSchar[]	// Array[#64..#127]
    = "椥娩㦢Ꞁ";

static	char	RUSout	= false;	// p ". ᨬ"

/************************************************************************
 *		窠  <conio.h>
 */

int	getch(void)
{
uns char	CH;
_AH = 0x00;
asm	int	16h
CH = _AH;
if (_AL)
	return(_AL);
else	return(CH | 0x100);
}	/* getch */

int	kbhit(void)
{
int	AH;
_AH = 0x01;
asm	int	16h
asm	lahf
AH = _AH;
if ((AH & 0x40) != 0)
	return(false);
else	return(true);
}	/* kbhit */

void	GetXY(byte *X, byte *Y)	{
_AH = 0x03;
_BH = 0;
asm	int	10h
*X = _DL; *Y = _DH;
}	/* GetXY */

void _fastcall	GotoXY(int X,int Y)	{
_DL = X;
_DH = Y;
_BX = 0;
_AH = 0x02;
asm	int	10h
}	/* GotoXY */

void _fastcall	PutCH(char Tcol, char C)	{
_BX = Tcol;
_CX = 1;
_AH = 0x09;
_AL = C;
asm	int	10h
}	// PutCH

void _fastcall	TTYOUT(char C)	{
_AH = 0x0E;
_AL = C;
asm	int	10h
}	// TTYOUT

void _fastcall	cprintf(char *str)	{
while (*str != NULL)	TTYOUT(*str++);
}	/* cprintf */


/************************************************************************
 *		 pp
 */
char	INrdy	= false,	// ⮢ p
	INeni	= false;	// pp. pp뢠
char	INdat	= 0;		// 室 
uns	INirq_M	= 0;		// ᪠ p pp뢠

static uns	OUTirq_M	= 0;	// ᪠ p pp뢠
static char	OUTrdy	= false;	// ⮢ p稪
static char	OUTeni	= false;	// pp. pp뢠

byte	HALT_flag	= 0;
byte	TIME_flag	= 0;
byte	Modify_flag	= 1;
byte	Open_FLAG	= 0;

void _fastcall	SetRUSLAT(char NewRUS)	{	// p /
byte	Xc;
byte	Yc;
GetXY(&Xc,&Yc);
GotoXY(8,0);
if (NewRUS)
	PutCH(LIGHTGREEN,Lamp_CH1);
else	PutCH(GREEN,Lamp_CH0);
RUSout = NewRUS;
GotoXY(Xc,Yc);
}	/* SetRUSLAT */

void	SetLamps(void)	{
byte	Xc;
byte	Yc;

if (Modify_flag == 0)	return;
Modify_flag = 0;

GetXY(&Xc,&Yc);

GotoXY(16,0);
if (HALT_flag)	{
	PutCH(LIGHTGREEN,Lamp_CH1);	//  "HALT"
	IRQ |= HALTirq_M;		//  HALT
	}
else	{
	PutCH(GREEN,Lamp_CH0);
	IRQ &= ~HALTirq_M;		// 몫. HALT
	}

GotoXY(24,0);
if (TIME_flag)
	PutCH(LIGHTGREEN,Lamp_CH1);	//  "TIMER"
else	PutCH(GREEN,Lamp_CH0);

GotoXY(Xc,Yc);				//  -  
}	// SetLamps

uns	mSec	= 0;
char	TimeStr[10] = "00:00:00";

void	TimeHMS(uns V, char *S)	{
*S++ = '0' + ((V/10)%10);
*S++ = '0' + V%10;
}	// TimeHMS

void	TimeInit(void)	{
uns	H;
uns	M;
uns	S;
_AH = 0x2C;
asm	int	21h
H = _CH;
M = _CL;
S = _DH;
TimeHMS(H,&TimeStr[0]);
TimeHMS(M,&TimeStr[3]);
TimeHMS(S,&TimeStr[6]);
}	// TimeInit

#define		Clock_X0	72

void _fastcall	ClockStr(uns X, char C)	{
if (Open_FLAG)	{	GotoXY(Clock_X0+X,0); PutCH(0x07,C);	}
}	// ClockStr

void	Clock(void)	{
byte	Xc;
byte	Yc;
if (mSec >= 1000)	{
	mSec -= 1000;
	if (Open_FLAG)	GetXY(&Xc,&Yc);
	if (++TimeStr[7] > '9')	{
	 TimeStr[7] = '0';
	 if (++TimeStr[6] > '5')	{
	  TimeStr[6] = '0';
	  if (++TimeStr[4] > '9')	{
	   TimeStr[4] = '0';
	   if (++TimeStr[3] > '5')	{
	    TimeStr[3] = '0';
	    if (++TimeStr[1] > '9')	{
	     TimeStr[1] = '0';
	     if (++TimeStr[0] > '5')
	      TimeStr[0] = '0';
	     ClockStr(0,TimeStr[0]);
	     }
	    ClockStr(1,TimeStr[1]);
	    }
	   ClockStr(3,TimeStr[3]);
	   }
	  ClockStr(4,TimeStr[4]);
	  }
	 ClockStr(6,TimeStr[6]);
	 }
	ClockStr(7,TimeStr[7]);
	if (Open_FLAG)	GotoXY(Xc,Yc);
	}
}	// Clock

void	NoStatus(void)	{
_CH = 0;	// Y0
_DH = 0;	// Y1
_CL = 0;	// X0
_DL = 79;	// X1
_BH = 0x07;
_AL = 0;
_AH = 0x06;
asm	int	10h
}	// NoStatus

void	Status(void)	{		// p 
byte	Xc;
byte	Yc;
if (Open_FLAG == 0)	return;
GetXY(&Xc,&Yc);
NoStatus();
GotoXY(0,0);
cprintf("    [+] Halt[+] Time[+]   <TTY - console>  V01.00 [OWA] Hard & Soft");
GotoXY(Clock_X0,0);
cprintf(TimeStr);
SetRUSLAT(RUSout);
Modify_flag = true;
SetLamps();
GotoXY(Xc,Yc);
}	/* Status */

void _fastcall	PutSYM(char C)	{		// p⪠ ᨬ
byte	Xc;
byte	Yc;
if ((C &= 0x7F) == 0)	return;
if (C == LF)	{
	GetXY(&Xc,&Yc);
	TTYOUT(C);
	if (Yc > 23)	Status();
	}	else
if (C == HT)	{
	GetXY(&Xc,&Yc);
	GotoXY((Xc|7)+1,Yc);
	}	else
if (C == 0177)	TTYOUT(254);		else
if (C == RUS)	SetRUSLAT(true);	else
if (C == LAT)	SetRUSLAT(false);	else
if (C < '@')	TTYOUT(C);		else
if (RUSout == false)
		TTYOUT(C);
else		TTYOUT(RUSchar[C-'@']);
}	/* PutSYM */

/***********************************************************************
 *		p饭  pp 0177564,0177566
 */

void	SetOUTeni(void)	{		// pp襭 pp뢠
if (OUTrdy)
  if (OUTeni == false)	IRQ |= OUTirq_M;
OUTeni = true;
}	/* SetOUTeni */

void	DisOUTeni(void)	{		// p pp뢠
IRQ &= ~OUTirq_M;
OUTeni = false;
}	/* DisOUTeni */

uns	GetOUTcsr(void)	{		// ⥭ pp ﭨ
uns	csr = 0;
if (OUTrdy)	csr = 0x80;
if (OUTeni)	csr |= 0x40;
return(csr);
}	/* GetOUTcsr */

void _fastcall	PutOUTcsr(uns CSR)	{	//   pp ﭨ
if (CSR & 0x40)
	SetOUTeni();
else	DisOUTeni();
}	/*PutOUTcsr */

void	SetOUTrdy(void)	{
OUTrdy = true;
if (OUTeni == true)	{	// pp뢠 pp襭 !!!
	DisOUTeni();
	SetOUTeni();		// 뢠 pp뢠
	}
}	// SetOUTrdy

void	DisOUTrdy(void)	{
OUTrdy = false;
}	// DisOUTrdy

void _fastcall	PutOUTdat(char	DAT)	{	//   pp 
PutSYM(DAT);		// 뢮 ᨬ
DisOUTrdy();
SetOUTrdy();
}	/* PutOUTdat */


/***********************************************************************
 *		p⪠ p pp 177560,177562
 */

void	SetINrdy(void)	// ⠭  ⮢  p pp뢠
{
if (kbhit())	{
	if ((INeni) && (INrdy == false))
		IRQ |= INirq_M;	// p pp뢠
	INrdy = true;		// ⮢
	}
}	/* SetINrdy */

void	DisINrdy(void)		// p ⮢  p pp뢠
{
INrdy = false;
IRQ &= ~INirq_M;
}	/* DisINrdy */

void	SetINeni(void)		// . pp. pp.  p pp.
{
if ((INrdy) && (INeni == false))
	IRQ |= INirq_M;
INeni = true;
}	/* SetINeni */

void	DisINeni(void)		// p饭 pp뢠
{
INeni = false;
IRQ &= ~INirq_M;
}	/* DisINeni */

uns	GetINcsr(void)		// ⥭ pp ﭨ p
{
uns	INcsr	= 0;
if (INrdy)	INcsr = 0200;
if (INeni)	INcsr |= 0100;
return(INcsr);
}	/* GetINcsr */

void _fastcall	PutINcsr(uns CSR)	//  pp ﭨ p
{
if (CSR & 0100)
	SetINeni();
else	DisINeni();
}	/* PutINcsr */

int	GetINdat(void)		// ⥭ pp  p
{
if (kbhit())	INdat = getch();
DisINrdy();
SetINrdy();
return(INdat);
}	/* GetINdat */

void interrupt	(* SysInt08)(void);
void interrupt	(* SysInt60)(void);
void interrupt	(* SysInt09)(void);

/***********************************************************************
 *		p⪠ pp뢠
 */

void interrupt	MyInt09()	{
char	c	= inp(0x60);	//   (᪠-)
if (Open_FLAG)	{
	if ((c == KwHALT) || (c == KwHALT2))	{
		HALT_flag = ~HALT_flag;	// p HALT	  (F11/F10)
		goto Tret;
		}
	if ((c == KwTIMER) || (c == KwTIME2))	{
		TIME_flag = ~TIME_flag;	//   (F12/F9)
		goto Tret;
	}	}

(*SysInt09)();
return;

Tret:
Modify_flag = 1;
outp(0x20,0x20);
}	// MyInt09

void	SetClock(uns Divizor)	{
_AL = 0x36;			// ० ⠩ #0 - ० 3, 
asm	out	43h,al
_AX = Divizor;			// ⥫  1.193180 
asm	out	40h,al
_AL = _AH;
asm	out	40h,al
}	// SetClock

char huge	*DOS_active_flag;
char		OpenIN	= true;
byte		TimCNT	= 0;

void interrupt	MyInt08(/*...*/)		// p⪠ pp뢠 ⠩p 18.2
{
char register	here	= OpenIN;
OpenIN = false;

if (++TimCNT > 10)	TimCNT = 0;	// 稪 ⨪, 11 .
if ((1<<TimCNT) & TimMAP)
	(*SysInt08)();			// ⤠ ⥬
else	{				//  - ᠬ 蠥 뢠
	_AL = 0x20;
	asm	out	20h,al
	}

mSec += SysTIM;
if (here)	{		//  ᤥ   뫨 !
	Clock();		// ⨪ ᠬ
	if (Open_FLAG)	{	// ࠧ襭 ?
		if (TIME_flag)	IRQ |= TIMEirq_M; 	// p ⠩p
		if (*DOS_active_flag == 0)	{
			SetINrdy();	// p뢠 ⮢ p
			SetLamps();	//  窨
	}	}	}
OpenIN = true;
}	/* MyInt08 */

/***********************************************************************
 *                p⪠ pp뢠  p饭  p
 */

uns	BUS_System(uns AX, uns BX, uns CX,uns DX, uns ES)
{
switch(AX >> 8)	{
case	INIT:			// 樠
		INirq_M = DX;		// ᪠ 襣 p
		DX <<= 1;
		OUTirq_M = DX;
		DX <<= 1;		// ᪠  ᫥. p⢠
		IRQ &= ~(OUTirq_M + INirq_M + HALTirq_M);
		INdat = 0;
		Open_FLAG = 1;
case	RESET:			//     p
		Status();
		INrdy = false;		//  ⮢.
		DisINeni();		// p. pp.
		OUTrdy = true;
		DisOUTeni();
		break;
case	DONE:			// p襭 p
		NoStatus();
		Open_FLAG = 0;
		TIME_flag = 0;
		HALT_flag = 0;
		DisINeni();		// p. pp.
		DisOUTeni();
		break;
}	// switch(AX>>8)

if (SysInt60 == NULL)			//  ᫥. p⢮ ?
	return(AX);			//  ?  !
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();				// p ᫥. p
return(_AX);				//  p
}	//  BUS_System

/***********************************************************************
 *		p⪠ p饭  pp
 */
uns  BUS_Put(uns AX, uns BX, uns CX, uns DX)	//   pp
{
if (SysInt60)	{			//  ᫥. p⢮ ?
	_DX = DX;
	_CX = CX;
	_BX = BX;
	_AX = AX;
	(*SysInt60)();			// p ᫥. p
	if (_AL == 0) return(_AX);	//  p
	}

//  設 祣  ,
//  ॣ ନ ?

switch (AX >> 8)	{	//  "" ?
case	WRITEW:			//  ᫮
case	WRITEB:			//  
		switch(BX)	{
	case TTinCSR:	PutINcsr(DX);		// pp ﭨ 
			return(0);
	case TToutCSR:	PutOUTcsr(DX);		// pp ﭨ 뢮
			return(0);
	case TToutDAT:	PutOUTdat(DX);		// pp  뢮
	case TTinDAT:	return(0);		// p稥  pp
		}	// switch(BX)
		break;
}	// switch(AX>>8)
return(AX);
}	// BUS_Put

uns BUS_Get(uns AX, uns BX, uns CX, uns near *DX)	// ⥭ pp
{
if (SysInt60)	{		//  ᫥. p⢮ ?
	_CX = CX;
	_BX = BX;
	_AX = AX;
	(*SysInt60)();			// p ᫥. p
	*DX = _DX;			// p⠭ 
	if (_AL == 0)	return(_AX);	//  p
	}

//  設 祣  ,
//  ॣ ନ ?

switch (AX >> 8)	{
case	TRAP:			// ।⠢ 뢠 ?
		if (IRQ & INirq_M)	{
			*DX = TTinVec;		// p 
			IRQ &= ~INirq_M;	// p⠭
			return(0);		// Ok.
			}
		if (IRQ & OUTirq_M)	{	// p 뢮
			*DX = TToutVec;
			IRQ &= ~OUTirq_M;
			return(0);
			}
		break;

case	READW:
case	READB:			//  "⥭" ?
		switch(BX)	{
		case TTinCSR:	*DX = GetINcsr();
				return(0);
		case TTinDAT:	*DX = GetINdat();
				return(0);
		case TToutCSR:	*DX = GetOUTcsr();
				return(0);
		case TToutDAT:	*DX = TTinVec;
				return(0);
		}	// switch(BX)
		break;
}	// switch(AX>>8)

return(AX);
}	// BUS_Get

/***********************************************************************
 *                p⪠ 襭 int 60
 */

void interrupt	MYint60
	(uns BP,uns DI,uns SI,uns DS,
	 uns ES,uns DX,uns CX,uns BX,uns AX)
{	if (((AX>>8) == TRAP10) && (CX == 010))
		{	BUS_Done();
			if (system(&MEMORY.B.BYTE[MEMORY.W.REG[0]]))
				AX = 010;
			else	AX = 0;
			BUS_Init();
			return;
		}

if (SysInt60 == NULL)			//  ᫥. p⢮ ?
	return;				//  ?  !
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();				// p ᫥. p
DX = _DX;
AX = _AX;
}	// MYint60

void	BUS_Load(void)			// 堫 !
{
_AH = 0x34;
asm int 21h
DOS_active_flag = MK_FP(_ES,_BX);	// !0 - ࠧ襭 맮 DOS-㭪権

TimeInit();

SysInt60 = getvect(PDPvec);		//  pp뢠
setvect(PDPvec,MYint60);		// 蠫 뢠  int 60

SysInt09 = getvect(KbInt);		// p
setvect(KbInt,MyInt09);

SetClock(TimCLK);			// ணࠬ㥬 ⠩

SysInt08 = getvect(TimInt);		// ⠩p
setvect(TimInt,MyInt08);

}	// BUS_Load

void	BUS_UnLoad(void)		// p   !!!
{
setvect(KbInt,SysInt09);
setvect(TimInt,SysInt08);
SetClock(SysCLK);			// ணࠬ㥬 ⠩ ⭮
setvect(PDPvec,SysInt60);
}	// BUS_UnLoad

