#include	"VT52key.h"	// pp ᨬ
#include	"pdp11dev.h"

/************************************************************************
 *		p  設 PDP-11
 */

extern unsigned		_stklen 	= 128;
extern unsigned		_heaplen	= 128;

#define	TTinCSR	0177560			// pp ﭨ
#define	TTinDAT	0177562			// pp 
#define	TTinVec	060			// p pp뢠

#define	TToutCSR	0177564		// pp ﭨ
#define	TToutDAT	0177566		// pp 
#define	TToutVec	064		// p pp뢠

#define	TTioREADY	0200		// ⮢


#define	TimInt	0x1C			// p ⠩p

#define	BELL	007
#define	BS	010
#define	HT	011
#define	LF	012
#define	FF	014
#define	CR	015
#define	RUS	016
#define	LAT	017
#define	ESC	033

#define	Wx0	0
#define	Wy0	1
#define	Wx1	79
#define	Wy1	24
#define	WidX	Wx1-Wx0		// p . 
#define	WidY	Wy1-Wy0		//  . 

/************************************************************************
 *		. pp VT52 (OUTPUT)
 */

char	RUSchar[]	// Array[#64..#127]
    = "椥娩㦢Ꞁ";

#define		ESC0		1	//  ESC,...
#define		ESCY_1		2	//  ESC,Y,...
#define		ESCY_2		3	//  ESC,Y,row,...

static	byte	Xc	= 0,
		Yc	= 0;		// . p. pp
static	char	RUSout	= false;	// p ". ᨬ"
static	char	SYST	= 1;		// ⥬  ᯫ
static	char	Switch	= NULL;		// ⥪. p 

uns far		*IRQ	= NULL;		// ॣ ᮢ 뢠

/************************************************************************
 *		窠  <conio.h>  VT52out
 */

#define		Lamp_CH1	0xFE //0xB1	// ᨬ "窠 ."
#define		Lamp_CH0	0x07 //0xB0	// ᨬ "窠 몫."
#define		NormText	15	// LIGHTWHITE
#define		BadCTRL		14	// YELLOW
#define		BadESC		11	// LIGHTGREEN
#define		DARKGRAY	8	// DARKGRAY
#define		LIGHTGREEN	10
#define		GREEN		2

void _fastcall	GotoXY(int X,int Y)	{
_DL = X;
_DH = Y;
_BX = 0;
_AH = 0x02;
asm	int	10h
}	/* GotoXY */

void _fastcall	GotoHOME(void)	{
Xc = Wx0;
Yc = Wy0;
}	/* GotoHOME */

void	GotoCUR(void)	{
_DL = Xc;
_DH = Yc;
_BX = 0;
_AH = 0x02;
asm	int	10h
}	/* GotoCUR */

void	WhereXY(void)	{
_AH = 0x03;
_BH = 0;
asm	int	10h
Xc = _DL; Yc = _DH;
}	/* WhereXY */

void _fastcall	PutCH(char Tcol, char C)	{
_BX = Tcol;
_CX = 1;
_AH = 0x09;
_AL = C;
asm	int	10h
}	// PutCH

void _fastcall	cprintf(char *str)	{
char register	C;
while (*str != NULL)	{
	C = *str++;
	_AH = 0x0E;
	_AL = C;
	asm	int	10h
	}
}	/* cprintf */


/************************************************************************
 *		 pp
 */
char	INrdy	= false,	// ⮢ p
	INeni	= false;	// pp. pp뢠
char	INdat	= 0;		// 室 
uns	INirq_M	= 0;		// ᪠ p pp뢠

uns	OUTirq_M= 0;		// ᪠ p pp뢠
char	OUTrdy	= false;	// ⮢ p稪
char	OUTeni	= false;	// pp. pp뢠

byte	Modify_flag	= 1;
byte	Open_FLAG	= 0;

char far	*DOS_active_flag;	// !0 -  맮 DOS

void	Bell(void)	{		// 
_AX = 0x0E07;
asm int	10h
//sound(1000); delay(200); nosound();
}	/* Bell */

#define	RUSLAT_X	8
#define	SYST_X		32


void _fastcall	SetRUSLAT(char NewRUS)	{	// p /
GotoXY(RUSLAT_X,0);
if ((RUSout = NewRUS) != false)
	PutCH(LIGHTGREEN,Lamp_CH1);
else	PutCH(GREEN,Lamp_CH0);
}	/* SetRUSLAT */

void _fastcall	SetSYST(char NewSYST)	{	// p /
GotoXY(SYST_X,0);
PutCH(0x07,'0'+(SYST = NewSYST));
}	/* SetSYST */

void	Status(void)	{		// p 
WhereXY();
/*
    [+] Halt[+] Time[+] VT52(+) 15-00-013 V03.00 [OWA] Hard & Soft");
	8	16	24	32	40	48	56	64	72
*/

GotoXY(4,0);	cprintf("[+]");
GotoXY(27,0);	cprintf("VT52(+) 15-00-013 V03.00 [OWA] Hard & Soft");

SetRUSLAT(RUSout);
SetSYST(SYST);
GotoCUR();
}	/* Status */

void	ClrEol(void)	{
_CH = Yc;	// Y0
_DH = _CH;	// Y1
_CL = Xc;	// X0
_DL = Wx1;	// X1
_AH = 0x06;
_BH = NormText;
_AL = 0;
asm int	10h
}	/* ClrEol */

void _fastcall	ScrollUp(char H)	{	// p p p
_CH = Wy0;	// Y0
_DH = Wy1;	// Y1
_CL = Wx0;	// X0
_DL = Wx1;	// X1
_BH = NormText;
_AL = H;
_AH = 0x06;
asm int	10h
}	/* ScrollUp */

void _fastcall	ScrollDn(char H)	{	// p p 
_CH = Wy0;	// Y0
_DH = Wy1;	// Y1
_CL = Wx0;	// X0
_DL = Wx1;	// X1
_BH = NormText;
_AL = H;
_AH = 0x07;
asm int	10h
}	/* ScrollDn */

void	CYincRol(void)	{		// Y++  p
if (Yc < Wy1)	Yc++;
else	{
	Yc = Wy1;
	ScrollUp(1);
	}
}	/* CYincRol */

void	CXincRol(void)	{		// X++  p
if (++Xc > WidX)	{
	Xc = 0;
	CYincRol();
	}
}	/* CXincRol */

void _fastcall	CYincMod(void)	{	// Y++  
if (Yc < Wy1)	Yc++;
else		Yc = Wy0;
}	// CYincMod

void _fastcall	CYdecMod(void)	{	// Y++  
if (Yc > Wy0)	Yc--;
else		Yc = Wy1;
}	// CYdecMod

void	MakeTAB(void)	{		//  ⠡
Xc |= 7;
CXincRol();
}	/* MakeTAB */

void _fastcall	MakeChar(char Tcol, char C)	{	// p㥬 ᨬ
PutCH(Tcol,C);
CXincRol();
}	/* MakeChar */

void	ClrLinePage(void)	{	// ⪠   p
_CH = Yc+1;	// Y0
_DH = 24;	// Y1
_CL = Wx0;	// X0
_DL = Wx1;	// X1
_AH = 0x06;
_BH = NormText;
_AL = 0;
asm	int	10h
}	/* ClrLinePage */

void _fastcall	MakeESCY_1(char C)	{
Switch = ESCY_2;
if ((C >= ' ') && (C <= WidY+' '))	Yc = C-' '+Wy0;
}	/* MakeESCY_1 */

void _fastcall	MakeESCY_2(char C)	{
Switch = NULL;
if ((C >= ' ') && (C <= WidX+' '))	Xc = C-' '+Wx0;
}	/* MakeESCY_2 */

void _fastcall	MakeESC(char C)	{		// ESC-ᨬ

Switch = NULL;
switch(C)	{
case	'A':	if (Yc > Wy0)	Yc--;
		break;
case	'B':    if (Yc < Wy1)	Yc++;
		break;
case	'C':	if (Xc < Wx1)	Xc++;		//  ࠢ
		else	{	Xc = Wx0; CYincMod();	}
		break;
case	'D':    if (Xc > Wx0)	Xc--;
		else	{	Xc = Wx1; CYdecMod();	}
		break;
case	'E':	SetSYST(0);
		break;
case	'H':	GotoHOME();
		break;
case	'I':	if (Yc == Wy0)
			ScrollDn(1);
		else	Yc--;
		break;
case	'J':    ClrLinePage();
case	'K':	ClrEol();
		break;
case	'Y':	Switch = ESCY_1;
		break;
case	'Z':	PutKbStr("\033Z");
		break;
//default:
//	MakeChar(BadESC,C | 0100);
} /*case*/
}	/* MakeESC */

void _fastcall	MakeCTRL(char C)	{	// CTRL-ᨬ

switch(C)	{
case	BELL:	Bell();
		break;
case	LF:
case	013:
case	FF:	CYincRol();
		break;
case	CR:	Xc = 0;
		break;
case	RUS:	SetRUSLAT(true);
		break;
case	LAT:	SetRUSLAT(false);
		break;
default:  if (SYST)
		switch(C)	{
		case	005:	PutKbStr("\033Z");
				break;
		case	BS:	if (Xc > Wx0) Xc--;
				break;
		case	HT:	MakeTAB();
				break;
		case	ESC:	Switch = ESC0;
				break;
//		default:	MakeChar(BadCTRL,C+0140);
		}	// case 1
	  else
		switch(C)	{
		case	006:			//  - । ப
		case	036:			// 
		case	021:			// 
		case	023:			// 몠
		case	024:			// 몠
				break;
		case	010:	GotoHOME();	// HOME
				break;
		case	014:	GotoHOME();	// 
		case	037:	ClrLinePage();	// 
		case	013:	ClrEol();	// 
				break;
		case	022:	ScrollUp(1);	//  
				break;
		case	025:	Xc = Wx0; CYincRol();
				break;
		case	026:	ScrollDn(1);	//  
				break;
		case	027:	SetSYST(1);	// ⥬  #1
				break;
		case	031:	if (Xc < Wx1)	Xc++;	//  ࠢ
				else	{ Xc = Wx0; CYincMod();	}
				break;
		case	032:	if (Xc > Wx0)	Xc--;	//  
				else	{ Xc = Wx1; CYdecMod();	}
				break;
		case	034:	CYdecMod();
				break;
		case	035:	CYincMod();
				break;
		}	// case 0
}	// case
}	/* MakeCTRL */

void _fastcall	PutSYM(char C)	{		// p⪠ ᨬ

if ((C &= 0x7F) == 0)	return;
WhereXY();
switch(Switch) {
case	NULL:		// ᢥ쪨 ᨬ
		if (C == 0177)	MakeChar(NormText,254);	else
		if (C < ' ')	MakeCTRL(C);		else
		if (C < '@')	MakeChar(NormText,C);	else
		if (RUSout == false)
				MakeChar(NormText,C);	else
				MakeChar(NormText,RUSchar[C-'@']);
		break;
case	ESC0:		// ESC-ᨬ !!!
		MakeESC(C);
		break;
case	ESCY_1:		// ESC,Y,...
		MakeESCY_1(C);
		break;
case	ESCY_2:		// ESC,Y,row,...
		MakeESCY_2(C);
		break;
}	/*case*/
GotoCUR();
}	/* PutSYM */

/***********************************************************************
 *		p饭  pp 0177564,0177566
 */

void	SetOUTeni(void)	{		// pp襭 pp뢠
if (OUTrdy)
  if (OUTeni == false)	*IRQ |= OUTirq_M;
OUTeni = true;
}	/* SetOUTeni */

void	DisOUTeni(void)	{		// p pp뢠
*IRQ &= ~OUTirq_M;
OUTeni = false;
}	/* DisOUTeni */

uns	GetOUTcsr(void)	{		// ⥭ pp ﭨ
uns	csr = 0;
if (OUTrdy)	csr = 0x80;
if (OUTeni)	csr |= 0x40;
return(csr);
}	/* GetOUTcsr */

void _fastcall	PutOUTcsr(uns CSR)	{	//   pp ﭨ
if (CSR & 0x40)
	SetOUTeni();
else	DisOUTeni();
}	/*PutOUTcsr */

void	SetOUTrdy(void)	{
OUTrdy = true;
if (OUTeni == true)	{	// pp뢠 pp襭 !!!
	DisOUTeni();
	SetOUTeni();		// 뢠 pp뢠
	}
}	// SetOUTrdy

void	DisOUTrdy(void)	{
OUTrdy = false;
}	// DisOUTrdy

void _fastcall	PutOUTdat(char	DAT)	{	//   pp 
PutSYM(DAT);		// 뢮 ᨬ
DisOUTrdy();
SetOUTrdy();
}	/* PutOUTdat */


/************************************************************************
 *		窠  <conio.h>  VT52in
 */

int	getch(void)
{
uns char	CH;
_AH = 0x00;
asm	int	16h
CH = _AH;
if (_AL)
	return(_AL);
else	return(CH | 0x100);
}	/* getch */

int	kbhit(void)
{
int	AH;
_AH = 0x01;
asm	int	16h
asm	lahf
AH = _AH;
if ((AH & 0x40) != 0)
	return(false);
else	return(true);
}	/* kbhit */

/***********************************************************************
 *		室 p p
 */

#define		KbSize	8
uns byte	KbWR	= 0,
		KbRD	= 0,
		KbCnt	= 0;
char		KbBuffer[KbSize];

int	GetKb(void)		// ⥭  p p
{
register	C;
if (KbCnt == 0)	return(0);
C = KbBuffer[KbRD++];
KbRD %= KbSize;
KbCnt--;
return(C);
}	/* GetKb */

void near _fastcall	PutKb(int C)		//   p p
{
KbBuffer[KbWR++] = C;
KbWR %= KbSize;
if (KbCnt++ > KbSize-4)	{
	do {} while (GetKb() != ESC);
}
}	/* PutKb */

void near _fastcall	PutKbStr(char *str)	{
while (*str)	PutKb(*str++);
}	// PutKbStr

/***********************************************************************
 *		p PC-Kb --> VT52-Kb
 */
uns char	RUSin	= false;
char	RusLatAp[] = "abwgdevzijklmnoprstufhc~{}yx|`qABWGDEVZIJKLMNOP";
char	RusLatPq[] = "RSTUFHC^[]_YX\\@Q";

void	MakeNewChar(void)
{
int	C;
if ((C = MakeVT52key(getch())) == 0)	return;

if ((C &= 0xFF) >= 0x80)	// p ᨬ
	{
	if (RUSin == false)	PutKb(RUS);	//  !!!
	RUSin = true;
	if (C < 176)
		C = RusLatAp[C-128];
	else
	if ((C >= 224) && (C < 240))
		C = RusLatPq[C-224];
	else	C |= 64;
	}
else	{
	if (RUSin == true)	PutKb(LAT);	//  !!!
	RUSin = false;
	}
PutKb(C);
}	/* MakeNewChar */

/***********************************************************************
 *		p⪠ p pp 177560,177562
 */

void	SetINrdy(void)	// ⠭  ⮢  p pp뢠
{
if ((kbhit()) || (KbCnt > 0))	{
	if ((INeni) && (INrdy == false))
		*IRQ |= INirq_M;	// p pp뢠
	INrdy = true;			// ⮢
	}
}	/* SetINrdy */

void	DisINrdy(void)		// p ⮢  p pp뢠
{
INrdy = false;
*IRQ &= ~INirq_M;
}	/* DisINrdy */

void	SetINeni(void)		// . pp. pp.  p pp.
{
if ((INrdy) && (INeni == false))
	*IRQ |= INirq_M;
INeni = true;
}	/* SetINeni */

void	DisINeni(void)		// p饭 pp뢠
{
INeni = false;
*IRQ &= ~INirq_M;
}	/* DisINeni */

uns	GetINcsr(void)		// ⥭ pp ﭨ p
{
uns	INcsr	= 0;
if (INrdy == true)	INcsr = 0200;
if (INeni == true)	INcsr |= 0100;
return(INcsr);
}	/* GetINcsr */

void _fastcall	PutINcsr(uns CSR)	//  pp ﭨ p
{
if (CSR & 0100)
	SetINeni();
else	DisINeni();
}	/* PutINcsr */

int	GetINdat(void)		// ⥭ pp  p
{
if (KbCnt == 0)
  if (kbhit())	MakeNewChar();
if (KbCnt)
	INdat = GetKb();
DisINrdy();
SetINrdy();
return(I            	            K 	            K           2       2     	             K 	             K              U              U 4         U                    0       U              U 4         U                           U              U              U              U              U              U              U              U              U ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U     ,           U       U                  U  $                            x  *                          9              9       x  *                          2              2              2              2              2              2              2              2              2              2              2              2              A              2              2              2              A              2              2              2 4         @                            2              2              2              2 4         A                            2              2              2 4         A                            2              2              2 4         A                            2              2          9                        9                        9                        9                        9                        9                d                      4         2                           2              2        `     2       `     2       `     2       `     2       `     2       `     2              2             2         2                           2              2        0     2        @     2       P     2       `     2        P     2        @     2        0     2              2             2            2       2                2       2                2       2      d        2       2                2       2               2       2             2                     `     2        `     2       `     2         2                     `     2             2            2             2            2       `     2       `     2       `     2       `     2         2                       2                            2              A              2              2 4         A                            2          9                        9                            2              2              2              A              2              2 4         A                            2          9                        9                            2              2              2              2              2              2              2              2              2              2              A              2              2              2              2              2              2              A              2              2              2 ,           @                          2              2              2              2          2                        2               4         2                        2                        2               4         2                $        2              $   