/*
 * Copyright (c) 2006, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the uIP TCP/IP stack
 *
 * $Id: clock-arch.c,v 1.2 2006/06/12 08:00:31 adam Exp $
 */

/**
 * \file
 *         Implementation of architecture-specific clock functionality
 * \author
 *         Adam Dunkels <adam@sics.se>
 */

#include "clock-ar.h"

static unsigned char  OldINT50B;
static unsigned short OldINT50W;

static clock_time_t clock_count;

/*
    nop
    ld HL,(_clock_count)
    inc HL
    ld (_clock_count),HL
    nop
    ld A,(_OldINT50B)
    nop 
    ld HL,(_OldINT50W)
    nop 
    jp 61956		; BJMP 61956=0xF204
*/
unsigned short clock_update[]={ 0x2A00, (unsigned short)(void*)&clock_count,
				0x2223, (unsigned short)(void*)&clock_count,	
				0x3A00, (unsigned short)(void*)&OldINT50B,
				0x2A00, (unsigned short)(void*)&OldINT50W,
				0xC300, 0xF204 };

/*				ix+6	*/	
void clock_init(void)
{
  clock_count=0;
#asm
    di
#endasm
  OldINT50B=*INT50B;
  OldINT50W=*INT50W; 
  *INT50B=*MARKER;		/* memory page where we are executing */   
  *INT50W=(unsigned short)(void*)&clock_update[0];
#asm
    ei
#endasm
}
 
void clock_restore(void)
{
#asm
    di
#endasm
  *INT50B=OldINT50B;
  *INT50W=OldINT50W; 
#asm
    ei
#endasm
}

/*---------------------------------------------------------------------------*/
clock_time_t clock_time(void)
{
  return clock_count;
}
/*---------------------------------------------------------------------------*/
