/*
 * Copyright (c) 2001, Adam Dunkels.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Adam Dunkels.
 * 4. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This file is part of the uIP TCP/IP stack.
 *
 * $Id: main.c,v 1.16 2006/06/11 21:55:03 adam Exp $
 *
 */

#define _NOINC_

#include "uip-arch.h"
/* #include <stdio.h> */

#include "uip-app.h"
#include "uip-base.h"
#include "uip-ext.h"
#include "uip-arp.h"
#include "timer.h"

#define BUF ((struct uip_eth_hdr *)&uip_buf[0])

#ifndef NULL
#define NULL (void *)0
#endif /* NULL */

extern struct uip_eth_addr uip_ethaddr;
static struct uip_eth_addr ethaddr = {{0x00,0xFF,'S','E','R','G'}};

/*---------------------------------------------------------------------------*/
int
main(void)
{
  register int i;
  uip_ipaddr_t ipaddr;
  struct timer periodic_timer, arp_timer;

  timer_set(&periodic_timer, CLOCK_SECOND / 2);
  timer_set(&arp_timer, CLOCK_SECOND * 10);

  /* Initialise the uIP TCP/IP stack. */
  uip_init();

  uip_setethaddr(ethaddr);		/* MAC address */
  
  uip_ipaddr(ipaddr, 172,20,0,2);	/* host IP */
  uip_sethostaddr(ipaddr);
  uip_ipaddr(ipaddr, 172,20,0,1);	/* gateway IP */
  uip_setdraddr(ipaddr);
  uip_ipaddr(ipaddr, 255,255,255,0);	/* IP mask */
  uip_setnetmask(ipaddr);

kprintf("My address/mask: %d.%d.%d.%d", uip_ipaddr1(uip_hostaddr),
        uip_ipaddr2(uip_hostaddr), uip_ipaddr3(uip_hostaddr),
        uip_ipaddr4(uip_hostaddr));
kprintf(" / %d.%d.%d.%d\n", uip_ipaddr1(uip_netmask),
        uip_ipaddr2(uip_netmask), uip_ipaddr3(uip_netmask),
        uip_ipaddr4(uip_netmask));

  /* Initialise the app. */
#ifdef UIP_APPINIT
      UIP_APPINIT();
#else
      app_init();
#endif
  
  /*  telnetd_init();*/
  
  /*  hello_world_init();*/

  /*  {
      u8_t mac[6] = {1,2,3,4,5,6};
      dhcpc_init(&mac, 6);
      }*/
  
  /*uip_ipaddr(ipaddr, 127,0,0,1);
  smtp_configure("localhost", ipaddr);
  SMTP_SEND("adam@sics.se", NULL, "uip-testing@example.com",
	    "Testing SMTP from uIP",
	    "Test message sent by uIP\r\n");*/

  /*
    webclient_init();
    resolv_init();
    uip_ipaddr(ipaddr, 195,54,122,204);
    resolv_conf(ipaddr);
    resolv_query("www.sics.se");*/

  /* Initialise the ARP cache. */
  uip_arp_init();
  
  /* Initialise timer. */
  clock_init();

  /* Initialise the device driver. */ 
  DEVICE_INIT();

  while(1) {
    uip_len = DEVICE_READ();
    if(uip_len > 0) {
      if(BUF->type == htons(UIP_ETHTYPE_IP)) {
	uip_arp_ipin();
	uip_input();
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
	if(uip_len > 0) {
	  uip_arp_out();
/*
UIP_LOG("send1");
*/
	  DEVICE_SEND();
	}
      } else if(BUF->type == htons(UIP_ETHTYPE_ARP)) {
	uip_arp_arpin();
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
	if(uip_len > 0) {
/*
UIP_LOG("send2");
*/
	  DEVICE_SEND();
	}
      }

    } else if(timer_expired(&periodic_timer)) {
      timer_reset(&periodic_timer);
      for(i = 0; i < UIP_CONNS; i++) {
	uip_periodic(i);
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
	if(uip_len > 0) {
	  uip_arp_out();
/*
UIP_LOG("send3");
*/
	  DEVICE_SEND();
	}
      }

#if UIP_UDP
      for(i = 0; i < UIP_UDP_CONNS; i++) {
	uip_udp_periodic(i);
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
	if(uip_len > 0) {
	  uip_arp_out();
/*
UIP_LOG("send4");
*/
	  DEVICE_SEND();
	}
      }
#endif /* UIP_UDP */
      
      /* Call the ARP timer function every 10 seconds. */
      if(timer_expired(&arp_timer)) {
	timer_reset(&arp_timer);
	uip_arp_timer();
      }
    }
  }
  clock_restore();  
  return 0;
}
/*---------------------------------------------------------------------------*/
void
uip_log(char *m)
{
  kprintf("uIP> %s\n", m);
}

#ifdef __RESOLV_H__ 
void
resolv_found(char *name, register u16_t *ipaddr)
{
/*  u16_t *ipaddr2; */
  
  if(ipaddr == NULL) {
    kprintf("Host '%s' not found.\n", name);
  } else {
    kprintf("Found name '%s' = %d.%d.%d.%d\n", name,
	   htons(ipaddr[0]) >> 8,
	   htons(ipaddr[0]) & 0xff,
	   htons(ipaddr[1]) >> 8,
	   htons(ipaddr[1]) & 0xff);
    /*    webclient_get("www.sics.se", 80, "/~adam/uip");*/
  }
}
#endif  /* __RESOLV_H__ */

#ifdef __DHCPC_H__
void
dhcpc_configured(register struct dhcpc_state *s)
{
  uip_sethostaddr(s->ipaddr);
  uip_setnetmask(s->netmask);
  uip_setdraddr(s->default_router);
  resolv_conf(s->dnsaddr);
}
#endif /* __DHCPC_H__ */

#ifdef __SMTP_H__
void
smtp_done(unsigned char code)
{
  kprintf("SMTP done with code %d\n", code);
}
#endif /* __SMTP_H__ */

#ifdef __WEBCLIENT_H__
void
webclient_closed(void)
{
  kprintf("Webclient: connection closed\n");
}
void
webclient_aborted(void)
{
  kprintf("Webclient: connection aborted\n");
}
void
webclient_timedout(void)
{
  kprintf("Webclient: connection timed out\n");
}
void
webclient_connected(void)
{
  kprintf("Webclient: connected, waiting for data...\n");
}
void
webclient_datahandler(char *data, u16_t len)
{
  kprintf("Webclient: got %d bytes of data.\n", len);
}
#endif /* __WEBCLIENT_H__ */
/*---------------------------------------------------------------------------*/
