
#define _NOINC_

#include "timer.h"
#include "httpd.h"
#include "uip-base.h"
#include "uip-arp.h"
#include "uip-arch.h"

struct ethip_hdr {
  struct uip_eth_hdr ethhdr;
  /* IP header. */
  u8_t vhl,
    tos,
    len[2],
    ipid[2],
    ipoffset[2],
    ttl,
    proto;
  u16_t ipchksum;
  u16_t srcipaddr[2],
    destipaddr[2];
};

struct timer test_timer;

u8_t uip_buf[1500];
uip_ipaddr_t dest;
#define IPBUF ((struct ethip_hdr *)&uip_buf[0])

void main()
{
  char ch='A';

  uip_ipaddr_copy(dest, IPBUF->destipaddr);

  timer_set(&test_timer, CLOCK_SECOND);

  kprintf("\nCLOCK_SECOND=%d\n", CLOCK_SECOND);

  clock_init();

  while (!kbhit() /*bios(NCONSTS)*/) /* returns 255 if a key has been pressed, 0 otherwise. */
  {
    bios(NCONOUT, ch);
    ch++;
    while (!timer_expired(&test_timer)) continue;
    timer_reset(&test_timer);
  }
  clock_restore();
  return;
}

