<?php
/*======================================================================*\
|| #################################################################### ||
|| # Threadmins by Revan aka Belazor                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # This hack lets you configure users as so-called "threadmins",    # ||
|| # or administrators of one or more threads, each with their own    # ||
|| # individual set of permissions for this thread only.              # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2004-2005 NeoMateria Productions. All Rights Reserved # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.neomateria.net | http://www.neomateria.net/licence    # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'threadmin');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// get templates used by all actions
$globaltemplates = array(
	'tdm_manage',
	'tdm_manage_opt'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'validate';
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!can_administer('canadminthreads'))
{
	// We don't want tricksssy hobbitsesss here!
	print_no_permission();
}

// #######################################################################
if ($_REQUEST['do'] != 'validate')
{
	$_REQUEST['olddo'] = $_REQUEST['do'];
	$_REQUEST['do'] = 'validate';
}

// #######################################################################
$options = array();
$options['caneditposts'] = 1;
$options['candeleteposts'] = 2;
$options['canremoveposts'] = 131072;
$options['canopenclose'] = 4;
$options['caneditthreads'] = 8;
$options['canmanagethreads'] = 16;
$options['caneditpoll'] = 1048576;

// #######################################################################
if ($_REQUEST['do'] == 'validate')
{
	$vbulletin->input->clean_array_gpc('r', array(
		't'					=> TYPE_UINT,
		'u'					=> TYPE_UINT,
		'threadminperms'	=> TYPE_ARRAY_BOOL
	));
	
	switch ($_REQUEST['olddo'])
	{
		case 'manage':
		case 'update':
			if (!$_REQUEST['threadid'])
			{
				// Invalid Thread is bad, mmmkay? Mmmkay.
				eval(standard_error(fetch_error('invalidid', $vbphrase['thread'])));
			}
			$thread = $db->query_first("SELECT `threadid`, `title` FROM `" . TABLE_PREFIX . "thread` WHERE `threadid` = '" . intval($_REQUEST['threadid']) ."'");
			if (!$thread)
			{
				// Invalid Thread is bad, mmmkay? Mmmkay.
				eval(standard_error(fetch_error('invalidid', $vbphrase['thread'])));
			}
			
			if (!$_REQUEST['userid'])
			{
				// Revert to self
				$_REQUEST['userid'] = $vbulletin->userinfo['userid'];
			}
			if ($_REQUEST['userid'] == $vbulletin->userinfo['userid'])
			{
				// Self
				$user = $vbulletin->userinfo;
			}
			else
			{
				// Some random astard
				$user = $db->query_first("SELECT `userid`, `username`, `threadmin` FROM `" . TABLE_PREFIX . "user` WHERE `userid` = '" . intval($_REQUEST['userid']) . "'");
			}
			if (!$user)
			{
				// Invalid User is bad, mmmkay? Mmmkay.
				eval(standard_error(fetch_error('invalidid', $vbphrase['user'])));
			}
	
			break;
		
		default: // throw an error about invalid $_REQUEST['do']
			$handled_do = false;
			
			if (!$handled_do)
			{
				eval(standard_error(fetch_error('invalid_action')));
			}
	}
	
	// Unserialize the useroptions
	$useroptions = unserialize($user['threadmin']);

	// Revert to default $_REQUEST['do']
	$_REQUEST['do'] = $_REQUEST['olddo'];
}

// #######################################################################
if ($_REQUEST['do'] == 'manage')
{
	foreach ($options as $opt => $bit)
	{
		// Setup the vBPhrase with proper prefix
		$phrase = $vbphrase['tdm_' . $opt];
		
		$yes = $no = '';
		
		// Check to see if option is enabled or not
		if ($useroptions["$thread[threadid]"] & $vbulletin->bf_misc_moderatorpermissions["$opt"])
		{
			//echo $opt . '<br />';
			// Check the yes box
			$yes = ' checked="checked"';
		}
		else
		{
			// Check the no box
			$no = ' checked="checked"';
		}
		
		eval('$tdmoptions .= "' . fetch_template('tdm_manage_opt') . '";');
	}
	
	$navbits[] = $vbphrase['tdm_threadmin_management'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('tdm_manage') . '");');
}

// #######################################################################
if ($_POST['do'] == 'update')
{
	$useroptions["$_REQUEST[threadid]"] = 0;
	foreach ($vbulletin->GPC['threadminperms'] as $opt => $onoff)
	{
		if ($onoff)
		{
			// If its enabled, add its bit
			$useroptions["$_REQUEST[threadid]"] += $options["$opt"];
		}
	}
	
	// Write to database
	$db->query_write("
		UPDATE `" . TABLE_PREFIX . "user`
		SET `threadmin` = '" . serialize($useroptions) . "'
		WHERE `userid` = '" . intval($_REQUEST['userid']) . "'
	");
	
	$vbulletin->url = 'showthread.php?' . $vbulletin->session->vars['sessionurl'] . "t=" . intval($_REQUEST['threadid']);
	eval(print_standard_redirect('redirect_tdm_threadmin_permissions_updated', true, true));
}

/*======================================================================*\
|| ####################################################################
|| # Created: 16:14, Fri Jun 2nd 2006
|| # SVN: $RCSfile: threadmin.php,v $ - $Revision: $WCREV$ $
|| ####################################################################
\*======================================================================*/
?>