<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'threadmin_admin');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// get templates used by all actions
$globaltemplates = array(
	'tdm_summary',
	'tdm_manage_summary'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'view';
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

/* if (!can_administer('canadminthreads'))
{
	print_no_permission();
} */

if (!($permissions['threadmin_adminpermissions'] & $vbulletin->bf_ugp['threadmin_adminpermissions']['threadmin_adminpermissions_view']))
{
	print_no_permission();
}


// #######################################################################
$options = array();
$options['caneditposts'] = 1;
$options['candeleteposts'] = 2;
$options['canremoveposts'] = 131072;
$options['canopenclose'] = 4;
$options['caneditthreads'] = 8;
$options['canmanagethreads'] = 16;
$options['caneditpoll'] = 1048576;

// #######################################################################


if ($_REQUEST['do'] == 'delete')
{
	if (!($permissions['threadmin_adminpermissions'] & $vbulletin->bf_ugp['threadmin_adminpermissions']['threadmin_adminpermissions_delete']))
	{
		print_no_permission();
	}
	
	
	$vbulletin->input->clean_array_gpc('r', array(
		'u' => TYPE_UINT,
		't'		 => TYPE_UINT
	));
	
	if (!$vbulletin->GPC['t'])
	{
		// Invalid Thread
		eval(standard_error(fetch_error('invalidid', $vbphrase['thread'])));
	}
	
	if (!$vbulletin->GPC['u'])
	{
		// Invalid userid
		eval(standard_error(fetch_error('invalidid', $vbphrase['userid'])));
	}
	
	$users = $db->query_read("SELECT `userid`, `username`, `threadmin` FROM `" . TABLE_PREFIX . "user` WHERE `userid` = '" . intval($vbulletin->GPC['u']) . "' ORDER BY username");
	
	$removethread = $vbulletin->GPC['t']; // thread to have permissions removed
	$useroptions_new = '';
	
	if ($db->num_rows($users) > 0){
		while ($user = $db->fetch_array($users)){ 
			$HTML .= $user['username']."<br />";
		  
			// Unserialize the useroptions
			$useroptions = unserialize($user['threadmin']);
			
			
			//loop through the elements of the serial data skipping the bit we don't want
			if($user[threadmin])
			{
				foreach ($useroptions AS $key => $val)
				{
					if($key != $removethread AND $key != 0)
					{
						$HTML .= $key."&nbsp;".$val."<br />";
						// add bit for threads to keep
						$useroptions_new["$key"] += $val;
					}
				}			
			}
		}
			// Write to database
			$db->query_write("
				UPDATE `" . TABLE_PREFIX . "user`
				SET `threadmin` = '" . iif($useroptions_new == '','',serialize($useroptions_new)) . "'
				WHERE `userid` = '" . intval($vbulletin->GPC['u']) . "'
			");
	}


	
	$_REQUEST['do'] = 'view'; // return to the view page
	$vbulletin->url = 'threadmin_admin.php';
	eval(print_standard_redirect('redirect_tdm_threadmin_permissions_updated', true, true));

}


if ($_REQUEST['do'] == 'view')
{
    // check delete permissions
	if (!($permissions['threadmin_adminpermissions'] & $vbulletin->bf_ugp['threadmin_adminpermissions']['threadmin_adminpermissions_delete']))
	{
		$deleteallowed = 0;
	} else {
		$deleteallowed = 1;
	}
	
	
	$users = $db->query_read("SELECT `userid`, `username`, `threadmin` FROM `" . TABLE_PREFIX . "user` WHERE `threadmin` != '' ORDER BY username");
	
	if ($db->num_rows($users) > 0){
	  while ($user = $db->fetch_array($users)){
	
		// Unserialize the useroptions
		$useroptions = unserialize($user['threadmin']);
	
		foreach ($useroptions AS $key => $val) {
				
					$thread = $db->query_first("SELECT `threadid`, `title` FROM `" . TABLE_PREFIX . "thread` WHERE `threadid` = '" . intval($key) ."'");
					if (!$thread)
					{
						// If thread is hard deleted, remove threadmin permissions
						$vbulletin->url = "threadmin_admin.php?do=delete&amp;t=" . intval($key)."&amp;u=".$user['userid'];
						eval(print_standard_redirect('redirect_tdm_threadmin_permissions_updated', true, true));
					}

		
				foreach ($options as $opt => $bit)
				{
					// Check to see if option is enabled or not
					if ($useroptions["$thread[threadid]"] & $vbulletin->bf_misc_moderatorpermissions["$opt"])
					{
						// print type of permission, sloppy adding the list tags here, I guess I should add another template
						$phrase .= '<li>'.$vbphrase['tdm_' . $opt].'</li>';

					}

				}						
				
				if ($phrase != '')
				{
					exec_switch_bg();
					eval('$tdmoptions .= "' . fetch_template('tdm_manage_summary') . '";');
					$phrase = '';
				}
				
		}						
		
	  }
	} else {
		$errormessage = $vbphrase['tdm_threadmin_no_threads'];
		eval('print_output("' . fetch_template('STANDARD_ERROR') . '");');
		exit();
	}
	
	$navbits[] = $vbphrase['tdm_threadmin_management'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('tdm_summary') . '");');
}
?>