    DEVICE ZXSPECTRUM128

    ORG  #6200

BEGIN:

    DI
    LD   SP,#61FF
;    CALL WG_REST
;    CALL WG_OFF
    JP   START_P
    NOP

HELLO:
    DEFM "HELLO TO  : ARKAN,  J.V.B.,  SAM,   "
    DEFM "KOROTKOV ELDAR,  D&K,   T.V.I.,   "
    DEFM "L.Y.N.,  BRAIN,  KUTIN V.,   "
    DEFM "VOVA-KILLER,   IWANSOFT,  ETC  ...   "
    NOP

START_P:
    CALL INIT_DR
    JR   ST_PROG

PRG_ERR:
    CALL WG_OFF
    CALL PLAY_NO

ST_PROG:
    DI
    LD   SP,#61FF
    CALL SCR_CLS

    LD   SP,#4038

    CALL N_BREAK
    CALL SOUND_1
    CALL CH_OPEN
    CALL MAK_FNT

START:
    CALL PRT_MAS
    CALL ONL_ENT
    JR   CONT_IN

AGAIN:
    CALL KEY_ENT
CONT_IN:
    CALL INIT
    CALL PRT_CHK
    CALL WG_ON
    CALL WG_REST
    CALL TEST_TV
    CALL LOADER
DAT_XOR:
    CALL XOR_DAT
    CALL RET_DAT
    CALL WG_REST

    CALL RE_REST

    CALL WG_REST
    CALL WG_OFF
    CALL PRT_FRM
    CALL KEY_Y_N
    CALL PRT_COP
    CALL KEY_ENT
    CALL PRT_RES
    CALL WG_ON
    CALL WG_REST

    CALL WR_REST

    CALL WG_REST
    LD   D,#00
    CALL FORM_TR
    CALL WG_REST
    CALL SAV_CAT
    CALL REST_TR
    CALL WG_REST
    CALL WG_OFF
    CALL PRT_OK
    CALL SOUND_1
    CALL WG_PAUS
    CALL ZVUK3
    JR   AGAIN

; ------ ;
SCR_CLS:
    XOR  A
    OUT  (#FE),A
    LD   (23624),A
    LD   HL,23295
    LD   DE,23294
    LD   BC,6911
    LD   (HL),A
    LDDR
    RET

; ------ ;
N_BREAK:
    LD   HL,51697
    LD   (23746),HL
    RET

; ------ ;
CH_OPEN:
    LD   A,#02
    CALL 5633
    RET

; ------ ;
INIT:
    LD   A,36
    LD   (MAX_FIL+1),A
    XOR  A
    LD   (NUM_FIL),A
    LD   HL,BUF_DAT
    LD   (BUF_IX),HL
FM_INIT:
    LD   (FORM_TR),A
    LD   (REST_TR),A
    RET

; ------ ;
ONL_ENT:
    LD   A,#BF
    IN   A,(#FE)
    RRA
    JR   C,ONL_ENT

    CALL NC,SOUND_2
    RET

; ------ ;
KEY_ENT:
    LD   A,#BF
    IN   A,(#FE)
    RRA
    JR   NC, PRS_ENT

KEY_SPC:
    LD   A,#7F
    IN   A,(#FE)
    RRA
    JR   C,KEY_ENT

PRS_SPS:
    JP   ST_PROG

PRS_ENT:
    CALL NC,SOUND_2
    RET

; ------ ;
KEY_Y_N:
    LD   A,#DF
    IN   A,(#FE)
    BIT  4,A
    JR   Z,PRS_Y

    LD   A,#7F
    IN   A,(#FE)
    BIT  3,A
    JR   NZ,KEY_Y_N

PRS_N:
    CALL SOUND_2
    LD   A,#C9
    JR   FM_INIT

PRS_Y:
    CALL SOUND_2
    XOR  A
    JR   FM_INIT

; ------ ;
NUM_FIL:
    DEFB #00

; ------ ;
BUF_IX:
    DEFW BUF_DAT

; ------ ;
BOOT:
    DEFM "boot    "

; ------ ;
LDI_DTM:
    LD   HL, DAT_MEM
LDI_DT1:
    LD   DE,BUF_DAT
    LD   BC,256
    LDIR
    RET

; ------ ;
MAK_FNT:
    LD   HL,#3D00
    LD   DE,BUF_FNT
    PUSH DE
    LD   BC,768
M_FNT1:
    LD   A,(HL)
    RRA
    OR   (HL)
    LD   (DE),A
    INC  HL
    INC  DE
    DEC  BC
    LD   A,B
    OR   C
    JR   NZ,M_FNT1
    POP  HL
    DEC  H
    LD   (23606),HL
    RET

; ------ ;
PRT_MAS:
    LD   DE,MAS_TXT
    JR   PRINT
PRT_COP:
    LD   DE,COP_TXT
    JR   PRINT
PRT_FRM:
    LD   DE,FRM_TXT
    JR   PRINT
PRT_CHK:
    LD   DE,CHK_TXT
    JR   PRINT
PRT_WRK:
    LD   DE,WRK_TXT
    JR   PRINT
PRT_RES:
    LD   DE,RES_TXT
    JR   PRINT
PRT_OK:
    LD   DE,OK_TXT
    JR   PRINT
PRT_NO:
    LD   DE,NO_TXT
PRINT:
    LD   BC,45
    JP   8252

; ------ ;
MAS_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#07,#13,#01
    DEFM "    INSERT MASTER DISK    "
    DEFB #16,#0C,#0C
    DEFM "<ENTER>"

COP_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#06,#13,#01
    DEFM "INSERT COPY OF MASTER DISK"
    DEFB #16,#0C,#0C
    DEFM "<ENTER>"

FRM_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#02,#13,#01
    DEFM "RE-FORMAT CAT & F_TRACK ? "
    DEFB #16,#0C,#0C
    DEFM "< Y/N >"

CHK_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#04,#13,#01
    DEFM "NOW CHECKING LABEL OF DISK"
    DEFB #16,#0C,#0C
    DEFM " "

WRK_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#05,#13,#01
    DEFM "  NOW LOADING & DECODING  "
    DEFB #16,#0C,#0C
    DEFM " "

RES_TXT:
    DEFB #16,#0A, #03,#11,#00,#10,#05,#13,#01
VER_RES:
    DEFM "NOW RESTORING - FANTOM 4.5"
    DEFB #16,#0C,#0C
    DEFM " "

OK_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#04,#13,#01
    DEFM "DISK RESTORED, INSERT NEXT"
    DEFB #16,#0C,#0C
    DEFM "<ENTER>"

NO_TXT:
    DEFB #16,#0A,#03,#11,#00,#10,#03,#13,#01
    DEFM "NO FANTOM NUMBER 4.0 - 4.5"
    DEFB #16,#0C,#0C
    DEFM "<ENTER>"

; ------ ;
TEST_TV:
    CALL CATALOG

    LD   IX,NAME_DI  ; NAME OF DISK = TV_._ #10
    LD   A,(IX+#00)
    CP   "T"
    JP   NZ,NO_FPS
    LD   A,(IX+#01)
    CP   "V"
    JP   NZ,NO_FPS
    LD   A,(IX+#03)
    CP   "."

; ------ ;
    JP   NZ,NO_FPS
    LD   A,(IX+#05)
    CP   #10
    JP   NZ,NO_FPS

; ------ ;
    LD   A,(IX+#02)
    CP   #31
    JR   Z,FPS_1X
    CP   #32
    JR   Z,FPS_2X
    CP   #33
    JR   Z,FPS_3X
    CP   #34
    JP   NZ,NO_FPS

; ------ ;
FPS_4X:
    LD   A,(IX+#04)
    CP   #30
    JP   Z,FPS_40
    CP   #31
    JP   Z,FPS_41
    CP   #32
    JP   Z,FPS_42
    CP   #35
    JP   Z,FPS_45
    JP   NZ,NO_FPS

; ------ ;
FPS_3X:
    LD   A,(IX+#04)
    CP   #30
    JP   Z,FPS_30
    CP   #31
    JP   Z,FPS_31
    JP   NZ,NO_FPS

; ------ ;
FPS_2X:
    LD   A,(IX+#04)
    CP   #30
    JP   Z,FPS_20
    JP   NZ,NO_FPS

; ------ ;
FPS_1X:
    LD   A,(IX+#04)
    CP   #30
    JP   Z,FPS_10
    CP   #31
    JP   Z,FPS_11
    CP   #32
    JP   Z,FPS_12
    CP   #33
    JP   Z,FPS_13
    CP   #34
    JP   Z,FPS_14
    JP   NZ,NO_FPS

; ------ ;
NO_FPS:
    CALL WG_OFF
    CALL PRT_NO
    CALL SOUND_3
    CALL WG_PAUS

    CALL PLAY_NO

    CALL KEY_ENT
    POP  AF
    JP   START

; ------ ;
YES_FPS:
    CALL INI_VER   ; HL
    CALL INI_YES   ; IX

    CALL PRT_WRK
    CALL PLAY_YE

    LD   IX,BUF_CAT
    LD   BC,16
AGAIN_8:
    PUSH BC
    PUSH IX
    LD   A,(IX+#00)
    OR   A
    JP   Z,QUIT_F8
    CP   #01
    JP   Z,NXT_FIL
    LD   A,(IX+#08)
    CP   #42
    JP   NZ,NXT_FIL

    PUSH IX
    LD   B,#08
    LD   HL,BOOT
CP_BT_0:
    LD   A,(HL)
    CP   (IX+#00)
    JR   NZ,CON_YES
    INC  HL
    INC  IX
    DJNZ CP_BT_0
    POP  IX
    JR   NXT_FIL

CON_YES:
    POP  IX

    LD   A,(IX+#09)

CAT_9_0:
    CP   #DC
    JR   NZ,NXT_FIL
    LD   A,(IX+#0A)
CAT_A_0:
    CP   #00
    JR   NZ,NXT_FIL
    LD   A,(IX+#0B)
CAT_B_0:
    CP   #DC
    JR   NZ,NXT_FIL
    LD   A,(IX+#0C)
CAT_C_0:
    CP   #00
    JR   NZ,NXT_FIL
    LD   A,(IX+#0E)
    CP   #08
    JR   NZ,NXT_FIL

FANT_TR:
    LD   A,(IX+#0F)
    LD   (LOADER+1),A
    LD   (FPS_TRK+1),A
    LD   (TRK_FAN+1),A
    LD   (S53_TR1+1),A
    LD   (S53_TR2+1),A

    OR   A
    JR   Z,C0NT_T1
    LD   A,#20
    JR   CONT_T2
C0NT_T1:
    LD   A,#24
CONT_T2:
    LD   (WG_CODE+1),A
    CALL LOAD_FN

    POP  IX
    POP  BC
    RET

QUIT_F8:
    POP  IX
    POP  BC

    POP  AF
    JP   NO_FPS

NXT_FIL:
    POP  IX
    POP  BC
    ADD  IX,BC
    JP   AGAIN_8

; ------ ;
LOAD_FN:
    LD   HL,BUF_LD
    LD   BC,#0105
FPS_TRK:
    LD   D,#00
    LD   E,#08
    CALL DISK_DR
    RET

; ------ ;
CATALOG:
    LD   HL,BUF_CAT
    LD   DE,#0000
    LD   BC,#0905
    CALL DISK_DR
    RET

; ------ ;
INI_YES:
    LD   A,(IX+#00)
    LD   (CAT_9_0+1),A
    LD   (CAT_9_1+1),A
    LD   A,(IX+#01)
    LD   (CAT_A_0+1),A
    LD   (CAT_A_1+1),A
    LD   A,(IX+#02)
    LD   (CAT_B_0+1),A
    LD   (CAT_B_1+1),A
    LD   A,(IX+#03)
    LD   (CAT_C_0+1),A
    LD   (CAT_C_1+1),A
    RET

; ------ ;
INI_VER:
    LD   A,H
    LD   (VER_RES+#17),A
    LD   A,L
    LD   (VER_RES+#19),A
    RET

; ------ ;
LOADER:
    LD   D,#00
    LD   A,D
    LD   (LOAD_TR+1),A
    CALL TRACK

    CALL INIT_R
LOAD_3:
    LD   BC,#070A
LOAD_2:
    LD   DE,F42_PAT
    LD   HL,BUF_LD
LOAD_1:
    LD   A,(DE)
    CALL SECTOR
    JR   NZ,LOAD_ER
    INC  H
    INC  DE
    DJNZ LOAD_1
    RET

LOAD_ER:
    PUSH HL
    LD   HL,LOAD_2
    LD   (TREAT_A+1),HL
    POP  HL
LOAD_TR:
    LD   D,#00

    CALL TREAT_E

    JP   Z,ST_PROG
    JR   C,LOAD_3
    JP   NC,ST_PROG

; ------ ;
LD_S53:
    CALL INIT_R
S53_TR1:
    LD   D,#00
    CALL TRACK

AGN_D53:
    LD   C,#0A
AGN_S53:
    LD   HL,BUF_LD
    LD   A,#53
    CALL SECTOR
    RET  NZ

S53_ERR:
    PUSH HL
    LD   HL,AGN_S53
    LD   (TREAT_A+1),HL
    POP  HL

S53_TR2:
    LD   D,#00
    CALL TREAT_E

    JP   Z,ST_PROG
    JR   C,AGN_D53
    JP   NC,ST_PROG

; ------ ;
RET_DAT:
    LD   IX,BUF_CAT
    LD   BC,16
AGAIN_1:
    PUSH BC
    PUSH IX
    LD   A,(IX+#00)
    OR   A
    JR   Z,QUIT_L1
    CP   #01
    JR   Z,NEXT_FL
    LD   A,(IX+#08)
    CP   #42
    JR   NZ,NEXT_FL

    PUSH IX
    LD   B,#08
    LD   HL,BOOT
CP_BT_1:
    LD   A,(HL)
    CP   (IX+#00)
    JR   NZ,CP_FANT
    INC  HL
    INC  IX
    DJNZ CP_BT_1
    POP  IX
    JR   NEXT_FL

CP_FANT:
    POP  IX

    LD   A,(IX+#09)
CAT_9_1:
    CP   #DC
    JR   NZ,QUIT_L1
    LD   A,(IX+#0A)
CAT_A_1:
    CP   #00
    JR   NZ,QUIT_L1
    LD   A,(IX+#0B)
CAT_B_1:
    CP   #DC
    JR   NZ,QUIT_L1
    LD   A,(IX+#0C)
CAT_C_1:
    CP   #00
    JR   NZ,QUIT_L1
    LD   A,(IX+#0E)
    CP   #08
    JR   NZ,QUIT_L1

    PUSH IX

NO_BOOT:
    POP  HL
    LD   BC,#09
    ADD  HL,BC
    EX   DE,HL
    CALL LDI_DAT
    LD   HL,NUM_FIL
    INC  (HL)
    LD   A,(HL)
MAX_FIL:
    CP   36
    JR   C,NEXT_FL
QUIT_L1:
    POP  IX
    POP  BC
    RET

NEXT_FL:
    POP  IX
    POP  BC
    ADD  IX,BC
    JR   AGAIN_1

LDI_DAT:
    LD   IX,(BUF_IX)
    LD   B,#07
B7_LDIR:
    LD   A,(IX+#00)
    LD   (DE),A
    INC  IX
    INC  DE
    DJNZ B7_LDIR
    LD   (BUF_IX),IX
    RET

; ------ ;
RE_REST:
    LD   A,#05
    LD   (D_MODE+1),A
    XOR  A
    LD   (JR_MD_3),A
    JR   RESTORE

WR_REST:
    LD   A,#06
    LD   (D_MODE+1),A
    LD   A,#C9
    LD   (JR_MD_3),A

; ------ ;
RESTORE:
    LD   IX,BUF_DAT
    LD   A,(NUM_FIL)
    OR   A
    JP   Z,PRG_ERR
    CP   37
    JP   NC,PRG_ERR
    LD   B,A
    LD   HL,BUF_LD
REST_1:
    PUSH BC
    LD   B,1
    LD   E,(IX+#05)
    LD   A,E
    CP   16
    JP   NC,PRG_ERR
    LD   D,(IX+#06)
    LD   A,D
    CP   160
    JP   NC,PRG_ERR
    PUSH HL
    PUSH IX
D_MODE:
    LD   C,#05
    CALL DISK_DR
    POP  IX
    POP  HL
    LD   BC,#07
    ADD  IX,BC
    POP  BC
    INC  H
    DJNZ REST_1
JR_MD_3:
    NOP
BAS_XOR:
    CALL XOR_BAS
    RET

; ------ ;
REST_TR:
    NOP

TRK_FAN:
    LD   D,#00

    CALL TRACK
    LD   HL,BUF_LD
    LD   BC,#0905
    LD   E,#00
    PUSH DE

    CALL DISK_DR
    POP  DE
    PUSH DE
    CALL FORM_TR
    POP  DE
    LD   HL,BUF_LD
    LD   BC,#0906
    LD   E,#00
    CALL DISK_DR
    RET

; ------ ;
FORM_TR:
    NOP

    CALL TRK_MOD
    LD   (CHK_FRM+1),A
    CALL TRACK
    LD   HL,#5CD8
    LD   A,(HL)
    LD   (BUF_CD8+1) ,A
    LD   A,#01
    LD   (HL),A

    XOR  A
    CALL TO_3F
    LD   A,#0A
    CALL TO_5F

    CALL TRK_MOD
    LD   E,A


    LD   HL,PATTERN
    LD   A,#F0
    CALL TO_1F
    PUSH DE
    CALL FORMAT
    POP  DE

    PUSH  AF
BUF_CD8:
    LD   A,#00
    LD   (#5CD8),A
    POP  AF

    CP   #0A
    JR   NZ,CHK_FRT

    LD   C,#01      ; WRITE PROTECTION
    CALL TREAT_E

    JP   Z,ST_PROG
    JR   C,FORM_TR
    JP   NC,ST_PROG

CHK_FRT:
    CALL INIT_R

CHK_FRM:
    LD   A,#00
    CALL TO_3F
    LD   E,#01

    LD   HL,BUF_SEC
    LD   BC,#1001
CHK_F01:
    LD   A,E
    CALL SECTOR
    JR   NZ,ERR_FRM
    INC  E
    DJNZ CHK_F01
    RET

ERR_FRM:
    CALL TREAT_E
    JP   Z,ST_PROG
    JR   C,FORM_TR
    JP   NC,ST_PROG

PATTERN:
    DEFB #01,#02,#03,#04,#05,#06,#07,#08
    DEFB #09,#0A,#0B,#0C,#0D,#0E,#0F,#10

; ------ ;
SAV_CAT:
    CALL M_NAME

    LD   HL,BUF_CAT
    LD   DE,#0000
    LD   BC,#0906
    CALL DISK_DR
    RET

; ------ ;
M_NAME:
    LD   HL,NAME_DS
    LD   DE,NAME_DI
    LD   BC,#08
    LDIR
    RET

NAME_DS:
    DEFM  "RESTORED"

; ------ ;
SOUND_1:
    LD   HL,408
    LD   DE,104
    CALL 949
    DI
    LD   HL,340
    LD   DE,141
    CALL 949
    DI
SOUND_2:
    LD   HL,250

    LD   DE,174
    CALL 949
    DI
    RET

; ------ ;
SOUND_3:
    LD   A,(23624)
    RRA
    RRA
    RRA
    LD   B,#FF
    LD   C,#FE
SND_3_1:
    DEC  H
    JR   NZ,SND_3_2
    XOR  #10
    OUT  (C),A
    LD   H,#EE
SND_3_2:
    DEC  L
    JR   NZ,SND_3_1
    XOR  #10
    OUT  (C),A
    LD   L,#FE
    DJNZ SND_3_1
    RET

; ------ ;
ZVUK3:
    LD   HL,MUS_OK ; MESSAGE FOR T.V.I. : "DO YOU
    LD   DE,#0C2A    ; KNOW THIS SUBROUTINE ???!!!"
    LD   BC,#FFFD
    LD   A,#07
    OUT  (C),A

    LD   A,B
    LD   B,#BF
    OUT  (C),A

LL1:
    CALL CHANN
    LD   A,(HL)
    AND  #0F
    CALL SOUND

    CALL CHANN
    LD   A,(HL)
    AND  #F0
    RRCA
    RRCA
    RRCA
    RRCA
    CALL SOUND

    INC  HL
    DEC  DE
    LD   A,D
    OR   E
    JR   NZ,LL1

    LD   B,#BF
    XOR  A
    OUT  (C),A
    DI

CHANN:
    LD   B,#FF
    LD   A,#09
    OUT  (C),A
    RET

SOUND:
    OR   #A0
    LD   B,#BF
    OUT  (C),A
    LD   A,#0F
LL2:
    DEC  A
    JR   NZ,LL2
    RET

; ------ ;
PLAY_NO:
    RET  ; Do not play sound.
    LD   HL,MUS_ONO
    LD   (ADR_SND+1),HL
    JR   ZVUK4

PLAY_YE
    RET  ; Do not play sound.
    LD   HL,MUS_YEA
    LD   (ADR_SND+1),HL

ZVUK4:
    EXX        ; PLAYER FROM "LENINGRAD  128"
    PUSH BC    ; (C)   1995 AGAEV E.
    PUSH DE
    LD   BC,#FFFD
    LD   DE,#0908
    EXX
    CALL ZVUK4_3
ADR_SND:
    LD   HL,MUS_YEA
    LD   DE,#1F40
    LD   BC,#BFFD
ZVUK4_1:
    PUSH DE
    PUSH HL
    NOP
    EXX
    OUT  (C),E
    EXX
    LD   A,(HL)
    SRL  A
    SRL  A
    SRL  A
    SRL  A
    OUT  (C) ,A
    NOP
    NOP
    NOP
    NOP
    NOP
    NOP
    LD   A, (HL)
    AND  #0F
    EXX
    OUT  (C),D
    EXX
    LD   D,#06
ZVUK4_2:
    DEC  D
    JR   NZ, ZVUK4_2
    OUT  (C),A
    NOP
    NOP
    NOP
    NOP
    NOP
    NOP
    POP  HL
    INC  HL
    POP  DE
    DEC  DE
    LD   A,D
    OR   E
    JR   NZ,ZVUK4_1
    LD   BC,#FFFD
    LD   E,#08
    OUT  (C),E
    LD   B,#BF
    XOR  A
    OUT  (C),A
    LD   B,#FF
    INC  E
    OUT  (C),E
    LD   B,#BF
    OUT  (C),A
    EXX
    POP  DE
    POP  BC
    EXX
    RET
ZVUK4_3:
    LD   BC,#FFFD
    LD   A,#07
    OUT  (C),A
    LD   B,#BF
    LD   A,#3F
    OUT  (C),A
    RET
    LD   A,C
    RET

; ------- DISK - DRIVER ------ ;
DISK_DR DI
;    LD   DE,(#5CF4)
    PUSH HL
    LD   A,B
    BIT  0,C
    JR   Z,WRITE
READ:
    LD   BC,#80E5
    JR   INIT_RW
WRITE:
    LD   BC,#A0CA
INIT_RW:
    LD   HL,SECT+1
    LD   (HL),B
    LD   HL,MODE+2
    LD   (HL),C

    LD   HL, REPEAT
    LD   (TREAT_A+1),HL

    LD   B,A
    POP  HL

    CALL TRACK
AGAIN_D:
    LD   C,10    ; RETRY CONSTANT
;BREAK:
;    CALL #1F54
;    JR   NC,EXIT

REPEAT:
    LD   A,E
    INC  A
    CALL SECTOR
    JR   Z,NEXT_SC

    CALL TREAT_E

    JP   Z,ST_PROG ;  IF ABORT    MODE
    JR   C,AGAIN_D  ;  IF RETRY    MODE
;    JR   NC,NEXT_SC  ;  IF IGNORE MODE

NEXT_SC:
    INC  E
    BIT  4,E
    JR   Z,NEW_BUF
    LD   E,#00
    INC  D
    LD   A,B
    DEC  A
    CALL NZ,TRACK

NEW_BUF:
    INC  H
    DJNZ AGAIN_D

EXIT:
    DI
;    LD   (#5CF4),DE
    RET

TREAT_E:
    PUSH BC
    CALL RES_A_T
    POP  BC
    DEC  C
    JR   Z,DSK_ERR
    POP  AF
TREAT_A:
    JP   REPEAT

DSK_ERR:
    CALL WG_OFF

    EXX
    PUSH HL
    CALL SPR_ON
    POP  HL
    EXX

KEY_R:
    LD   A,#FB
    IN   A,(#FE)
    BIT  3,A
    JR   Z,RETRY
KEY_I:
    LD   A,#DF
    IN   A,(#FE)
    BIT  2,A
    JR   Z,IGNORE
KEY_A:
    LD   A,#FD
    IN   A,(#FE)
    RRA
    JR   C,KEY_R

ABORT:
    CALL REST_DR
    XOR  A
    RET

RETRY:
    CALL REST_DR
    XOR  A
    CP   #01
    RET

IGNORE:
    CALL REST_DR
    XOR  A
    CP   #01
    CCF
    RET

REST_DR:
    EXX
    PUSH HL
    CALL SPR_OFF
    POP  HL
    EXX
WG_ON:
    CALL PHYSIC
    EX   AF,AF'
    LD   A,#D0
    CALL TO_1F
    XOR  A
PAUSE:
    DEC  A
    JR   NZ,PAUSE
    EX   AF, AF'
    CALL TO_3F
    JR   TRACK

RES_A_T:
    CALL WG_REST

TRACK:
    LD   A,D
    LD   (BUF_TRK),A
    CALL PHYSIC
    CALL TO_7F
    LD   A,#18
FIND_TR:
    CALL TO_1F
    CALL READY
    DI
WG_PAUS:
    PUSH AF
    PUSH BC
    LD   A,#50
    LD   C,#00
PAUSE_S:
    DEC  C
    JR   NZ,PAUSE_S
    DEC  A
    JR   NZ,PAUSE_S
    POP  BC
    POP  AF
    RET

BUF_TRK:
    DEFB #00

WG_REST:
    XOR  A
    LD   (BUF_TRK),A
    LD   A,#08
    JR   FIND_TR

PHYSIC:
    LD   A,(BUF_TRK)
    LD   D,A


DRV_NUM:
    LD   A,#3C
JR_MODE:
    JR   SIDE
SIDE:
    BIT  0,D
    JR   Z,SIDE_FF
    RES  4,A
SIDE_FF:
    CALL TO_FF

TRK_MOD:
    LD   A,D
    NOP
    AND  A
    RRA
    RET

SECTOR:
    PUSH HL
    PUSH BC
    CALL TO_5F

SECT:
    LD   A,#80
    CALL TO_1F
    LD   C,#7F
MODE:
    LD   IX,#3FE5
    CALL TO_DOS

CHECK:
    LD   A,(#5CD6)
    EX   AF,AF'

    LD   BC,VERIFY
    PUSH BC

CHECK_M:
    LD   BC,CHECK_M
    PUSH BC
    LD   B,#01
    PUSH BC
I1:
    LD   IX,#2099
    JR   TO_DOS

VERIFY:
    DI
    EX   AF,AF'
    LD   HL,#5CD6
    CP   (HL)
    LD   (HL),A
    POP  BC
    POP  HL
    RET

WG_OFF:
    LD   A,#3C
    AND  #03

TO_FF:
    LD   C,#FF

TO_WG93:
    LD   IX,#2A53
    JR   TO_DOS

TO_1F:
    LD   C,#1F
    JR   TO_WG93

TO_3F:
    LD   C,#3F
    JR   TO_WG93

TO_5F:
    LD   C,#5F
    JR   TO_WG93

TO_7F:
    LD   C,#7F
    JR   TO_WG93

READY:
    LD   IX,#3EF5
    JR   TO_DOS

FORMAT:
    LD   IX,#2005

TO_DOS:
    PUSH IX
    JP   #3D2F

INIT_DR:
    LD   A,(#5CF6)
    LD   HL,#5CC8
    ADD  A,L
    LD   L,A
    BIT  1,(HL)
    JR   NZ, DRIVE_N

    LD   A,#06
    LD   (JR_MODE+1),A
    LD   A,#C9
    LD   (TRK_MOD+1),A

DRIVE_N:
    LD   A,(#5D16)
    SET  4,A
    LD   (DRV_NUM+1),A
    LD   (WG_OFF+1),A

DOS_VER:
    LD   H,#00
    LD   IX,#0516
    CALL TO_DOS
    LD   A,H
    OR   A
DOS_503:
    RET  Z

DOS_501:
    LD   HL,TO_WG93+2
    LD   (HL),#09
    LD   HL,READY+2
    LD   (HL),#EB
    LD   HL,I1+2
    LD   (HL),#5D  ;  ?
    LD   HL,FORMAT+2
    LD   (HL),#92  ;  ?
    LD   HL,READ+1
    LD   (HL),#DB
    LD   HL,WRITE+1
    LD   (HL),#C0
    RET

INIT_R:
    PUSH HL
    PUSH BC
    LD   BC,#80E5
    LD   HL,SECT+1
    LD   (HL),B
    LD   HL,MODE+2
    LD   (HL),C
    POP  BC
    POP  HL
    RET

INIT_W:
    PUSH HL
    PUSH BC
    LD   BC,#A0CA
    LD   HL,SECT+1
    LD   (HL),B
    LD   HL,MODE+2
    LD   (HL),C
    POP  BC
    POP  HL
    RET

; --- PRINT "RETRY, IGNORE, ABORT" --- ;
CONT_1:
    XOR  A
    CALL ATR_COP

CONT_2:
    XOR  A
    CALL ATR_CLS
    LD   HL,ERROR_1
    LD   DE,#50C6
    CALL PRINT_S
    LD   DE,#50E6

PRINT_S:
    LD   C,#08
PRINT_1:
    PUSH DE
    LD   B,#14
PRINT_2:
    LD   A,(DE)
    EX   AF,AF'
    LD   A,(HL)
    LD   (DE),A
    EX   AF,AF'
    LD   (HL),A
    INC  HL
    INC  DE
    DJNZ PRINT_2
    POP  DE
    INC  D
    DEC  C
    JR   NZ,PRINT_1
    RET

SPR_OFF:
    CALL CONT_2

    LD   A,#EB
ATR_COP:
    LD   (BUF_BT1),A
    LD   (BUF_BT2),A
    LD   HL,#5AC6
    LD   DE,ATR_1
    CALL BUF_BT2
BUF_BT1:
    NOP
    LD   L,#E6
BUF_BT2:
    NOP

ATR_SCN:
    LD   BC,20
ATR_SC1:
    LDIR
    RET

SPR_ON:
    CALL CONT_1
    LD   A,#46

ATR_CLS:
    LD   HL,#5AC6
    CALL ATR_FIL
    LD   L,#E6

ATR_FIL:
    LD   D,H
    LD   E,L
    INC  DE
    LD   BC,19
    LD   (HL),A
    JR   ATR_SC1

ERROR_1:
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
    DEFB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FE
    DEFB #7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
    DEFB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FE
    DEFB #60,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#06
    DEFB #60,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#06
    DEFB #63,#88,#00,#00,#00,#00,#00,#0E,#01,#00
    DEFB #00,#47,#00,#00,#00,#02,#19,#00,#01,#06
    DEFB #62,#40,#C9,#06,#52,#8C,#A0,#09,#31,#14
    DEFB #90,#42,#33,#8C,#A3,#02,#25,#06,#51,#06
    DEFB #62,#59,#0A,#09,#6B,#52,#D1,#09,#4B,#9A
    DEFB #90,#82,#4A,#52,#D4,#84,#25,#C9,#6B,#86

    DEFB #62,#48,#CC,#0E,#42,#12,#80,#0E,#71,#10
    DEFB #90,#82,#4A,#52,#87,#04,#3D,#29,#41,#06
    DEFB #62,#48,#2A,#08,#42,#12,#81,#09,#41,#10
    DEFB #71,#02,#3A,#52,#84,#08,#25,#29,#41,#06
    DEFB #63,#9D,#C9,#06,#42,#0C,#80,#09,#30,#D0
    DEFB #11,#07,#0A,#4C,#83,#08,#25,#C6,#40,#C6
    DEFB #60,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #60,#00,#30,#00,#00,#00,#00,#00,#00,#06
    DEFB #60,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#06
    DEFB #7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
    DEFB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FE
    DEFB #7F,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
    DEFB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FE
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00

ATR_1:
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00


ATR_2:
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00
    DEFB #00,#00,#00,#00,#00,#00,#00,#00,#00,#00

; ------ ;

; .INCLUDE  A_FPS2_4
  INCLUDE "a_fps2_4.asm"

;MUS_OK .INCBIN    VOICE_AY
MUS_OK:
    DEFB #00

MUS_YEA EQU MUS_OK+3328

MUS_ONO EQU MUS_YEA+8192

; ------ ;
BUF_FNT:
    DEFS 03*256,#00
BUF_SEC:
    DEFS 01*256,#00
BUF_DAT:
    DEFS 01*256,#00
BUF_CAT:
    DEFS 09*256, #00
NAME_DI EQU BUF_CAT+2293

BUF_LD:
    DEFS 36*256,#00
FST_MEM EQU BUF_LD+#0047
SND_MEM EQU BUF_LD+#047F
FST_M45 EQU BUF_LD+#0047
SND_M45 EQU BUF_LD+#046F

DAT_MEM EQU BUF_LD+#0503
XOR_MEM EQU BUF_LD+#0323

END:

    SAVESNA  "afps45.sna",BEGIN
    EMPTYTRD "afps45.trd"
    SAVETRD  "afps45.trd","afps45.c",BEGIN,END-BEGIN
