﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EliteUniverse
{
    class Planet
    {
        public readonly byte Number;
        public readonly byte x;
        public readonly byte y;
        public readonly string Name;
        public readonly byte TechLevel;
        public readonly string Economy;
        public readonly string Gouvernement;
        public readonly float Population;
        public readonly string Inhabitnat;
        public readonly ushort GrossProductivity;
        public readonly ushort AverageRadius;

        private static string UpFirstChar(string source)
        {
            StringBuilder sb = new StringBuilder(source);
            sb[0] = Char.ToUpper(sb[0]);
            return sb.ToString();
        }

        private string GetName(Bible planetBible)
        {
            string res = string.Empty;
            Bible generator = new Bible();
            planetBible.CopyTo(ref generator);
            bool skipLastSyllabel = (generator.lW1 & 0x40) == 0;
            for (int i = 0; i < 4; i++)
            {
                byte syllabel = (byte)(generator.hW3 & 0x1f);
                if ((syllabel != 0) && (( i != 3) || (!skipLastSyllabel))) res += EliteConsts.Syllabel[syllabel];
                generator.NextData();
            }
            return res;
        }

        public Planet(Bible planetBible, byte planetNumber)
        {
            Number = planetNumber;
            Name = GetName(planetBible);
            x = planetBible.hW2;
            y = (byte)(planetBible.hW1 >> 1);
            #region helper variables
            byte def8 = (byte)(planetBible.hW1 & 0x07);
            byte def9 = (byte)((planetBible.lW2 >> 3) & 0x07);
            if ((def9 >> 1) == 0) def8 |= 0x02;
            byte defa = (byte)((def8 ^ 0x07) + (planetBible.hW2 & 0x03) + (def9 >> 1) + (def9 & 0x01));
            ushort temp = (ushort)((defa * 4) + def9 + def8 + 1);
            byte defb = (byte)((byte)(temp & 0xff) + (byte)(temp >> 8));
            #endregion helper variables
            TechLevel = (byte)(defa + 1);
            #region Economy
            byte economyLevel;
            economyLevel = EliteConsts.def8ToEconomyLevel[def8];
            byte economyType = (byte)(def8 >> 2);
            Economy = UpFirstChar(EliteConsts.GetEconomy(economyLevel, economyType));
            #endregion Economy
            Gouvernement = EliteConsts.Gouvernement[def9];
            Population = (float)defb / 10;
            Inhabitnat = EliteConsts.Inhabitnat[planetBible.lW3 >> 7];
            GrossProductivity = (ushort)((((def8 ^ 0x07) + 3) * (def9 + 4)) * defb * 8);
            AverageRadius = (ushort)(((((planetBible.hW3) & 0x0f) + 0x0b) << 8) + planetBible.hW2);
        }
    }
}