﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace EliteUniverse
{
    [StructLayout(LayoutKind.Explicit)]
    struct Bible
    {
        [FieldOffset(0)]
        public UInt16 W1;
        [FieldOffset(2)]
        public UInt16 W2;
        [FieldOffset(4)]
        public UInt16 W3;

        [FieldOffset(0)]
        public byte lW1;
        [FieldOffset(1)]
        public byte hW1;
        [FieldOffset(2)]
        public byte lW2;
        [FieldOffset(3)]
        public byte hW2;
        [FieldOffset(4)]
        public byte lW3;
        [FieldOffset(5)]
        public byte hW3;

        private byte Rlc(byte value)
        {
            uint temp = (uint)value * 2;
            if (temp >= 0x100) temp = temp | 0x01;
            return (byte)(temp & 0xff);
        }

        public void NextData()
        {
            UInt16 summ = (UInt16)(W1 + W2 + W3);
            W1 = W2;
            W2 = W3;
            W3 = summ;
        }

        public void NextGalaxy()
        {
            lW1 = Rlc(lW1);
            hW1 = Rlc(hW1);
            lW2 = Rlc(lW2);
            hW2 = Rlc(hW2);
            lW3 = Rlc(lW3);
            hW3 = Rlc(hW3);
        }

        public void CopyTo(ref Bible dest)
        {
            dest.W1 = W1;
            dest.W2 = W2;
            dest.W3 = W3;
        }
    }

    class Universe
    {
        private byte galaxyNumber;
        private byte planetNumber;
        private Bible GalaxyBible;
        private Bible planetBible;

        public byte GalaxyNumber { get { return (byte)(galaxyNumber + 1); } }

        public Universe(byte targedGalaxyNumber)
        {
            galaxyNumber = 0;
            EliteConsts.InitialUniverseBible.CopyTo(ref GalaxyBible);
            while (this.galaxyNumber < (targedGalaxyNumber - 1))
                NextGalaxy();
            ResetPlanets();
        }

        private int NextGalaxy()
        {
            galaxyNumber = (byte)((galaxyNumber + 1) & 0x07);
            GalaxyBible.NextGalaxy();
            return galaxyNumber;
        }

        public void ResetPlanets()
        {
            planetNumber = 0x00;
            GalaxyBible.CopyTo(ref planetBible);
        }

        public Planet NextPlanet()
        {
            Planet result = new Planet(planetBible, planetNumber);
            for (int i = 0; i < 4; i++)
                planetBible.NextData();
            if (planetNumber == 0xff)
                ResetPlanets();
            else
                planetNumber++;
            return result;
        }

    }

}
