;====================================================================================================
;=										=
;=	FIRMWARE    "USB-RECORDER" V1.00.02			   120812 =
;=										=
;=	       -			=
;=	  USB 							=
;=	    (1 )   12000000/272=44117,647 	=
;=										=
;=	   : WAV 44100 , 8  MONO	 DAT			=
;= 	   : 00.WAV - 99.WAV  00.DAT - 99.DAT			=
;=										=
;=	   : DAT -   #00/#FF 			=
;=	   : 00.DAT - 99.DAT					=
;=										=
;=	 ATMEGA8515   12 					=
;=	   V2DIP2-48 (USB-HOST)    FIFO			=
;=										=
;=	(C)   (ZST) 2012 .						=
;=										=
;====================================================================================================


.include "m8515def.inc"

;----------------------------------------------------------------------------------------------------
;									     120812
;----------------------------------------------------------------------------------------------------

;     
;.equ	SegmentPort = PORTB
;.equ	PORT_LEDS   = PORTC
;----------------------------------------------------------------------------------------------------
;			  				     120812
;----------------------------------------------------------------------------------------------------

.DEF	NUMBER_DIG = r17	; ,     
			; 10000000 - 1  (), 01111111 - 2  ()
.DEF	DIG1	 = r18	;    -   
.DEF	DIG2 	 = r19	;    -   

.DEF	temp	 = r20	;    -     
.DEF	temp2	 = r21	;    -    
.DEF	LEDS_DATA  = r22	;  


;----------------------------------------------------------------------------------------------------
;			   			     120812
;----------------------------------------------------------------------------------------------------
.org	$000
rjmp RESET 		; Reset Handler
reti; rjmp EXT_INT0	 	; IRQ0 Handler
reti; rjmp EXT_INT1 	; IRQ1 Handler
reti; rjmp TIM1_CAPT 	; Timer1 Capture Handler
rjmp TIM1_COMPA		; Timer1 Compare A Handler
reti; rjmp TIM1_COMPB 	; Timer1 Compare B Handler
reti; rjmp TIM1_OVF	 	; Timer1 Overflow Handler
reti; rjmp TIM0_OVF   	; Timer0 Overflow Handler
reti; rjmp SPI_STC    	; SPI Transfer Complete Handler
reti; rjmp USART_RXC  	; USART RX Complete Handler
reti; rjmp USART_UDRE 	; UDR0 Empty Handler
reti; rjmp USART_TXC 	; USART TX Complete Handler
reti; rjmp ANA_COMP 	; Analog Comparator Handler
reti; rjmp EXT_INT2 	; IRQ2 Handler
reti; rjmp TIM0_COMP 	; Timer0 Compare Handler
reti; rjmp EE_RDY 		; EEPROM Ready Handler
reti; rjmp SPM_RDY 		; Store Program memory Ready 


;----------------------------------------------------------------------------------------------------
;		      		     120812
;----------------------------------------------------------------------------------------------------
.org	$100
FONTS1:	;    0-9  
.db	0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110, 0b01101101 
.db	0b01111101, 0b00000111, 0b01111111, 0b01101111  

FONTS2:	;    0-9  
.db	0b10111111, 0b10000110, 0b11011011, 0b11001111, 0b11100110, 0b11101101
.db	0b11111101, 0b10000111, 0b11111111, 0b11101111  


;----------------------------------------------------------------------------------------------------
;				  			     120812
;----------------------------------------------------------------------------------------------------
RESET: 	ldi	temp,low(RAMEND)	;     
	out	SPL,temp
	ldi	temp,high(RAMEND)
	out	SPH,temp
	
	

;	ldi	temp,$ff
;	out	PORTB,temp	; Set all pins at port B high
;	out	DDRB,temp		; Set port B as output
;     -

;----------------------------     -------------------------------

	ldi	NUMBER_DIG,0b10000000	;     1 
	ldi	ZH,high(2*FONTS1)		;      
	ldi	ZL,low(2*FONTS1)
	
;-------------------     1   44100  --------------------------

          ldi	temp,0b00001001	;   CTC   A,   
	out 	TCCR1B,temp

	ldi	temp,0b00001000	;   CTC   A,   A   0
	out 	TCCR1A,temp	;     OC1A

          ldi	temp,high(271)	;   A -  1    0  A=271
	out 	OCR1AH,temp	;      12000000/272=44117,647 
          ldi	temp,low(271)
	out 	OCR1AL,temp

	clr	temp		;    1     
	out 	TCNT1H,temp
	out 	TCNT1L,temp

          ldi	temp,(1<<OCIE1A)	;     1   CTC   A
	out 	TIMSK,temp

          sei			;   	
          
;------------------   -    -------------------------- 
;		     
MAIN_LOOP:

;    -     	
	
	rjmp	MAIN_LOOP
	
;----------------------------------------------------------------------------------------------------
;		     1			     120812
;----------------------------------------------------------------------------------------------------
TIM1_COMPA:
	in	temp2,SREG	;      
	push	temp2
	
;      DIGITAL_IN  
;        DIGITAL_OUT
;       
;       
;       
	
	pop	temp2		;    
	out	SREG,temp2
	reti			;       
;----------------------------------------------------------------------------------------------------
