;================================================================================================
;=												=
;=	FIRMWARE    "USB-RECORDER" V1.00.07			 120813 =
;=												=
;=	       -			=
;=	  USB 								=
;=	    (1 )   12000000/272=44117,647 	=
;=												=
;=	   : WAV 44100 , 8  MONO  DAT			=
;= 	   : 00.WAV - 99.WAV  00.DAT - 99.DAT			=
;=												=
;=	   : DAT -   #00/#FF 			=
;=	   : 00.DAT - 99.DAT						=
;=												=
;=	 ATMEGA8515   12 						=
;=	   V2DIP2-48 (USB-HOST)    FIFO			=
;=												=
;=	(C)   (ZST) 2012 .							=
;=												=
;================================================================================================

.include "m8515def.inc"					

;------------------------------------------------------------------------------------------------
;				       					   120813
;------------------------------------------------------------------------------------------------

;---------------------------------    -----------------------------------
.equ	WAIT	  = 0	;  
.equ	LOAD	  = 1	;   USB-
.equ	SAVE	  = 2	;   USB-

;------------------------------------------------------------------------------------------------
;				  					   120813
;------------------------------------------------------------------------------------------------

.def	temp	  = r17	;    -     
.def	temp2	  = r18	;    -    

.def	indic_count=r19 ;      
.def	indic_digit=r20	; ,     
			; 10000000 - 1  (), 01111111 - 0  ()
.def	digit1	  = r21	;     -   
.def	digit0	  = r22	;     -   
.def	fontsAdr  = r23 ;      	
.def	mode	  = r24	;    DIGITAL_IN  DIGITAL_OUT  
; r25 max
;------------------------------------------------------------------------------------------------
;				    -			   120812
;------------------------------------------------------------------------------------------------
.MACRO	SET_FIFO_IN		;    FIFO  
	ldi	temp,0b00000000
	out	DDRC,temp
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	SET_FIFO_OUT		;    FIFO  
	ldi	temp,0b11111111
	out	DDRC,temp
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	SET_ANOTHER_PORTS 	;    -:

	ldi	temp,0b11011100	; PORTA:
	out	DDRA,temp
				; PA7 -  -  0 
				; PA6 -  -  1 
				; PA5 -   - DIGITAL_IN -    
				; PA4 -  - DIGITAL_OUT -    
				; PA3 -  - FIFO_RD -     FIFO
				; PA2 -  - FIFO_WR -     FIFO
				; PA1 -   - FIFO_RXF -     
				; PA0 -   - FIFO_TXE -    
				
	ldi	temp,0b00000000	; PORTB:
	out	DDRB,temp
				; PB7 -   -  
				; PB6 -   -  
				; PB5 -   -  
				; PB4 -   -  PLAY
				; PB3 -   -  PAUSE
				; PB2 -   -  RECORD
				; PB1 -   -     
				; PB0 -   -     

	ldi	temp,0b11111111	;  D   -  
	out	DDRD,temp

	ldi	temp,0b00000111	; PORTE:
	out	DDRE,temp
				; PE7 -   - 
				; PE6 -   - 
				; PE5 -   - 
				; PE4 -   - 
				; PE3 -   - 
				; PE2 -  -  PLAY
				; PE1 -  -  PAUSE
				; PE0 -  -  RECORD
.ENDMACRO		
;------------------------------------------------------------------------------------------------
.MACRO 	CLR_DIGITAL_OUT		;   0    
	cbi	PORTA,4
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO SET_DIGITAL_OUT		;   1    
	sbi	PORTA,4
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	TST_DIGITAL_IN		;     
	in	temp2,PINA	;    0,  temp2   0
	andi	temp2,0b00100000
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	TST_FIFO_RXF		;  FIFO_RXF -       
	in	temp2,PINA	;    0,  temp2   0
	andi	temp2,0b00000010
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	TST_FIFO_TXE		;  FIFO_TXE -      
	in	temp2,PINA	;    0,  temp2   0
	andi	temp2,0b00000001
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO	OUT_SEGMENTS		;       
	out	PORTD,temp2
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_PLAY_ON		;   PLAY
	cbi	PORTE,2
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_PLAY_OFF		;   PLAY
	sbi	PORTE,2
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_PAUSE_ON		;   PAUSE
	cbi	PORTE,1
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_PAUSE_OFF		;   PAUSE
	sbi	PORTE,1
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_RECORD_ON		;   RECORD
	cbi	PORTE,0
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO LED_RECORD_OFF		;   RECORD
	sbi	PORTE,0
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO FIFO_RD_ON		;     FIFO 
	cbi	PORTA,3
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO FIFO_RD_OFF		;     FIFO 
	sbi	PORTA,3
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO FIFO_WR_ON		;     FIFO 
	cbi	PORTA,2
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO FIFO_WR_OFF		;    FIFO 
	sbi	PORTA,2
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO DIGIT0_ON		;     
	cbi	PORTA,7
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO DIGIT0_OFF		;     
	sbi	PORTA,7
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO DIGIT1_ON		;     
	cbi	PORTA,6
.ENDMACRO
;------------------------------------------------------------------------------------------------
.MACRO DIGIT1_OFF		;     
	sbi	PORTA,6
.ENDMACRO

;------------------------------------------------------------------------------------------------
;			   				   120812
;------------------------------------------------------------------------------------------------
.org	$000
rjmp	RESET 		; Reset Handler
reti; rjmp EXT_INT0	; IRQ0 Handler
reti; rjmp EXT_INT1 	; IRQ1 Handler
reti; rjmp TIM1_CAPT 	; Timer1 Capture Handler
rjmp	TIM1_COMPA	; Timer1 Compare A Handler
reti; rjmp TIM1_COMPB 	; Timer1 Compare B Handler
reti; rjmp TIM1_OVF	; Timer1 Overflow Handler
reti; rjmp TIM0_OVF   	; Timer0 Overflow Handler
reti; rjmp SPI_STC    	; SPI Transfer Complete Handler
reti; rjmp USART_RXC  	; USART RX Complete Handler
reti; rjmp USART_UDRE 	; UDR0 Empty Handler
reti; rjmp USART_TXC 	; USART TX Complete Handler
reti; rjmp ANA_COMP 	; Analog Comparator Handler
reti; rjmp EXT_INT2 	; IRQ2 Handler
reti; rjmp TIM0_COMP 	; Timer0 Compare Handler
reti; rjmp EE_RDY	; EEPROM Ready Handler
reti; rjmp SPM_RDY	; Store Program memory Ready 


;------------------------------------------------------------------------------------------------
;			      		   120812
;------------------------------------------------------------------------------------------------
.org	$100
FONTS:			;    0-9  
.db	0b00111111, 0b00000110, 0b01011011, 0b01001111, 0b01100110, 0b01101101 
.db	0b01111101, 0b00000111, 0b01111111, 0b01101111  

FONTS2:			;    0-9  
.db	0b10111111, 0b10000110, 0b11011011, 0b11001111, 0b11100110, 0b11101101
.db	0b11111101, 0b10000111, 0b11111111, 0b11101111  


;------------------------------------------------------------------------------------------------
;				  				   120813
;------------------------------------------------------------------------------------------------
RESET: 	ldi	temp,low(RAMEND);     
	out	SPL,temp
	ldi	temp,high(RAMEND)
	out	SPH,temp
;----------------------------   - -------------------------------------
	
	SET_FIFO_IN		;    FIFO  
	SET_ANOTHER_PORTS	;    -
	FIFO_RD_OFF		;     FIFO 
	FIFO_WR_OFF		;     FIFO 
	LED_PLAY_OFF		;   PLAY
	LED_PAUSE_OFF		;   PAUSE
	LED_RECORD_OFF		;   RECORD

;----------------------------     ---------------------------

	ldi	digit1,0		;    - 01
	ldi	digit0,1

	ldi	indic_digit,0b10000000	;      
	ldi	fontsAdr,low(2*FONTS)	;      
	clr	indic_count		;    

	ldi	XH,$01			;    X   Y
	ldi	XL,$00			;        $0100 
	ldi	YH,$01	
	ldi	YL,$00 			;    ,  
	
	
;-------------------     1   44100  ----------------------

	ldi	temp,0b00001001	;   CTC   A,   
	out 	TCCR1B,temp

	ldi	temp,0b00001000	;   CTC   A,   A   0
	out 	TCCR1A,temp	;     OC1A

	ldi	temp,high(271)	;   A -  1    0  A=271
	out 	OCR1AH,temp	;      12000000/272=44117,647 
	ldi	temp,low(271)
	out 	OCR1AL,temp

	clr	temp		;    1     
	out 	TCNT1H,temp
	out 	TCNT1L,temp

	ldi	temp,(1<<OCIE1A);     1   CTC   A
	out 	TIMSK,temp

	sei			;   	
          
;----------------------   -    ------------------
;			     
MAIN_LOOP:

;    -     	
	
	rjmp	MAIN_LOOP
	
;------------------------------------------------------------------------------------------------
;		     1			 	   120813
;------------------------------------------------------------------------------------------------
TIM1_COMPA:
	in	temp2,SREG	;      
	push	temp2

	cpi	mode,LOAD	;    -  LOAD 	
	brne	TIM1_10

;----------------------    USB-   --------------------------

LOAD_00:cp	XL,YL		;    -  
	breq	TIM1_10
	
	ld	temp2,X		;        X
	cpi	temp2,0		
	brne	LOAD_10		;     0,    
	
	nop			;  1       
	CLR_DIGITAL_OUT		;     = 0
	rjmp	LOAD_20
	
LOAD_10:SET_DIGITAL_OUT		;     = 1	
LOAD_20:inc	XL		;        	
	rjmp	TIM1_20	

;------------------------------------------------------------------------------------------------

TIM1_10:cpi	mode,SAVE	;    -  SAVE 	
	brne	TIM1_20

;----------------------      USB- ----------------------------

SAVE_00:TST_DIGITAL_IN		;    
	brne	SAVE_10 	;     0,       
	
 	ldi	temp2,$00	;     0 -     $00
 	st	Y,temp2
	rjmp	SAVE_20
	
SAVE_10:ldi	temp2,$FF	;     1 -     $FF
 	st	Y,temp2
SAVE_20:inc	YL		;        

 	cp	XL,YL		;     -  
	brne	TIM1_20
				;  :	
	dec	YL		;        
	
TIM1_20:
;------------------------------------------------------------------------------------------------

;       
;       

;-------------------       -----------------

INDIC_0:inc	indic_count	;  256-  (  172 ) -  
        brne	INDIC_END

	ldi	ZH,high(2*FONTS);     
	mov	ZL,fontsAdr
	
	com	indic_digit	;  -    
	brmi	INDIC_DIG1	;        
	
INDIC_DIG0:			; 0 -     :
	DIGIT1_OFF		;     

	add	ZL,digit0	;      
        lpm	temp2,Z		;    
    
    	OUT_SEGMENTS	        ;       
	
	DIGIT0_ON		;      
	rjmp	INDIC_END
	
INDIC_DIG1:			; 1 -     :
	DIGIT0_OFF		;     

	add	ZL,digit1	;      
        lpm	temp2,Z		;    			
    
    	OUT_SEGMENTS	        ;       

	DIGIT1_ON		;      
INDIC_END:
       
;-------------------      1 ----------------------------

	pop	temp2		;    
	out	SREG,temp2
	reti			;       
;------------------------------------------------------------------------------------------------