macro_file Z80;
/*==============================================================================
														 Multi-Edit Macro File
                               12-Mar-99  14:57

  Function: Language support macros for Visual Basic languages.

		VBasSetProperties	- Dialog to set language specific properties
		VBasGetProperties - Get the language specific properties
		VBasInitMatch			- Sets the language specifc construct matching globals
		VBasInit 					- Initializes language specific support
		VBasIndent				- Performs language specifec smart indent
		_VBasGetMatchPat	- Locate a language specific match pattern
		VBasMatch					- Performs language specific construct matching
		VBasFindTag				- Generate language specific tags

	Author  : Dan Hughes

  $Header: /Me91/Src/VBasic.s 15    04-11-08 13:03 Danh $

             Copyright (C) 2002-2004 by Multi Edit Software, Inc.
 ====================================================================( ldh )==*/
#include Dialog.sh
#include DbTools.sh
#include Language.sh
#include MeTags.sh
#include RegExp.sh
//#include StdDlgs.sh


#ifdef _Debug_
  #include Win32.sh
  #include MsgLog.sh
#endif

// Dialog field constants
#define id_EolCol							1003

#define id_MatchHiCB          1100
#define id_ParenHiCB          1101
#define id_EolCmtAdjCB				1104
#define _z80_whitespace      " \t\xFF"

str Z80FindTag(
		int Tag			= Parse_Int( "/TAG=", MParm_Str ),
		int SrchFwd	= Parse_Int( "/F=", MParm_Str ),
		str ParmStr	= MParm_Str
		) trans2
/*------------------------------------------------------------------------------
															 Multi-Edit Macro
                               27-Mar-05  03:07

	Function: Scans for Z80 procedures.
	Entry   : int Tag       - When TRUE will scan and tag functions, else
														will return the next/previous function.     (/TAG=)
						int SrchFwd   - TRUE to search for next function else search for
														previous function														(/F=)
						str ParmStr   - Additional parameters

	Exit    : str ( return_str )  The found function name
	Author  : Kurles^HS^CPU
  Based on sources by Dan Hughes
             Copyright (C) 2005 by HorrorSoft.
 --------------------------------------------------------------------( ldh )--*/
{
	int SavRefresh = Refresh;
	int SrchDir 	 = _backward;
  int Limit      = Parse_Int( "/LIM=", ParmStr );
  int EndLine;
	int Found;

	str	TStr;
	str	Object[ 40 ];
	str	TagId[ 100 ];
  str FindStr = "^[a-zA-Z0-9_:]+$";
	Refresh = false;
	FindStr = ReTranslate( FindStr, 1 );
  if ( Copy( FindStr, 1, 1 ) == "<" ) {
    FindStr = "^[a-zA-Z0-9_:]+$";
    FindStr = ReTranslate( FindStr, 1 );
  }
	if ( Tag ) {
    if ( Limit ) {
      EndLine = C_Line + Limit;
    }
    else {
      Tof;
    }
		SrchDir = 0;
		while ( true ) {
      call _DoSearch;
			if ( Found ) {
        switch ( Tag ) {

          case 1 :
            TagShowProgress( C_Line );
            TagAddTag(  TagId, Object, TStr );
						//MsgDlg (Object,TagId,"",0);
            break;

          case 2 :
            Mark_Pos;
            Rm( "Collapse^CollapseTag" );
            Goto_Mark;
            break;
        }
				Eol;
			}
			else {
				break;
			}
		}
	}
	else {
		if ( SrchFwd ) {
			SrchDir = 0;
		}
    call _DoSearch;
	}
	Refresh = SavRefresh;
	return ( Return_Str = TagId );


// **** Internal routines ****


_DoSearch:
  while ( Found = Find_Text( FindStr, Limit, SrchDir | _regExp ) ) {
    if ( Limit ) {
      if ( C_Line > EndLine ) {
        Found = false;
        break;
      }
    }
    if ( ( GetStatusAtCursor( ) & ( _gsac_Comments | _gsac_String ) ) == 0 ) {
      First_Word;
      TStr = Copy( Get_Line( ), C_Col, 255 );
      TagId = Get_Word( _z80_whitespace );
			Object="";
      Forward_Till_Not( _z80_whitespace );
      //Mark_Pos;
      //TagId = Get_Word( _z80_whitespace + "{(" );
      //Goto_Mark;
      break;
    }
    if ( SrchDir ) {
      Left;
    }
    else {
      First_Word;
      Right;
    }
	}
	ret;

}  // Z80FindTag


