;		OUTPUT "park.xxx"
	DEVICE  ZXSPECTRUM48
	include	"const.asm"

	org  100h
        ld      sp,8000h
        di
	call	HardWareINIT

        ld      hl,zeropnt
        ld      de,zeropnt+1
        ld      bc,(24*32)-1

        ld      a,0
        ld      (hl),a
        call    _LDIR_


; time bar      : fca0..fcad (0xb0)



;time bar
        ld      hl,0fca0h
        ld      de,0fca0h+1
        ld      bc,0fh-1

        ld      a,0b0h
        ld      (hl),a
        call    _LDIR_

m1:
;pool

        ld      hl,pnt_ss09     ;5 tumb
        call    show_scr
;clear pool 
        ld      hl,0fe97h; d9h
        ld      a,0;83h
        ld      (hl),a

        ld      de,0fe97h+1
        ld      bc,64+32
        call    _LDIR_

;fill 5tumb 
        ld      a,0bfh
        ld      (0fe97h),a
        ld      (0fe98h),a
        ld      (0fea7h),a
        ld      (0fea8h),a

        ld      (0fe5fh),a
        ld      (0fe60h),a
        ld      (0fe9fh),a
        ld      (0fea0h),a

;rope
; pool          : 0fe90h..0feafh
; pool          : 0fed9h..0fee6h (83)


        ld      hl,pnt_f10      ;rope + pool
        call    show_scr

;clear 5tumb
        xor     a
;        ld      (0fe97h),a
;        ld      (0fe98h),a
;        ld      (0fea7h),a
;        ld      (0fea8h),a

        ld      (0fe5fh),a
        ld      (0fe60h),a
;        ld      (0fe9fh),a
;        ld      (0fea0h),a

;fill pool
        ld      hl,0fe97h
        ld      a,0bfh
        ld      (hl),a

        ld      de,0fe97h+1
        ld      bc,18-1
        call    _LDIR_

        ld      hl,0fed9h
        ld      de,0fed9h+1
        ld      bc,14-1

        ld      a,083h
        ld      (hl),a
        call    _LDIR_


        jp      m1



show_scr:
        push    hl

        ld      de,zeropnt
        ex      de,hl

        ld      bc,24*32
cplp:
        ld      a,(de)

;        or      a
;        jp      nz,mm1
;        ld      a,0ffh
;mm1:

        cp      (hl)
        jp      nz,xCP
        xor     a
xCP:
        ld      (hl),a
        inc     de
        inc     hl
        dec     bc
        ld      a,c
        or      b
        jp      nz,cplp


        ld      a, 6Ch ; 'l'
        ld      (regbase1c+SYSREG), a

        ld      hl,chr_map0
        ld      (chrptr+1),hl

        ld      hl,zeropnt
        ld      de,GZU+((256-192)*64)/2+(32/2)
        call    pnt13

        push    hl
        ld      hl,chr_map1
        ld      (chrptr+1),hl
        pop     hl
        call    pnt13

        push    hl
        ld      hl,chr_map2
        ld      (chrptr+1),hl
        pop     hl
        call    pnt13

;copy buffer to zeropnt
        ld      de,zeropnt
        ld      bc,24*32
        pop     hl
        call    _LDIR_



        ld      a, 1Ch
        ld      (regbase6C+SYSREG), a
        ret


pnt13:
        ld      b,32
        ld      c,8
xloop:
        ld      a,(hl)
        inc     hl
        or      a
        call    nz,show_chr
        inc     de              ;next x char
        dec     b
        jp      nz,xloop

        push    hl
        ld      hl,32+64*7
        add     hl,de        ;first char in next row
        ex      de,hl
        pop     hl

        ld      b,32
        dec     c
        jp      nz,xloop
        ret



;a chr
;de - gzu addr
show_chr:
        push    hl
        push    de
        push    bc

        push    de
        ld      h,0
        ld      l,a
        add     hl,hl
chrptr:        
        ld      de,chr_map0
        add     hl,de
        ld      a,(hl)
        ld      c,a
        inc     hl
        ld      a,(hl)
        ld      h,a
        ld      l,c             ;hl - chr*
        pop     de

;clear
        ex      de,hl
        push    hl              ;scr addr


        ld      a, _WL01_|_LAYER_MODE_W|0
        ld      (regbase6C+NCREG), a

        ld      bc,64
        ld      a,0ffh

        dup     8
                ld      (hl), a
                add     hl, bc
        edup

        pop     hl
        push    hl

        ld      a, _WL_1_|_LAYER_MODE_W|1
        ld      (regbase6C+NCREG), a

        dup     8
                ld      a,(de)
                ld      (hl), a
                add     hl, bc
                inc     de
        edup

        pop     hl
;        push    hl
        ld      a, _WL0__|_LAYER_MODE_W|1
        ld      (regbase6C+NCREG), a

        dup     8
                ld      a,(de)
                ld      (hl), a
                add     hl, bc
                inc     de
        edup

        pop     bc
        pop     de
        pop     hl
        ret       

zeropnt:
        ds      24*32


	include	"_hw_init.asm"

;        include "xx_tree1.asm"
;        include "xx_ss09.asm"
;        include "xx_f10.asm"
        include "xx_b2.asm"

	db	"ESL 2012"
xend 	equ 	$

	SAVEBIN "xpark.com",0x100,(xend-0x100)

;
; time bar      : fca0..fcad (0xb0)

; 5 tumb  left  : fe97,fe98 (0xbf)
; 5 tumb  right : fea7,fea8 (0xbf)
; 5 tumb  middle: fe5f,fe60,fe9f,fea0 (0xbf)

; pool          : 0fe90h..0feafh
; pool          : 0fed0h..0feefh
