;hl - srcpnt
show_pnt:
;        di
;        ld      a, 6Ch ; 'l'
;        ld      (regbase1c+SYSREG), a

        push	hl
        push	de
        push	bc

        ld	de,localPNT
        ld	bc,32*24

shp_loop:

        ld	a,(de)
        cp 	(hl)

        call	nz,show_char_store
        inc	de
        inc	hl

        dec	bc
        ld	a,c
        or	b
        jp	nz,shp_loop

        pop	bc
        pop	de
        pop	hl

;        ld      a, 1Ch
;        ld      (regbase6C+SYSREG), a
;        ei
        ret


;a - char
;de - pnt addr
;config should be regbase6C
show_char_store:
        di
        ld      a, 6Ch ; 'l'
        ld      (regbase1c+SYSREG), a

        ld      a,(hl)
	ld	(de),a
;show_char:
	push	bc
	push	hl
	push	de

	ld	b,d	;save pnt 1/3

	ex	de,hl
	add	hl,hl
	ld	de,PNT2GZU
	add	hl,de	;gzu addr in
        ld      c,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,c
	push	hl

	ld	l,a
	ld	h,b
	add	hl,hl
	ld	de,font_table
	add	hl,de   ;hl char ptr
        ld      c,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,c

	pop	de
        ex      de,hl   ;hl scr addr, de char bitmap

;clear
        ld      a, _WL01_|_LAYER_MODE_W|0
        ld      (regbase6C+NCREG), a

        ld      bc,64
        ld      a,0ffh

        push	hl
        dup     8
                ld      (hl), a
                add     hl, bc
        edup
        pop	hl

;first plane

        ld      a, _WL_1_|_LAYER_MODE_W|1
        ld      (regbase6C+NCREG), a

        push	hl
        dup     8
                ld      a,(de)
                ld      (hl), a
                add     hl, bc
                inc     de
        edup

        pop     hl
;second plane

;        push    hl
        ld      a, _WL0__|_LAYER_MODE_W|1
        ld      (regbase6C+NCREG), a

        dup     8
                ld      a,(de)
                ld      (hl), a
                add     hl, bc
                inc     de
        edup        


	pop	de
	pop	hl
	pop	bc

        ld      a, 1Ch
        ld      (regbase6C+SYSREG), a
        ei

        ret


cls_pnt:
        ld      a,0
        ld      hl,PNT
        ld      de,PNT+1
        ld      (hl),a
        ld      bc,32*24-1
        jp    _LDIR_


init_pnt:

;init pnt2gzu table
;pacman based
	ld	hl, PNT2GZU
	ld	de, GZU;+(256-192)/2*64+(64-32)/2
	ld	bc, 8*64-32
	ld	a, 24

iniColumnLoop:
	push	af
	ld	a, 32

iniRowLoop:
	ld	(hl), e
	inc	hl
	ld	(hl), d
	inc	hl
	inc	de
	dec	a
	jp	nz, iniRowLoop
	ex	de, hl
	add	hl, bc
	ex	de, hl
	pop	af
	dec	a
	jp	nz, iniColumnLoop

        ld      a,0aah
        ld      hl,localPNT
        ld      de,localPNT+1
        ld      (hl),a
        ld      bc,32*24-1
        call    _LDIR_

        jp      cls_pnt
	;ret

