; =============== S U B	R O U T	I N E =======================================


doRope:					; CODE XREF: game_move_items+26 p
;		ld	a, (_Flag_Scene_) ; 0 1	- FishPool
;					; 1 2 -	Rope
;					; 2 4 -	JumpTubles
;					; 3 8 -	4 Fountain
;					; 4 1 -	5 Tumb
;					; 5 2 -	Vegetables
;					; 6 4 -	Fire
;					; 7 8 -	Pool Flag
;		and	2
;		ret	z
		ld	de,  VLINE+(6*32)+10
		ld	a, (RopePhase1)
		call	DisplayRope	; Return:
;					; B - x	RightRope
;					; C - x	LeftRope
;					; D - Y
;
;		ld	hl, RopeLeftXY
;		ld	(hl), b
;		inc	hl
;		ld	(hl), c
;
		ld	de,  VLINE+(6*32)+22
		ld	a, (RopePhase2)
		call	DisplayRope	; Return:
					; B - x	RightRope
					; C - x	LeftRope
					; D - Y
;
;		ld	hl, RopeRigthXY
;		ld	(hl), b
;		inc	hl
;		ld	(hl), d
		ret
; End of function doRope

; =============== S U B	R O U T	I N E =======================================

; C-miss, NC- near end

;CheckEndRope:				; CODE XREF: L6C3C-F p L6C3C-7 p ...
;		ld	de, PlayerYPos
;		ld	a, (de)
;		add	a, 8
;		sub	(hl)
;		jp	c, ropeMiss
;		cp	10h
;		jp	nc, ropeMiss
;		inc	de
;		inc	hl
;		ld	a, (de)
;		sub	(hl)
;		jp	c, ropeMiss
;		cp	10h
;		jp	nc, ropeMiss
;		or	a
;		ret
; ---------------------------------------------------------------------------

ropeMiss:					
		scf
		ret
; End of function CheckEndRope


; =============== S U B	R O U T	I N E =======================================

; Return:
; B - x	RightRope
; C - x	LeftRope
; D - Y

DisplayRope:				; CODE XREF: doRope+C p	doRope+1B p
		and	0Fh
		cp	9
		jp	c, L60E1
;esl		
;		neg
		cpl
		add a,1
;esl		
		and	0Fh

L60E1:					; CODE XREF: DisplayRope+4 j
		ld	hl, RopePhaseTable
		rlca
		call	add_a_hl
		push	de
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ex	de, hl
		pop	de

_ropeLoop:				; CODE XREF: DisplayRope+27 j
		push	de

_ropeLoop2:				; CODE XREF: DisplayRope+3B j
		ld	a, (hl)
		inc	hl
		ld	b, a
		inc	b		; ff
		jp	z, _RopeExit
		inc	b
		jp	nz, L6100
		ld	a, 31		; FE

_ropeAddCoord:				; CODE XREF: DisplayRope+2E j
					; DisplayRope+35 j
		pop	de
		call	add_a_de
		jp	_ropeLoop
; ---------------------------------------------------------------------------

L6100:					; CODE XREF: DisplayRope+1F j
		inc	b
		jp	nz, L6107
		ld	a, 32		; FD
		jp	_ropeAddCoord
; ---------------------------------------------------------------------------

L6107:					; CODE XREF: DisplayRope+2A j
		inc	b
		jp	nz, _ropeWriteValue
		ld	a, 33		; FC
		jp	_ropeAddCoord
; ---------------------------------------------------------------------------

_ropeWriteValue:			; CODE XREF: DisplayRope+31 j
;esl
		;call	vdp_wr_de_a
		ld	(de),a
;esl

		inc	de
		jp	_ropeLoop2
; ---------------------------------------------------------------------------

_RopeExit:				; CODE XREF: DisplayRope+1C j
		pop	de
		ld	b, (hl)
		inc	hl
		ld	c, (hl)
		inc	hl
		ld	d, (hl)
		ret
; End of function DisplayRope


RopePhaseTable:	
		dw _RopePH0		; DATA XREF: DisplayRope:L60E1 o
		dw _RopePH1
		dw _RopePH2
		dw _RopePH3
		dw _RopePH4
		dw _RopePH5
		dw _RopePH6
		dw _RopePH7
		dw _RopePH8
_RopePH0:	db 0FEh,0B5h,	0,0FEh,	62h, 63h,   0,0FEh ; DATA XREF:	RAM:RopePhaseTable o
		db  64h, 65h,	0,   0,0FEh, 64h, 66h,	 0
		db    0,   0,0FEh, 67h,	68h,   0,   0,	 0
		db    0,0FCh,	0,   0,	  0,   0,   0,0FCh
		db    0,   0,	0,   0,0FFh
		db 78			; X Right?
		db 28			; X Left?
		db 124			; Y?
;
_RopePH1:	db 0FEh,0B0h,0B1h,0FEh,	69h, 6Ah,   0,0FEh ; DATA XREF:	RAM:555D o
		db    0, 6Bh,	0,   0,0FEh,   0, 6Ch, 6Dh
		db    0,   0,0FEh,   0,	62h, 6Eh,   0,	 0
		db    0,0FCh, 6Fh,   0,	  0,   0,   0,0FCh
		db    0,   0,	0,   0,0FFh
		db  82,	34,130

_RopePH2:	db 0FEh,0B2h,0B3h,0FEh,	  0, 70h,   0,0FEh,   0, 69h, 71h
					; DATA XREF: RAM:555F o
		db    0,0FEh,	0,   0,	60h,   0,   0,0FEh,   0,   0, 72h
		db  73h,   0,	0,0FCh,	  0, 74h,   0,	 0,   0,0FCh, 75h
		db    0,   0,	0,0FFh
		db  87,	42,138

_RopePH3:	db 0FEh,   0,0B4h,0FEh,	  0, 76h, 77h,0FEh ; DATA XREF:	RAM:5561 o
		db    0,   0, 78h,   0,0FEh,   0,   0,	 0
		db  79h,   0,0FEh,   0,	  0,   0,   0, 7Ah
		db    0,0FCh,	0,   0,	7Bh, 7Ch,   0,0FCh
		db    0, 7Dh,	0,   0,0FFh, 5Ch, 36h, 96h

_RopePH4:	db 0FEh,   0,0B6h,0FEh,	  0,   0, 61h,	 0 ; DATA XREF:	RAM:5563 o
		db 0FEh,   0,	0,   0,	61h,   0,0FEh,	 0
		db    0,   0,	0, 61h,	  0,0FEh,   0,	 0
		db    0,   0,	0, 61h,	  0,0FCh,   0,	 0
		db    0,   0, 61h,   0,	  0,0FCh,   0,	 0
		db    0, 61h,	0,   0,0FFh, 5Eh, 45h,0A5h

_RopePH5:	db 0FDh,0BBh,	0,0FDh,	95h, 94h,   0,0FDh ; DATA XREF:	RAM:5565 o
		db    0, 96h,	0,   0,0FDh,   0, 97h,	 0
		db    0,   0,0FDh,   0,	98h,   0,   0,	 0
		db    0,0FDh,	0, 9Ah,	99h,   0,   0,0FDh
		db    0,   0, 9Bh,   0,0FFh, 5Ch, 54h,0B4h

_RopePH6:	db 0FDh,0BAh,0B9h,0FDh,	  0, 8Eh,   0,0FDh ; DATA XREF:	RAM:5567 o
		db    0, 8Fh, 87h,   0,0FDh,   0,   0, 7Eh
		db    0,   0,0FDh,   0,	  0, 91h, 90h,	 0
		db    0,0FDh,	0,   0,	  0, 92h,   0,0FDh
		db    0,   0,	0, 93h,0FFh, 57h, 60h,0C0h

_RopePH7:	db 0FDh,0B8h,0B7h,0FDh,	  0, 88h, 87h,0FDh ; DATA XREF:	RAM:5569 o
		db    0,   0, 89h,   0,0FDh,   0,   0, 8Bh
		db  8Ah,   0,0FDh,   0,	  0,   0, 8Ch, 80h
		db    0,0FDh,	0,   0,	  0,   0, 8Dh,0FDh
		db    0,   0,	0,   0,0FFh, 52h, 68h,0C8h

_RopePH8:	db 0FDh,   0,0BCh,0FDh,	  0, 81h, 80h,0FDh ; DATA XREF:	RAM:556B o
		db    0,   0, 83h, 82h,0FDh,   0,   0,	 0
		db  84h, 82h,0FDh,   0,	  0,   0,   0, 86h
		db  85h,0FDh,	0,   0,	  0,   0,   0,0FDh
		db    0,   0,	0,   0,0FFh
		db  78,110,206

