cls_aczu:
	ld 	hl,0fc00h
	ld 	de,0fc01h
	xor 	a
	ld 	(hl),a
	ld 	bc,1024-1
	call 	_LDIR_
	ret


_LDIR_:
		push 	af
_LDIR1_:
		LD 		A,(HL)
		LD 		(DE),A
		INC 	HL
		INC 	DE
		DEC 	BC
		ld 		a,c
		or 		b
		jp 		nz,_LDIR1_
		pop 	af
		ret 


add_a_hl:				; CODE XREF: jp_CASE_A+2 p
					; CheckGameStartKeys+13 p ...
		add	a, l
		ld	l, a
		ret	nc
		inc	h
		ret
; End of function add_a_hl


; =============== S U B	R O U T	I N E =======================================


add_a_de:				; CODE XREF: ML_8_MenuBlink+47 p
					; ClearFromCenter+2B p ...
		add	a, e
		ld	e, a
		ret	nc
		inc	d
		ret

jp_CASE_A:				; CODE XREF: RAM:4146 p	ML_8_MenuBlink+3 p ...
		add	a, a
		pop	hl
		call	add_a_hl
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ex	de, hl
		jp	(hl)
; End of function jp_CASE_A

Fill_VRAM_DE_A_BC:
		;push	de
		push	hl
		ld 	l,a
fvr:
		ld 	a,l		
		ld	(de),a
		inc	de
		dec	bc
		ld	a,c
		or	b
		jp 	nz,fvr;Fill_VRAM_DE_A_BC

		pop	hl
		;pop	de
		ret
;Unpack
;called as
;	;call Unpacker_5F65
;	dw 	control_stream
;	dw 	data_stream
;	dw 	screen_addr

; control stream
; 00h 		- stop
; 01..7Fh	- copy nn bytes from data stream to VRAM
; 80h 		- dw new_screen_addr
; 81..fFh	- fill nn & 7fh bytes with byte from data

xcp_CmdStream:	dw 	0
xCP_DataStream:	dw 	0
xCP_VRAM:	dw 	0

Unpacker_5F65:	
		pop	hl
		ld	de, xcp_CmdStream
		ld	bc, 6
	
		;ldir
		call	_LDIR_

		push	hl

xUnpackLoop:				; CODE XREF: Unpacker_5F65+5C j
		ld	hl, (xcp_CmdStream)
		ld	a, (hl)
		cp	80h ; '€'
		jp	nz, L5F84
		inc	hl
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		inc	hl
		ld	(xcp_CmdStream), hl
;esl
;		ld	(xCP_VRAM), de
		ex 	hl,de
		ld	(xCP_VRAM), hl
		ex 	hl,de

		ld	a, (hl)

L5F84:					; CODE XREF: Unpacker_5F65+10 j
		or	a
		ret	z
		ld	b, a
		and	7Fh ; ''
		ld	c, a
;ESL
;		xor	a
;		bit	7, b
;		ld	b, a
		cp 	b
		ld 	b,0

;ESL

;esl
;		ld	hl, (xCP_DataStream)
;		ld	de, (xCP_VRAM)

		ld	hl, (xCP_VRAM)
		ex 	hl,de
		ld	hl, (xCP_DataStream)

		jp	z, L5F9F
		ld	a, (hl)
		call	Fill_VRAM_DE_A_BC
		ld	a, 1
		jp	FinishUnpackLoop
; ---------------------------------------------------------------------------

L5F9F:					; CODE XREF: Unpacker_5F65+30 j
		push	bc
;		call	CopyToVRAM_HL_DE_BC
		push 	de
		call	_LDIR_
		pop	de
		pop	bc
		ld	a, c

FinishUnpackLoop:			; CODE XREF: Unpacker_5F65+38 j
		ld	hl, (xCP_DataStream)
		call	add_a_hl
		ld	(xCP_DataStream), hl
		ld	hl, (xcp_CmdStream)
		ld	a, (hl)
		and	7Fh ; ''
		inc	hl
		ld	(xcp_CmdStream), hl
		ld	hl, (xCP_VRAM)
		call	add_a_hl
		ld	(xCP_VRAM), hl
		jp	xUnpackLoop
; End of function Unpacker_5F65


;Copy rectangle box to screen
;de - vram
;hl - pattern to copy
;b - row count
;c - columb


CopyToVRAM_ROW:				; CODE XREF: DisplayLIFE+24 p
					; ShowJumper+10 p ...
		push	bc
		push	de

L6413:					; CODE XREF: CopyToVRAM_ROW+9 j
		ld	a, (hl)
		ld	(de),a
		inc	hl
		inc	de
		dec	c
		jp	nz, L6413
		pop	de
		ld	a, 32
		call	add_a_de
		pop	bc
		
		;djnz
		dec b
		jp nz,CopyToVRAM_ROW

		ret
; =============== S U B	R O U T	I N E =======================================

;Show message on screen
; FF - end of message
; FE - next two byte - new screen addr

xStringToVram_HL:			; CODE XREF: ML_2_KonamiScrollUP+C p
					; ML_4_AthleticLandAnim+C p ...
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		inc	hl

xStringToVram_HLDE:			; CODE XREF: xStringToVram_HLDE+C j
		ld	a, (hl)
		inc	hl
		ld	b, a
		inc	b
		ret	z
		inc	b
		jp	z, xStringToVram_HL
;		call	vdp_wr_de_a
		ld 	(de),a
		inc	de
		jp	xStringToVram_HLDE

		