WRTPSG:					; CODE XREF: sub_83D1+2p sub_AE78+2p
		di
		push	hl
		push	de
		push	af
		ld	hl, AYmainJmpTable

WRTPSG_Dispatch:			; CODE XREF: AY07sub+Fj
		and	0Fh
		add	a, a
		call	add_hl_a
		ld	d, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, d
		jp	(hl)
; End of function WRTPSG

; ---------------------------------------------------------------------------
AYmainJmpTable:	dw AY00			; DATA XREF: WRTPSG+4o
		dw AY01
		dw AY02
		dw AY03
		dw AY04
		dw AY05
		dw AY06_r
		dw AY07
		dw AY08
		dw AY09
		dw AY10
		dw AY11_r
		dw AY12_r
		dw AY13_r
		dw AY1415_r
		dw AY1415_r
; ---------------------------------------------------------------------------

AY00:					; DATA XREF: RAM:AYmainJmpTableo
		ld	a, e
		ld	(AY_R00_chA_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY01:					; DATA XREF: RAM:8261o
		ld	a, e
		and	0Fh
		ld	(AY_R01_chA_freq), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


FREQAY_to_VI53:				; CODE XREF: SoundProcInt+38p
		ld	a, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, a
		or	h
		jp	nz, PSG2TIMER2
		ld	hl, 7
		ret
; ---------------------------------------------------------------------------

PSG2TIMER2:				; CODE XREF: FREQAY_to_VI53+5j
		add	hl, hl
		ld	e, l
		ld	d, h
		add	hl, hl
		add	hl, de
		add	hl, hl
		ret
; End of function FREQAY_to_VI53

; ---------------------------------------------------------------------------

AY02:					; DATA XREF: RAM:8263o
		ld	a, e
		ld	(AY_R02_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY03:					; DATA XREF: RAM:8265o
		ld	a, e
		and	0Fh
		ld	(AY_R03_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY04:					; DATA XREF: RAM:8267o
		ld	a, e
		ld	(AY_R04_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY05:					; DATA XREF: RAM:8269o
		ld	a, e
		and	0Fh
		ld	(AY_R05_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY06_r:					; DATA XREF: RAM:826Bo
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY11_r:					; DATA XREF: RAM:8275o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY12_r:					; DATA XREF: RAM:8277o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY13_r:					; DATA XREF: RAM:8279o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY07:					; DATA XREF: RAM:826Do
		call	AY07sub

AY1415_r:				; CODE XREF: RAM:8283j	RAM:828Cj ...
		pop	af
		pop	de
		pop	hl

subAY07_000:				; DATA XREF: RAM:AY07JMPTableo
		ei
		ret

; =============== S U B	R O U T	I N E =======================================


AY07sub:				; CODE XREF: RAM:AY07p
		ld	a, e
		rrca
		rrca
		rrca
		or	e
		ld	e, a
		ld	a, (AY_R07_Process)
		xor	e
		ld	hl, AY07JMPTable
		and	7
		jp	WRTPSG_Dispatch
; End of function AY07sub

; ---------------------------------------------------------------------------
AY07JMPTable:	dw subAY07_000		; DATA XREF: AY07sub+Ao
		dw subAY07_001
		dw subAY07_010
		dw subAY07_011
		dw subAY07_100
		dw subAY07_101
		dw subAY07_110
		dw subAY07_111

; =============== S U B	R O U T	I N E =======================================


subAY07_001:				; CODE XREF: RAM:subAY07_011p
					; RAM:subAY07_101p ...
		ld	hl, AY_R08_chA_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	1
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_010:				; CODE XREF: RAM:832Dj
					; RAM:subAY07_110p
					; DATA XREF: ...
		ld	hl, AY_R09_chB_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	2
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_100:				; CODE XREF: RAM:8333j	RAM:8339j
					; DATA XREF: ...
		ld	hl, AY_R10_chC_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	4
		ld	a, 0FDh	; 'ý'

subAY07_a:				; CODE XREF: subAY07_001+Bj
					; subAY07_001+19j
		jp	z, subAY07_b
		ld	a, 2
		or	(hl)
		ld	(hl), a
		ret
; ---------------------------------------------------------------------------

subAY07_b:				; CODE XREF: subAY07_001:subAY07_aj
		and	(hl)
		ld	(hl), a
		ret
; End of function subAY07_001

; ---------------------------------------------------------------------------

subAY07_011:				; DATA XREF: RAM:82EEo
		call	subAY07_001
		jp	subAY07_010
; ---------------------------------------------------------------------------

subAY07_101:				; DATA XREF: RAM:82F2o
		call	subAY07_001
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_110:				; CODE XREF: RAM:833Fj
					; DATA XREF: RAM:82F4o
		call	subAY07_010
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_111:				; DATA XREF: RAM:82F6o
		call	subAY07_001
		jp	subAY07_110
; ---------------------------------------------------------------------------

AY08:					; DATA XREF: RAM:826Fo
		ld	hl, AY_R08_chA_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY09:					; DATA XREF: RAM:8271o
		ld	hl, AY_R09_chB_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY10:					; DATA XREF: RAM:8273o
		ld	hl, AY_R10_chC_Vol

_AY080910:				; CODE XREF: RAM:8345j	RAM:834Bj
		ld	a, e
		and	10h
		jp	nz, AY1415_r
		ld	a, e
		and	0Fh
		cp	3
		ld	a, 1
		jp	c, subAY10_b
		ld	a, 0FEh	; 'þ'
		and	(hl)
		ld	(hl), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

subAY10_b:				; CODE XREF: RAM:835Ej
		or	(hl)
		ld	(hl), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


SoundProcInt:				; CODE XREF: RAM:loc_8055p
		ld	a, (AY_R08_chA_Vol)
		or	a
		jp	z, spi_001
		ld	a, (AY_R10_chC_Vol)
		or	a
		jp	z, spi_000
		ld	a, Mode_BCD|mode_FreqDiv|load_Fix|Ch0
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		xor	a
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ret
; ---------------------------------------------------------------------------

spi_000:				; CODE XREF: SoundProcInt+Bj
		ld	a, (AY_R08_chA_Vol)
		or	a
		jp	nz, spi_005
		jp	spi_002
; ---------------------------------------------------------------------------

spi_001:				; CODE XREF: SoundProcInt+4j
		ld	a, (AY_R10_chC_Vol)
		or	a
		jp	nz, spi_004

spi_002:				; CODE XREF: SoundProcInt+1Fj
		ld	a, (spi_var_x)
		and	1
		ld	hl, AY_R08_chA_Vol
		jp	z, spi_003
;
		ld	hl, AY_R10_chC_Vol

spi_003:				; CODE XREF: SoundProcInt+31j
					; SoundProcInt+4Bj ...
		inc	hl
		call	FREQAY_to_VI53
		ld	a, l
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	a, h
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	hl, spi_var_x
		inc	(hl)
		ret
; ---------------------------------------------------------------------------

spi_004:				; CODE XREF: SoundProcInt+26j
		ld	hl, AY_R08_chA_Vol
		jp	spi_003
; ---------------------------------------------------------------------------

spi_005:				; CODE XREF: SoundProcInt+1Cj
		ld	hl, AY_R10_chC_Vol
		jp	spi_003
; End of function SoundProcInt

; ---------------------------------------------------------------------------
AY_R07_Process:	db 0FFh			; DATA XREF: AY07sub+6r subAY07_001+4w ...
spi_var_x:	db 0B9h			; DATA XREF: SoundProcInt:spi_002r
					; SoundProcInt+43o
AY_R08_chA_Vol:	db 0			; DATA XREF: subAY07_001o RAM:AY08o ...
AY_R00_chA_freq:db 0FAh			; DATA XREF: RAM:8280w
AY_R01_chA_freq:db 2			; DATA XREF: RAM:8289w
AY_R09_chB_Vol:	db 0			; DATA XREF: subAY07_001:subAY07_010o
					; RAM:AY09o
AY_R02_chB_freq:db 0DDh			; DATA XREF: RAM:82A3w
AY_R03_chB_freq:db 1			; DATA XREF: RAM:82ACw
AY_R10_chC_Vol:	db 0			; DATA XREF: subAY07_001:subAY07_100o
					; RAM:AY10o ...
AY_R04_chC_freq:db 7Dh			; DATA XREF: RAM:82B3w
AY_R05_chC_freq:db 2			; DATA XREF: RAM:82BCw


add_hl_a:				; CODE XREF: WRTPSG+Ap
		add	a, l
		ld	l, a
		ret	nc
		inc	h
		ret
drvmsg:

		db 	'DRV:binaryland2-AC                 '
