WRTPSG:					; CODE XREF: RAM:9871p	RAM:loc_98B7p
		di
		push	hl
		push	de
		push	af
		ld	hl, AYmainJmpTable

WRTPSG_Dispatch:			; CODE XREF: AY07sub+Fj
		and	0Fh
		add	a, a
		call	add_hl_a
		ld	d, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, d
		jp	(hl)
; End of function WRTPSG

; ---------------------------------------------------------------------------
AYmainJmpTable:	dw AY00			; DATA XREF: WRTPSG+4o
		dw AY01
		dw AY02
		dw AY03
		dw AY04
		dw AY05
		dw AY06_r
		dw AY07
		dw AY08
		dw AY09
		dw AY10
		dw AY11_r
		dw AY12_r
		dw AY13_r
		dw AY1415_r
		dw AY1415_r
; ---------------------------------------------------------------------------

AY00:					; DATA XREF: RAM:AYmainJmpTableo
		ld	a, e
		ld	(AY_R00_chA_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY01:					; DATA XREF: RAM:89DEo
		ld	a, e
		and	0Fh
		ld	(AY_R01_chA_freq), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


FREQAY_to_VI53:				; CODE XREF: SoundProcInt+40p
		ld	a, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, a
		add	hl, hl
		ld	e, l
		ld	d, h
		add	hl, hl
		add	hl, de
		add	hl, hl
		ret
; End of function FREQAY_to_VI53

; ---------------------------------------------------------------------------

AY02:					; DATA XREF: RAM:89E0o
		ld	a, e
		ld	(AY_R02_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY03:					; DATA XREF: RAM:89E2o
		ld	a, e
		and	0Fh
		ld	(AY_R03_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY04:					; DATA XREF: RAM:89E4o
		ld	a, e
		ld	(AY_R04_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY05:					; DATA XREF: RAM:89E6o
		ld	a, e
		and	0Fh
		ld	(AY_R05_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY06_r:					; DATA XREF: RAM:89E8o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY11_r:					; DATA XREF: RAM:89F2o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY12_r:					; DATA XREF: RAM:89F4o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY13_r:					; DATA XREF: RAM:89F6o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY07:					; DATA XREF: RAM:89EAo
		call	AY07sub

AY1415_r:				; CODE XREF: RAM:8A00j	RAM:8A09j ...
		pop	af
		pop	de
		pop	hl

subAY07_000:				; DATA XREF: RAM:AY07JMPTableo
		ei
		ret

; =============== S U B	R O U T	I N E =======================================


AY07sub:				; CODE XREF: RAM:AY07p
		ld	a, e
		rrca
		rrca
		rrca
		or	e
		ld	e, a
		ld	a, (AY_R07_Process)
		xor	e
		ld	hl, AY07JMPTable
		and	7
		jp	WRTPSG_Dispatch
; End of function AY07sub

; ---------------------------------------------------------------------------
AY07JMPTable:	dw subAY07_000		; DATA XREF: AY07sub+Ao
		dw subAY07_001
		dw subAY07_010
		dw subAY07_011
		dw subAY07_100
		dw subAY07_101
		dw subAY07_110
		dw subAY07_111

; =============== S U B	R O U T	I N E =======================================


subAY07_001:				; CODE XREF: RAM:subAY07_011p
					; RAM:subAY07_101p ...
		ld	hl, AY_R08_chA_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	1
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_010:				; CODE XREF: RAM:8AA2j
					; RAM:subAY07_110p
					; DATA XREF: ...
		ld	hl, AY_R09_chB_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	2
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_100:				; CODE XREF: RAM:8AA8j	RAM:8AAEj
					; DATA XREF: ...
		ld	hl, AY_R10_chC_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	4
		ld	a, 0FDh	; 'ý'

subAY07_a:				; CODE XREF: subAY07_001+Bj
					; subAY07_001+19j
		jp	z, subAY07_b
		ld	a, 2
		or	(hl)
		ld	(hl), a
		ret
; ---------------------------------------------------------------------------

subAY07_b:				; CODE XREF: subAY07_001:subAY07_aj
		and	(hl)
		ld	(hl), a
		ret
; End of function subAY07_001

; ---------------------------------------------------------------------------

subAY07_011:				; DATA XREF: RAM:8A63o
		call	subAY07_001
		jp	subAY07_010
; ---------------------------------------------------------------------------

subAY07_101:				; DATA XREF: RAM:8A67o
		call	subAY07_001
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_110:				; CODE XREF: RAM:8AB4j
					; DATA XREF: RAM:8A69o
		call	subAY07_010
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_111:				; DATA XREF: RAM:8A6Bo
		call	subAY07_001
		jp	subAY07_110
; ---------------------------------------------------------------------------

AY08:					; DATA XREF: RAM:89ECo
		ld	hl, AY_R08_chA_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY09:					; DATA XREF: RAM:89EEo
		ld	hl, AY_R09_chB_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY10:					; DATA XREF: RAM:89F0o
		ld	hl, AY_R10_chC_Vol

_AY080910:				; CODE XREF: RAM:8ABAj	RAM:8AC0j
		ld	a, e
		and	10h
		jp	nz, AY1415_r
		ld	a, e
		and	0Fh
		cp	3
		ld	a, 1
		jp	c, subAY10_b
		ld	a, 0FEh	; 'þ'
		and	(hl)
		ld	(hl), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

subAY10_b:				; CODE XREF: RAM:8AD3j
		or	(hl)
		ld	(hl), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


SoundProcInt:				; CODE XREF: sub_3C:loc_8894p
		ld	a, (AY_R08_chA_Vol)
		or	a
		jp	z, spi_001
		ld	a, (AY_R09_chB_Vol)
		or	a
		jp	z, spi_000
		ld	a, (spi_var_a)
		or	a
		ret	z
		ld	a, Mode_BCD|mode_FreqDiv|load_Fix|Ch0
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		xor	a
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	(spi_var_a), a
		ret
; ---------------------------------------------------------------------------

spi_000:				; CODE XREF: SoundProcInt+Bj
		ld	a, (AY_R08_chA_Vol)
		or	a
		jp	nz, spi_005
		jp	spi_002
; ---------------------------------------------------------------------------

spi_001:				; CODE XREF: SoundProcInt+4j
		ld	a, (AY_R09_chB_Vol)
		or	a
		jp	nz, spi_004

spi_002:				; CODE XREF: SoundProcInt+27j
		ld	a, (spi_var_x)
		and	1
		ld	hl, AY_R08_chA_Vol
		jp	z, spi_003
		ld	hl, AY_R09_chB_Vol

spi_003:				; CODE XREF: SoundProcInt+39j
					; SoundProcInt+58j ...
		inc	hl
		call	FREQAY_to_VI53
		ld	a, l
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	a, h
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	hl, spi_var_x
		inc	(hl)
		ld	a, 0FFh
		ld	(spi_var_a), a
		ret
; ---------------------------------------------------------------------------

spi_004:				; CODE XREF: SoundProcInt+2Ej
		ld	hl, AY_R08_chA_Vol
		jp	spi_003
; ---------------------------------------------------------------------------

spi_005:				; CODE XREF: SoundProcInt+24j
		ld	hl, AY_R09_chB_Vol
		jp	spi_003
; End of function SoundProcInt

; ---------------------------------------------------------------------------
AY_R07_Process:	db 0FFh			; DATA XREF: AY07sub+6r subAY07_001+4w ...
spi_var_x:	db 5Ah			; DATA XREF: SoundProcInt:spi_002r
					; SoundProcInt+4Bo
spi_var_a:	db 0			; DATA XREF: SoundProcInt+Er
					; SoundProcInt+1Cw ...
AY_R08_chA_Vol:	db 1			; DATA XREF: subAY07_001o RAM:AY08o ...
AY_R00_chA_freq:db 0			; DATA XREF: RAM:89FDw
AY_R01_chA_freq:db 0			; DATA XREF: RAM:8A06w
AY_R09_chB_Vol:	db 1			; DATA XREF: subAY07_001:subAY07_010o
					; RAM:AY09o ...
AY_R02_chB_freq:db 0F8h			; DATA XREF: RAM:8A18w
AY_R03_chB_freq:db 3			; DATA XREF: RAM:8A21w
AY_R10_chC_Vol:	db 1			; DATA XREF: subAY07_001:subAY07_100o
					; RAM:AY10o
AY_R04_chC_freq:db 0			; DATA XREF: RAM:8A28w
AY_R05_chC_freq:db 0			; DATA XREF: RAM:8A31w

add_hl_a:				; CODE XREF: WRTPSG+Ap
		add	a, l
		ld	l, a
		ret	nc
		inc	h
		ret
drvmsg:

		db 	'DRV:pacman2-AB                 '
