WRTPSG:					; CODE XREF: sub_8D38+4p sub_8D38+Ap ...
		di
		push	hl
		push	de
		push	af
		ld	hl, AYmainJmpTable

WRTPSG_Dispatch:			; CODE XREF: AY07sub+Fj
		and	0Fh
		add	a, a
		call	add_hl_a
		ld	d, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, d
		jp	(hl)
; End of function WRTPSG

; ---------------------------------------------------------------------------
AYmainJmpTable:	dw AY00			; DATA XREF: WRTPSG+4o
		dw AY01
		dw AY02
		dw AY03
		dw AY04
		dw AY05
		dw AY06_r
		dw AY07
		dw AY08
		dw AY09
		dw AY10
		dw AY11_r
		dw AY12
		dw AY13
		dw AY1415_r
		dw AY1415_r
; ---------------------------------------------------------------------------

AY00:					; DATA XREF: RAM:AYmainJmpTableo
		ld	a, e
		ld	(AY_R00_chA_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY01:					; DATA XREF: RAM:82E6o
		ld	a, e
		and	0Fh
		ld	(AY_R01_chA_freq), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


FREQAY_to_VI53:				; CODE XREF: SndProcInt+52p
		ld	a, (hl)
		inc	hl
		ld	h, (hl)
		ld	l, a
		add	hl, hl
		ld	e, l
		ld	d, h
		add	hl, hl
		add	hl, de
		add	hl, hl		; *10 ?
		ret
; End of function FREQAY_to_VI53

; ---------------------------------------------------------------------------

AY02:					; DATA XREF: RAM:82E8o
		ld	a, e
		ld	(AY_R02_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY03:					; DATA XREF: RAM:82EAo
		ld	a, e
		and	0Fh
		ld	(AY_R03_chB_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY04:					; DATA XREF: RAM:82ECo
		ld	a, e
		ld	(AY_R04_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY05:					; DATA XREF: RAM:82EEo
		ld	a, e
		and	0Fh
		ld	(AY_R05_chC_freq), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY06_r:					; DATA XREF: RAM:82F0o
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY11_r:					; DATA XREF: RAM:82FAo
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY07:					; DATA XREF: RAM:82F2o
		call	AY07sub

AY1415_r:				; CODE XREF: RAM:8308j	RAM:8311j ...
		pop	af
		pop	de
		pop	hl

subAY07_000:				; DATA XREF: RAM:AY07JMPTableo
		ei
		ret
; ---------------------------------------------------------------------------

AY12:					; DATA XREF: RAM:82FCo
		ld	a, e
		rrca
		and	7Eh ; '~'
		inc	a
		inc	a
		ld	(AY_R12_EnvPeriod_a), a
		ld	(AY_R12_EnvPeriod_b), a
		jp	AY1415_r
; ---------------------------------------------------------------------------

AY13:					; DATA XREF: RAM:82FEo
		ld	a, (AY_R12_EnvPeriod_a)
		ld	(AY_R12_EnvPeriod_b), a
		ld	hl, AY_R13_EnvCycle_a
		ld	a, (hl)
		inc	hl
		and	(hl)
		ld	(hl), a
		ld	hl, AY_R13_EnvCycle_b
		ld	a, (hl)
		inc	hl
		and	(hl)
		ld	(hl), a
		ld	hl, AY_R13_EnvCycle_c
		ld	a, (hl)
		inc	hl
		and	(hl)
		ld	(hl), a
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


AY07sub:				; CODE XREF: RAM:AY07p
		ld	a, e
		rrca
		rrca
		rrca
		or	e
		ld	e, a
		ld	a, (AY_R07_Process)
		xor	e
		ld	hl, AY07JMPTable
		and	7
		jp	WRTPSG_Dispatch
; End of function AY07sub

; ---------------------------------------------------------------------------
AY07JMPTable:	dw subAY07_000		; DATA XREF: AY07sub+Ao
		dw subAY07_001
		dw subAY07_010
		dw subAY07_011
		dw subAY07_100
		dw subAY07_101
		dw subAY07_110
		dw subAY07_111

; =============== S U B	R O U T	I N E =======================================


subAY07_001:				; CODE XREF: RAM:subAY07_011p
					; RAM:subAY07_101p ...
		ld	hl, AY_R08_chA_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	1
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_010:				; CODE XREF: RAM:83D1j
					; RAM:subAY07_110p
					; DATA XREF: ...
		ld	hl, AY_R09_chB_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	2
		ld	a, 0FDh	; 'ý'
		jp	subAY07_a
; ---------------------------------------------------------------------------

subAY07_100:				; CODE XREF: RAM:83D7j	RAM:83DDj
					; DATA XREF: ...
		ld	hl, AY_R10_chC_Vol
		ld	a, e
		ld	(AY_R07_Process), a
		and	4
		ld	a, 0FDh	; 'ý'

subAY07_a:				; CODE XREF: subAY07_001+Bj
					; subAY07_001+19j
		jp	z, subAY07_b
		ld	a, 2
		or	(hl)
		ld	(hl), a
		ret
; ---------------------------------------------------------------------------

subAY07_b:				; CODE XREF: subAY07_001:subAY07_aj
		and	(hl)
		ld	(hl), a
		ret
; End of function subAY07_001

; ---------------------------------------------------------------------------

subAY07_011:				; DATA XREF: RAM:8392o
		call	subAY07_001
		jp	subAY07_010
; ---------------------------------------------------------------------------

subAY07_101:				; DATA XREF: RAM:8396o
		call	subAY07_001
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_110:				; CODE XREF: RAM:83E3j
					; DATA XREF: RAM:8398o
		call	subAY07_010
		jp	subAY07_100
; ---------------------------------------------------------------------------

subAY07_111:				; DATA XREF: RAM:839Ao
		call	subAY07_001
		jp	subAY07_110
; ---------------------------------------------------------------------------

AY08:					; DATA XREF: RAM:82F4o
		ld	hl, AY_R08_chA_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY09:					; DATA XREF: RAM:82F6o
		ld	hl, AY_R09_chB_Vol
		jp	_AY080910
; ---------------------------------------------------------------------------

AY10:					; DATA XREF: RAM:82F8o
		ld	hl, AY_R10_chC_Vol

_AY080910:				; CODE XREF: RAM:83E9j	RAM:83EFj
		ld	a, e
		and	10h
		jp	nz, ay0910__1
		ld	a, e
		and	0Fh
		cp	3
		ld	a, 1
		jp	c, subAY10_b
		ld	a, 0FEh	; 'þ'
		and	(hl)
		ld	(hl), a

ay0910__3:				; CODE XREF: RAM:8411j
		dec	hl
		ld	(hl), 1
		jp	AY1415_r
; ---------------------------------------------------------------------------

subAY10_b:				; CODE XREF: RAM:8402j
		or	(hl)
		ld	(hl), a
		jp	ay0910__3
; ---------------------------------------------------------------------------

ay0910__1:				; CODE XREF: RAM:83F8j
		ld	a, (AY_R12_EnvPeriod_a)
		ld	(AY_R12_EnvPeriod_b), a
		ld	(hl), 0
		dec	hl
		ld	(hl), 0
		jp	AY1415_r

; =============== S U B	R O U T	I N E =======================================


SoundProcInt:				; CODE XREF: RAM:loc_8077p
		ld	hl, AY_R12_EnvPeriod_b
		dec	(hl)
		jp	nz, spi1
		ld	a, 1
		ld	(AY_R08_chA_Vol), a
		ld	(AY_R09_chB_Vol), a
		ld	(AY_R10_chC_Vol), a

spi1:					; CODE XREF: SndProcInt+4j
		ld	a, (AY_R10_chC_Vol)
		or	a
		jp	z, spi_001
		ld	a, (AY_R09_chB_Vol)
		or	a
		jp	z, spi_000
		ld	a, (spi_var_a)
		or	a
		ret	z
		ld	a, Mode_BCD|mode_FreqDiv|load_Fix|Ch0
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		xor	a
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	(spi_var_a), a
		ret
; ---------------------------------------------------------------------------

spi_000:				; CODE XREF: SndProcInt+1Dj
		ld	a, (AY_R10_chC_Vol)
		or	a
		jp	nz, spi_005
		jp	spi_002
; ---------------------------------------------------------------------------

spi_001:				; CODE XREF: SndProcInt+16j
		ld	a, (AY_R09_chB_Vol)
		or	a
		jp	nz, spi_004

spi_002:				; CODE XREF: SndProcInt+39j
		ld	a, (spi_var_x)
		and	1
		ld	hl, AY_R10_chC_Vol
		jp	z, spi_003
		ld	hl, AY_R09_chB_Vol

spi_003:				; CODE XREF: SndProcInt+4Bj
					; SndProcInt+6Aj ...
		inc	hl
		call	FREQAY_to_VI53
		ld	a, l
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	a, h
		ld	(portbase1C+TMR_0), a	; Sound	2000Hz
		ld	hl, spi_var_x
		inc	(hl)
		ld	a, 0FFh
		ld	(spi_var_a), a
		ret
; ---------------------------------------------------------------------------

spi_004:				; CODE XREF: SndProcInt+40j
		ld	hl, AY_R10_chC_Vol
		jp	spi_003
; ---------------------------------------------------------------------------

spi_005:				; CODE XREF: SndProcInt+36j
		ld	hl, AY_R09_chB_Vol
		jp	spi_003
; End of function SndProcInt

; ---------------------------------------------------------------------------
AY_R07_Process:	db 0FFh			; DATA XREF: AY07sub+6r subAY07_001+4w ...
spi_var_x:	db 0			; DATA XREF: SndProcInt:spi_002r
					; SndProcInt+5Do
spi_var_a:	db 0FFh			; DATA XREF: SndProcInt+20r
					; SndProcInt+2Ew ...
AY_R12_EnvPeriod_a:db 0			; DATA XREF: RAM:8353w	RAM:AY13r ...
AY_R12_EnvPeriod_b:db 0			; DATA XREF: RAM:8356w	RAM:835Fw ...
AY_R13_EnvCycle_a:db 1			; DATA XREF: RAM:8362o
AY_R08_chA_Vol:	db 1			; DATA XREF: subAY07_001o RAM:AY08o ...
AY_R00_chA_freq:db 1			; DATA XREF: RAM:8305w
AY_R01_chA_freq:db 1			; DATA XREF: RAM:830Ew
AY_R13_EnvCycle_b:db 1			; DATA XREF: RAM:8369o
AY_R09_chB_Vol:	db 1			; DATA XREF: subAY07_001:subAY07_010o
					; RAM:AY09o ...
AY_R02_chB_freq:db 1			; DATA XREF: RAM:8320w
AY_R03_chB_freq:db 1			; DATA XREF: RAM:8329w
AY_R13_EnvCycle_c:db 1			; DATA XREF: RAM:8370o
AY_R10_chC_Vol:	db 1			; DATA XREF: subAY07_001:subAY07_100o
					; RAM:AY10o ...
AY_R04_chC_freq:db 1			; DATA XREF: RAM:8330w
AY_R05_chC_freq:db 1			; DATA XREF: RAM:8339w

add_hl_a:				; CODE XREF: WRTPSG+Ap
		add	a, l
		ld	l, a
		ret	nc
		inc	h
		ret
drvmsg:

		db 	'DRV:XYZON2-BC                 '
