;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; $Id: testvm1.asm 1.0 2009/01/23 16:15:00 toma Exp $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; TASM  test file
; Test all instructions and addressing modes.
; Processor: 580VM1
;



idata16  .equ    1234h
idata8   .equ    12h
port     .equ    34h
addr16   .equ    5678h

        .org 1000h

start:
        nop
        lxi     b,idata16
        stax    b
        inx     b
        inr     b
        dcr     b
        mvi     b,idata8
        rlc

        dad     b
        ldax    b
        dcx     b
        inr     c
        dcr     c
        mvi     c,idata8
        rrc

;       ---                     ; 10
        lxi     d,idata16
        stax    d
        inx     d
        inr     d
        dcr     d
        mvi     d,idata8
        ral
;       ---
        dad     d
        ldax    d
        dcx     d
        inr     e
        dcr     e
        mvi     e,idata8
        rar


        lxi     h,idata16
        shld    addr16
        inx     h
        inr     h
        dcr     h
        mvi     h,idata8
        daa
;       ---
        dad     h
        lhld    addr16
        dcx     h
        inr     l
        dcr     l
        mvi     l,idata8
        cma


        lxi     sp,idata16
        sta     addr16
        inx     sp
        inr     m
        dcr     m
        mvi     m,idata8
        stc
;       ---
        dad     sp
        lda     addr16
        dcx     sp
        inr     a
        dcr     a
        mvi     a,idata8
        cmc

        mov     b,b             ; 40
        mov     b,c
        mov     b,d
        mov     b,e
        mov     b,h
        mov     b,l
        mov     b,m
        mov     b,a
        mov     c,b
        mov     c,c
        mov     c,d
        mov     c,e
        mov     c,h
        mov     c,l
        mov     c,m
        mov     c,a

        mov     d,b             ; 50
        mov     d,c
        mov     d,d
        mov     d,e
        mov     d,h
        mov     d,l
        mov     d,m
        mov     d,a
        mov     e,b
        mov     e,c
        mov     e,d
        mov     e,e
        mov     e,h
        mov     e,l
        mov     e,m
        mov     e,a

        mov     h,b             ; 60
        mov     h,c
        mov     h,d
        mov     h,e
        mov     h,h
        mov     h,l
        mov     h,m
        mov     h,a
        mov     l,b
        mov     l,c
        mov     l,d
        mov     l,e
        mov     l,h
        mov     l,l
        mov     l,m
        mov     l,a

        mov     m,b             ; 70
        mov     m,c
        mov     m,d
        mov     m,e
        mov     m,h
        mov     m,l
        hlt
        mov     m,a
        mov     a,b
        mov     a,c
        mov     a,d
        mov     a,e
        mov     a,h
        mov     a,l
        mov     a,m
        mov     a,a

        add     b               ; 80
        add     c
        add     d
        add     e
        add     h
        add     l
        add     m
        add     a
        adc     b               ; 88
        adc     c
        adc     d
        adc     e
        adc     h
        adc     l
        adc     m
        adc     a

        sub     b               ; 90
        sub     c
        sub     d
        sub     e
        sub     h
        sub     l
        sub     m
        sub     a
        sbb     b               ; 98
        sbb     c
        sbb     d
        sbb     e
        sbb     h
        sbb     l
        sbb     m
        sbb     a

        ana     b               ; a0
        ana     c
        ana     d
        ana     e
        ana     h
        ana     l
        ana     m
        ana     a
        xra     b               ; a8
        xra     c
        xra     d
        xra     e
        xra     h
        xra     l
        xra     m
        xra     a

        ora     b               ; b0
        ora     c
        ora     d
        ora     e
        ora     h
        ora     l
        ora     m
        ora     a
        cmp     b               ; b8
        cmp     c
        cmp     d
        cmp     e
        cmp     h
        cmp     l
        cmp     m
        cmp     a

        rnz                     ; c0
        pop     b
        jnz     start
        jmp     start
        cnz     start
        push    b
        adi     idata8
        rst     0
        rz
        ret
        jz      start
;       ---
        cz      start
        call    start
        aci     idata8
        rst     1

        rnc                     ; d0
        pop     d
        jnc     start
        out     port
        cnc     start
        push    d
        sui     idata8
        rst     2
        rc
;       ---
        jc      start
        in      port
        cc      start
;       ---
        sbi     idata8
        rst     3

        rpo                     ; e0
        pop     h
        jpo     start
        xthl
        cpo     start
        push    h
        ani     idata8
        rst     4
        rpe
        pchl
        jpe     start
        xchg
        cpe     start
;       ---
        xri     idata8
        rst     5

        rp                      ; f0
        pop     psw
        jp      start
        di
        cp      start
        push    psw
        ori     idata8
        rst     6
        rm
        sphl
        jm      start
        ei
        cm      start
;       ---
        cpi     idata8
        rst     7

;580VM1

	adc	h1
	adc	l1
	adc	m1

	add	h1
	add	l1
	add	m1

	ana	h1
	ana	l1
	ana	m1

	anx

	cmp	h1
	cmp	l1
	cmp	m1

	cs

	dad	h1		;H1L1=H1L1+H1L1
	rs\ dad b		;H1L1=H1L1+BC
	rs\ dad d		;H1L1=H1L1+DE
	rs\ dad sp		;H1L1=H1L1+SP
	cs\ dad b		;HL=HL+BC+CY
	cs\ dad d		;HL=HL+DE+CY
	cs\ dad h1		;H1L1=H1L1+H1L1+CY
	cs\ dad sp		;HL=HL+SP+CY
	cs\ rs\ dad b	;H1L1=H1L1+BC+CY
	cs\ rs\ dad d	;H1L1=H1L1+DE+CY
	cs\ rs\ dad sp	;H1L1=H1L1+SP+CY

	dcmp	b
	rs\ dcmp b		;H1L1-BC
	cs\ dcmp b		;HL-BC-CY
	cs\ rs\ dcmp b	;H1L1-BC-CY
	dcmp	d
	rs\ dcmp d		;H1L1-DE
	cs\ dcmp d		;HL-DE-CY
	cs\ rs\ dcmp d	;H1L1-DE-CY

	dcr	h1
	dcr	l1
	dcr	m1

	dcx	h1

	dsub	b		;HL=HL-BC
	rs\ dsub b		;H1L1=H1L1-BC
	cs\ rs\ dsub b	;H1L1=H1L1-DE-CY
	dsub	d		;HL=HL-DE
	rs\ dsub d		;H1L1=H1L1-DE
	cs\ rs\ dsub d	;H1L1=H1L1-DE-CY

	inr	h1
	inr	l1
	inr	m1

	inx	h1

	jof	start

	lh1l1d addr16
	
	lhlx

	lh1l1x

	lxi h1,idata16

	mb

	mov	b,h1
	mov	b,l1
	mov	b,m1
	mov	c,h1
	mov	c,l1
	mov	c,m1
	mov	d,h1
	mov	d,l1
	mov	d,m1
	mov	e,h1
	mov	e,l1
	mov	e,m1
	mov	h1,b
	mov	h1,c
	mov	h1,d
	mov	h1,e
	mov	h1,h1
	mov	h1,l1
	mov	h1,m1
	mov	h1,a
	mov	l1,b
	mov	l1,c
	mov	l1,d
	mov	l1,e
	mov	l1,h1
	mov	l1,l1
	mov	l1,m1
	mov	l1,a
	mov	m1,b
	mov	m1,c
	mov	m1,d
	mov	m1,e
	mov	m1,h1
	mov	m1,l1
	mov	m1,a
	mov	a,h1
	mov	a,l1
	mov	a,m1

	mvi	h1,idata8
	mvi	l1,idata8
	mvi	m1,idata8
	
	ora	h1
	ora	l1
	ora	m1

	orx

	pch1l1

	pop	h1

	push	h1	

	rs

	sbb	h1
	sbb	l1
	sbb	m1
	
	sh1l1d addr16

	shlx
	sh1l1x

	sph1l1

	smf0
	smf1

	sub	h1
	sub	l1
	sub	m1

	xra	h1
	xra	l1
	xra	m1

	xrx

	xth1l1

        .END

