;***************************** MACRO DEFINITIONS ***************************************

.MACRO M1H[3]
;CALL	TRACE
;CALL	TIMETST
		SBIS	PIND,MINT				; 1
		SEI								; 2
		CPI		PCH,0X11				; 3
.ENDMACRO

.MACRO M1L_LR[16]
		STS		XMCRB,ONE				; 2		6
		OR		PCH,CONST128			; 3		7
		OUT		PORTC,ZERO				; 4		8	----------
		XON								; 5 	9	----------
		LD		ZH,X+					; 8 	12	----------
		XOFF							; 9 	13	----------
		OUT		PORTC,CURRC				; 10	14	----------
		EOR		PCH,CONST128			; 11	15
		LDI		ZL,0X00					; 12	16	
		LSR		ZH						; 13	17	
		ROR		ZL						; 14	18	
		IJMP							; 16	20	
.ENDMACRO

.MACRO M1L_HR[15]
		STS		XMCRB,ZERO				; 2		7
		NOP								; 3		8
		XON								; 4 	9	----------
		LD		ZH,X+					; 7 	12	----------
		XOFF							; 8 	13	----------
		LDI		ZL,0X00					; 9		14
		LSR		ZH						; 10	15
		ROR		ZL						; 11	16	
		ADIW	ZL,0X00					; 13	18
		IJMP							; 15	20	
.ENDMACRO

.MACRO	XON
		OUT		MCUCR,CONST128
.ENDMACRO

.MACRO	XOFF
		;NOP
		OUT		MCUCR,ZERO
.ENDMACRO

;*********************************************************************************
;*********************************************************************************
;*********************************************************************************


.MACRO LOAD_BUF_PC[7]
		;XON_RBBCP
		LD		BUF,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_TMPL_PC_[10]
		;XON_RBBCP
		LD		TMPL,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_RES_PC[7]
		;XON_RBBCP
		LD		RES,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_RES_PC_[10]
		;XON_RBBCP
		LD		RES,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_B_PC[7]
		;XON_RBBCP
		LD		B,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_B_PC_[10]
		;XON_RBBCP
		LD		B,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_C_PC[7]
		;XON_RBBCP
		LD		C,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_C_PC_[10]
		;XON_RBBCP
		LD		C,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_D_PC[7]
		;XON_RBBCP
		LD		D,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_D_PC_[10]
		;XON_RBBCP
		LD		D,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_E_PC[7]
		;XON_RBBCP
		LD		E,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_E_PC_[10]
		;XON_RBBCP
		LD		E,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_PC[7]
		;XON_RBBCP
		LD		A,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_PC_[10]
		;XON_RBBCP
		LD		A,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_H_PC_[10]
		;XON_RBBCP
		LD		H,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_L_PC_[10]
		;XON_RBBCP
		LD		L,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IXH_PC_[10]
		;XON_RBBCP
		LD		IXH,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IXL_PC_[10]
		;XON_RBBCP
		LD		IXL,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO


.MACRO LOAD_ZH_PC[7]
		;XON_RBBCP
		LD		ZH,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BC_PC[10]
		;XON_RBBCP
		LD		C,X+
		LD		B,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BC_PC_[13]
		;XON_RBBCP
		LD		C,X+
		LD		B,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_DE_PC[10]
		;XON_RBBCP
		LD		E,X+
		LD		D,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_DE_PC_[13]
		;XON_RBBCP
		LD		E,X+
		LD		D,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_HL_PC_[13]
		;XON_RBBCP
		LD		L,X+
		LD		H,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IX_PC_[13]
		;XON_RBBCP
		LD		IXL,X+
		LD		IXH,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_PC_STP[10]
		;XON_RBBCP
		LD		PCL,Y+
		LD		PCH,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_PC_STP_[13]
		;XON_RBBCP
		LD		PCL,Y+
		LD		PCH,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BC_STP[10]
		;XON_RBBCP
		LD		C,Y+
		LD		B,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BC_STP_[13]
		;XON_RBBCP
		LD		C,Y+
		LD		B,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_DE_STP[10]
		;XON_RBBCP
		LD		E,Y+
		LD		D,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_DE_STP_[13]
		;XON_RBBCP
		LD		E,Y+
		LD		D,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_HL_STP[10]
		;XON_RBBCP
		LD		L,Y+
		LD		H,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_HL_STP_[13]
		;XON_RBBCP
		LD		L,Y+
		LD		H,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_AF_STP[9]
		;XON_RBBCP
		LD		F,Y+
		LD		A,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_AF_STP_[13]
		;XON_RBBCP
		LD		F,Y+
		LD		A,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_Z_STP[11]
		;XON_RBBCP
		LD		ZL,Y+
		LD		ZH,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IX_STP[10]
		;XON_RBBCP
		LD		IXL,Y+
		LD		IXH,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IX_STP_[13]
		;XON_RBBCP
		LD		IXL,Y+
		LD		IXH,Y+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IY_STP[10]
		;XON_RBBCP
		LD		IYL,Y+
		LD		IYH,Y+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IYH_PC_[10]
		;XON_RBBCP
		LD		IYH,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IYL_PC_[10]
		;XON_RBBCP
		LD		IYL,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

;****************************************************************************************
;****************************************************************************************


.MACRO LOAD_BUF_Z[7]
		;XON_RBBCP
		LD		BUF,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BUFH_Z[7]
		;XON_RBBCP
		LD		BUFH,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BUFH_Z_[10]
		;XON_RBBCP
		LD		BUFH,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_RES_Z[7]
		;XON_RBBCP
		LD		RES,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_TMPL_Z[7]
		;XON_RBBCP
		LD	TMPL,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_TMPL_ZI[7]
		;XON_RBBCP
		LD	TMPL,Z+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_Z[7]
		;XON_RBBCP
		LD		A,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_Z_[10]
		;XON_RBBCP
		LD		A,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_ZI[7]
		;XON_RBBCP
		LD		A,Z+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_A_ZI_[10]
		;XON_RBBCP
		LD		A,Z+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_B_Z[7]
		;XON_RBBCP
		LD		B,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_B_Z_[10]
		;XON_RBBCP
		LD		B,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_C_Z[7]
		;XON_RBBCP
		LD		C,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_C_Z_[10]
		;XON_RBBCP
		LD		C,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_D_Z[7]
		;XON_RBBCP
		LD		D,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_D_Z_[10]
		;XON_RBBCP
		LD		D,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_E_Z[7]
		;XON_RBBCP
		LD		E,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_E_Z_[10]
		;XON_RBBCP
		LD		E,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_H_Z[7]
		;XON_RBBCP
		LD		H,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_H_Z_[10]
		;XON_RBBCP
		LD		H,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_L_Z[7]
		;XON_RBBCP
		LD		L,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_L_Z_[10]
		;XON_RBBCP
		LD		L,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_AF_Z[10]
		;XON_RBBCP
		LD		F,Z+P
		LD		A,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_TMP_Z[10]
		;XON_RBBCP
		LD		TMPL,Z+
		LD		TMPH,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_BC_Z[10]
		;XON_RBBCP
		LD		C,Z+
		LD		B,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_DE_Z[10]
		;XON_RBBCP
		LD		E,Z+
		LD		D,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_HL_Z[10]
		;XON_RBBCP
		LD		L,Z+
		LD		H,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_HL_Z_[13]
		;XON_RBBCP
		LD		L,Z+
		LD		H,Z
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_PC_Z[11]
		;XON_RBBCP
		LD		ZL,X+
		LD		ZH,X+
		;XOFF;_RBBCP
		MOVW	PCL,ZL
.ENDMACRO

.MACRO LOAD_IX_Z[10]
		;XON_RBBCP
		LD		IXL,Z+
		LD		IXH,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IY_Z[10]
		;XON_RBBCP
		LD		IYL,Z+
		LD		IYH,Z+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_IY_Z_[15]
		;XON_RBBCP
		LD		TMPL,Z+
		LD		TMPH,Z+
		LD		BUF,X
		;XOFF;_RBBCP
		MOV		IYL,TMPL
		MOV		IYH,TMPH
.ENDMACRO

.MACRO LOAD_STP_PC[10]
		;XON_RBBCP
		LD		STPL,X+
		LD		STPH,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_STP_PC_[13]
		;XON_RBBCP
		LD		STPL,X+
		LD		STPH,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_STP_Z[10]
		;XON_RBBCP
		LD		STPL,Z+
		LD		STPH,Z
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_Z_PC[10]
		;XON_RBBCP
		LD		ZL,X+
		LD		ZH,X+
		;XOFF;_RBBCP
.ENDMACRO

.MACRO LOAD_Z_PC_[13]
		;XON_RBBCP
		LD		ZL,X+
		LD		ZH,X+
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO


;***********************************************************************************************
;***********************************************************************************************

.MACRO RLOAD_BUF[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	BUF,Z+
		ADIW	PCL,0X01	
.ENDMACRO

.MACRO RLOAD_RES[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	RES,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_IYH[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	IYH,Z
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_IYL[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	IYL,Z
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_TMPL[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	TMPL,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_TMPL_Z[4]
		OR		ZH,ROMID
		ELPM	TMPL,Z
.ENDMACRO

.MACRO RLOAD_BUF_Z[4]
		OR		ZH,ROMID
		ELPM	BUF,Z
.ENDMACRO

.MACRO RLOAD_RES_Z[4]
		OR		ZH,ROMID
		ELPM	RES,Z
.ENDMACRO

.MACRO RLOAD_BUFH_Z[4]
		OR		ZH,ROMID
		ELPM	BUFH,Z
.ENDMACRO

.MACRO RLOAD_A[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	A,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_A_Z[4]
		OR		ZH,ROMID
		ELPM	A,Z
.ENDMACRO

.MACRO RLOAD_A_ZI[5]
		OR		ZH,ROMID	
		ELPM	A,Z+
		CBR		ZH,0B11000000
.ENDMACRO

.MACRO RLOAD_B[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	B,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_C[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	C,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_D[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	D,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_E[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	E,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_H[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	H,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_L[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	L,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_IXH[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	IXH,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_IXL[7]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	IXL,Z+
		ADIW	PCL,0X01
.ENDMACRO

.MACRO RLOAD_BC[10]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	C,Z+
		ELPM	B,Z+
		ADIW	PCL,0X02
.ENDMACRO

.MACRO RLOAD_DE[10]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	E,Z+
		ELPM	D,Z+
		ADIW	PCL,0X02
.ENDMACRO

.MACRO RLOAD_HL[10]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	L,Z+
		ELPM	H,Z+
		ADIW	PCL,0X02
.ENDMACRO

.MACRO RLOAD_IX[10]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	IXL,Z+
		ELPM	IXH,Z+
		ADIW	PCL,0X02
.ENDMACRO

.MACRO RLOAD_TMP_Z[7]
		OR		ZH,ROMID
		ELPM	TMPL,Z+
		ELPM	TMPH,Z
.ENDMACRO

.MACRO RLOAD_BC_Z[7]
		OR		ZH,ROMID
		ELPM	C,Z+
		ELPM	B,Z
.ENDMACRO

.MACRO RLOAD_DE_Z[7]
		OR		ZH,ROMID
		ELPM	E,Z+
		ELPM	D,Z
.ENDMACRO

.MACRO RLOAD_HL_Z[7]
		OR		ZH,ROMID
		ELPM	L,Z+
		ELPM	H,Z
.ENDMACRO

.MACRO RLOAD_IX_Z[9]
		OR		ZH,ROMID
		ELPM		BUF,Z+
		MOV		IXL,BUF
		ELPM		BUF,Z
		MOV		IXH,BUF
.ENDMACRO

.MACRO RLOAD_IY_Z[9]
		OR		ZH,ROMID	
		ELPM		TMPL,Z+
		MOV		IYL,TMPL
		ELPM		TMPL,Z
		MOV		IYH,TMPL
.ENDMACRO

.MACRO RLOAD_PC[8]
		MOVW	ZL,PCL 
		OR		ZH,ROMID
		ELPM		PCL,Z+
		ELPM		PCH,Z+
.ENDMACRO

.MACRO RLOAD_STP[10]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM		STPL,Z+
		ELPM		STPH,Z+
		ADIW	PCL,0X02	
.ENDMACRO

.MACRO RLOAD_STP_Z[7]
		OR		ZH,ROMID
		ELPM		STPL,Z+
		ELPM		STPH,Z
.ENDMACRO

.MACRO RLOAD_Z_PC[11]
		MOVW	ZL,PCL
		OR		ZH,ROMID
		ELPM	BUFH,Z+
		ELPM	ZH,Z
		ADIW	PCL,0X02
		MOV		ZL,BUFH
.ENDMACRO


;***********************************************************************************************
;***********************************************************************************************


.MACRO SAVE_RES_Z[7]
		;XON_RBBCP
		ST		Z,RES
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_RES_Z_[10]
		;XON_RBBCP
		ST		Z,RES
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BUF_Z[7]
		;XON_RBBCP
		ST		Z,BUF
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BUFH_Z[7]
		;XON_RBBCP
		ST		Z,BUFH
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BUFH_Z_[10]
		;XON_RBBCP
		ST		Z,BUFH
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BUF_Z_[10]
		;XON_RBBCP
		ST		Z,BUF
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_TMP_Z[10]
		;XON_RBBCP
		ST		Z+,TMPL
		ST		Z,TMPH
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_TMPH_Z[7]
		;XON_RBBCP
		ST		Z,TMPH
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_TMPL_Z[7]
		;XON_RBBCP
		ST		Z,TMPL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_TMPL_ZI[7]
		;XON_RBBCP
		ST		Z+,TMPL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_A_Z[7]
		;XON_RBBCP
		ST		Z,A
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_A_Z_[10]
		;XON_RBBCP
		ST		Z,A
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_A_ZI[7]
		;XON_RBBCP
		ST		Z+,A
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_A_ZI_[10]
		;XON_RBBCP
		ST		Z+,A
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_B_Z[7]
		;XON_RBBCP
		ST		Z,B
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_B_Z_[10]
		;XON_RBBCP
		ST		Z,B
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_C_Z[7]
		;XON_RBBCP
		ST		Z,C
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_C_Z_[10]
		;XON_RBBCP
		ST		Z,C
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_D_Z[7]
		;XON_RBBCP
		ST		Z,D
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_D_Z_[10]
		;XON_RBBCP
		ST		Z,D
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_E_Z[7]
		;XON_RBBCP
		ST		Z,E
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_E_Z_[10]
		;XON_RBBCP
		ST		Z,E
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_H_Z[7]
		;XON_RBBCP
		ST		Z,H
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_H_Z_[10]
		;XON_RBBCP
		ST		Z,H
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_L_Z[7]
		;XON_RBBCP
		ST		Z,L
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_L_Z_[10]
		;XON_RBBCP
		ST		Z,L
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO


.MACRO SAVE_STP_Z[10]
		;XON_RBBCP
		ST		Z+,STPL
		ST		Z,STPH
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_AF_Z[10]
		;XON_RBBCP
		ST		Z+,F
		ST		Z,A
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BC_Z[10]
		;XON_RBBCP
		ST		Z+,C
		ST		Z,B
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BC_Z_[13]
		;XON_RBBCP
		ST		Z+,C
		ST		Z,B
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_DE_Z[10]
		;XON_RBBCP
		ST		Z+,E
		ST		Z,D
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_DE_Z_[13]
		;XON_RBBCP
		ST		Z+,E
		ST		Z,D
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_HL_Z[10]
		;XON_RBBCP
		ST		Z+,L
		ST		Z,H
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_HL_Z_[13]
		;XON_RBBCP
		ST		Z+,L
		ST		Z,H
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IX_Z[12]
		MOV		TMPL,IXL
		MOV		BUF,IXH
		;XON_RBBCP
		ST		Z+,TMPL
		ST		Z,BUF
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IY_Z[12]
		MOV		TMPL,IYL
		MOV		BUF,IYH
		;XON_RBBCP
		ST		Z+,TMPL
		ST		Z,BUF
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_PC_SP[10]
		;XON_RBBCP
		ST		-Y,PCH
		ST		-Y,PCL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BC_SP[10]
		;XON_RBBCP
		ST		-Y,B
		ST		-Y,C
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_BC_SP_[13]
		;XON_RBBCP
		ST		-Y,B
		ST		-Y,C
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_DE_SP[10]
		;XON_RBBCP
		ST		-Y,D
		ST		-Y,E
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_DE_SP_[13]
		;XON_RBBCP
		ST		-Y,D
		ST		-Y,E
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_HL_SP[10]
		;XON_RBBCP
		ST		-Y,H
		ST		-Y,L
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_HL_SP_[13]
		;XON_RBBCP
		ST		-Y,H
		ST		-Y,L
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_Z_SP[10]
		;XON_RBBCP
		ST		-Y,ZH
		ST		-Y,ZL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_Z_SP_[13]
		;XON_RBBCP
		ST		-Y,ZH
		ST		-Y,ZL
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IX_STP[10]
		;XON_RBBCP
		ST		-Y,IXH
		ST		-Y,IXL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IX_STP_[13]
		;XON_RBBCP
		ST		-Y,IXH
		ST		-Y,IXL
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_TMP_SP[10]
		;XON_RBBCP
		ST		-Y,TMPH
		ST		-Y,TMPL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IY_SP[10]
		;XON_RBBCP
		ST		-Y,IYH
		ST		-Y,IYL
		;XOFF;_RBBCP
.ENDMACRO

.MACRO SAVE_IY_SP_[13]
		;XON_RBBCP
		ST		-Y,IYH
		ST		-Y,IYL
		LD		BUF,X
		;XOFF;_RBBCP
.ENDMACRO


