
;********************************************************************************************************************************************
;****************************************************** OPCPDE 0x ***************************************************************************
;********************************************************************************************************************************************


.ORG	0X0000+0X00*128						; NOP            [ 00 ] 4  (36) NONE //

EX00:			JMP		NOPTST				; 23


.ORG	0X0004

				SBIS	PIND,TOCPU			; TEST FOR INTERRUPT PHASE
				RJMP	PDPRQ				; GO TO PDP REQUEST HANDLING
				POP		BUF					; RETURN
				POP		BUF					; SP
				LDI		BUF,(1<<MUXA15)|(1<<MUXA14); 2
				OUT		PORTB,CURRB			; 2 CURRENT PAGE
				OUT		PORTE,TMPH			; 
				STS		PORTF,BUFH			; 
				NOP
				NOP	
				NOP
				NOP
				NOP
		
	NOP			; 1 DO NON CHANGE !!!
	NOP			; 1

				OUT		SREG,TMPSRG			; RESTORE I
				OUT		EIFR,CONSTFF		; CLEAR INT FLAGS			
				RET

PDPRQ:			LDI		BUF,(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); 2
				OUT		PORTB,BUF			; 2 ALT PAGE
				CBI		PORTD,TOVCPU		; 0 ENABLE PDP
				IN		TMPSRG,SREG			; 0
				NOP							; 0
				NOP							; 0
				NOP							; 0
				SBI		PORTD,TOVCPU		; 0
				NOP
				NOP
				NOP
				NOP
				NOP
				OUT		EIFR,CONSTFF		; CLEAR INT FLAGS
				SEI
WAITFORSYNC:	RJMP	WAITFORSYNC			; WAIT FOR AN INTERRUPT IN SYNC STATE


NOPTST:			SBIS	CONTROL,SYS			; 26
				JMP		RESET				; 
				JMP		M1-T4+29			; 29


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X01*128						; LXI B,$		[ 01 ] 10 (81) NONE //
				
EX01:			LDI		ZL,REGCADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				JMP		M1-T10+62			; 62

RESET:			CLI

				LDI		BUF,(1<<MUXA15)|(1<<MUXA14)			; 1 
				OUT		PORTB,BUF							; 1 PORTB 
				MOV		CURRB,BUF							; 1
				LDI		BUF,(1<<TOTAPE)|(1<<BEEP)|(1<<NBEEP)|(1<<MUXA17)|(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); 1 CONFIGURATION
				OUT		DDRB,BUF							; 1 

				LDI		BUF,(1<<A15_CPU)|(1<<A14_CPU)		; 1 
				OUT		PORTC,BUF							; 1 PORTC 
				MOV		CURRC,BUF							; 1
				LDI		BUF,(1<<A15_CPU)|(1<<A14_CPU)		; 1 CONFIGURATION
				OUT		DDRC,BUF							; 1 

				LDI		BUF,(1<<TOVCPU)|(1<<TOCPU)			; 2 
				OUT		PORTD,BUF							; 2 PORTD CONFIGURATION
				LDI		BUF,(1<<BORDERL)|(1<<BORDERM)|(1<<BORDERH)|(1<<BORDERY)|(1<<TOVCPU); 2 
				OUT		DDRD,BUF

				LDI		BUF,0X00							; 2 
				OUT		PORTE,BUF							; 2 PORTE CONFIGURATION
				MOV		CURRE,BUF							; 2
				LDI		BUF,0X00							; 2 
				OUT		DDRE,BUF							; 2 

				LDI		BUF,(1<<KEYMH)						; 3 
				STS		PORTF,BUF							; 3 PORTF CONFIGURATION
				MOV		CURRF,BUF							; 3
				LDI		BUF,(1<<KEYMH)|(1<<KEYL)			; 3 
				STS		DDRF,BUF							; 3 

				LDI		BUF,0XFF							; 0 STEK POINTER
				OUT		SPL,BUF								; 0 INITIALISING
				LDI		BUF,0X10							; 0 STEK POINTER
				OUT		SPH,BUF								; 0 INITIALISING

				LDI		BUF,1<<SYS							; 
				OUT		CONTROL,BUF							; 
				
				CLR		ZERO								; CLEAR ZERO REGISTER
				LDI		BUF,0XFF							; SET
				MOV		CONSTFF,BUF							; CONSTFF 
				LDI		BUF,128								; 1 LOAD 
				MOV		CONST128,BUF						; 1 CONST128 REGISTER
				LDI		BUF,0X01							; 2 LOAD
				MOV		ONE,BUF								; 2 ONE REGISTER
				LDI		BUF,0X00;01<<ROMIDBIT				; 2 LOAD
				MOV		ROMID,BUF							; 2 ROMID REGISTER

				LDI		B,0XFF					;
				LDI		C,0XFF					;
				MOVW	E,C						;
				MOVW	L,C						;
				LDI		A,0B00000011			;

				MOV		MEMPTRL,ZERO			; 
				MOV		MEMPTRH,ZERO			; 

				LDI		BUF,(1<<ADLAR)|(1<<MUX2)|(1<<MUX1)|(1<<REFS0)	; % SET EXTERNAL REF, LEFT ADJUSTMENT, 
				OUT		ADMUX,BUF										; % ADC6 CHANNEL
				LDI		BUF,(1<<ADEN)|(1<<ADFR)|(1<<ADSC)|(1<<ADPS1)	; % ON AD CONVERTER IN FREE-RUNNING MODE
				OUT		ADCSRA,BUF										; % WITH PRESCALING FACTOR 2

CALL	TAB16
				
				
				CBI		PORTD,TOVCPU			; 
WFVCPURD:		SBIC	PIND,TOCPU				; 
				RJMP	WFVCPURD				; 
				SBI		PORTD,TOVCPU			; 	
				
				LDI		BUF,0X00				; SELECT LOW LEVEL INTERRUPT
				STS		EICRA,BUF				; ON INT1 (MINT)
				LDI		BUF,1<<INT1				; ENABLE
				OUT		EIMSK,BUF				; INT1
				OUT		EIFR,CONSTFF			; RESET INTERRUPT FLAGS	
				
			
				;LDI		ZH,0X00					; 
				;LDI		ZL,0X00					; 
				;LDI		XH,0XF8					; 
				;LDI		XL,0X00					; 
				OUT		RAMPZ,ONE				; 
				;OUT		MCUCR,CONST128			; 
;EXTRACTLOOP:	ELPM	BUF,Z+					; 
				;ST		X+,BUF					; 
				;CPI		XH,0X00					; 
				;BRNE	EXTRACTLOOP				; 
				;OUT		MCUCR,ZERO				; 	
				JMP		EXTR2					; 


.ORG	0X0000+0X11*128						; LXI D,$		[ 11 ] 10 (81) NONE //
				
EX11:			LDI		ZL,REGEADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				JMP		M1-T10+62			; 62


EXTR2:			LDI		ZL,0X00								; **
				LDI		ZH,0X01								; ** FIRST PARITY TABLE (WITH Z FLAG)
				LDI		TMPH,1<<PP							; **
PM1:			LDI		BUF,0X08							; **
				MOV		ZERO,BUF							; **
				LDI		BUF,1<<PP							; **
				MOV		TMPL,ZL								; **	
BITLPTP:		SBRC	TMPL,7								; **
				EOR		BUF,TMPH							; **
				LSL		TMPL								; **
				DEC		ZERO								; **
				BRNE	BITLPTP								; **
				ST		Z,BUF								; **
				LDI		ZH,0X05								; ** THURD PARITY TABLE (WITHOUT Z FLAG AND AC FLAGS)
				ST		Z,BUF								; **
				LDI		ZH,0X03								; ** SECOND PARITY TABLE (WITH Z FLAG AND AC SET)
				SBR		BUF,1<<AC							; **
				ST		Z+,BUF								; **
				LDI		ZH,0X01								; ** FIRST PARITY TABLE (WITH Z FLAG)
				CP		ZL,ZERO								; **
				BRNE	PM1    								; ** 
				LDI		BUF,(1<<ZZ)|(1<<PP)					; ** 
				ST		Z,BUF								; ** 
				LDI		ZH,0X03								; ** SECOND PARITY TABLE (WITH Z FLAG AND AC SET)
				LDI		BUF,(1<<ZZ)|(1<<PP)|(1<<AC)			; **
				ST		Z,BUF								; ** 
				LDI		ZH,0X05								; ** THURD PARITY TABLE (WITHOUT Z FLAG AND AC FLAGS)
				LDI		BUF,(1<<PP)							; **
				ST		Z,BUF								; ** 


				LDI		ZH,HIGH(PAGETBL)					; # 
				LDI		ZL,0X00								; # 
PGTBLFILLLOOP:	MOV		BUF,ZL								; # 
				CBR		BUF,0B11111100						; # 
				CPI		BUF,0X00							; # 
				BRNE	PAGENOT0							; # 
				LDI		BUF,(1<<MUXA15)|(1<<MUXA14)			; # 
				ST		Z+,BUF								; #
				LDI		BUF,0X00							; # 
				ST		Z+,BUF								; #
				LDI		BUF,1<<KEYMH						; # 
				ST		Z+,BUF								; #
				RJMP	COMPGTBLFILL						; # 
PAGENOT0:		CPI		BUF,0X01							; # 
				BRNE	PAGENOT1							; # 
				LDI		BUF,(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14)	; # 
				ST		Z+,BUF								; # 
				LDI		BUF,1<<SCRA16						; # 
				ST		Z+,BUF								; #
				LDI		BUF,1<<KEYMH						; # 
				ST		Z+,BUF								; #
				RJMP	COMPGTBLFILL						; # 
PAGENOT1:		CPI		BUF,0X02							; # 
				BRNE	PAGE3								; # 
				LDI		BUF,(1<<MUXA17)|(1<<MUXA15)|(1<<MUXA14)	; # 
				ST		Z+,BUF								; # 
				LDI		BUF,0X00							; # 
				ST		Z+,BUF								; #
				LDI		BUF,(1<<KEYMH)|(1<<KEYL)			; # 
				ST		Z+,BUF								; #
				RJMP	COMPGTBLFILL						; # 
PAGE3:			LDI		BUF,(1<<MUXA17)|(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14)	; # 
				ST		Z+,BUF								; #
				LDI		BUF,1<<SCRA16						; # 
				ST		Z+,BUF								; #
				LDI		BUF,(1<<KEYMH)|(1<<KEYL)			; # 
				ST		Z+,BUF								; #
COMPGTBLFILL:	INC		ZL									; #
				CPI		ZL,0X00								; # 
				BRNE	PGTBLFILLLOOP						; # 

				
				LDI		BUF,(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14)	; 2
				OUT		PORTB,BUF								; 2 ALT PAGE
				LDI		ZH,0XC0
				LDI		ZL,0X00
				OUT		MCUCR,CONST128
				LDI		BUF,0B01000111
FILLLP2:		ST		Z+,BUF
				CPI		ZH,0XF0
				BRNE	FILLLP2
				OUT		MCUCR,ZERO
				LDI		BUF,(1<<MUXA15)|(1<<MUXA14); 2
				OUT		PORTB,BUF			; 2 PRIM PAGE
	
	
	LDI		BUF,0B00000001			; 2 TCNT1: NO PRESCALING
	OUT		TCCR1B,BUF				; 2 START TIMER COUNTER 1
				
				
				LDI		PCH,0XF8				; RESET
				LDI		PCL,0X00                ; PROGRAM COUNTER
				OUT		EIFR,CONSTFF			; CLEAR INTERRUPT FLAG
				JMP		M1


.ORG	0X0000+0X21*128						; LXI H,$		[ 21 ] 10 (81) NONE //
				
EX21:			LDI		ZL,REGLADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				JMP		M1-T10+62			; 62


DONEM80:		NOP											; -80
DONEM79:		NOP											; -79
DONEM78:		NOP											; -78
DONEM77:		NOP											; -77
DONEM76:		NOP											; -76
DONEM75:		NOP											; -75
DONEM74:		NOP											; -74
DONEM73:		NOP											; -73
DONEM72:		NOP											; -72
DONEM71:		NOP											; -71
DONEM70:		NOP											; -70
DONEM69:		NOP											; -69
DONEM68:		NOP											; -68
DONEM67:		NOP											; -67
DONEM66:		NOP											; -66
DONEM65:		NOP											; -65
DONEM64:		NOP											; -64
DONEM63:		NOP											; -63
DONEM62:		NOP											; -62
DONEM61:		NOP											; -61
DONEM60:		NOP											; -60
DONEM59:		NOP											; -59
DONEM58:		NOP											; -58
DONEM57:		NOP											; -57
DONEM56:		NOP											; -56
DONEM55:		NOP											; -55
DONEM54:		NOP											; -54
DONEM53:		NOP											; -53
DONEM52:		NOP											; -52
DONEM51:		NOP											; -51
DONEM50:		NOP											; -50
DONEM49:		NOP											; -49
DONEM48:		NOP											; -48
DONEM47:		NOP											; -47
DONEM46:		NOP											; -46
DONEM45:		NOP											; -45
DONEM44:		NOP											; -44
DONEM43:		NOP											; -43
DONEM42:		NOP											; -42
DONEM41:		NOP											; -41
DONEM40:		NOP											; -40
DONEM39:		NOP											; -39
DONEM38:		NOP											; -38
DONEM37:		NOP											; -37
DONEM36:		NOP											; -36
DONEM35:		NOP											; -35
DONEM34:		NOP											; -34
DONEM33:		NOP											; -33
DONEM32:		NOP											; -32
DONEM31:		NOP											; -31
DONEM30:		NOP											; -30
DONEM29:		NOP											; -29
DONEM28:		NOP											; -28
DONEM27:		NOP											; -27
DONEM26:		NOP											; -26
DONEM25:		NOP											; -25
DONEM24:		NOP											; -24
DONEM23:		NOP											; -23
DONEM22:		NOP											; -22
DONEM21:		NOP											; -21
DONEM20:		NOP											; -20
DONEM19:		NOP											; -19
DONEM18:		NOP											; -18
DONEM17:		NOP											; -17
DONEM16:		NOP											; -16
DONEM15:		NOP											; -15
DONEM14:		NOP											; -14
DONEM13:		NOP											; -13
DONEM12:		NOP											; -12
DONEM11:		NOP											; -11
DONEM10:		NOP											; -10
DONEM9:			NOP											; -9
DONEM8:			NOP											; -8
DONEM7:			NOP											; -7
DONEM6:			NOP											; -6
DONEM5:			NOP											; -5
DONEM4:			NOP											; -4
				NOP											; -3
DONEM2:			NOP											; -2
DONEM1:			NOP											; -1
M1:				M1H[3]							; 3 
				BRCC	HRAMRD					; 4 /> 5
				M1L_LR[16]						; 20
HRAMRD:			M1L_HR[15]						; 20


.ORG	0X0000+0X31*128						; LXI SP,$		[ 31 ] 10 (81) NONE //
				
EX31:			LDI		ZL,REGSPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				JMP		M1-T10+62			; 62


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X02*128						; STAX B		[ 02 ]	7	(54)	NONE
				
				MOVW	ZL,C				; 21 
				MOV		TMPL,A				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49

ST_TMPL_Z:		CPI		ZH,0XF0				; 27			1
				BRCS	STTLZ_NSYS			; 28 /> 29		2 /> 3
				STS		XMCRB,ZERO			; 30			4
				MOV		BUF,CURRB			; 31			5
				LDI		BUF,(1<<MUXA15)|(1<<MUXA14);32		6
				CPI		ZH,0XF9				; 33			7
				BREQ	STTLZ_F9			; 34 /> 35		8 /> 9
				OUT		PORTB,BUF			; 35			9
				XON							; 36			10
				ST		Z,TMPL				; 39			13
				XOFF						; 40			14
				OUT		PORTB,CURRB			; 41			15
				CPI		ZH,0XFA				; 42			16
				BRNE	STTLZNOTFA			; 43 /> 44		17 /> 18
				COM		TMPL				; 44			18
				MOV		CURRC,TMPL			; 45			19
				ROR		CURRC				; 46			20
				ROR		CURRC				; 47			21
				ROR		CURRC				; 48			22
				OUT		PORTC,CURRC			; 49			23
				DELAY2						; 51			25
				RET							; 55			29
STTLZNOTFA:		CPI		ZH,0XF8				; 45			19
				BRNE	STTLZNOTF8			; 46 /> 47		20 /> 21
				MOV		BUF,TMPL			; 47			21
				LSL		BUF					; 48			22
				LSL		BUF					; 49			23
				LSL		BUF					; 50			24
				OUT		PORTD,BUF			; 51			25
				RET							; 55			29
STTLZNOTF8:		CPI		ZH,0XF4				; 48			22
				BRNE	STTLZNOTF4			; 49 /> 50		23 /> 24
				OUT		PORTA,TMPL			; 50			24
				DELAY1						; 51			25
				RET							; 55			29
STTLZNOTF4:		CPI		ZH,0XF5				; 51			25
				BREQ	STTLZF5				; 52 /> 53		26 /> 27
				DELAY3						; 55
				DELAY3						; 58
				DELAY2						; 60
				RET							; 64

STTLZ_F9:		MOV		ZL,TMPL				; 36			10
				LDI		ZH,HIGH(PAGETBL)	; 37			11
				MOV		BUF,CURRB			; 38			12
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); 39			13
				LD		CURRB,Z+			; 41			15
				OR		CURRB,BUF			; 42			16
				OUT		PORTB,CURRB			; 43			17
				LD		CURRE,Z+			; 45			19
				OUT		PORTE,CURRE			; 46			20
				LD		BUF,Z				; 48			22
				STS		PORTF,BUF			; 50			24
				MOV		CURRF,BUF			; 51			25
				RET							; 55			29			
STTLZ_NSYS:		CPI		ZH,0X11				; 30			4
				BRCC	STTLZ_HR			; 31 /> 32		5 /> 6
				STS		XMCRB,ONE			; 33			7
				OR		ZH,CONST128			; 34			8
				OUT		PORTC,ZERO			; 35			9
				XON							; 36			10
				ST		Z,TMPL				; 39			13
				XOFF						; 40			14
				OUT		PORTC,CURRC			; 41			15
				EOR		ZH,CONST128			; 42			16
				RET							; 46			20
STTLZ_HR:		STS		XMCRB,ZERO			; 34			8
				DELAY1						; 35			9
				XON							; 36			10
				ST		Z,TMPL				; 39			13
				XOFF						; 40			14
				DELAY2						; 42			16
				RET							; 46			20
STTLZF5:		OUT		RDAH,ZH				; 54
				OUT		RDAL,ZL				; 55
				DELAY3						; 58
				DELAY2						; 60
				RET							; 64


.ORG	0X0000+0X12*128						; STAX D		[ 12 ]	7	(54)	NONE
				
				MOVW	ZL,E				; 21 
				MOV		TMPL,A				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


TAB16:			LDI		ZH,0X08
				LDI		ZL,0X00
				LDI		BUF,0X45					; 0
				ST		Z+,BUF
				LDI		BUF,0X16					; 1
				ST		Z+,BUF
				LDI		BUF,0X1E					; 2
				ST		Z+,BUF
				LDI		BUF,0X26					; 3
				ST		Z+,BUF
				LDI		BUF,0X25					; 4
				ST		Z+,BUF
				LDI		BUF,0X2E					; 5
				ST		Z+,BUF
				LDI		BUF,0X36					; 6
				ST		Z+,BUF
				LDI		BUF,0X3D					; 7
				ST		Z+,BUF
				LDI		BUF,0X3E					; 8
				ST		Z+,BUF
				LDI		BUF,0X46					; 9
				ST		Z+,BUF
				LDI		BUF,0X1C					; A
				ST		Z+,BUF
				LDI		BUF,0X32					; B
				ST		Z+,BUF
				LDI		BUF,0X21					; C
				ST		Z+,BUF
				LDI		BUF,0X23					; D
				ST		Z+,BUF
				LDI		BUF,0X24					; E
				ST		Z+,BUF
				LDI		BUF,0X2B					; F
				ST		Z+,BUF
				RET

.ORG	0X0000+0X22*128						; SHLD			[ 22 ]	16	(126)	NONE
				
				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				MOVW	ZL,TMPL				; 60
				MOVW	TMPL,L				; 61
				DELAY2						; 63
				SBIS	PIND,MINT			; 64
				SEI							; 65
				DELAY1						; 66			
				CALL	ST_TMP_Z			; 70+29=99
				JMP		M1-T16+102			; 102
ST_TMP_Z:		CPI		ZH,0XF0				; 26			1
				BRCS	STTMPZ_NSYS			; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				CPI		ZH,0XF5				; 33			8
				BREQ	STTMPZF5			; 34 /> 35		9 /> 10
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				ST		Z+,TMPL				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				DELAY2						; 43			18
				OUT		PORTB,BUF			; 44			19
				XON							; 45			20
				ST		Z+,TMPH				; 48			23
				XOFF						; 49			24
				OUT		PORTB,CURRB			; 50			25
				RET							; 54			29
STTMPZ_NSYS:	CPI		ZH,0X11				; 29			4
				BRCC	STTMPZ_HR			; 30 /> 31		5 /> 6
				STS		XMCRB,ONE			; 32			7
				OR		ZH,CONST128			; 33			8
				DELAY1						; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				ST		Z+,TMPL				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				DELAY2						; 43			18
				OUT		PORTC,ZERO			; 44			19
				XON							; 45			20
				ST		Z+,TMPH				; 48			23
				XOFF						; 49			24
				OUT		PORTC,CURRC			; 50			25
				RET							; 54			29
STTMPZ_HR:		STS		XMCRB,ZERO			; 33			8
				DELAY2						; 35			10
				XON							; 36			11
				ST		Z+,TMPL				; 39			14
				XOFF						; 40			15
				DELAY2						; 42			17
				DELAY2						; 44			19
				XON							; 45			20
				ST		Z+,TMPH				; 48			23
				XOFF						; 49			24
				NOP							; 50			25
				RET							; 54			29
STTMPZF5:		OUT		RDAH,ZH				; 36			11
				OUT		RDAL,ZL				; 37			12
				DELAY3						; 40			15
				DELAY1						; 41			16
				RET							; 45			20








.ORG	0X0000+0X32*128						; STA			[ 32 ]	13	(108)	NONE
				
				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				MOVW	ZL,TMPL				; 60
				MOV		TMPL,A				; 61
				DELAY2						; 63
				SBIS	PIND,MINT			; 64
				SEI							; 65
				DELAY1						; 66 !!! TO NOT TUCH !!!
				DELAY1						; 67  
				CALL	ST_TMPL_Z			; 71+20=91. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T13+94			; 94













.ORG	0X0000+0X0A*128						; LDAX B		[ 0A ]	7	(54)	NONE 
				
				MOVW	ZL,C				; 21 
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		A,TMPL				; 49
				JMP		M1-T7+52			; 52
						
LD_TMPL_Z:		CPI		ZH,0XF0				; 26			1
				BRCS	LDTMPLZ_NSYS		; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				CPI		ZH,0XF5				; 33			8
				BREQ	LDTMPLF5			; 34 /> 35		9 /> 10
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				LD		TMPL,Z				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				CPI		ZH,0XF4				; 42			17
				BRNE	LDTMPLZNOTF4		; 43 /> 44		18 /> 19
				IN		TMPL,PORTA			; 44			19
				LDI		TMPL,0XFF			; **+1			
				
	
				
				IN		BUF,PORTA
				IN		BUFH,PORTC						; ROM31/RAM32
				STS		PORTF,ZERO						; ROM34/RAM35	2	GENERATE INTERRUPT
				LDI		TMPH,0XFF						; ROM35/RAM36	3
				OUT		PORTC,BUF							; ROM36/RAM37	4
				OUT		DDRC,TMPH						; ROM37/RAM38	5
				STS		DDRF,ZERO						; ROM39/RAM40	7
				LDI		TMPH,(1<<A15_CPU)|(1<<A14_CPU)	; ROM40/RAM41	8
				OUT		PORTC,CURRC						; ROM41/RAM43	9
				OUT		DDRC,TMPH						; ROM42/RAM42	10
				NOP										; 
				LDI		TMPH,1<<KEYMH					; ROM44/RAM45	12
				DELAY3									; ROM47/RAM48	15
				DELAY3									; ROM50/RAM51	18
				DELAY2									; ROM52/RAM53	20
				LDI		TMPL,0XFF						; ROM53/RAM54	21
				DELAY2
				IN		TMPL,PINF							; ROM1/RAM2		24
				SBR		TMPL,(1<<7)|(1<<6)|(1<<5)
				DELAY2
				DELAY1
				NOP
				STS		PORTF,TMPH						; ROM9/RAM10
				STS		DDRF,TMPH						; ROM11/RAM12


LDTMPLZNOTF4:	RET							; 48			23
LDTMPLZ_NSYS:	CPI		ZH,0X11				; 29			4
				BRCS	LDTMPLZ_LR			; 30 /> 31		5 /> 6
				STS		XMCRB,ZERO			; 32			7
				DELAY3						; 35			10
				XON							; 36			11
				LD		TMPL,Z				; 39			14
				XOFF						; 40			15
				DELAY2						; 42			17
				DELAY2						; 44			19
				RET							; 48			23
LDTMPLZ_LR:		STS		XMCRB,ONE			; 33			8
				OR		ZH,CONST128			; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				LD		TMPL,Z				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				EOR		ZH,CONST128			; 42			17
				DELAY2						; 44			19
				RET							; 48			23
LDTMPLF5:		IN		ZH,RDAH				; 36			11
				IN		ZL,RDAL				; 37			12
				ELPM	TMPL,Z				; 40			15
				DELAY3						; 43			18
				DELAY1						; 44			19
				RET							; 48			23





.ORG	0X0000+0X1A*128						; LDAX D		[ 1A ]	7	(54)	NONE 
				
				MOVW	ZL,E				; 21 
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		A,TMPL				; 49
				JMP		M1-T7+52			; 52


TRACE:			CLI
				SBIC	CONTROL,SNDE
				RJMP	TRACEN
				LDI		BUF,0XFE
				CPI		PCL,0X18
				CPC		PCH,BUF
				BREQ	TRACEN				; 
				RET

TRACEN:			SBI		CONTROL,SNDE
				MOVW	ZL,PCL				; 
				CALL	PRINT_WORD			; 
				MOVW	ZL,PCL				; 
				STS		XMCRB,ZERO			;
				XON							;
				LD		BUF,Z				;
				XOFF						; 
				CALL	PRINT_BYTE			; 
				
				
				MOVW	ZL,PCL				;
				ADIW	ZL,0X01				; 
				XON							;
				LD		BUF,Z				;
				XOFF						; 
				CALL	PRINT_BYTE			; 			
				
				MOVW	ZL,PCL				;
				ADIW	ZL,0X02				; 
				XON							;
				LD		BUF,Z				;
				XOFF						; 
				CALL	PRINT_BYTE			; 	
				
				MOVW	ZL,PCL				;
				ADIW	ZL,0X03				; 
				XON							;
				LD		BUF,Z				;
				XOFF						; 
				CALL	PRINT_BYTE			; 		
				
				
				
				MOVW	ZL,C				; 
				CALL	PRINT_WORD			; 
				MOVW	ZL,E				; 
				CALL	PRINT_WORD			; 
				MOVW	ZL,L				; 
				CALL	PRINT_WORD			; 
				MOVW	ZL,F				;

				CALL	PRINT_WORD			; 

TRACEEND:		LDI		BUF,0X4C			; ";"
				CALL	KEYSND8				;
				MOV		BUF,ROMID			; 
				CALL	PRINT_BYTE			; 
				LDI		BUF,0X5A			; ENTER
				CALL	KEYSND8				; 
				RET							; 


.ORG	0X0000+0X2A*128						; LHLD			[ 2A ]	16	(126)	NONE
				
				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				MOVW	ZL,TMPL				; 60	
				DELAY3						; 63
				SBIS	PIND,MINT			; 64
				SEI							; 65
				DELAY1						; 66
				CALL	LD_TMP_Z			; 70+29=99
				MOVW	L,TMPL				; 100
				JMP		M1-T16+103			; 103

LD_TMP_Z:		CPI		ZH,0XF0				; 26			1
				BRCS	LDTMPZ_NSYS			; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				CPI		ZH,0XF5				; 33			8
				BREQ	LDTMPZF5			; 34 /> 35		9 /> 10
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				LD		TMPL,Z+				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				DELAY2						; 43			18
				OUT		PORTB,BUF			; 44			19
				XON							; 45			20
				LD		TMPH,Z+				; 48			23
				XOFF						; 49			24
				OUT		PORTB,CURRB			; 50			25
				RET							; 54			29
LDTMPZ_NSYS:	CPI		ZH,0X11				; 29			4
				BRCC	LDTMPZ_HR			; 30 /> 31		5 /> 6
				STS		XMCRB,ONE			; 32			7
				OR		ZH,CONST128			; 33			8
				DELAY1						; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				LD		TMPL,Z+				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				DELAY2						; 43			18
				OUT		PORTC,ZERO			; 44			19
				XON							; 45			20
				LD		TMPH,Z+				; 48			23
				XOFF						; 49			24
				OUT		PORTC,CURRC			; 50			25
				RET							; 54			29
LDTMPZ_HR:		STS		XMCRB,ZERO			; 33			8
				DELAY2						; 35			10
				XON							; 36			11
				LD		TMPL,Z+				; 39			14
				XOFF						; 40			15
				DELAY2						; 42			17
				DELAY2						; 44			19
				XON							; 45			20
				LD		TMPH,Z+				; 48			23
				XOFF						; 49			24
				NOP							; 50			25
				RET							; 54			29

LDTMPZF5:		IN		ZH,RDAH				; 36			11
				IN		ZL,RDAL				; 37			12
				ELPM	TMPL,Z				; 40			15
				DELAY3						; 43			18
				DELAY3						; 46			21
				DELAY3						; 49			24
				DELAY1						; 50			25
				RET							; 54			29








.ORG	0X0000+0X3A*128						; LDA			[ 3A ]	13	(108)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				MOVW	ZL,TMPL				; 60
				DELAY3						; 63
				SBIS	PIND,MINT			; 64
				SEI							; 65
				DELAY1						; 66
				CALL	LD_TMPL_Z			; 70+23=93
				MOV		A,TMPL				; 94
				JMP		M1-T13+97			; 97


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X03*128						; INX B			[ 03 ]	5	(36)	NONE 
				
				ADD		C,ONE				; 21
				ADC		B,ZERO				; 22
				JMP		M1-T5+25			; 25


KEYSND8:		SBIC	PINE,KEYCLK					; TEST FOR HOST REQUEST
				RJMP	NORMOUT						; 
				SBI		PORTE,KEYCLK				; 1 SET
				SBI		DDRE,KEYCLK					; 1 KEYCLK
				CALL	DELAY_1						; 
				CALL	DELAY_1
				CBI		DDRE,KEYCLK					; 1 REALISE
				CBI		PORTE,KEYCLK				; 1 KEYCLK
				CALL	DELAY_1
				CALL	DELAY_1						; 
				RJMP	KEYSND8						; 
NORMOUT:		CBI		PORTE,KEYDATA				; 1 
				SBI		DDRE,KEYDATA				; 1 RESED DATA LINE
				SBI		PORTE,KEYCLK				; 2 SET
				SBI		DDRE,KEYCLK					; 2 CLK LINE
				CLR		TMPH						; CLEAR PARITET
				CALL	DELAY_1						; WAIT
				CBI		PORTE,KEYCLK				; RESET KEYCLK LINE
				CALL	DELAY_1						; WAIT
				SBI		PORTE,KEYCLK				; SET KEYCLK LINE
				CALL	DELAY_1						; WAIT
				RJMP	KEYSND81					; 	
KEYSND81:		
				MOV		TMPL,ONE					; 1 NUMBER OF BITS = 8
				LSL		TMPL						; 1 
				LSL		TMPL						; 1 
				LSL		TMPL						; 1 
LPSH8:			SBRS	BUF,0						; TEST FOR CURRENT BIT
				CBI		PORTE,KEYDATA				; RESET DATA LINE
				SBRC	BUF,0						; TEST FOR CURRENT BIT
				SBI		PORTE,KEYDATA				; SET DATA LINE
				SBRC	BUF,0						; TEST FOR PARITET
				INC		TMPH						; CORRECT PARITET
				CALL	DELAY_1						; WAIT
				CBI		PORTE,KEYCLK				; RESET KEYCLK LINE
				CALL	DELAY_1						; WAIT
				SBI		PORTE,KEYCLK				; SET KEYCLK LINE
				LSR		BUF							; PREPARE NEXT BIT
				DEC		TMPL						; COUNT BITS
				BRNE	LPSH8						; TEST FOR END OF BYTE
				INC		TMPH						; CORRECT PARITET
				SBRS	TMPH,0						; 3 
				CBI		PORTE,KEYDATA				; 3 
				SBRC	TMPH,0						; 3 PARITET
				SBI		PORTE,KEYDATA				; 3 BIT
				CALL	DELAY_1						; 3 
				CBI		PORTE,KEYCLK				; 3 
				CALL	DELAY_1						; 3 
				SBI		PORTE,KEYCLK				; 3 
				CALL	DELAY_1						; 3 
				SBI		PORTE,KEYDATA				; 4 
				CALL	DELAY_1						; 4 
				CBI		PORTE,KEYCLK				; 4 STOP BIT
				CALL	DELAY_1						; 4 SENDING
				SBI		PORTE,KEYCLK				; 4 
				CALL	DELAY_1						; 4
				LDI		BUF,0X80
				OUT		PORTE,BUF
				LDI		BUF,1<<RBBCP
				OUT		DDRE,BUF
				LDI		TMPH,0X36					; 5 
CALLD:			CALL	DELAY_1						; 5 DELAY BEFORE
				DEC		TMPH						; 5 RETURNING
				BRNE	CALLD						; 5 
				RET									; RETURN


.ORG	0X0000+0X13*128						; INX D			[ 13 ]	5	(36)	NONE
				
				ADD		E,ONE				; 21
				ADC		D,ZERO				; 22
				JMP		M1-T5+25			; 25


PRINT_WORD:		PUSH	ZL					; 
				PUSH	ZL					; 
				PUSH	ZH					; 
				PUSH	ZH					; 
				LDI		ZH,0X08				; 
				POP		ZL					; 
				ANDI	ZL,0XF0				; 
				SWAP	ZL					; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				POP		ZL					; 
				ANDI	ZL,0X0F				; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				POP		ZL					; 
				ANDI	ZL,0XF0				; 
				SWAP	ZL					; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				POP		ZL					; 
				ANDI	ZL,0X0F				; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				LDI		BUF,0X29			; 
				CALL	KEYSND8				; 
				RET							; 


PRINT_BYTE:		PUSH	BUF					; 
				LDI		ZH,0X08				; 
				MOV		ZL,BUF				; 
				ANDI	ZL,0XF0				; 
				SWAP	ZL					; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				POP		ZL					; 
				ANDI	ZL,0X0F				; 
				LD		BUF,Z				; 
				CALL	KEYSND8				; 
				LDI		BUF,0X29			; 
				CALL	KEYSND8				; 
				RET							; 

DELAY_1:		PUSH	BUF
				LDI		BUF,210					; DELAY FOR 20 kHz
LPDELAY1:		NOP
				NOP
				DEC		BUF
				BRNE	LPDELAY1
				POP		BUF
				RET


.ORG	0X0000+0X23*128						; INX H			[ 23 ]	5	(36)	NONE 
				
				ADD		L,ONE				; 21
				ADC		H,ZERO				; 22
				JMP		M1-T5+25			; 25

TIMETST:		IN		BUF,TCNT1L
				SUBI	BUF,0X08
				
LOOPTMTST:		SUBI	BUF,0X09
				BREQ	RETTIMETST
				BRCS	BREAKPT
				RJMP	LOOPTMTST
BREAKPT:		NOP
RETTIMETST:		MOVW	ZL,XL
				XON		
				LD		BUFH,Z+
				NOP
				LD		TMPL,Z+
				NOP
				LD		TMPH,Z+
				NOP
				LD		MEMPTRL,Z
				XOFF
				LDI		ZL,0X00
				LDI		ZH,0X09
				ST		Z+,BUFH
				ST		Z+,TMPL
				ST		Z+,TMPH
				ST		Z+,MEMPTRL
				OUT		TCNT1L,ZERO
				RET









.ORG	0X0000+0X33*128						; INX SP		[ 33 ]	5	(36)	NONE 
				
				ADD		STPL,ONE			; 21
				ADC		STPH,ZERO			; 22
				JMP		M1-T5+25			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X0B*128						; DCX B			[ 0B ]	5	(36)	NONE

				SUB		C,ONE				; 21
				SBC		B,ZERO				; 22
				JMP		M1-T5+25			; 25


.ORG	0X0000+0X1B*128						; DCX D			[ 1B ]	5	(36)	NONE

				SUB		E,ONE				; 21
				SBC		D,ZERO				; 22
				JMP		M1-T5+25			; 25


.ORG	0X0000+0X2B*128						; DCX H			[ 2B ]	5	(36)	NONE

				SUB		L,ONE				; 21
				SBC		H,ZERO				; 22
				JMP		M1-T5+25			; 25


.ORG	0X0000+0X3B*128						; DCX SP		[ 3B ]	5	(36)	NONE

				SUB		STPL,ONE			; 21
				SBC		STPH,ZERO			; 22
				JMP		M1-T5+25			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X04*128						; INR B			[ 04 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		B,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X0C*128						; INR C			[ 0C ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		C,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,C				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X14*128						; INR D			[ 14 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		D,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,D				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X1C*128						; INR E			[ 1C ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		E,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,E				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X24*128						; INR H			[ 24 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		H,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,H				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X2C*128						; INR L			[ 2C ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		L,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,L				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X3C*128						; INR A			[ 3C ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				ADD		A,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,A				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X34*128						; INR M			[ 34 ]	10	(90!81)	SZPA 
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				ADD		TMPL,ONE			; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 51
				BLD		F,CC				; 52
				MOV		RES,TMPL			; 51
				SBIS	PIND,MINT			; 55
				SEI							; 56
				DELAY1						; 57 !!! DO NOT TUCH !!! 
				DELAY1						; 59 
				CALL	ST_TMPL_Z			; 62+20=82. SYSTEM AREA EXCESS DELAYED BY 9.
				MOVW	ZL,RES				; 83
				LD		BUF,Z				; 85
				OR		F,BUF				; 86
				JMP		M1-90+89			; 89


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X05*128						; DCR B			[ 05 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		B,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X0D*128						; DCR C			[ 0D ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		C,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X15*128						; DCR D			[ 15 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		D,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X1D*128						; DCR E			[ 1D ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		E,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X25*128						; DCR H			[ 25 ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		H,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X2D*128						; DCR L			[ 2D ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		L,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X3D*128						; DCR A			[ 3D ]	5	(36)	SZPA 
				                            ;
				BST		F,CC				; 21
				SUB		A,ONE				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 24
				BLD		F,CC				; 25
				MOV		RES,B				; 26
				MOVW	ZL,RES				; 27
				LD		BUF,Z				; 29
				OR		F,BUF				; 30
				JMP		M1-T5+33			; 33


.ORG	0X0000+0X35*128						; DCR M			[ 35 ]	10	(90!81)	SZPA 
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				SUB		TMPL,ONE			; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC); 51
				BLD		F,CC				; 52
				MOV		RES,TMPL			; 51
				SBIS	PIND,MINT			; 55
				SEI							; 56
				DELAY1						; 57 !!! DO NOT TUCH !!!
				DELAY1						; 58  
				CALL	ST_TMPL_Z			; 62+20=82. SYSTEM AREA EXCESS DELAYED BY 9.
				MOVW	ZL,RES				; 83
				LD		BUF,Z				; 85
				OR		F,BUF				; 86
				JMP		M1-90+89			; 89


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X06*128						; MVI B,#			[ 06 ]	7	(54)	NONE

				LDI		ZL,REGBADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51

LD_DST8_PC:		CPI		XH,0XF0				; 26			1
				BRCS	LDDST8PC_NSYS		; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				DELAY2						; 34			9
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				CLR		ZH					; 42			17
				ST		Z,TMPL				; 44			19
				RET							; 48			23
LDDST8PC_NSYS:	CPI		XH,0X11				; 29			4
				BRCC	LDDST8PC_HR			; 30 /> 31		5 /> 6
				STS		XMCRB,ONE			; 32			7
				OR		XH,CONST128			; 33			8
				LDI		ZH,0X00				; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				EOR		XH,CONST128			; 42			17
				ST		Z,TMPL				; 44			19
				RET							; 48			23
LDDST8PC_HR:	STS		XMCRB,ZERO			; 33			8
				DELAY2						; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				LDI		ZH,0X00				; 41			16
				ST		Z,TMPL				; 43			18
				DELAY1						; 44			19
				RET							; 48			23
				


.ORG	0X0000+0X0E*128						; MVI C,#			[ 0E ]	7	(54)	NONE

				LDI		ZL,REGCADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X16*128						; MVI D,#			[ 16 ]	7	(54)	NONE

				LDI		ZL,REGDADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X1E*128						; MVI E,#			[ 1E ]	7	(54)	NONE

				LDI		ZL,REGEADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X26*128						; MVI H,#			[ 26 ]	7	(54)	NONE

				LDI		ZL,REGHADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X2E*128						; MVI L,#			[ 2E ]	7	(54)	NONE

				LDI		ZL,REGLADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X3E*128						; MVI A,#			[ 3E ]	7	(54)	NONE

				LDI		ZL,REGAADDR			; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				JMP		M1-T7+51			; 51


.ORG	0X0000+0X36*128						; MVI M,#			[ 36 ]	10	(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				MOVW	ZL,L				; 49
				CALL	ST_TMPL_Z			; 53+20=73. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T10+76			; 76


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X07*128						; RLC				[ 07 ]	4	(36)	C
											; 
				BST		A,7					; 21
				BLD		F,CC				; 22
				LSL		A					; 23
				BLD		A,0					; 24
				JMP		M1-27+27			; 27
				

.ORG	0X0000+0X0F*128						; RRC				[ 0F ]	4	(36)	C
											; 
				BST		A,0					; 21
				BLD		F,CC				; 22
				LSR		A					; 23
				BLD		A,7					; 24
				JMP		M1-27+27			; 27


.ORG	0X0000+0X17*128						; RAL				[ 17 ]	4	(36)	C
											; 
				BST		A,7					; 21
				OUT		SREG,F				; 22
				ROL		A					; 23
				BLD		F,CC				; 24
				JMP		M1-27+27			; 27
				
				
.ORG	0X0000+0X1F*128						; RAR				[ 1F ]	4	(36)	C
											; 
				BST		A,0					; 21
				OUT		SREG,F				; 22
				ROR		A					; 23
				BLD		F,CC				; 24
				JMP		M1-27+27			; 27


.ORG	0X0000+0X27*128						; DAA				[ 27 ]	4	(36)	SZPCA

				OUT		EEARL,A 			; 21
				BST		F,AC	 			; 22
				BLD		F,ZZ	 			; 23
				CBR		F,0B11111000		; 24
				OUT		EEARH,F				; 25
				DELAY1;OUT		EECR,ONE			; 26 BRINGS FRAME ERROR !!!
				IN		A,EEDR				; 27
				SBI		EEARH,3				; 29
				DELAY1;OUT		EECR,ONE			; 30 BRINGS FRAME ERROR !!!
				IN		F,EEDR				; 31
				MOV		RES,A				; 32
				JMP		M1-T4+35			; 35


.ORG	0X0000+0X2F*128						; CMA				[ 2F ]	4	(36)	NONE
											; 
				COM		A					; 21
				JMP		M1-T4+24			; 24


.ORG	0X0000+0X37*128						; STC				[ 37 ]	4	(36)	C
											; 										1
				SBR		F,1<<CC				; 21
				JMP		M1-T4+24			; 24


.ORG	0X0000+0X3F*128						; CMC				[ 3F ]	4	(36)	C
											; 										~
				EOR		F,ONE				; 21
				JMP		M1-T4+24			; 24


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X08*128						; NOP				[ 08 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


.ORG	0X0000+0X18*128						; NOP				[ 18 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


.ORG	0X0000+0X28*128						; NOP				[ 28 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


.ORG	0X0000+0X38*128						; NOP				[ 38 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23

.ORG	0X0000+0X10*128						; NOP				[ 10 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


.ORG	0X0000+0X20*128						; NOP				[ 20 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


.ORG	0X0000+0X30*128						; NOP				[ 30 ]	4	(36)	NONE
											; 
				JMP		M1-T4+23			; 23


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X09*128						; DAD B				[ 09 ]	10	(81)	C 
                                            ; 
				ADD		L,C					; 21
				ADC		H,B					; 22
				IN		BUF,SREG			; 23
				BST		BUF,CC				; 24
				BLD		F,CC				; 25
				JMP		M1-T10+28			; 28


.ORG	0X0000+0X19*128						; DAD B				[ 19 ]	10	(81)	C 
                                            ; 
				ADD		L,E					; 21
				ADC		H,D					; 22
				IN		BUF,SREG			; 23
				BST		BUF,CC				; 24
				BLD		F,CC				; 25
				JMP		M1-T10+28			; 28


.ORG	0X0000+0X29*128						; DAD D				[ 29 ]	10	(81)	C 
                                            ; 
				ADD		L,L					; 21
				ADC		H,H					; 22
				IN		BUF,SREG			; 23
				BST		BUF,CC				; 24
				BLD		F,CC				; 25
				JMP		M1-T10+28			; 28


.ORG	0X0000+0X39*128						; DAD H				[ 39 ]	10	(81)	C 
                                            ; 
				ADD		L,STPL				; 21
				ADC		H,STPH				; 22
				IN		BUF,SREG			; 23
				BST		BUF,CC				; 24
				BLD		F,CC				; 25
				JMP		M1-T10+28			; 28


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X40*128						; MOV	B,B			[ 40 ]	5	(36)	NONE
											; 
				MOV		B,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X41*128						; MOV	B,C			[ 41 ]	5	(36)	NONE
											; 
				MOV		B,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X42*128						; MOV	B,D			[ 42 ]	5	(36)	NONE
											; 
				MOV		B,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X43*128						; MOV	B,E			[ 43 ]	5	(36)	NONE
											; 
				MOV		B,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X44*128						; MOV	B,H			[ 44 ]	5	(36)	NONE
											; 
				MOV		B,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X45*128						; MOV	B,L			[ 45 ]	5	(36)	NONE
											; 
				MOV		B,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X47*128						; MOV	B,A			[ 47 ]	5	(36)	NONE
											; 
				MOV		B,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X48*128						; MOV	C,B			[ 48 ]	5	(36)	NONE
											; 
				MOV		C,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X49*128						; MOV	C,C			[ 49 ]	5	(36)	NONE
											; 
				MOV		C,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X4A*128						; MOV	C,D			[ 4A ]	5	(36)	NONE
											; 
				MOV		C,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X4B*128						; MOV	C,E			[ 4B ]	5	(36)	NONE
											; 
				MOV		C,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X4C*128						; MOV	C,H			[ 4C ]	5	(36)	NONE
											; 
				MOV		C,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X4D*128						; MOV	C,L			[ 4D ]	5	(36)	NONE
											; 
				MOV		C,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X4F*128						; MOV	C,A			[ 4F ]	5	(36)	NONE
											; 
				MOV		C,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X50*128						; MOV	D,B			[ 50 ]	5	(36)	NONE
											; 
				MOV		D,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X51*128						; MOV	D,C			[ 51 ]	5	(36)	NONE
											; 
				MOV		D,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X52*128						; MOV	D,D			[ 52 ]	5	(36)	NONE
											; 
				MOV		D,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X53*128						; MOV	D,E			[ 53 ]	5	(36)	NONE
											; 
				MOV		D,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X54*128						; MOV	D,H			[ 54 ]	5	(36)	NONE
											; 
				MOV		D,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X55*128						; MOV	D,L			[ 55 ]	5	(36)	NONE
											; 
				MOV		D,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X57*128						; MOV	D,A			[ 57 ]	5	(36)	NONE
											; 
				MOV		D,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X58*128						; MOV	E,B			[ 58 ]	5	(36)	NONE
											; 
				MOV		E,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X59*128						; MOV	E,C			[ 59 ]	5	(36)	NONE
											; 
				MOV		E,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X5A*128						; MOV	E,D			[ 5A ]	5	(36)	NONE
											; 
				MOV		E,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X5B*128						; MOV	E,E			[ 5B ]	5	(36)	NONE
											; 
				MOV		E,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X5C*128						; MOV	E,H			[ 5C ]	5	(36)	NONE
											; 
				MOV		E,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X5D*128						; MOV	E,L			[ 5D ]	5	(36)	NONE
											; 
				MOV		E,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X5F*128						; MOV	E,A			[ 5F ]	5	(36)	NONE
											; 
				MOV		E,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X60*128						; MOV	H,B			[ 60 ]	5	(36)	NONE
											; 
				MOV		H,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X61*128						; MOV	H,C			[ 61 ]	5	(36)	NONE
											; 
				MOV		H,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X62*128						; MOV	H,D			[ 62 ]	5	(36)	NONE
											; 
				MOV		H,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X63*128						; MOV	H,E			[ 63 ]	5	(36)	NONE
											; 
				MOV		H,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X64*128						; MOV	H,H			[ 64 ]	5	(36)	NONE
											; 
				MOV		H,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X65*128						; MOV	H,L			[ 65 ]	5	(36)	NONE
											; 
				MOV		H,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X67*128						; MOV	H,A			[ 67 ]	5	(36)	NONE
											; 
				MOV		H,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X68*128						; MOV	L,B			[ 68 ]	5	(36)	NONE
											; 
				MOV		L,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X69*128						; MOV	L,C			[ 69 ]	5	(36)	NONE
											; 
				MOV		L,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X6A*128						; MOV	L,D			[ 6A ]	5	(36)	NONE
											; 
				MOV		L,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X6B*128						; MOV	L,E			[ 6B ]	5	(36)	NONE
											; 
				MOV		L,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X6C*128						; MOV	L,H			[ 6C ]	5	(36)	NONE
											; 
				MOV		L,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X6D*128						; MOV	L,L			[ 6D ]	5	(36)	NONE
											; 
				MOV		L,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X6F*128						; MOV	L,A			[ 6F ]	5	(36)	NONE
											; 
				MOV		L,A					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X78*128						; MOV	A,B			[ 78 ]	5	(36)	NONE
											; 
				MOV		A,B					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X79*128						; MOV	A,C			[ 79 ]	5	(36)	NONE
											; 
				MOV		A,C					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X7A*128						; MOV	A,D			[ 7A ]	5	(36)	NONE
											; 
				MOV		A,D					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X7B*128						; MOV	A,E			[ 7B ]	5	(36)	NONE
											; 
				MOV		A,E					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X7C*128						; MOV	A,H			[ 7C ]	5	(36)	NONE
											; 
				MOV		A,H					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X7D*128						; MOV	A,L			[ 7D ]	5	(36)	NONE
											; 
				MOV		A,L					; 21
				JMP		M1-T4+24			; 24

.ORG	0X0000+0X7F*128						; MOV	A,A			[ 7F ]	5	(36)	NONE
											; 
				MOV		A,A					; 21
				JMP		M1-T4+24			; 24


.ORG	0X0000+0X46*128						; MOV	B,M			[ 46 ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		B,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X4E*128						; MOV	C,M			[ 4E ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		C,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X56*128						; MOV	D,M			[ 56 ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		D,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X5E*128						; MOV	E,M			[ 5E ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		E,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X66*128						; MOV	H,M			[ 66 ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		H,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X6E*128						; MOV	L,M			[ 6E ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		L,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X7E*128						; MOV	A,M			[ 7E ]	7	(54)	NONE
											; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		A,TMPL				; 49
				JMP		M1-T7+52			; 52


.ORG	0X0000+0X70*128						; MOV	M,B			[ 70 ]	7	(54)	NONE
											; 
				MOV		TMPL,B				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X71*128						; MOV	M,C			[ 71 ]	7	(54)	NONE
											; 
				MOV		TMPL,C				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X72*128						; MOV	M,D			[ 72 ]	7	(54)	NONE
											; 
				MOV		TMPL,D				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X73*128						; MOV	M,E			[ 73 ]	7	(54)	NONE
											; 
				MOV		TMPL,E				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X74*128						; MOV	M,H			[ 74 ]	7	(54)	NONE
											; 
				MOV		TMPL,H				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X75*128						; MOV	M,L			[ 75 ]	7	(54)	NONE
											; 
				MOV		TMPL,L				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


.ORG	0X0000+0X77*128						; MOV	M,A			[ 77 ]	7	(54)	NONE
											; 
				MOV		TMPL,A				; 21
				MOVW	ZL,L				; 22
				CALL	ST_TMPL_Z			; 26+20=46. SYSTEM AREA EXCESS DELAYED BY 9.
				JMP		M1-T7+49			; 49


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X76*128						; HLT				[ 76 ]	7	(54)	NONE

HLTLOOP:		SBIS	PIND,MINT			; 
				RJMP	EXIT_HLT			; 
				RJMP	HLTLOOP				; 
EXIT_HLT:		SEI							; 2
				CPI		PCH,0X11			; 3
				BRCC	HRAMRD76			; 4 /> 5
				M1L_LR[16]					; 20
HRAMRD76:		M1L_HR[15]					; 20


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X80*128						; ADD B				[ 80 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X81*128						; ADD C				[ 81 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X82*128						; ADD D				[ 82 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X83*128						; ADD E				[ 83 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X84*128						; ADD H				[ 84 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X85*128						; ADD L				[ 85 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X87*128						; ADD A				[ 87 ]	4	(36)	SZPCA
				                            ; 
				ADD		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X86*128						; ADD M				[ 87 ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				ADD		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X88*128						; ADC B				[ 88 ]	4	(36)	SZPCA
				                            ; 
				ADC		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X89*128						; ADC C				[ 89 ]	4	(36)	SZPCA
				                            ; 
				ADC		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8A*128						; ADC D				[ 8A ]	4	(36)	SZPCA
				                            ; 
				ADC		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8B*128						; ADC E				[ 8B ]	4	(36)	SZPCA
				                            ; 
				ADC		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8C*128						; ADC H				[ 8C ]	4	(36)	SZPCA
				                            ; 
				ADC		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8D*128						; ADC L				[ 8D ]	4	(36)	SZPCA
				                            ; 
				ADC		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8F*128						; ADC A				[ 8F ]	4	(36)	SZPCA
				                            ; 
				ADC		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X8E*128						; ADC M				[ 8E ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				ADC		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X90*128						; SUB B				[ 90 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X91*128						; SUB C				[ 91 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X92*128						; SUB D				[ 92 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X93*128						; SUB E				[ 93 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X94*128						; SUB H				[ 94 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X95*128						; SUB L				[ 95 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X97*128						; SUB A				[ 97 ]	4	(36)	SZPCA
				                            ; 
				SUB		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X96*128						; SUB M				[ 96 ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				SUB		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X98*128						; SBB B				[ 98 ]	4	(36)	SZPCA
				                            ; 
				SBC		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X99*128						; SBB C				[ 99 ]	4	(36)	SZPCA
				                            ; 
				SBC		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9A*128						; SBB D				[ 9A ]	4	(36)	SZPCA
				                            ; 
				SBC		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9B*128						; SBB E				[ 9B ]	4	(36)	SZPCA
				                            ; 
				SBC		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9C*128						; SBB H				[ 9C ]	4	(36)	SZPCA
				                            ; 
				SBC		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9D*128						; SBB L				[ 9D ]	4	(36)	SZPCA
				                            ; 
				SBC		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9F*128						; SBB A				[ 9F ]	4	(36)	SZPCA
				                            ; 
				SBC		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0X9E*128						; SBB M				[ 9E ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				SBC		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XA0*128						; ANA B				[ A0 ]	4	(36)	SZPCA
				                            ; 
				AND		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA1*128						; ANA C				[ A1 ]	4	(36)	SZPCA
				                            ; 
				AND		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA2*128						; ANA D				[ A2 ]	4	(36)	SZPCA
				                            ; 
				AND		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA3*128						; ANA E				[ A3 ]	4	(36)	SZPCA
				                            ; 
				AND		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA4*128						; ANA H				[ A4 ]	4	(36)	SZPCA
				                            ; 
				AND		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA5*128						; ANA L				[ A5 ]	4	(36)	SZPCA
				                            ; 
				AND		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA7*128						; ANA A				[ A7 ]	4	(36)	SZPCA
				                            ; 
				AND		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA6*128						; ANA M				[ A6 ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				AND		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XA8*128						; XRA B				[ A8 ]	4	(36)	SZPCA
				                            ; 
				EOR		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XA9*128						; XRA C				[ A9 ]	4	(36)	SZPCA
				                            ; 
				EOR		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAA*128						; XRA D				[ AA ]	4	(36)	SZPCA
				                            ; 
				EOR		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAB*128						; XRA E				[ AB ]	4	(36)	SZPCA
				                            ; 
				EOR		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAC*128						; XRA H				[ AC ]	4	(36)	SZPCA
				                            ; 
				EOR		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAD*128						; XRA L				[ AD ]	4	(36)	SZPCA
				                            ; 
				EOR		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAF*128						; XRA A				[ AF ]	4	(36)	SZPCA
				                            ; 
				EOR		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XAE*128						; XRA M				[ AE ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				EOR		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XB0*128						; ORA B				[ B0 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,B					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB1*128						; ORA C				[ B1 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,C					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB2*128						; ORA D				[ B2 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,D					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB3*128						; ORA E				[ B3 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,E					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB4*128						; ORA H				[ B4 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,H					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB5*128						; ORA L				[ B5 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,L					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB7*128						; ORA A				[ B7 ]	4	(36)	SZPCA
				                            ; 										   00
				OR		A,A					; 21
				IN		F,SREG				; 22
				ANDI	F,(1<<SS)|(1<<ZZ)	; 23
				MOV		RES,A				; 24
				MOVW	ZL,RES				; 25
				LD		BUF,Z				; 27
				OR		F,BUF				; 28
				JMP		M1-T4+31			; 31


.ORG	0X0000+0XB6*128						; ORA M				[ B6 ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				OR		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)	; 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XB8*128						; CMP B				[ B8 ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,B				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XB9*128						; CMP C				[ B9 ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,C				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBA*128						; CMP D				[ BA ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,D				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBB*128						; CMP E				[ BB ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,E				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBC*128						; CMP H				[ BC ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,H				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBD*128						; CMP L				[ BD ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,L				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBF*128						; CMP A				[ BF ]	4	(36)	SZPCA
				                            ; 
				MOV		BUF,A				; 21
				SUB		BUF,A				; 22
				IN		F,SREG				; 23
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 24
				MOV		RES,A				; 25
				MOVW	ZL,RES				; 26
				LD		BUF,Z				; 28
				OR		F,BUF				; 29
				JMP		M1-T4+32			; 32


.ORG	0X0000+0XBE*128						; CMP M				[ BE ]	7	(63!54)	SZPCA
				                            ; 
				MOVW	ZL,L				; 21
				CALL	LD_TMPL_Z			; 25+23=48
				MOV		BUF,A				; 49
				SUB		BUF,TMPL			; 50
				IN		F,SREG				; 51
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<CC)|(1<<AC); 52
				MOV		RES,A				; 53
				MOVW	ZL,RES				; 54
				LD		BUF,Z				; 56
				OR		F,BUF				; 57
				JMP		M1-63+60			; 60


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC0*128						; RNZ 				[ C0 ]	11/5	(90/36)	NONE
				
				SBRC	F,ZZ				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26

COMRET:			MOVW	ZL,YL				; 27
				ADIW	YL,0X02				; 29
				DELAY1						; 30
				CALL	LD_TMP_Z			; 34+29=63
				MOVW	PCL,TMPL			; 64
				JMP		M1-T11+67			; 67


.ORG	0X0000+0XC8*128						; RZ 				[ C8 ]	11/5	(90/36)	NONE
				
				SBRS	F,ZZ				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XD0*128						; RNC 				[ D0 ]	11/5	(90/36)	NONE
				
				SBRC	F,CC				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XD8*128						; RC 				[ D8 ]	11/5	(90/36)	NONE
				
				SBRS	F,CC				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XE0*128						; RPO 				[ E0 ]	11/5	(90/36)	NONE
				
				SBRC	F,PP				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XE8*128						; RPE 				[ E8 ]	11/5	(90/36)	NONE
				
				SBRS	F,PP				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XF0*128						; RP 				[ F0 ]	11/5	(90/36)	NONE
				
				SBRC	RES,SS				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


.ORG	0X0000+0XF8*128						; RM 				[ F8 ]	11/5	(90/36)	NONE
				
				SBRS	RES,SS				; 21 /> 23
				JMP		M1-T5+24			; 24
				JMP		COMRET				; 26


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC1*128						; POP B				[ C1 ]	10		(81)	NONE

				MOVW	ZL,YL				; 21
				CALL	LD_TMP_Z			; 25+29=54
				MOVW	C,TMPL				; 55
				ADIW	STPL,0X02			; 57
				JMP		M1-T10+60			; 60


.ORG	0X0000+0XD1*128						; POP D				[ D1 ]	10		(81)	NONE

				MOVW	ZL,YL				; 21
				CALL	LD_TMP_Z			; 25+29=54
				MOVW	E,TMPL				; 55
				ADIW	STPL,0X02			; 57
				JMP		M1-T10+60			; 60


.ORG	0X0000+0XE1*128						; POP H				[ E1 ]	10		(81)	NONE

				MOVW	ZL,YL				; 21
				CALL	LD_TMP_Z			; 25+29=54
				MOVW	L,TMPL				; 55
				ADIW	STPL,0X02			; 57
				JMP		M1-T10+60			; 60


.ORG	0X0000+0XF1*128						; POP PSW			[ F1 ]	10		(81)	NONE

				MOVW	ZL,YL				; 21
				CALL	LD_TMP_Z			; 25+29=54
				MOVW	F,TMPL				; 55
				ADIW	STPL,0X02			; 57
				LDI		F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<PP)|(1<<CC); 58
				JMP		M1-T10+61			; 61


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC2*128						; JNZ				[ C2 ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRS	F,ZZ				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XCA*128						; JZ				[ CA ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRC	F,ZZ				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XD2*128						; JNC				[ D2 ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRS	F,CC				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XDA*128						; JC				[ DA ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRC	F,CC				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XE2*128						; JPO				[ E2 ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRS	F,PP				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XEA*128						; JPE				[ EA ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRC	F,PP				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XF2*128						; JP				[ F2 ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRS	RES,SS				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


.ORG	0X0000+0XFA*128						; JM				[ FA ]	10		(81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				SBRC	RES,SS				; 60 /> 61
				MOVW	PCL,TMPL			; 61
				JMP		M1-T10+64			; 64


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC3*128						; JMP			[ C3 ]	10	(81)	NONE

				LDI		ZL,REGPCLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				JMP		M1-T10+62			; 62
LD_DST16_PC:	CPI		XH,0XF0				; 26			1
				BRCS	LDDSTPC_NSYS		; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				DELAY2						; 34			9
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				CLR		ZH					; 42			17
				DELAY1						; 43			18
				OUT		PORTB,BUF			; 44			19
				XON							; 45			20
				LD		TMPH,X+				; 48			23
				XOFF						; 49			24
				OUT		PORTB,CURRB			; 50			25
				ST		Z+,TMPL				; 52			27
				ST		Z+,TMPH				; 54			29
				DELAY1						; 55			30
				RET							; 59			34
LDDSTPC_NSYS:	CPI		XH,0X11				; 29			4
				BRCC	LDDSTPC_HR			; 30 /> 31		5 /> 6
				STS		XMCRB,ONE			; 32			7
				OR		XH,CONST128			; 33			8
				DELAY1						; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				LDI		ZH,0X00				; 42			17
				DELAY1						; 43			18
				OUT		PORTC,ZERO			; 44			19
				XON							; 45			20
				LD		TMPH,X+				; 48			23
				XOFF						; 49			24
				OUT		PORTC,CURRC			; 50			25
				EOR		XH,CONST128			; 51			26
				ST		Z+,TMPL				; 53			28
				ST		Z+,TMPH				; 55			30
				RET							; 59			34
LDDSTPC_HR:		STS		XMCRB,ZERO			; 33			8
				DELAY2						; 35			10
				XON							; 36			11
				LD		TMPL,X+				; 39			14
				XOFF						; 40			15
				LDI		ZH,0X00				; 41			16
				ST		Z+,TMPL				; 43			18
				DELAY1						; 44			19
				XON							; 45			20
				LD		TMPH,X+				; 48			23
				XOFF						; 49			24
				ST		Z+,TMPH				; 51			26
				DELAY2						; 53			28
				DELAY2						; 55			30
				RET							; 59			34


.ORG	0X0000+0XD3*128						; OUT N			[ D3 ]	10	(90!81)	NONE

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				MOV		ZH,TMPL				; 49
				LDI		ZL,0X00				; 50
				MOV		TMPL,A				; 51
				DELAY3						; 54
				SBIS	PIND,MINT			; 55
				SEI							; 56
				DELAY1						; 57 !!! DO NOT TUCH !!!
				DELAY1						; 58
				CALL	ST_TMPL_Z			; 62+20=82
				JMP		M1-90+85			; 85


.ORG	0X0000+0XE3*128						; XTHL			[ E3 ]	18	(144)	NONE

				MOVW	ZL,YL				; 21
				CALL	LD_TMP_Z			; 25+29=54
				SBIS	PIND,MINT			; 55
				SEI							; 56
				MOVW	MEMPTRL,TMPL		; 57
				DELAY2						; 59
				DELAY3						; 62
				MOVW	ZL,YL				; 63
				SBIW	ZL,0X02				; 65
				MOVW	TMPL,L				; 66
				CALL	ST_TMP_Z			; 70+29=99
				SBIS	PIND,MINT			; 100
				SEI							; 101
				DELAY1						; 102 !!! DO NOT TUCH !!!	
				MOVW	L,MEMPTRL			; 103
				JMP		M1-T18+106			; 106


.ORG	0X0000+0XF3*128						; DI 			[ F3 ]	4	(36)	NONE

				CLT							; 21
				BLD		CURRB,BEEP			; 22
				OUT		PORTB,CURRB			; 23
				JMP		M1-T4+26			; 26


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC4*128						; CNZ 			[ C4 ]	11/17(90/135)NONE

				SBRS	F,ZZ				; 21 /> 22
				RJMP	EXCNZ				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCNZ:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117

ST_TMP_Y:		CPI		YH,0XF0				; 26			1
				BRCS	STTMPY_NSYS			; 27 /> 28		2 /> 3
				STS		XMCRB,ZERO			; 29			4
				MOV		BUF,CURRB			; 30			5
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16);31		6
				SBR		BUF,(1<<MUXA15)|(1<<MUXA14);32		7
				DELAY2						; 34			9
				OUT		PORTB,BUF			; 35			10
				XON							; 36			11
				ST		-Y,TMPH				; 39			14
				XOFF						; 40			15
				OUT		PORTB,CURRB			; 41			16
				DELAY2						; 43			18
				OUT		PORTB,BUF			; 44			19
				XON							; 45			20
				ST		-Y,TMPL				; 48			23
				XOFF						; 49			24
				OUT		PORTB,CURRB			; 50			25
				DELAY1						; 51			26
				RET							; 55			30
STTMPY_NSYS:	CPI		YH,0X11				; 29			4
				BRCC	STTMPY_HR			; 30 /> 31		5 /> 6
				STS		XMCRB,ONE			; 32			7
				OR		YH,CONST128			; 33			8
				DELAY1						; 34			9
				OUT		PORTC,ZERO			; 35			10
				XON							; 36			11
				ST		-Y,TMPH				; 39			14
				XOFF						; 40			15
				OUT		PORTC,CURRC			; 41			16
				DELAY2						; 43			18
				OUT		PORTC,ZERO			; 44			19
				XON							; 45			20
				ST		-Y,TMPL				; 48			23
				XOFF						; 49			24
				OUT		PORTC,CURRC			; 50			25
				EOR		YH,CONST128			; 51			26
				RET							; 55			30
STTMPY_HR:		STS		XMCRB,ZERO			; 33			8
				DELAY2						; 35			10
				XON							; 36			11
				ST		-Y,TMPH				; 39			14
				XOFF						; 40			15
				DELAY2						; 42			17
				DELAY2						; 44			19
				XON							; 45			20
				ST		-Y,TMPL				; 48			23
				XOFF						; 49			24
				DELAY2						; 51			26
				RET							; 55			30


.ORG	0X0000+0XCC*128						; CZ 			[ CC ]	11/17(90/135)NONE

				SBRC	F,ZZ				; 21 /> 22
				RJMP	EXCZ				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCZ:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XD4*128						; CNC 			[ D4 ]	11/17(90/135)NONE

				SBRS	F,CC				; 21 /> 22
				RJMP	EXCNC				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCNC:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XDC*128						; CC 			[ DC ]	11/17(90/135)NONE

				SBRC	F,CC				; 21 /> 22
				RJMP	EXCC				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCC:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XE4*128						; CPO 			[ E4 ]	11/17(90/135)NONE

				SBRS	F,PP				; 21 /> 22
				RJMP	EXCPO				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCPO:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XEC*128						; CPE 			[ EC ]	11/17(90/135)NONE

				SBRC	F,PP				; 21 /> 22
				RJMP	EXCPE				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCPE:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XF4*128						; CP 			[ F4 ]	11/17(90/135)NONE

				SBRS	RES,SS				; 21 /> 22
				RJMP	EXCP				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCP:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


.ORG	0X0000+0XFC*128						; CM 			[ FC ]	11/17(90/135)NONE

				SBRC	RES,SS				; 21 /> 22
				RJMP	EXCM				; 23
				ADIW	PCL,0X02			; 24
				JMP		M1-T11+27			; 27
EXCM:			MOVW	TMPL,PCL			; 24
				ADIW	TMPL,0X02			; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	ST_TMP_Y			; 34+30=64
				DELAY3						; 67
				DELAY3						; 70
				DELAY2						; 72
				SBIS	PIND,MINT			; 73
				SEI							; 74
				LDI		ZL,REGTMPLADDR		; 75 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 79+34=113
				MOVW	PCL,TMPL			; 114
				JMP		M1-T17+117			; 117


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC5*128						; PUSH B			[ C5 ]	11	(90)	NONE

				MOVW	TMPL,C				; 21
				CALL	ST_TMP_Y			; 25+30=55
				JMP		M1-T11+58			; 58


.ORG	0X0000+0XD5*128						; PUSH D			[ D5 ]	11	(90)	NONE

				MOVW	TMPL,E				; 21
				CALL	ST_TMP_Y			; 25+30=55
				JMP		M1-T11+58			; 58


.ORG	0X0000+0XE5*128						; PUSH H			[ E5 ]	11	(90)	NONE

				MOVW	TMPL,L				; 21
				CALL	ST_TMP_Y			; 25+30=55
				JMP		M1-T11+58			; 58


.ORG	0X0000+0XF5*128						; PUSH PSW			[ F5 ]	11	(90)	NONE

				MOV		TMPH,A				; 21
				LDI		TMPL,1<<1			; 22
				BST		RES,SS				; 23
				BLD		TMPL,7				; 24
				BST		F,ZZ				; 25
				BLD		TMPL,6				; 26
				BST		F,AC				; 27
				BLD		TMPL,4				; 28
				BST		F,PP				; 29
				BLD		TMPL,2				; 30
				BST		F,CC				; 31
				BLD		TMPL,0				; 32
				DELAY3						; 35
				DELAY3						; 38
				DELAY1						; 39
				CALL	ST_TMP_Y			; 43+30=73
				JMP		M1-T11+76			; 76


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC6*128						; ADI #				[ C6 ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				ADD		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XD6*128						; SUI #				[ D6 ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				SUB		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XE6*128						; ANI #				[ E6 ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				AND		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XF6*128						; ORI #				[ F6 ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				OR		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XCE*128						; ACI #				[ CE ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				ADC		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XDE*128						; SBI #				[ DE ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				SBC		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XEE*128						; XRI #				[ EE ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				EOR		A,TMPL				; 49
				IN		F,SREG				; 50
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 51
				MOV		RES,A				; 52
				MOVW	ZL,RES				; 53
				LD		BUF,Z				; 55
				OR		F,BUF				; 56
				JMP		M1-63+59			; 59


.ORG	0X0000+0XFE*128						; CPI #				[ FE ]	7	(63!54)	SZPCA

				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				MOV		BUF,A				; 49
				SUB		BUF,TMPL			; 50
				IN		F,SREG				; 51
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<AC)|(1<<CC); 52
				MOV		RES,A				; 53
				MOVW	ZL,RES				; 54
				LD		BUF,Z				; 56
				OR		F,BUF				; 57
				JMP		M1-63+60			; 60


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC7*128						; RST 0				[ C7 ]	11	(90)	NONE

				LDI		PCL,0X00			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XCF*128						; RST 1				[ CF ]	11	(90)	NONE

				LDI		PCL,0X08			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XD7*128						; RST 0				[ D7 ]	11	(90)	NONE

				LDI		PCL,0X10			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XDF*128						; RST 1				[ DF ]	11	(90)	NONE

				LDI		PCL,0X18			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XE7*128						; RST 0				[ E7 ]	11	(90)	NONE

				LDI		PCL,0X20			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XEF*128						; RST 1				[ EF ]	11	(90)	NONE

				LDI		PCL,0X28			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XF7*128						; RST 0				[ F7 ]	11	(90)	NONE

				LDI		PCL,0X30			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


.ORG	0X0000+0XFF*128						; RST 1				[ FF ]	11	(90)	NONE

				LDI		PCL,0X38			; 21
				LDI		PCH,0X00			; 22
				JMP		M1-T11+25			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&



.ORG	0X0000+0XC9*128						; RET 				[ C9 ]	10	(81)	NONE

				MOVW	ZL,YL				; 21
				ADIW	YL,0X02				; 23
				DELAY3						; 26
				DELAY3						; 29
				DELAY1						; 30
				CALL	LD_TMP_Z			; 34+29=63
				MOVW	PCL,TMPL			; 64
				JMP		M1-T10+67			; 67
				

.ORG	0X0000+0XD9*128						; NOP 				[ D9 ]	4	(36)	NONE

				JMP		M1-T4+23			; 23


.ORG	0X0000+0XE9*128						; PCHL 				[ E9 ]	5	(36)	NONE

				MOVW	PCL,L				; 21
				JMP		M1-T5+24			; 24


.ORG	0X0000+0XF9*128						; SPHL 				[ F9 ]	5	(36)	NONE

				MOVW	STPL,L				; 21
				JMP		M1-T5+24			; 24


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XCB*128						; NOP 				[ CB ]	4	(36)	NONE

				JMP		M1-T4+23			; 23


.ORG	0X0000+0XDB*128						; IN N 				[ DB ]	10	(90!81)	NONE


				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST8_PC			; 25+23=48
				MOV		ZH,TMPL				; 49
				LDI		ZL,0X00				; 50
				DELAY1						; 51
				DELAY3						; 54
				SBIS	PIND,MINT			; 55
				SEI							; 56
				DELAY1						; 57 !!! DO NOT TUCH !!!
				DELAY3						; 60
				CALL	LD_TMPL_Z			; 61+23=84
				MOV		A,TMPL				; 85
				DELAY2						; 87
				JMP		M1-90+90			; 90


.ORG	0X0000+0XEB*128						; XCHG 				[ EB ]	4	(36)	NONE

				MOVW	TMPL,L				; 21
				MOVW	L,E					; 22
				MOVW	E,TMPL				; 23
				JMP		M1-T4+26			; 26


.ORG	0X0000+0XFB*128						; DI 				[ FB ]	4	(36)	NONE

				SET							; 21
				BLD		CURRB,BEEP			; 22
				OUT		PORTB,CURRB			; 23
				JMP		M1-T4+26			; 26


.ORG	0X0000+0XCD*128						; CALL *			[ CD ]	17	(135)	NONE

				
				LDI		ZL,REGTMPLADDR		; 21 DESTINATION LOW ADDRESS
				CALL	LD_DST16_PC			; 25+34=59
				MOVW	MEMPTRL,TMPL		; 60
				DELAY3						; 63
				SBIS	PIND,MINT			; 64
				SEI							; 65
				MOVW	TMPL,PCL			; 66
				CALL	ST_TMP_Y			; 70+30=100
				MOVW	PCL,MEMPTRL			; 101
				JMP		M1-T17+104			; 104


.ORG	0X0000+0XDD*128						; NOP 				[ DD ]	4	(36)	NONE

				JMP		M1-T4+23			; 23


.ORG	0X0000+0XED*128						; NOP 				[ ED ]	4	(36)	NONE

				JMP		M1-T4+23			; 23


.ORG	0X0000+0XFD*128						; NOP 				[ FD ]	4	(36)	NONE

				JMP		M1-T4+23			; 23





