;
; MCPROFI - profi ds80 mode timing test by Alex Makeev
;

	device zxspectrum128
;------------------------------------------------------------------------------
	org	#8000
start:
	di
	ld		sp,#7900
	; enable ds80 video mode
	ld		bc,#DFFD
	ld		a,#87
	out		(c),a
	ld		bc,#7FFD
	ld		a,#00
	out		(c),a
	; now B&W area = page #04 
	;     CLR area = page #38 (mapped to window #C000..#FFFF)
	ld		hl,#C000
	ld		de,#C001
	ld		bc,8191
	ld		(hl),#47	; black/white
	ldir
	ld		hl,#E000
	ld		de,#E001
	ld		bc,8191
	ld		(hl),#47	; black/white
	ldir


	ld		bc,#DFFD
	ld		a,#80
	out		(c),a
	ld		bc,#7FFD
	ld		a,#04
	out		(c),a
	; now B&W area = page #04 (mapped to window #C000..#FFFF)
	;     CLR area = page #38 

	ld		hl,#E000
	ld		bc,8191
lpX8:
	ld		a,#FF
	bit		5,l
	jr		nz,lp8Xz
	xor		a
lp8Xz:
	ld		(hl),a
	inc		hl
	dec		bc
	ld		a,b
	or		c
	jr		nz,lpX8

	ld		hl,#C000
	ld		bc,8191
lpX8_2:
	ld		a,#FF
	bit		5,l
	jr		z,lp8Xz_2
	xor		a
lp8Xz_2:
	ld		(hl),a
	inc		hl
	dec		bc
	ld		a,b
	or		c
	jr		nz,lpX8_2

	; switch page to avoid corrupt image
	ld		a,#00
	ld		bc,#7FFD
	out		(c),a
;--------------------


	CALL		FILTER

	ld		a,#FE
	ld		i,a
	ld		hl,#FE00
	push	hl
	pop		de
	inc		de
	ld		bc,256
	ld		(hl),#FF
	ldir
	ld		l,h
	ld		(hl),#C9
	im		2
frame:
	ld		hl,#0204	; 3 yellow, 4 white, 5 black
	ld		d,#01
	ld		c,#FE
	ld		b,23
	ld		a,11
	ld		e,b
	ei
	halt

	jr $+2
	jr $+2

loop1:					; 19T+10T here

	dec		b			; 4
	jp		z,switch	; 10

	out		(c),0		; 12  12
	out		(c),h		; 12  24
	out		(c),l		; 12  36
	out		(c),d		; 12  48
	out		(c),h		; 12  60
	out		(c),l		; 12  72
	out		(c),d		; 12  84
	out		(c),h		; 12  96
	out		(c),l		; 12  108
	out		(c),d		; 12  120
	out		(c),h		; 12  132
	out		(c),l		; 12  144
	out		(c),d		; 12  156
	out		(c),h		; 12  168
	out		(c),l		; 12  180
	;out		(c),h		; 12  192
	;out		(c),l		; 12  204
	nop
	nop
	nop
	nop
	nop
	jp		loop1		; 10T

switch:
	out		(c),0		; 12  12
	out		(c),h		; 12  24
	out		(c),l		; 12  36
	out		(c),d		; 12  48
	out		(c),h		; 12  60
	out		(c),l		; 12  72
	out		(c),d		; 12  84
	out		(c),h		; 12  96
	out		(c),l		; 12  108
	out		(c),d		; 12  120
	out		(c),h		; 12  132
	out		(c),l		; 12  144
	out		(c),d		; 12  156
	out		(c),h		; 12  168
	out		(c),l		; 12  180
	;out		(c),h		; 12  192
	;out		(c),l		; 12  204
	inc		h
	inc		l
	inc		d
	ld		b,e
	dec		a
	jp		nz,loop1		; 10T

	ld		a,0
	;inc		hl

	jp		frame

FILTER: 
	; filter didn't works... :(

	DI
	LD 	HL,INT
	LD 	(#B0FF),HL
	LD 	A,0
	LD 	(BUFF+4),A
	LD 	E,1
	LD 	HL,BUFF
	LD 	A,#B0
	LD 	I,A
	IM 	2
	EI
	HALT

	CALL 	WAIT
	INC 	E
	CALL 	WAIT
	INC 	E
	CALL 	WAIT
	INC 	E
	DI

	LD 	BC,2688		; frameTactCount/26
	LD 	HL,(BUFF+1)
	EX 	DE,HL
	LD 	HL,(BUFF+3)
	LD 	A,H
	OR 	A
	JR 	NZ,F2

F0: 
	LD 	A,L
	CP 	4
	JR 	Z,DISP3
	LD 	A,D
	CP 	L
	JR 	Z,DISP2
	LD 	A,E
	CP 	D
	JR 	Z,DISP1
DISP0:
	NOP
	LD 	R,A
	LD 	R,A
F1:
	DEC 	BC
	LD 	A,B
	OR 	C
	JR 	NZ,F1
	RET
F2:
	LD 	E,D
	LD 	D,L
	LD 	L,H
	DEC 	BC
	DEC 	BC
	LD 	A,(HL)
	NOP
	JR 	F0
DISP1: 
	DEC 	BC
	NOP
	JR 	DISP0
DISP2: 
	JR 	DISP0

DISP3: 
	LD 	R,A
	LD 	A,(HL)
	JR 	DISP0
WAIT:
	LD 	BC,2688		; frameTactCount/26
W1: 
	DEC 	BC
	LD 	A,B
	OR 	C
	JR 	NZ,W1
	LD 	B,(HL)
	RET
INT: 
	LD 	(HL),E
	INC 	HL
	LD 	D,(HL)
	LD 	D,(HL)
	EI
	RET
BUFF: 
	DEFS 	5
;------------------------------------------------------------------------------
	;savesna "mcprofi.sna",start
	emptytrd "mcprofi.trd"
	savetrd "mcprofi.trd", "mcprofi.C", start, $-start
