	device zxspectrum128
         ORG #61a8
begin
 
 ;ORG 25000
 
 ;; BEEPER assembly listing... May 27/2010 By Karl McNeil
 
  LD HL,NOTES
 
read_notes_loop:
 
  LD A,(HL)
 
  INC A ; If duration byte is 0, then EXIT...
  DEC A ; (Zero is the end marker for the note data)
 RET Z
 
 LD B,A
 INC HL
 
 LD C,(HL)
 INC HL
 
CheckKey:
         xor a
         in a, ($fe)
         cpl
         and %00011111
         RET nz ; EXIT routine if key is pressed
 
 PUSH HL
 CALL BEEPIT ; BC is set, so now Play note...
 POP HL
 
 jp read_notes_loop
 
BEEPIT:
 ; Input BC = B=Duration, C=Pitch
 ; Output Action: Beeps note using the ROM beeper routine...
 
 ; Our duration will be a multiple of our mini-unit
 ; (a mini-unit is actually 5/255)...
 ; To convert a Basic BEEP duration into our assembled value,
 ; Assembled Duration = INT(Basic duration in Sec / (5/255) )
 ; Limitations: Our Duration can thus go no higher than 5 seconds (value 255)
 
 ; Our pitch will be the same as BASIC but with 60 added
 ; This avoids messing with negative numbers while storing data
 
 PUSH BC
 
  ;SET-UP Basic Unit of duration (5/255)
 RST $28 ; use the floating point calculator
 DEFB $A2; stk_half
 DEFB $A4; stk_ten
 DEFB $04; multiple ; Now we have 5 on the stack
 DEFB $38 ; end-calc
 
 LD A,255;(units are 5/255)
 CALL $2D28; Push A onto Calc Stack via Rom routine
 RST $28 ; use the floating point calculator
 DEFB $05; division
 DEFB $38 ; end-calc
 ; Fraction of (5/255) is now be on CalcStack
 ; now to push Our duration Value and multiple
 POP BC
 PUSH BC
 
 LD A,B
 CALL $2D28; Push A onto Calc Stack via Rom routine: Duraton (B)
 RST $28 ; use the floating point calculator
 DEFB $04; multiple
 DEFB $38 ; end-calc
 
 POP BC
 
 LD A,C
 CALL $2D28; Push A onto Calc Stack via Rom routine: Pitch (C)
 LD A,60
 CALL $2D28; Push A onto Calc Stack via Rom routine: Pitch (C)
 RST $28 ; use the floating point calculator
 DEFB $03; subtract
 DEFB $38 ; end-calc
 
 ; Currect duration & pitch value now on calc stack and ready
 
 CALL $03F8; entry point for BEEP
 RET
 
NOTES:
 
 DEFB 1,92,5,68,6,94,6,92
 DEFB 6,91,1,92,5,63,6,94
 DEFB 6,96,6,97,12,99,1,96
 DEFB 11,63,1,96,2,68,3,96
 DEFB 3,96,15,96,1,101,11,61
 DEFB 12,97,1,97,2,68,3,97
 DEFB 3,97,15,97,1,99,11,68
 DEFB 1,96,11,67,1,96,2,65
 DEFB 3,96,3,96,3,96,12,63
 DEFB 1,92,5,56,6,94,6,92
 DEFB 6,91,1,92,5,51,6,94
 DEFB 1,96,5,56,6,97,12,99
 DEFB 1,96,11,51,1,96,2,44
 DEFB 3,96,3,96,15,96,1,98
 DEFB 5,58,6,96,12,94,1,98
 DEFB 5,53,6,96,6,94,6,62
 DEFB 1,99,2,63,3,99,3,99
 DEFB 3,99,38,99,1,56,5,92
 DEFB 6,94,1,92,1,87,4,84
 DEFB 6,91,1,51,5,92,6,94
 DEFB 1,96,1,87,4,84,6,97
 DEFB 1,56,11,99,1,96,1,84
 DEFB 10,87,1,51,1,96,1,82
 DEFB 1,85,2,96,3,96,3,96
 DEFB 1,84,11,80,1,49,11,101
 DEFB 1,97,1,89,10,85,1,44
 DEFB 2,97,3,97,3,97,3,97
 DEFB 1,89,11,85,1,56,11,99
 DEFB 1,55,1,96,1,87,9,84
 DEFB 1,53,1,96,1,82,1,85
 DEFB 2,96,3,96,3,96,1,51
 DEFB 1,80,10,84,1,56,5,92
 DEFB 6,94,1,92,1,87,4,84
 DEFB 6,91,1,51,5,92,6,94
 DEFB 1,96,1,87,4,84,6,97
 DEFB 1,56,11,99,1,96,1,87
 DEFB 10,84,1,51,1,96,1,85
 DEFB 1,82,2,96,3,96,3,96
 DEFB 1,80,11,84,1,58,5,98
 DEFB 6,96,1,94,1,86,10,82
 DEFB 1,53,5,98,6,96,1,94
 DEFB 1,86,4,89,6,62,1,63
 DEFB 1,99,1,87,1,91,2,99
 DEFB 3,99,3,99,1,58,1,99
 DEFB 1,82,9,79,1,51,1,80
 DEFB 10,77,1,79,11,75,1,61
 DEFB 1,77,4,48,6,73,1,89
 DEFB 1,97,1,92,1,77,2,52
 DEFB 6,79,1,56,1,80,10,48
 DEFB 1,92,1,89,1,97,1,77
 DEFB 2,52,6,73,1,61,1,77
 DEFB 4,48,6,79,1,92,1,89
 DEFB 1,97,1,80,2,52,6,60
 DEFB 6,48,6,60,1,89,1,92
 DEFB 1,97,1,58,8,52,1,56
 DEFB 5,48,1,87,1,92,1,87
 DEFB 3,92,1,92,1,87,1,96
 DEFB 3,52,1,87,1,92,1,92
 DEFB 3,87,1,51,1,91,1,87
 DEFB 1,91,1,87,7,48,1,92
 DEFB 1,87,1,96,1,89,1,84
 DEFB 1,84,1,89,5,52,1,56
 DEFB 1,87,1,84,1,84,1,87
 DEFB 1,48,1,87,5,84,1,96
 DEFB 1,92,1,87,1,55,1,83
 DEFB 1,86,1,83,1,86,1,52
 DEFB 1,87,1,96,1,92,1,87
 DEFB 1,84,1,87,1,84,1,53
 DEFB 2,48,1,84,2,87,1,84
 DEFB 2,87,1,96,1,87,1,92
 DEFB 1,51,8,52,1,58,1,77
 DEFB 4,48,6,74,1,98,1,94
 DEFB 1,89,1,77,2,52,6,79
 DEFB 1,53,1,80,10,48,1,98
 DEFB 1,89,1,94,1,77,2,52
 DEFB 6,74,1,58,1,77,4,48
 DEFB 6,79,1,98,1,94,1,89
 DEFB 1,58,1,80,7,52,1,60
 DEFB 11,48,1,98,1,89,1,94
 DEFB 1,50,8,52,1,51,5,48
 DEFB 1,82,5,82,1,94,1,91
 DEFB 1,99,1,92,1,92,1,52
 DEFB 1,92,1,82,4,82,1,53
 DEFB 1,91,1,91,9,48,1,94
 DEFB 1,91,1,99,1,89,1,89
 DEFB 1,52,1,87,5,87,1,55
 DEFB 2,48,3,87,3,87,3,87
 DEFB 1,94,1,91,1,99,1,51
 DEFB 1,87,7,52,1,53,11,48
 DEFB 1,94,1,91,1,99,1,55
 DEFB 2,52,6,52,1,49,1,89
 DEFB 6,48,4,85,1,89,1,92
 DEFB 1,97,1,89,4,52,4,91
 DEFB 1,56,1,92,10,48,1,92
 DEFB 1,89,1,97,1,89,4,52
 DEFB 4,85,1,61,1,89,6,48
 DEFB 4,91,1,89,1,92,1,97
 DEFB 1,92,2,52,6,60,6,48
 DEFB 6,60,1,89,1,92,1,97
 DEFB 1,58,8,52,1,56,1,74
 DEFB 6,48,4,75,1,96,1,87
 DEFB 1,92,1,80,4,52,4,71
 DEFB 1,51,1,72,10,48,1,96
 DEFB 1,92,1,87,1,74,2,52
 DEFB 2,56,4,75,1,80,5,48
 DEFB 2,56,4,68,1,96,1,92
 DEFB 1,87,3,52,6,51,1,56
 DEFB 1,70,10,48,1,96,1,92
 DEFB 1,87,1,57,1,72,1,52
 DEFB 6,52,1,58,1,89,6,48
 DEFB 4,86,1,98,1,89,1,94
 DEFB 1,89,4,52,4,91,1,53
 DEFB 1,92,10,48,1,98,1,89
 DEFB 1,94,1,89,4,52,4,86
 DEFB 1,58,1,89,6,48,4,91
 DEFB 1,98,1,94,1,89,1,58
 DEFB 1,92,1,52,1,94,1,98
 DEFB 4,89,1,60,11,48,1,98
 DEFB 1,89,1,94,1,50,8,52
 DEFB 1,51,11,48,1,91,1,94
 DEFB 1,99,3,55,1,61,11,48
 DEFB 1,58,1,50,1,74,3,77
 DEFB 1,63,1,77,1,74,9,50
 DEFB 1,51,1,79,1,75,1,69
 DEFB 8,48,1,51,11,52,6,53
 DEFB 6,52,1,55,11,52,1,56
 DEFB 1,92,1,54,3,48,6,94
 DEFB 1,92,1,96,1,87,1,92
 DEFB 1,87,1,84,1,54,1,52
 DEFB 4,91,1,51,1,92,1,54
 DEFB 3,48,6,94,1,92,1,96
 DEFB 1,87,1,96,1,87,1,84
 DEFB 1,54,1,52,4,97,1,56
 DEFB 1,99,1,54,9,48,1,87
 DEFB 1,96,1,92,1,96,1,84
 DEFB 1,87,1,54,5,52,1,51
 DEFB 1,96,1,82,1,85,1,54
 DEFB 1,48,1,96,2,96,3,96
 DEFB 1,92,1,96,1,87,1,84
 DEFB 1,80,1,58,6,52,1,49
 DEFB 1,101,1,54,9,48,1,89
 DEFB 1,92,1,97,1,97,1,89
 DEFB 1,85,1,54,5,52,1,44
 DEFB 1,97,1,54,1,48,2,97
 DEFB 3,97,3,97,1,92,1,97
 DEFB 1,89,1,89,1,85,1,54
 DEFB 6,52,1,56,1,99,1,54
 DEFB 9,48,1,96,1,92,1,87
 DEFB 1,55,1,96,1,87,1,84
 DEFB 1,54,4,52,1,53,1,96
 DEFB 1,82,1,85,1,54,1,48
 DEFB 1,96,2,96,3,96,1,96
 DEFB 1,92,1,87,1,51,1,80
 DEFB 1,84,1,58,5,52,1,56
 DEFB 1,92,1,54,3,48,6,94
 DEFB 1,92,1,87,1,96,1,92
 DEFB 1,87,1,84,1,54,1,52
 DEFB 4,91,1,51,1,92,1,54
 DEFB 3,48,6,94,1,87,1,92
 DEFB 1,96,1,96,1,87,1,84
 DEFB 1,54,1,52,4,97,1,56
 DEFB 1,99,1,54,9,48,1,96
 DEFB 1,92,1,87,1,96,1,87
 DEFB 1,84,1,54,5,52,1,51
 DEFB 1,96,1,85,1,82,1,54
 DEFB 1,48,1,96,2,96,3,96
 DEFB 1,87,1,96,1,92,1,80
 DEFB 1,84,1,58,6,52,1,58
 DEFB 1,98,1,54,3,48,6,96
 DEFB 1,98,1,94,1,89,1,94
 DEFB 1,86,1,82,1,54,5,52
 DEFB 1,53,1,98,1,54,3,48
 DEFB 6,96,1,98,1,89,1,94
 DEFB 1,94,1,86,1,89,1,54
 DEFB 1,52,4,62,1,63,1,99
 DEFB 1,87,1,91,1,54,1,48
 DEFB 1,99,2,99,3,99,1,99
 DEFB 1,94,1,91,1,58,1,99
 DEFB 1,82,1,79,1,58,4,52
 DEFB 1,51,1,80,1,77,1,54
 DEFB 8,48,1,91,1,94,1,99
 DEFB 1,79,1,75,1,58,1,52
 DEFB 5,52,1,61,1,77,1,54
 DEFB 3,48,6,73,1,92,1,89
 DEFB 1,97,1,77,1,54,1,52
 DEFB 6,79,1,56,1,80,1,54
 DEFB 9,48,1,92,1,89,1,97
 DEFB 1,77,1,54,1,52,6,73
 DEFB 1,61,1,77,1,54,3,48
 DEFB 6,79,1,92,1,89,1,97
 DEFB 1,80,1,54,1,52,6,60
 DEFB 1,54,5,48,6,60,1,89
 DEFB 1,92,1,97,1,58,1,58
 DEFB 7,52,1,56,1,54,4,48
 DEFB 1,87,1,92,1,87,3,92
 DEFB 1,92,1,96,1,87,1,54
 DEFB 2,52,1,87,1,92,1,92
 DEFB 3,87,1,51,1,91,1,87
 DEFB 1,91,1,87,1,54,6,48
 DEFB 1,92,1,96,1,87,1,89
 DEFB 1,84,1,84,1,89,1,54
 DEFB 4,52,1,56,1,87,1,84
 DEFB 1,84,1,87,1,54,1,48
 DEFB 1,87,4,84,1,96,1,92
 DEFB 1,87,1,55,1,83,1,86
 DEFB 1,83,1,86,1,54,1,52
 DEFB 1,96,1,92,1,87,1,87
 DEFB 1,84,1,87,1,84,1,53
 DEFB 1,54,1,48,1,84,1,87
 DEFB 1,84,2,87,1,92,1,96
 DEFB 1,87,1,51,1,58,7,52
 DEFB 1,58,1,77,1,54,3,48
 DEFB 6,74,1,94,1,98,1,89
 DEFB 1,77,1,54,1,52,6,79
 DEFB 1,53,1,80,1,54,9,48
 DEFB 1,98,1,89,1,94,1,77
 DEFB 1,54,1,52,6,74,1,58
 DEFB 1,77,1,54,3,48,6,79
 DEFB 1,98,1,89,1,94,1,58
 DEFB 1,80,1,54,6,52,1,60
 DEFB 1,54,10,48,1,98,1,89
 DEFB 1,94,1,50,1,58,7,52
 DEFB 1,51,1,54,4,48,1,82
 DEFB 5,82,1,99,1,94,1,91
 DEFB 1,92,1,92,1,54,1,52
 DEFB 1,92,1,82,3,82,1,53
 DEFB 1,91,1,91,1,54,8,48
 DEFB 1,91,1,94,1,99,1,89
 DEFB 1,89,1,54,1,52,1,87
 DEFB 14,87,0
 
END_OF_PROG:
 ; All done...
end
 	display /d,end-begin
 	savesna "Play.sna",begin
 
 