-- ZX Spectrum for Altera DE2-115
--
-- Copyright (c) 2012 Anton Vasilenok
--
-- All rights reserved
--
-- Redistribution and use in source and synthezised forms, with or without
-- modification, are permitted provided that the following conditions are met:
--
-- * Redistributions of source code must retain the above copyright notice,
--   this list of conditions and the following disclaimer.
--
-- * Redistributions in synthesized form must reproduce the above copyright
--   notice, this list of conditions and the following disclaimer in the
--   documentation and/or other materials provided with the distribution.
--
-- * Neither the name of the author nor the names of other contributors may
--   be used to endorse or promote products derived from this software without
--   specific prior written agreement from the author.
--
-- * License is granted for non-commercial use only.  A fee may not be charged
--   for redistributions as source code or in synthesized/hardware form without 
--   specific prior written agreement from the author.
--
-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
-- AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
-- THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
-- PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE
-- LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
-- CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
-- SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
-- INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
-- CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
-- ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
-- POSSIBILITY OF SUCH DAMAGE.
--

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.std_logic_unsigned.ALL;

entity zxram is
generic
(
   addr_lines : natural := 21
);
port (
	CLK				:	in std_logic;
	CLKEN_CPU		:	in std_logic;
	ADDR_CPU			:  in std_logic_vector(addr_lines-1 downto 0);
	DI_CPU			:  in std_logic_vector(7 downto 0);
	WR_N				:  in std_logic;
	DO_CPU			:  out std_logic_vector(7 downto 0);
	CLKEN_VIDEO		:	in std_logic;
	ADDR_VIDEO		:  in std_logic_vector(addr_lines-1 downto 0);
	DO_VIDEO			:  out std_logic_vector(7 downto 0);
	
	--- SRAM interface
	SRAM_ADDR	:	out		std_logic_vector(19 downto 0);
	SRAM_DQ		:	inout		std_logic_vector(15 downto 0);
	SRAM_CE_N	:	out		std_logic;
	SRAM_OE_N	:	out		std_logic;
	SRAM_WE_N	:	out		std_logic;
	SRAM_UB_N	:	out		std_logic;
	SRAM_LB_N	:	out		std_logic
	);
end zxram;

architecture zxram_arch of zxram is
signal cpu_event   : std_logic :='0';
signal buffer_d    : std_logic_vector(7 downto 0);
signal buffer_qc   : std_logic_vector(7 downto 0);
signal buffer_qv   : std_logic_vector(7 downto 0);
signal buffer_addr : std_logic_vector(addr_lines-1 downto 0);
signal io_wr_n	    : std_logic :='0';
begin
	SRAM_CE_N <= '0';
	SRAM_OE_N <= '0';

	SRAM_DQ( 7 downto 0) <= buffer_d when io_wr_n = '0' and buffer_addr(0) = '0' else (others=>'Z');
	SRAM_DQ(15 downto 8) <= buffer_d when io_wr_n = '0' and buffer_addr(0) = '1' else (others=>'Z');		
	--SRAM_WE_N <= io_wr_n or not(CLK);
	SRAM_WE_N <= io_wr_n;
	
	SRAM_ADDR <= buffer_addr(addr_lines-1 downto 1);
	SRAM_LB_N <= 	  buffer_addr(0);
	SRAM_UB_N <= not(buffer_addr(0));
	
	DO_CPU    <= buffer_qc;
	DO_VIDEO  <= buffer_qv;
	
	process(CLK)
	begin
		if (falling_edge(CLK)) then
			if (CPU_event = '1') then
				if (buffer_addr(0) = '0') then
					buffer_qc <= SRAM_DQ(7 downto 0);
				else
					buffer_qc <= SRAM_DQ(15 downto 8);
				end if;
			else 
				if (buffer_addr(0) = '0') then
					buffer_qv <= SRAM_DQ(7 downto 0);
				else
					buffer_qv <= SRAM_DQ(15 downto 8);
				end if;
			end if;
			if (CLKEN_VIDEO='1') then	
				CPU_event   <= '1';
				buffer_addr <= ADDR_CPU;
				buffer_d    <= DI_CPU;
				io_wr_n     <= WR_N;
			else 
				CPU_event   <= '0';
				-- Video
				buffer_addr <=  ADDR_VIDEO;
				io_wr_n     <= '1';
			end if;
		end if;
	end process;
end;

