/* /AC /Ox /FPc */
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <bios.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <setjmp.h>
#include <conio.h>
#include <signal.h>
#include <float.h>

#define MEMSIZ  65535
#define word(a) (*(int far *)&memory[a])
#define PC      r[7]
#define SP      r[6]
#define PSW     word(0177776)
#define TTKS    memory[0177560]
#define TTKB    memory[0177562]
#define TTPS    memory[0177564]
#define TTPB    memory[0177566]
#define LPS     memory[0177514]
#define LPB     memory[0177516]
#define T       020
#define N       010
#define Z       04
#define V       02
#define C       01

char far memory[MEMSIZ] = {
        012700,012700/256,
        012345,012345/256,
        010001,010001/256,
        010137,010137/256,
        0100,0
};

char *title = "DEC PDP11 (R) Software emulator v2.1    SOS (C) 1989-1992      ^R reg.  ^X  quit";

int r[9]={0};
int ir=0;
int src=0, dst=0;
int byte=0;
int wasttr=0;
int wasfpe=0;
extern near dstoff;
extern void intrr(int),ctrlc(),fperr(int,int);
extern clr(),clrb(),com(),comb(),inc(),incb(),dec(),decb(),neg(),negb();
extern adc(),adcb(),sbc(),sbcb(),tst(),tstb(),ror(),rorb(),rol(),rolb();
extern asr(),asrb(),asl(),aslb(),mark(),mfpi(),mtpi(),sxt(),mov(),movb();
extern cmp(),cmpb(),bit(),bitb(),bic(),bicb(),bis(),bisb(),add(),sub();
extern sob(),eis(),illop(),mtps(),mfps();

int trace=0;
int step =0;
int tinfo=0;
int f[8];
int foffs=0;
int dzf=0;

jmp_buf env;

int directvideo = 0;

main(ac,av)
char **av;
{
        register i,j;
        int c;
        int brk=0177777;

        if(ac == 1) {
                fprintf(stderr, "EM: Usage: EM [-z] RT11DEV [...]\n");
                exit(1);
        }
        textcolor(RED);
        textbackground(BLUE);
        gotoxy(1,1);
        cputs(title);
        textcolor(WHITE);
        textbackground(BLACK);
        gotoxy(1,2);
        window(1,2,80,25);
        clrscr();
        initov();
        readboot();
#ifdef DEBUG
        printf("trace?");
        if(getch() == 'y') {
                trace++;
                printf("\nstep?");
                if(getch() == 'y')
                        step++;
        }
        printf("\ntrap info?");
        if(getch() == 'y')
                tinfo++;
        printf("\nbreak addr:");
        scanf("%o",&brk);
#endif
        for(i=0,c=1; av[c]; c++) {
                if(av[c][0] == '-') {
                        dzf++;
                        continue;
                }
                if(av[c][1] == ':' && av[c][2] == 0) {
                        f[i++] = -(av[c][0]&~0x20);
                        continue;
                }
                if((f[i] = open(av[c],O_BINARY|O_RDWR)) == -1)
                        printf("not found %s\n",av[c]);
                else
                        i++;
        }
        PC = 0;
#ifdef BINLOAD
        readbin();
#endif
        PSW = 0340;
        reset();
        signal(SIGINT,ctrlc);
        signal(SIGFPE,fperr);
        setjmp(env);
fetch:
#ifdef DEBUG
        if(PC == brk) {
                trace++;
                step++;
        }
        if(trace) {
                printf("%06o/ %06o %06o %06o PSW=%06o\n",PC,word(PC), word(PC+2), word(PC+4),PSW);
                for(i=0;i<8;i++)
                        printf("R%d=%06o ",i,r[i]);
        }
        i=0;
        if(step) {
                byte=0;
                for(;;) {
                switch(c=getche()) {

                case ' ':
                        break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                        i=(i<<3) + c - '0';
                default:
                        continue;
                case '\r':
                        i+=byte?1:2;
                        printf("%06o/",i);
pr:                     printf(" %06o %c\n",word(i),byte?memory[i]:' ');
                        continue;
                case '\\':
                        byte = 1;
                        goto pr;
                case '/':
                        byte = 0;
                        goto pr;
                case 'q':
                        exit();
                case 'p':
                        trace=0;
                        step=0;
                        break;
                case 'm':
                        printf("modify ");
                        scanf("%o",&c);
                        word(i) = c;
                        continue;
                }
                break;
                }
        }
#endif
        intrchk();
fet1:
        i = ir = word(PC);
        PC += 2;
        if(i & 070000) {          /* Double operands, EIS, FIS instructions */
                static (*fun[])() = {
                        illop,mov,cmp,bit,bic,bis,add,eis,
                        illop,movb,cmpb,bitb,bicb,bisb,sub,illop
                };

                (*fun[(i>>12)&017])();
                goto fetch;
        }
        if(i >= 0) {
                if(i & 07000)            /* Single op & branches */
                        switch(i & 07000) {

                        case 05000:
                        case 06000:
                                {
                                static (*fun[])() = {
                                        ror,rol,asr,asl,mark,mfpi,mtpi,sxt,
                                        clr,com,inc,dec,neg,adc,sbc,tst
                                };

                                (*fun[(i>>6)&017])();
                                goto fetch;
                                }
                        case 01000:
                                if(i & 0400) {
                                        if(PSW & Z)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & Z))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 02000:
                                if(i & 0400) {
                                        if((i=PSW & (N | V)) == N || i == V)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if((i=PSW & (N | V)) == 0 || i == (N | V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 03000:
                                if(i & 0400) {
                                        if(!((i=PSW & (N | V | Z)) == 0 || i == (N | V)))
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if((i=PSW & (N | V | Z)) == 0 || i == (N | V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 04000:
                                jadst();
                                i = (ir & 0700) >> 6;
                                push(r[i]);
                                r[i] = PC;
                                PC = dstoff;
                                break;
                        default:
                                illop();
                                break;
                        }
                else switch(i & 0700) {

                case 0400:
                case 0500:
                case 0600:
                case 0700:
                        PC += (*(char *) & ir)*2;
                        break;
                case 0100:
                        jadst();
                        PC = dstoff;
                        break;
                case 0200:
                        switch(i & 070) {

                        case 000:
                                i = ir & 7;
                                PC = r[i];
                                r[i] = pop();
                                break;
                        case 030:
                                PSW &= ~0340;
                                PSW |= (ir & 7) << 4;
                                break;
                        case 040:
                        case 050:
                        case 060:
                        case 070:
                                i = ir & 017;
                                if(ir & 020)
                                        PSW |= i;
                                else
                                        PSW &= ~i;
                                break;
                        default:
                                illop();
                                break;
                        }
                        break;
                case 0300:
                        swabb();
                        break;
                case 0000:
                        switch(i) {

                        case 0:
                                printf("Halt at PC %06o\npress any key to continue", PC);
                                if(getch() == 0)
                                        exit(1);
                                break;
                        case 1:
                                for(;;)
                                        intrchk();
                                break;
                        case 2:
                                PC = pop();
                                PSW= pop();
                                break;
                        case 3:
                                intrr(014);
                                break;
                        case 4:
                                intrr(020);
                                break;
                        case 5:
                                reset();
                                break;
                        case 6:
                                PC = pop();
                                PSW= pop();
                                goto fet1;
                        case 010:
                                msread();
                                break;
                        case 011:
                                mswrite();
                                break;
                        default:
                                illop();
                        }
                        break;
                }
        } else {
                if(i & 0107000)            /* Single op & branches */
                        switch(i & 0107000) {

                        case 0105000:
                        case 0106000:
                                {
                                static (*fun[])() = {
                                        rorb,rolb,asrb,aslb,mtps,mfpi,mtpi,mfps,
                                        clrb,comb,incb,decb,negb,adcb,sbcb,tstb
                                };

                                (*fun[(i>>6)&017])();
                                goto fetch;
                                }
                        case 0100000:
                                if(i & 0400) {
                                        if(PSW & N)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & N))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0101000:
                                if(i & 0400) {
                                        if(PSW & (C | Z))
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & (C | Z)))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0102000:
                                if(i & 0400) {
                                        if(PSW & V)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & V))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0103000:
                                if(i & 0400) {
                                        if(PSW & C)
                                                PC += (*(char *) & ir)*2;
                                } else {
                                        if(!(PSW & C))
                                                PC += (*(char *) & ir)*2;
                                }
                                break;
                        case 0104000:
                                if(i & 0400)
                                        intrr(034);
                                else
                                        intrr(030);
                                break;
                        default:
                                illop();
                                break;
                        }
        }
        goto fetch;
}

eis()
{
        switch(ir & 07000) {

        case 00000:
                mul();
                break;
        case 01000:
                divv();
                break;
        case 02000:
                ash();
                break;
        case 03000:
                ashc();
                break;
        case 04000:
                xor();
                break;
        case 05000:
                switch(ir & 0770) {

                case 000:
                        fadd();
                        break;
                case 010:
                        fsub();
                        break;
                case 020:
                        fmul();
                        break;
                case 030:
                        fdiv();
                        break;
                default:
                        illop();
                        break;
                }
                break;
        case 07000:
                if(--r[(ir & 0700) >> 6])
                        PC -= (ir & 077)*2;
                break;
        default:
                illop();
                break;
        }
}

mark()
{
        SP += ((ir & 077)+1) << 1;
        PC = r[5];
        r[5] = pop();
}

void ctrlc()
{
        int x,y;

        x=wherex();
        y=wherey();
        signal(SIGINT,ctrlc);
        trace++;
        step++;
        window(1,1,80,25);
        textcolor(RED);
        textbackground(BLUE);
        gotoxy(1,1);
        cputs(title);
        textcolor(WHITE);
        textbackground(BLACK);
        window(1,2,80,25);
        gotoxy(x,y);
#ifndef DEBUG
        TTKS |= 0200;
        TTKB = 3;
#endif
}

displayreg()
{
        char s[20];
        int i;
        static char *rn[] = {
                "R0","R1","R2","R3","R4","R5","SP","PC","PS"
        };
        int x,y;

        x=wherex();
        y=wherey();
        textbackground(BLUE);
        for(i=0; i<9; i++) {
                gotoxy(69,i+1);
                sprintf(s, "%s = %06o", rn[i], (i==8? PSW: r[i]));
                cputs(s);
        }
        textbackground(BLACK);
        gotoxy(x,y);
}


push(a)
{
        SP -= 2;
        word(SP) = a;
/*
        if(SP < (unsigned)0400)
                intrr(4);
*/
}

pop()
{
        register i;

        i = word(SP);
        SP += 2;
        return(i);
}

reset()
{
        TTPS = LPS = 0200;
        TTKS = 0;
}

fadd()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = (o1.x/4 + o2.x/4)*4;
#ifdef FISDEBUG
        sprintf(st,"\nFADD o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
}

fsub()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = (o1.x/4 - o2.x/4)*4;
#ifdef FISDEBUG
        sprintf(st,"\nFSUB o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
}

fmul()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = ((o1.x/4) * (o2.x/4))*4;
#ifdef FISDEBUG
        sprintf(st,"\nFMUL o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        word(rreg) = rez.ix[1];
        word(rreg+2) = rez.ix[0];
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
        } else
                intrr(0244);
}

fdiv()
{
        union {
                float x;
                int ix[2];
        } o1, o2, rez;
        register int reg,rreg;
#ifdef FISDEBUG
        char st[80];
#endif

        wasfpe = 0;
        PSW &= 0340;
        reg = ir & 07;
        o2.ix[1] = word(r[reg]);
        r[reg] += 2;
        o2.ix[0] = word(r[reg]);
        rreg = (r[reg] += 2);
        o1.ix[1] = word(rreg);
        o1.ix[0] = word(rreg + 2);
        rez.x = ((o1.x/4) / (o2.x/4))*4;
#ifdef FISDEBUG
        sprintf(st,"\nFDIV o1= %06o %06o  o2= %06o %06o rez = %06o %06o\n",
                o1.ix[0], o1.ix[1], o2.ix[0], o2.ix[1], rez.ix[0], rez.ix[1]);
        for(reg=0;st[reg];reg++)
                puttty(st[reg]);
#endif
        if(!wasfpe) {
                if(rez.x < 0)
                        PSW |= N;
                else if(rez.x == 0)
                        PSW |= Z;
                word(rreg) = rez.ix[1];
                word(rreg+2) = rez.ix[0];
        } else
                intrr(0244);
}

void fperr(sig, flag)
{
#ifdef FISDEBUG
        char str[80];
        int i;
#endif

        signal(SIGFPE, fperr);
        wasfpe = 1;
        switch(flag) {

        case FPE_OVERFLOW:
                PSW |= V;
                break;
        case FPE_UNDERFLOW:
                PSW |= V|N;
                break;
        case FPE_ZERODIVIDE:
                PSW |= V|N|C;
                break;
        default:
#ifdef FISDEBUG
                sprintf(str, "Unknown FP error %x\n", flag);
                for(i=0; str[i]; i++)
                        puttty(str[i]);
#endif
                break;
        }
}

void intrr(n)
register n;
{
#ifdef DEBUG
        if(tinfo)
                printf("Trap to %o\n", n);
#endif
        push(PSW);
        push(PC);
        PC = word(n);
        PSW = word(n+2);
        longjmp(env,0);
}

getdev(n)
{
        switch(n) {

        case 0177566:
        case 0177134:
        case 0177560:
        case 0177564:
        case 0177514:
        case 0177516:
        case 0177776:
                return(word(n));
        case 0177562:
                TTKS &= ~0200;
                return(word(n));
        default:
                intrr(4);
        }
}

putdev(n)
{
        switch(n) {

        case 0177564:
                wasttr=0;
        case 0177562:
        case 0177514:
                word(n) = dst | 0200;
                break;
        case 0177560:
        case 0177776:
        case 0177134:
                word(n) = dst;
                break;
        case 0177566:
                puttty(dst&0177);
                break;
        case 0177516:
                putc(dst,stdprn);
                fflush(stdprn);
                break;
        default:
                intrr(4);
        }
}

chkbus(n)
{
        switch(n) {

        case 0177564:
        case 0177562:
        case 0177560:
        case 0177776:
        case 0177134:
        case 0177566:
        case 0177514:
        case 0177516:
                return;
        default:
                intrr(4);
        }
}

illop()
{
#ifdef DEBUG
        printf("Illegal op %06o at PC=%06o\n", ir, PC);
#endif
        intrr(010);
}

mtpi()
{
        illop();
}

mtpd()
{
        illop();
}

mfpi()
{
        illop();
}

mfpd()
{
        illop();
}

msread()
{
        int i,j;

        j = memory[0177134];
        if(f[j] == 0)
                goto erread;
        else if(f[j] < 0) {
                if(diskread())
                        goto erread;
                else
                        return;
        }
        if(lseek(f[j], r[0]*512l, SEEK_SET) == -1l) {
#ifdef DEBUG
                printf("seek error\n");
#endif
                goto erread;
        }
#ifdef DEBUG
        printf("read block %d nw=%o adr=%o\n",r[0],r[1],r[2]);
#endif
        if((i=read(f[j], memory+r[2], r[1]*2)) != r[1]*2) {
#ifdef DEBUG
                printf("read error (retcode=%d)\n",i);
#endif
erread:         PSW |= C;
        } else
                PSW &= ~C;
}

mswrite()
{
        int i;

        i = memory[0177134];
#ifdef DEBUG
        printf("write block %d nw=%o adr=%o\n",r[0],r[1],r[2]);
#endif
        if(f[i] == 0)
                goto erwrite;
        else if(f[i] < 0) {
                if(diskwrite())
                        goto erwrite;
                else
                        return;
        }
        if(lseek(f[i], r[0]*512l, SEEK_SET) == -1l)
                goto erwrite;
        if(write(f[i], memory+r[2], r[1]*2) != r[1]*2)
erwrite:        PSW |= C;
        else
                PSW &= ~C;
}

readboot()
{
        if((f[0]=open("emboot.sav",O_BINARY|O_RDWR)) == -1)
                printf("not found emboot.sav\n");
        if(read(f[0],memory,01000) == -1)
                printf("error reading emboot.sav\n");
        close(f[0]);
}

#ifdef BINLOAD
readbin()
{
        int c,ks,i,l;

        for(;;) {
/*              printf("offset %06o\t",foffs);*/
                while((c=get(f[0])) != 1)
                        if(c==EOF) {
                                printf("EOF\n");
                                goto ask;
                        }
                if(get(f[0]) != 0) {
                        printf("not zero\n");
                        continue;
                }
                ks = 1;
                c = get(f[0]);
                ks += c;
                l = c;
                c = get(f[0]);
                ks += c;
                l |= (c<<8);
                c = get(f[0]);
                ks += c;
                i = c;
                c = get(f[0]);
                ks += c;
                i |= (c<<8);
                if(l == 6)
                        if(i == 1) {
ask:                            printf("start addr: ");
                                scanf("%o", &PC);
                                return;
                        } else {
                                PC = i;
                                printf("PC = %06o\n");
                                return;
                        }
/*              printf("load from %06o %06o bytes\n",i,l);*/
                while(l-- > 6) {
                        c = get(f[0]);
                        ks += c;
                        memory[i++] = c;
                }
                c = get(f[0]);
                if((c+ks) & 0377) {
                        printf("checksum error: c=%o ks=%o\n",c,ks&0377);
                }
        }
}

get(f)
{
        int c=0;
        if(read(f,(char *)&c,1) != 1)
                c=EOF;
        foffs++;
        return(c);
}
#endif

gettty()
{
        static escflg=0;
        int c;
        static int savch = 0;
        FILE *f;

        if(savch) {
                c = savch;
                savch = 0;
        } else
                c = getch();
        if(escflg == 0) {
                if(c == 0) {
                        escflg++;
                        return(033);
                } else if(c == 8)
                        return(0177);
                else if(c==('R'&0x1f)) {
                        displayreg();
                        return(0177);
                } else if(c==('X'&0x1f))
                        exit();
                else
                        return(c);
        }
        escflg = 0;
        switch(c) {

        case 72:
                return('A');
        case 80:
                return('B');
        case 77:
                return('C');
        case 75:
                return('D');
        case 71:
                return('c');
        case 82:
                return('d');
        case 83:
                return('e');
        case 79:
                return('f');
        case 73:
                return('g');
        case 81:
                return('h');
        case 59:
                return('P');
        case 60:
                return('Q');
        case 61:
                return('R');
        case 62:
                return('S');
        case 67:
                displayreg();
                return(0177);
        case 68:
                exit();
        }
}

int koi7toalt[] = {
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','','',
        '','','','','','','','','','','','','','','',''
};

puttty(c)
{
        static escflg=0,escyflg=0,row=-1,rus=0;
        int x,y,ox,oy;
        char l[2];

        if(escyflg) {
                if(row == -1)
                        row = c;
                else {
                        gotoxy(c-040+1, row-040+1);
                        row = -1;
                        escyflg=0;
                        escflg =0;
                }
                return;
        }
        if(escflg) {
es:             x=wherex();
                y=wherey();
                escflg = 0;
                switch(c) {

                case 'A':
                        if(y>1)
                                gotoxy(x,y-1);
                        break;
                case 'B':
                        if(y<24)
                                gotoxy(x,y+1);
                        break;
                case 'C':
                        if(x<80)
                                gotoxy(x+1,y);
                        break;
                case 'D':
                        if(x>1)
                                gotoxy(x-1,y);
                        break;
                case 'J':
                        window(y+1,1,25,80);
                        clrscr();
                        window(2,1,25,80);
                        goto kill_line;
                case 'E':
                        clrscr();
                        break;
                case 'H':
                        gotoxy(1,1);
                        break;
                case 'I':
                        if(y>1)
                                gotoxy(x,y-1);
                        else {
                                _AX = 0x701;
                                _CX = 0x100;
                                _DX = 0x2479;
                                _BH = 0;
                                geninterrupt(0x10);
                        }
                        break;
                case 'K':
kill_line:              clreol();
                        break;
                case 'Y':
                        escyflg=1;
                        break;
                default:
                        goto outch;
                        break;
                }
                return;
        }
        if(c == 3)
                return;
        if(c == 7) {
                putchar(c);
                return;
        }
        if(c == 033) {
                escflg = 1;
                return;
        }
        if(c == 8) {
                c = 'D';
                goto es;
        }
        if(c == 017) {
                rus = 0;
                return;
        }
        if(c == 016) {
                rus = 1;
                return;
        }
        if(c == 0177 & !rus)
                c = 0xdb;
outch:  if(c >= 0100 && c <= 0176 && rus)
                c = koi7toalt[c-0100];
        putch(c);
        if(c == 10 && wherey() == 24)
                clreol();
}

char bf[512];

diskread()
{
        register i,j;
        int track,head,sector;
        struct diskinfo_t di;
        int spt=20;

        if(dzf)
                spt=10;

        for(;r[1];r[0]++) {
                track = r[0]/spt;
                head = 0;
                sector = r[0]%spt;
                if(dzf)
                        if(sector < 5) {
                                sector=(sector+track)*2;
                                sector%=10;
                        } else {
                                sector=(sector+track)*2;
                                sector%=10;
                                sector++;
                        }
                if(sector > 10) {
                        sector -= 10;
                        head++;
                }
                if(dzf) {
                        track++;
                        if(track == 80)
                                track=0;
                }
                i = memory[0177134];
                di.drive = -f[i] - 'A';
                di.head = head;
                di.track= track;
		di.sector = sector+1;
                di.nsectors = 1;
                di.buffer = bf;
                if((i=_bios_disk(_DISK_READ, &di)) & 0xff00) {
                        printf("read error %04x\n",i);
                        return(1);
                }
                for(i=0;i<512 && r[1];r[1]--) {
                        memory[r[2]++] = bf[i++];
                        memory[r[2]++] = bf[i++];
                }
        }
        PSW &= ~C;
	return(0);
}

diskwrite()
{
        register i,j;
        int track,head,sector;
        struct diskinfo_t di;
        int spt=20;

        if(dzf)
                spt=10;


        for(;r[1];r[0]++) {
                for(i=0;i<512 && r[1];r[1]--) {
                        bf[i++] = memory[r[2]++];
                        bf[i++] = memory[r[2]++];
                }
                track = r[0]/spt;
                head = 0;
                sector = r[0]%spt;
                if(dzf)
                        if(sector < 5) {
                                sector=(sector+track)*2;
                                sector%=10;
			} else {
                                sector=(sector+track)*2;
                                sector%=10;
                                sector++;
                        }
                if(sector > 10) {
                        sector -= 10;
                        head++;
                }
                if(dzf) {
                        track++;
                        if(track == 80)
                                track=0;
		}
		i = memory[0177134];
		di.drive = -f[i] - 'A';
		di.head = head;
		di.track= track;
		di.sector = sector+1;
                di.nsectors = 1;
                di.buffer = bf;
                if(_bios_disk(_DISK_WRITE, &di) & 0xff00)
                        return(1);
        }
        PSW &= ~C;
        return(0);
}

