void HX_tool::ByteReceiver( PVOID pData, SocketClass *pSender )
{
	byte ch = (byte)pData;

	if( !sPhase.size()  )
	{
		if( 01 == ch ) 
		{//  .   -  .
			sPhase = "SOH";
			sPacketBuf += ch;
			return;
		}

		TTY_OutputSocket.Send( pData );
		return;
	}
	
	if( "SOH" == sPhase  )
	{//   -  .
		sPacketBuf += ch;

		if( 0375 == ch ) 
		{//  
			sPhase = "#"; 
			return;
		}
		if( 0376 == ch ) 
		{//  
			sPhase = "$";
			return;
		}

		//    -   SOH   .
		TTY_OutputSocket.SendByte( 01 );
		TTY_OutputSocket.Send(   pData   );

		sPhase.clear();
		sPacketBuf.clear();
		return;
	}
	
	if( "#" == sPhase )
	{//  .   -     (    ).
		uPacketSize = ch;
		sPacketBuf += ch;
		uCheckedSumm = 0;

		if( !uPacketSize )
		{//    == 0 -   1
			sPhase.clear();
			sPacketBuf.clear();
			return;
		}
		
		if( uPacketSize > MAX_SHORT_PACKET_SIZE )
		{
			//  .
			sPhase = "X";
			return;
		}
		
		sPhase = "#L";
		return;
	}

	if( "$" == sPhase )
	{//  .   -       (    ).
		uPacketSize = ch;
		uPacketSize <<= 8;

		sPacketBuf += ch;
		uCheckedSumm = 0;
		sPhase = "$L";
		return;
	}
	
	if( "$L" == sPhase )
	{//  .   -       ( ).
		uPacketSize |= ch;
		sPacketBuf += ch;

		if( !uPacketSize )
		{//    == 0 -   2 -   1.
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   = 0.

			sPhase.clear();
			sPacketBuf.clear();
			return;
		}
		sPhase = "$LL";
		return;
	}
	
	if( "#L" == sPhase || "$LL" == sPhase )
	{//    ,  .   -  .
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		if( 'C' == ch || 'R' == ch ) 
		{// C -  ; R - .
			if( !(--uPacketSize) ) 
			{//  .    .
				sPhase = "XX"; 
				return;
			} 
			sPhase += ch; 
			return; 
		} 
		//   
		sPhase = "X";
		return;
	}
	
	if( "#LC" == sPhase )
	{//    .   - .
		sPacketBuf   += ch;
		uCheckedSumm += ch;
		
		--uPacketSize;

		if( 'R' == ch )
		{// : R == "READ_RAW -   ".
			sPhase = "#LCR";
			if( !uPacketSize ) { sPhase = "XX"; } //  .    .
			return;
		}
		
		if( 'r'  == ch )
		{// : r == "READ_PACKED_STREAM -   ".
			sPhase = "#LCr";
			if( !uPacketSize ) { sPhase = "XX"; } //  .    .
			return;
		}

		if( 's' == ch )
		{// : s == " ".
			sPhase = "#LCs";

			if( !uPacketSize ) { sPhase = "XX"; } //  .    .
			return;
		}

		//  .
		sPhase = "X";
		if( !uPacketSize ) { sPhase = "XX"; } //  .    .
		return;
	}
	
	if( "#LCR" == sPhase )
	{	
		return Cmd_READ_RAW( ch );
	}

	if( "#LCr" == sPhase )
	{	
		if( St_PackData )
		{
			return Cmd_READ_PACKED_STREAM( ch );
		}
		else
		{
			return Cmd_READ_RAW( ch );
		}
	}
	
	if( "#LCs" == sPhase )
	{	
		return Cmd_SIZE( ch );
	}

	if( "$LLC" == sPhase )
	{//    .   - .
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		--uPacketSize;
		
		if( 'W' == ch )
		{// : R == "WRITE_RAW -   ".
			sPhase = "$LLCW";
			if( !uPacketSize ) { sPhase = "XX"; } //  .    .
			return;
		}
		
		//  .
		sPhase = "X";
		if( !uPacketSize ) { sPhase = "XX"; } //  .    .
		return;
	}	

	if( "$LLCW" == sPhase )
	{	
		return Cmd_WRITE_RAW( ch );
	}
	
	if( "X" == sPhase )
	{//  .
		char str[256];
		sprintf(str, LNG("HX: Bad Packet: Superfluous byte: %03o\n"), ch );
		Log( str );
	
		sPacketBuf   += ch;
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) { sPhase = "XX"; } //    .
		return;
	}
	
	if( "XX" == sPhase )
	{//  .   -    .
		Log( LNG("HX: Bad Packet: Wrong packet size !!!\n") );

		sPacketBuf += ch;

		uCheckSumm = ch;
		uCheckSumm <<= 8;
		sPhase = "XXs";
		return;
	}
	
	if( "XXs" == sPhase )
	{//  .   -    .
		uCheckSumm |= ch;
		sPacketBuf += ch;
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Log( LNG("HX: Bad Packet: CheckSum OK\n") );
			
			word ChSum = 0;
			byte ch;
		
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  2   ); //  .

			ch = 'R';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   - .

			ch = 'N';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //  - NOT SUPPORTED !!!.
			
			ch = ChSum >> 8;
			ByteOutputSocket.SendByte(  ch  ); //    .

			ch = ChSum;
			ByteOutputSocket.SendByte(  ch  ); //    .
		}
		else
		{//      .
			Log( LNG("HX: Bad Packet: CheckSum ERROR\n") );
			//   -      .
			for( int i = 0 ; i < sPacketBuf.size() ; i++ )
			{
				TTY_OutputSocket.SendByte( sPacketBuf[i] );
			}
		}
		
		sPhase.clear();
		sPacketBuf.clear();
		return;
	}

	sPhase.clear();
	sPacketBuf.clear();	
}


void HX_tool::Cmd_READ_RAW( byte ch )
{
	sPacketBuf += ch;

	if( !sCmd_READ_RAW_Phase.size() )
	{//  "  ".   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_READ_RAW_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		uBlock <<= 8;
		
		sCmd_READ_RAW_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= ch;
		
		sCmd_READ_RAW_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uWordCount = ch;
		uWordCount <<= 8;
		
		sCmd_READ_RAW_Phase = "UBBW";
		return;
	}
	
	if( "UBBW" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		uWordCount |= ch;

		if( !(--uPacketSize) ) 
		{//   .    .

			sCmd_READ_RAW_Phase = "UBBWW"; 
			return; 
		}

		//  .
		sCmd_READ_RAW_Phase.clear();
		sPhase = "X";
		return;
	}

	if( "UBBWW" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckSumm = ch;
		uCheckSumm <<= 8;
		
		sCmd_READ_RAW_Phase = "UBBWWs";
		return;
	}

	if( "UBBWWs" == sCmd_READ_RAW_Phase )
	{//   -    .
		uCheckSumm |= ch;

		sCmd_READ_RAW_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();		
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Cmd_READ_RAW_Execute();  //       .
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_READ_RAW_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_READ_RAW_Execute()
{
	char str[512];
	sprintf(str, LNG("HX: READ :  Unit: %u  |  Block: %5u  |  WordCount: %5u\n"), uUnit, uBlock, uWordCount );
	Log(str);

	byte DataBuf[1024*64];
	memset( DataBuf, 0, uWordCount*2 );
	
	int nRes = ReadDSK( uUnit, uBlock, uWordCount, (word*)DataBuf );

	word ChSum = 0;
	byte ch;
	
	if( !nRes )
	{// .
		Log( LNG("HX: ReadDSK -- ERROR\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'E';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}
	//  .

	ByteOutputSocket.SendByte( 0376 ); //  .
	
	int nSize = uWordCount*2 + 2;
	
	ch = nSize>>8;
	ByteOutputSocket.SendByte( ch ); //    .
	
	ch = nSize;
	ByteOutputSocket.SendByte( ch ); //    .

	ch = 'R';
	ChSum += ch;
	ByteOutputSocket.SendByte( ch ); //   - .

	ch = 'D';
	ChSum += ch;
	ByteOutputSocket.SendByte( ch ); //  -   .
	
	for( int i = 0 ; i < uWordCount*2 ; i++ )
	{
		ch = DataBuf[i];
		ChSum += ch;
		ByteOutputSocket.SendByte( ch );
	}
	
	ch = ChSum >> 8;
	ByteOutputSocket.SendByte( ch ); //    .

	ch = ChSum;
	ByteOutputSocket.SendByte( ch ); //    .
}


void HX_tool::Cmd_SIZE( byte ch )
{
	sPacketBuf += ch;

	//  "".   -  .
	if( !sCmd_SIZE_Phase.size() )
	{
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{//   .    .
			uUnit = ch;
			sCmd_SIZE_Phase = "U";
			return;
		}

		//  .
		sCmd_SIZE_Phase.clear();
		sPhase = "X";
		return;
	}
	
	if( "U" == sCmd_SIZE_Phase )
	{//  "".   -    .
		uCheckSumm = ch;
		uCheckSumm <<= 8;
		
		sCmd_SIZE_Phase = "Us";
		return;
	}

	if( "Us" == sCmd_SIZE_Phase )
	{//  "".   -    .
		uCheckSumm |= ch;

		sCmd_SIZE_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			word ChSum = 0;
			byte ch;

			word uDSK_Blocks = DSK_Rec[uUnit].uDSK_Blocks;

			char str[512];
			sprintf(str, LNG("HX: SIZE :  Unit: %u  |  Blocks:%5u\n"), uUnit, uDSK_Blocks );
			Log(str);

			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  4   ); //  .
			
			ch = 'R';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   - .

			ch = 's';
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //  -    .
			
			ch = uDSK_Blocks >> 8;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   .

			ch = uDSK_Blocks;
			ChSum += ch;
			ByteOutputSocket.SendByte(  ch  ); //   .

			ch = ChSum >> 8;
			ByteOutputSocket.SendByte(  ch  ); //    .

			ch = ChSum;
			ByteOutputSocket.SendByte(  ch  ); //    .

			sCmd_SIZE_Phase.clear();
			sPhase.clear();
			sPacketBuf.clear();
			
			return;
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_SIZE_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_WRITE_RAW( byte ch )
{
	sPacketBuf += ch;

	bool bWrite_OK = false;
	byte DataBuf[1024*64];

	if( !sCmd_WRITE_RAW_Phase.size() )
	{//   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_WRITE_RAW_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		uBlock <<= 8;
		
		sCmd_WRITE_RAW_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= ch;
		
		sCmd_WRITE_RAW_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uWordCount = ch;
		uWordCount <<= 8;
		
		sCmd_WRITE_RAW_Phase = "UBBW";
		return;
	}
	
	if( "UBBW" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uWordCount |= ch;
		
		uByteCount = uWordCount*2;
		
		if( uByteCount ) 
		{
			sCmd_WRITE_RAW_Phase = "UBBWW";
			memset( DataBuf, 0, uByteCount );
		}
		else
		{
			sCmd_WRITE_RAW_Phase = "UBBWWD";
			bWrite_OK = true;
		}

		char str[512];
		sprintf(str, LNG("HX: WRITE:  Unit: %u  |  Block: %5u  |  WordCount: %5u\n"), uUnit, uBlock, uWordCount );
		Log(str);
		
		return;
	}

	if( "UBBWW" == sCmd_WRITE_RAW_Phase )
	{//   -   .
		uCheckedSumm += ch;
		
		DataBuf[ uWordCount*2 - uByteCount ] = ch;

		if( !(--uByteCount) )
		{//      .
			sCmd_WRITE_RAW_Phase = "UBBWWD";

			if( (--uPacketSize) ) 
			{ //  .
				sCmd_WRITE_RAW_Phase.clear();
				sPhase = "X"; 
			}
			return;
		}
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_WRITE_RAW_Phase.clear();
			sPhase = "XX"; 
		}
		return;
	}

	if( "UBBWWD" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckSumm = ch;
		uCheckSumm <<= 8;

		sCmd_WRITE_RAW_Phase = "UBBWWDs";
		return;
	}

	if( "UBBWWDs" == sCmd_WRITE_RAW_Phase )
	{//   -    .
		uCheckSumm |= ch;

		sCmd_WRITE_RAW_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();
		
		if( uCheckSumm == uCheckedSumm )
		{//     .

			if( uWordCount )
			{
				int nRes = WriteDSK( uUnit, uBlock, uWordCount, (word*)DataBuf );
				if( nRes > 0 )
				{//  
					bWrite_OK = true;
				}
				else
				{
					Log( LNG("HX: WriteDSK -- ERROR\n") );
				}
			}
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}
		
		//   .
		
		word ChSum = 0;
		byte chr;
		
		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .
		
		chr = 'R';
		ChSum += chr;
		ByteOutputSocket.SendByte(  chr  ); //   - .

		if( bWrite_OK ) { chr = 'Y'; }  //   .
		else            { chr = 'E'; }  //    .
		
		ChSum += chr;
		ByteOutputSocket.SendByte(  chr  ); //  -    .
		
		chr = ChSum >> 8;
		ByteOutputSocket.SendByte(  chr  ); //    .

		chr = ChSum;
		ByteOutputSocket.SendByte(  chr  ); //    .
		
		return;
	}

	sCmd_WRITE_RAW_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}


void HX_tool::Cmd_READ_PACKED_STREAM( byte ch )
{
	sPacketBuf += ch;

	if( !sCmd_READ_PACKED_STREAM_Phase.size() )
	{//  "  ".   -  .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uUnit = ch;
		sCmd_READ_PACKED_STREAM_Phase = "U";
		return;
	}
	
	if( "U" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;
		
		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock = ch;
		uBlock <<= 8;
		
		sCmd_READ_PACKED_STREAM_Phase = "UB";
		return;
	}
	
	if( "UB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uBlock |= ch;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBB";
		return;
	}
	
	if( "UBB" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;

		if( !(--uPacketSize) ) 
		{ //  .    .
			sCmd_READ_PACKED_STREAM_Phase.clear();
			sPhase = "XX"; 
			return; 
		}

		uWordCount = ch;
		uWordCount <<= 8;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBW";
		return;
	}
	
	if( "UBBW" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckedSumm += ch;

		uWordCount |= ch;

		if( !(--uPacketSize) ) 
		{//   .    .

			sCmd_READ_PACKED_STREAM_Phase = "UBBWW"; 
			return; 
		}

		//  .
		sCmd_READ_PACKED_STREAM_Phase.clear();
		sPhase = "X";
		return;
	}

	if( "UBBWW" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckSumm = ch;
		uCheckSumm <<= 8;
		
		sCmd_READ_PACKED_STREAM_Phase = "UBBWWs";
		return;
	}

	if( "UBBWWs" == sCmd_READ_PACKED_STREAM_Phase )
	{//   -    .
		uCheckSumm |= ch;

		sCmd_READ_PACKED_STREAM_Phase.clear();
		sPhase.clear();
		sPacketBuf.clear();		
		
		if( uCheckSumm == uCheckedSumm )
		{//     .
			Cmd_READ_PACKED_STREAM_Execute();  //       .
		}
		else
		{//      .
			Log( LNG("HX: CheckSum ERROR !!!\n") );
			ByteOutputSocket.SendByte( 0375 ); //  .
			ByteOutputSocket.SendByte(  0   ); //   == 0.
		}

		return;
	}

	sCmd_READ_PACKED_STREAM_Phase.clear();
	sPhase.clear();
	sPacketBuf.clear();
}

void HX_tool::Cmd_READ_PACKED_STREAM_Execute()
{
	char str[512];
	sprintf(str, LNG("HX: read :  Unit: %u  |  Block: %5u  |  WordCount: %5u  "), uUnit, uBlock, uWordCount );
	Log(str);

	byte DataBuf[1024*64];
	memset( DataBuf, 0, uWordCount*2 );
	
	int nRes = ReadDSK( uUnit, uBlock, uWordCount, (word*)DataBuf );

	word ChSum = 0;
	byte ch;
	
	if( !nRes )
	{// .
		Log( LNG("HX: ReadDSK -- ERROR\n") );

		ByteOutputSocket.SendByte( 0375 ); //  .
		ByteOutputSocket.SendByte(  2   ); //  .

		ch = 'R';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //   - .

		ch = 'E';
		ChSum += ch;
		ByteOutputSocket.SendByte(  ch  ); //  -  .
		
		ch = ChSum >> 8;
		ByteOutputSocket.SendByte(  ch  ); //    .

		ch = ChSum;
		ByteOutputSocket.SendByte(  ch  ); //    .

		return;
	}
	//  .

	ByteOutputSocket.SendByte( 0374 ); //  .
	
	int nHeaderBytesSent = 0;
	int nDataBytesSent   = 0;
	int nBytesSaved      = 0;
	
	int nBytesInBuf  = uWordCount*2;
	int nBytesToCopy = 0;
	int nCopyOffset  = 0;
	for( int nOffset = 0 ; nOffset < nBytesInBuf ; )
	{
		byte chr = DataBuf[ nOffset ];

		int nRept = 1;
		while( chr == DataBuf[ nOffset+nRept ] && nRept <= 255 && nOffset+nRept < nBytesInBuf )
		{
			nRept++;
		}

		if( nRept >= 6 )
		{
			if( nBytesToCopy )
			{
				if( nBytesToCopy == 1 )
				{
					ch = 01;		         // ByteCount == 1
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;
					
					ch = 01;                 // ReptCount == 1
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;

					ch = DataBuf[ nCopyOffset++ ];
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nDataBytesSent++;

					nBytesToCopy = 0;
				}
				else
				{
					ch = nBytesToCopy;		 // ByteCount == nBytesToCopy
					ChSum += ch;
					ByteOutputSocket.SendByte( ch );
					nHeaderBytesSent++;

					while( nBytesToCopy-- )
					{
						ch = DataBuf[ nCopyOffset++ ];
						ChSum += ch;
						ByteOutputSocket.SendByte( ch );
						nDataBytesSent++;
					}

					nBytesToCopy = 0;
				}
			}
		
			ch = 01;		// ByteCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = nRept;   // ReptCount == nRept
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = chr;		// Byte == chr	
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;
			
			nBytesSaved += nRept-1;
			
			nOffset     += nRept;
			nCopyOffset += nRept;
			continue;
		}

		//  -    .
		nBytesToCopy++;
		nOffset++;

		if( nBytesToCopy < 255 ) { continue; }

		//  -   255 .

		ch = 255;		    // ByteCount == 255
		ChSum += ch;
		ByteOutputSocket.SendByte( ch );
		nHeaderBytesSent++;
		
		for( int i = 0 ; i < 255 ; i++ )
		{
			ch = DataBuf[ nCopyOffset++ ];
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;
		}
		
		nBytesToCopy = 0;
	}	

	if( nBytesToCopy )
	{
		if( nBytesToCopy == 1 )
		{
			ch = 01;		         // ByteCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;
			
			ch = 01;                 // ReptCount == 1
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			ch = DataBuf[ nCopyOffset++ ];
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nDataBytesSent++;

			nBytesToCopy = 0;
		}
		else
		{
			ch = nBytesToCopy;		 // ByteCount == nBytesToCopy
			ChSum += ch;
			ByteOutputSocket.SendByte( ch );
			nHeaderBytesSent++;

			while( nBytesToCopy-- )
			{
				ch = DataBuf[ nCopyOffset++ ];
				ChSum += ch;
				ByteOutputSocket.SendByte( ch );
				nDataBytesSent++;
			}

			nBytesToCopy = 0;
		}
	}

	ch = 00;						 //  .
	ChSum += ch;
	ByteOutputSocket.SendByte( ch );
	nHeaderBytesSent++;
	
	//*/
	
	ch = ChSum >> 8;
	ByteOutputSocket.SendByte( ch ); //    .

	ch = ChSum;
	ByteOutputSocket.SendByte( ch ); //    .
	
	if( uWordCount*2 != nDataBytesSent + nBytesSaved )
	{
		sprintf(str, LNG("\nRAW Bytes: %5u  |  Header Bytes: %5u  |  Total Sent: %5u  |  To Restore: %5u\n"), 
	                 uWordCount*2, nHeaderBytesSent, nHeaderBytesSent + nDataBytesSent, nDataBytesSent + nBytesSaved );
	}
	else
	{
		sprintf(str, LNG("|  Bytes Saved: %5i\n"), nBytesSaved - nHeaderBytesSent + 4 );
	}
	Log(str);
}
