        PAGE    0
        TITLE   '     "",  1.0'

        MACLIB  PK8020

CLS     EQU     04H
BEL     EQU     07H
TAB     EQU     09H
LF      EQU     0AH
FF      EQU     0CH
CR      EQU     0DH
ESC     EQU     1BH

CONSTS  EQU     0046H
CONIN   EQU     0049H
CONOUT  EQU     004CH
SUM     EQU     00B0H
MSGMOV  EQU     00C0H
SBEEP   EQU     00C9H
MADR    EQU     00E1H
MBYTE   EQU     00E6H
CONV    EQU     00F7H
BOOT    EQU     052DH

ICONF   SET     DOSA    ;   
ORIGIN  EQU     8000H   ;   
NEWORG  EQU     4000H   ; .  
ADRRM   EQU     0F700H
CONFIG  EQU     0F701H
SERMODE EQU     0F702H

CHANGE  MACRO   OLD,NEW
        IF      OLD EQ NEW
        EXITM
        ENDIF

        IF      OLD EQ BASG
RGBASE  SET     RGBASE4
        ELSE
        IF      (OLD EQ DOSA) OR (OLD EQ DOSG1)
RGBASE  SET     RGBASE3
        ELSE
        IF      (OLD AND 0DFH) EQ 0
RGBASE  SET     RGBASE1
        ELSE
RGBASE  SET     RGBASE2
        ENDIF
        ENDIF
        ENDIF

        di;;;;;;;;;;;;;;;;;;;;;;
        MVI     A,NEW          ;
        STA     SYSREG+RGBASE  ;
        ei;;;;;;;;;;;;;;;;;;;;;;
        ENDM

SENDMSG MACRO   MSGADR,OLD
        LXI     H,MSGADR

  IF    (OLD EQ NDOS) OR (OLD EQ ROMB1) OR (OLD EQ BASIC)
        CALL    MSGOUT
  ELSE
        IF      OLD EQ ODOSA
RGBASE  SET     RGBASE2
        ELSE
        IF      OLD EQ BASG
RGBASE  SET     RGBASE4
        ELSE
        IF      (OLD AND 0DFH) EQ 0
RGBASE  SET     RGBASE1
        ELSE
RGBASE  SET     RGBASE3
        ENDIF
        ENDIF
        ENDIF

        di;;;;;;;;;;;;;;;;;;;;;;;
        MVI     A,NDOS          ;
        STA     SYSREG+RGBASE   ;
        ei                      ;
        CALL    MSGOUT          ;
        di                      ;
        MVI     A,OLD           ;
        STA     SYSREG+RGBASE2  ;
        ei;;;;;;;;;;;;;;;;;;;;;;;
  ENDIF
        ENDM


        CSEG
LDPOINT:
        JMP     START
        RST     7
        DW      START
PGMSIZE SET     (PRLTBL-LDPOINT)
PGMSIZE SET     PGMSIZE+(PGMSIZE SHR 3)+1
LWORD   SET     PGMSIZE OR 0FFH
LWORD   SET     LWORD + 1
LWORD   SET     LWORD + (ORIGIN SHR 8)
        DW      LWORD

        ORG     100H

START:
        LXI     SP,START
        CHANGE  ICONF,NDOS
        IF      ICONF EQ DOSA
        MVI     D,HIGH (ORIGIN - 2000H)
        di;;;;;
               CALL    MOVKTDP
        ei;;;;;
        ENDIF

        MVI     A,0FFH
        STA     MSKREG+PBASE2
        SENDMSG IMSG,NDOS
BEGIN:
        CALL    CLRGR
        SENDMSG MENU,NDOS
BG1:
        SENDMSG PROMPT,NDOS
        LXI     H,FINISH
        PUSH    H
        CALL    CONIN
        PUSH    PSW
        MOV     C,A
        CALL    CONOUT
        SENDMSG MSG2,NDOS
        POP     PSW

        CPI     '0'
        JZ      TESTALL
        CPI     '1'
        JZ      VRAMTEST
        CPI     '2'
        JZ      CPUTEST
        CPI     '3'
        JZ      RAMTEST
        CPI     '4'
        JZ      ROMTEST
        CPI     '5'
        JZ      GRAMTEST
        CPI     '6'
        JZ      SCRTEST
        CPI     '7'
        JZ      KBTEST
        CPI     '8'
        JZ      SNDTEST
        CPI     '9'
        JZ      LANTEST
        CPI     'A'
        JZ      LSTTEST
        CPI     3
        JZ      BOOT
        POP     H
        JMP     BG1
FINISH:
        SENDMSG BREAK?,NDOS
FIN1:
        CALL    CONIN
        ANI     5FH
        CPI     'D'
        JZ      BOOT
        SENDMSG FFMSG,NDOS
        JMP     BEGIN
BREAK?:
        DB      '     ? (/): '
        DB      0

**********************************************************
TESTALL:
        CALL    VRAMTEST
        CALL    CPUTEST
        CALL    RAMTEST
        CALL    ROMTEST
        CALL    GRAMTEST

        SENDMSG MSG,NDOS
        SENDMSG CNTMSG,NDOS
POWTA:
        CALL    CONIN
        CPI     CR
        JNZ     POWTA

        CALL    SCRTEST
        SENDMSG CNTMSG,NDOS
POWTB:
        CALL    CONIN
        CPI     CR
        JNZ     POWTB
        CALL    KBTEST
        CALL    CLRGR
        SENDMSG FFMSG,NDOS
        CALL    SNDTEST
        CALL    LANTEST

        LDA     CONFIG
        ORA     A
        CZ      LSTTEST

        SENDMSG FMSG,NDOS
        RET

**********************************************************
RAMTEST:
        CALL    RAMLTEST
        MVI     D,HIGH (NEWORG-ORIGIN)
        CALL    MOVKTDP
        SENDMSG MOVEND,NDOS
        CALL    RAMHTEST
        MVI     D,HIGH (ORIGIN-NEWORG)
        CALL    MOVKTDP
        SENDMSG MOVEND,NDOS
        RET

**********************************************************
; /  

CLRGR:
        CHANGE  NDOS,BASG
        MVI     A,COLORMD
        STA     NCREG+RGBASE4
        LXI     H,0C000H
CLG1:
        MVI     M,0FFH
        INX     H
        MOV     A,H
        ORA     L
        JNZ     CLG1

        CHANGE  BASG,NDOS
        RET

**********************************************************
; /  

MOVKTDP:
        SENDMSG MOVMSG,NDOS

        LXI     H,LDPOINT
        SHLD    MEMPTR
        LXI     H,PRLTBL
        SHLD    TABPTR
MP05:
        LHLD    TABPTR
        MOV     B,M
        INX     H
        SHLD    TABPTR
        DCX     H
        MOV     A,H
        ADD     D
        MOV     H,A
        MOV     M,B
        MVI     C,8
MP10:
        MOV     A,B
        RLC
        MOV     B,A
        MVI     A,0
        JNC     $+4
        MOV     A,D
        LHLD    MEMPTR
        ADD     M
        MOV     E,A
        INX     H
        SHLD    MEMPTR
        DCX     H
        MOV     A,H
        ADD     D
        MOV     H,A
        MOV     M,E

        PUSH    D
        LHLD    MEMPTR
        LXI     D,PRLTBL
        MOV     A,E
        SUB     L
        MOV     A,D
        SBB     H
        POP     D
        JC      MP20
MP15:
        DCR     C
        JNZ     MP10
        JMP     MP05
MP20:
        LXI     H,0
        DAD     SP
        MOV     A,H
        ADD     D
        MOV     H,A
        SPHL
        POP     H
        MOV     A,H
        ADD     D
        MOV     H,A
        PCHL

MEMPTR:
        DS      2
TABPTR:
        DS      2
        
**********************************************************
;  

BUFFER  EQU     2000H
VRAMTEST:
        SENDMSG FFMSG,NDOS
        SENDMSG VRTMSG,NDOS

        MVI     A,ATRSET
        STA     VIREG+PBASE2
        LXI     H,VIBASE2
        LXI     D,BUFFER
VRT1:
        MOV     A,M
        STAX    D
        MVI     M,0
        INX     H
        INX     D
        MOV     A,H
        ORA     L
        JNZ     VRT1

        LHLD    0F705H
        MOV     A,H
        ANI     (HIGH BUFFER) + 3
        MOV     H,A
        SHLD    BUFPTR
;   
        LXI     B,PBASE2 + VIREG
        LXI     D,VIBASE2+1
WALOOP:
        MVI     A,ATRRES
        STAX    B
        MVI     A,0FFH
        STAX    D
        MVI     A,ATRSET
        STAX    B
        XRA     A
        STA     VIBASE2
        LXI     H,VIBASE2+1
        MVI     A,ATRFRE
        STAX    B
        MVI     C,VISTS
RALOOP:
        MOV     A,E
        CMP     L
        JNZ     RAL1
        MOV     A,D
        CMP     H
        JNZ     RAL1

        MVI     A,0FFH
        CMP     M
        JNZ     $+6
        LDAX    B
        ANI     ATRMSK
        CNZ     VRERR1
        JMP     RAL2
RAL1:
        XRA     A
        CMP     M
        JZ      $+9
        CALL    VRERR1
        JMP     RAL2
        LDAX    B
        ANI     ATRMSK
        CZ      VRERR1
RAL2:
        MOV     A,L
        ADD     A
        MOV     L,A
        JNZ     RALOOP
        MOV     A,H
        RAL
        ORI     0FCH
        MOV     H,A
        ANI     3
        JNZ     RALOOP

        MVI     C,VIREG
        MVI     A,ATRSET
        STAX    B
        XRA     A
        STAX    D
        MOV     A,E
        ADD     A
        MOV     E,A
        JNZ     WALOOP
        MOV     A,D
        RAL
        ORI     0FCH
        MOV     D,A
        ANI     3
        JNZ     WALOOP

        LXI     D,ATRMSK SHL 8
        MVI     C,VIREG
ATRT1:
        MVI     A,ATRFRE
        STAX    B
        MVI     C,VISTS
        LXI     H,VIBASE2
ATRT2:
        MOV     A,M
        CMP     E
        JNZ     $+7
        LDAX    B
        ANI     ATRMSK
        CMP     D
        CNZ     VRERR2
        INX     H
        MOV     A,H
        ORA     L
        JNZ     ATRT2

        ORA     D
        JZ      VRDTEST

        MVI     C,VIREG
        MVI     A,ATRRES
        STAX    B
        LXI     H,VIBASE2
ATRT3:
        MVI     M,0FFH
        INX     H
        MOV     A,L
        ORA     H
        JNZ     ATRT3
        LXI     D,0FFH
        JMP     ATRT1
VRDTEST:
        MVI     C,VIREG
        MVI     A,ATRRES
        STAX    B
        MVI     C,0FH
SPECVL:
        LXI     D,1
STEPVL:
        LXI     H,VIBASE2
WDVLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     A,C
        JZ      $+4
        CMA
        MOV     M,A
        INX     H
        MOV     A,H
        ORA     L
        JNZ     WDVLOOP

        LXI     H,VIBASE2
RDVLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     B,M
        MOV     A,C
        JZ      $+4
        CMA
        CMP     B
        CNZ     VRERR3
        INX     H
        MOV     A,H
        ORA     L
        JNZ     RDVLOOP

        MOV     A,E
        ADD     A
        MOV     E,A
        JNZ     STEPVL
        MOV     A,D
        RAL
        MOV     D,A
        ANI     4
        JZ      STEPVL

        MOV     A,C
        RLC
        MOV     C,A
        CPI     0FH
        JNZ     SPECVL
VRTEND:
        MVI     A,ATRRES
        STA     VIREG+PBASE2
        LXI     H,VIBASE2
        LXI     D,BUFFER
VRTxx:
        LDAX    D
        MOV     M,A
        INX     D
        INX     H
        MOV     A,H
        ORA     L
        JNZ     VRTxx

        LHLD    BUFPTR
        MOV     A,H
        ORI     HIGH    VIBASE2
        MOV     H,A
        SHLD    0F705H
        SENDMSG ENDMSG,NDOS
        RET

VRERR1:
        PUSH    D
        PUSH    H
        ORA     A
        MOV     A,M
        PUSH    PSW
        JZ      $+6
        LXI     H,VIBASE2
        PUSH    H
        LHLD    BUFPTR
        CALL    TABL
        JNC     VRE12
VRE11:
        CALL    MADR
        MVI     M,' '
        INX     H
        POP     D
        CALL    MADR
        MVI     M,' '
        INX     H
        LDAX    B
        ANI     ATRMSK
        RRC
        RRC
        RRC
        ADI     '0'
        MOV     M,A
        INX     H
        POP     PSW
        CALL    MBYTE
        SHLD    BUFPTR
        POP     H
        POP     D
        RET
VRE12:
        SHLD    BUFPTR
        POP     H
        POP     H
        POP     H
        POP     D
        POP     PSW
        JMP     VRTEND

VRERR2:
        PUSH    D
        PUSH    H
        LHLD    BUFPTR
        CALL    TABL
        JNC     VRE22
VRE21:
        POP     D
        CALL    MADR
        MVI     M,' '
        INX     H
        XCHG
        XTHL
        XCHG
        MOV     A,D
        RRC
        RRC
        RRC
        ADI     '0'
        MOV     M,A
        INX     H
        MOV     A,E
        CALL    MBYTE
        MVI     M,' '
        INX     H
        XCHG
        XTHL
        XCHG
        LDAX    B
        ANI     ATRMSK
        RRC
        RRC
        RRC
        ADI     '0'
        MOV     M,A
        INX     H
        LDAX    D
        CALL    MBYTE
        SHLD    BUFPTR
        XCHG
        POP     D
        RET
VRE22:
        SHLD    BUFPTR
        POP     H
        POP     D
        POP     PSW
        JMP     VRTEND

VRERR3:
        PUSH    D
        PUSH    B
        PUSH    PSW
        PUSH    H
        LHLD    BUFPTR
        CALL    TABL
        JC      VRE31
        SHLD    BUFPTR
        POP     H
        POP     PSW
        POP     B
        POP     D
        POP     PSW
        JMP     VRTEND
VRE31:
        POP     D
        CALL    MADR
        MVI     M,' '
        INX     H
        POP     PSW
        CALL    MBYTE
        MVI     M,' '
        INX     H
        POP     B
        MOV     A,B
        CALL    MBYTE
        SHLD    BUFPTR
        XCHG
        POP     D
        RET
TABL:
        MOV     A,L
        ANI     0FH
        JZ      $+7
        INX     H
        JMP     TABL
        MOV     A,H
        CPI     (HIGH BUFFER) + 3
        RC
        MOV     A,L
        CPI     80H
        RET
BUFPTR:
        DS      2

********************************************************
;   58080

CPUTEST:
        SENDMSG PTBMSG,NDOS
        CHANGE  NDOS,DOSA

        LXI     H,JMPERR
        LXI     D,0
        MVI     C,3
        CALL    XMOVE

        ORI     0FEH
        STC
        ANI     0
        JZ      $+4
        RST     0

        JNC     $+4
        RST     0

        JPE     $+4
        RST     0

        JP      $+4
        RST     0

        JNZ     LB1
        JC      LB1
        JPO     LB1
        JM      LB1
        JMP     $+4
LB1:
        RST     0

        ADI     6
        JNZ     $+4
        RST     0

        JC      LB2
        JPO     LB2
        JP      $+4
LB2:
        RST     0

        ADI     70H
        JPO     $+4
        RST     0

        JM      LB3
        JZ      LB3
        JNC     $+4
LB3:
        RST     0

        ADI     81H
        JM      $+4
        RST     0

        JZ      LB4
        JC      LB4
        JPO     $+4
LB4:
        RST     0

        ADI     0FEH
        JC      $+4
        RST     0

        JZ      LB5
        JPO     LB5
        JM      $+4
LB5:
        RST     0

        CPI     0
        JC      LB6
        JZ      LB6
        CPI     0F5H
        JC      LB6
        JNZ     LB6
        CPI     0FFH
        JZ      LB6
        JC      $+4
LB6:
        RST     0

        ACI     0AH
        ACI     0AH
        CPI     0BH
        JZ      $+4
        RST     0

        SUI     0CH
        SUI     0FH
        CPI     0F0H
        JZ      $+4
        RST     0

        SBI     0F1H
        SBI     0EH
        CPI     0F0H
        JZ      $+4
        RST     0

        ANI     55H
        CPI     50H
        JZ      $+4
        RST     0

        ORI     3AH
        CPI     7AH
        JZ      $+4
        RST     0

        XRI     0FH
        CPI     75H
        JZ      $+4
        RST     0

        ANI     0
        CC      LB7
        CPO     LB7
        CM      LB7
        CNZ     LB7
        CPI     0
        JZ      $+4
        RST     0

        SUI     77H
        CNC     LB7
        CPE     LB7
        CP      LB7
        CZ      LB7
        CPI     89H
        JZ      $+5
        RST     0
LB7:
        RST     0

        ANI     0FFH
        CPO     LB8
        CPI     0D9H
        JZ      LB16
        RST     0
LB8:
        RPE
        ADI     10H
        CPE     LB9
        ADI     2
        RPO
        RST     0
LB9:
        RPO
        ADI     20H
        CM      LB10
        ADI     4
        RPE
        RST     0
LB10:
        RP
        ADI     80H
        CP      LB11
        ADI     80H
        RM
        RST     0
LB11:
        RM
        ADI     40H
        CNC     LB12
        ADI     40H
        RP
        RST     0
LB12:
        RC
        ADI     8FH
        CC      LB13
        SUI     2
        RNC
        RST     0
LB13:
        RNC
        ADI     0F7H
        CNZ     LB14
        ADI     0FEH
        RC
        RST     0
LB14:
        RZ
        ADI     1
        CZ      LB15
        ADI     0D0H
        RNZ
        RST     0
LB15:
        RNZ
        ADI     47H
        CPI     47H
        RZ
        RST     0
LB16:
        MVI     A,11H
        MVI     B,22H
        MVI     C,33H
        MVI     D,44H
        MVI     E,55H
        MVI     H,66H
        MVI     L,77H
        CPI     11H
        CNZ     0
        CMP     B
        CZ      0
        CMP     C
        CZ      0
        CMP     D
        CZ      0
        CMP     E
        CZ      0
        CMP     H
        CZ      0
        CMP     L
        CZ      0
        CMP     A
        CNZ     0
        ADI     11H
        CMP     B
        CNZ     0
        ADI     11H
        CMP     C
        CNZ     0
        ADI     11H
        CMP     D
        CNZ     0
        ADI     11H
        CMP     E
        CNZ     0
        ADI     11H
        CMP     H
        CNZ     0
        ADI     11H
        CMP     L
        CNZ     0
        INR     A
        INR     B
        INR     C
        INR     D
        INR     E
        INR     H
        INR     L
        DCR     A
        DCR     B
        DCR     C
        DCR     D
        DCR     E
        DCR     H
        DCR     L
        CPI     77H
        CNZ     0
        CMP     L
        CNZ     0
        SUI     11H
        CMP     H
        CNZ     0
        SUI     11H
        CMP     E
        CNZ     0
        SUI     11H
        CMP     D
        CNZ     0
        SUI     11H
        CMP     C
        CNZ     0
        SUI     11H
        CMP     B
        CNZ     0
        MVI     A,0AAH
        MOV     B,A
        MOV     C,B
        MOV     D,C
        MOV     E,D
        MOV     H,E
        MOV     L,H
        MOV     A,L
        CPI     0AAH
        CNZ     0
        MVI     A,0BBH
        MOV     C,A
        MOV     E,C
        MOV     L,E
        MOV     B,L
        MOV     D,B
        MOV     H,D
        MOV     A,H
        CPI     0BBH
        CNZ     0
        MVI     A,0CCH
        MOV     D,A
        MOV     L,D
        MOV     C,L
        MOV     H,C
        MOV     B,H
        MOV     E,B
        MOV     A,E
        CPI     0CCH
        CNZ     0
        MVI     A,0DDH
        MOV     E,A
        MOV     B,E
        MOV     H,B
        MOV     C,H
        MOV     L,C
        MOV     D,L
        MOV     A,D
        CPI     0DDH
        CNZ     0
        MVI     A,0EEH
        MOV     H,A
        MOV     D,H
        MOV     B,D
        MOV     L,B
        MOV     E,L
        MOV     C,E
        MOV     A,C
        CPI     0EEH
        CNZ     0
        MVI     A,0FFH
        MOV     L,A
        MOV     H,L
        MOV     E,H
        MOV     D,E
        MOV     C,D
        MOV     B,C
        MOV     A,B
        CPI     0FFH
        CNZ     0
        MVI     A,0
        MVI     B,1
        MVI     C,3
        MVI     D,7
        MVI     E,0FH
        MVI     H,1FH
        MVI     L,3FH
        ADD     B
        ADD     C
        ADD     D
        ADD     E
        ADD     H
        ADD     L
        ADD     A
        CPI     0F0H
        CNZ     0
        SUB     B
        SUB     C
        SUB     D
        SUB     E
        SUB     H
        SUB     L
        CPI     78H
        CNZ     0
        SUB     A
        CNZ     0
        MVI     A,80H
        ADD     A
        MVI     B,1
        MVI     C,2
        MVI     D,3
        MVI     E,4
        MVI     H,5
        MVI     L,6
        ADC     B
        MVI     B,80H
        ADD     B
        ADD     B
        ADC     C
        ADD     B
        ADD     B
        ADC     D
        ADD     B
        ADD     B
        ADC     E
        ADD     B
        ADD     B
        ADC     H
        ADD     B
        ADD     B
        ADC     L
        ADD     B
        ADD     B
        ADC     A
        CPI     37H
        CNZ     0
        MVI     A,80H
        ADD     A
        MVI     B,1
        SBB     B
        MVI     B,0FFH
        ADD     B
        SBB     C
        ADD     B
        SBB     D
        ADD     B
        SBB     E
        ADD     B
        SBB     H
        ADD     B
        SBB     L
        CPI     0E0H
        CNZ     0
        MVI     A,80H
        ADD     A
        SBB     A
        CPI     0FFH
        CNZ     0
        MVI     A,0
        MVI     B,1
        MVI     C,2
        MVI     D,4
        MVI     E,8
        MVI     H,10H
        MVI     L,20H
        ORA     B
        ORA     C
        ORA     D
        ORA     E
        ORA     H
        ORA     L
        ORA     A
        CPI     3FH
        CNZ     0
        MVI     A,0FFH
        MVI     B,0FEH
        MVI     C,0FCH
        MVI     D,0EFH
        MVI     E,7FH
        MVI     H,0F4H
        MVI     L,0BFH
        ANA     B
        ANA     C
        ANA     D
        ANA     E
        ANA     H
        ANA     L
        ANA     A
        CPI     24H
        CNZ     0
        MVI     A,0
        MVI     B,1
        MVI     C,2
        MVI     D,4
        MVI     E,8
        MVI     H,8FH
        MVI     L,4FH
        XRA     B
        XRA     C
        XRA     D
        XRA     E
        XRA     H
        XRA     L
        CPI     0CFH
        CNZ     0
        XRA     A
        CNZ     0
        MVI     B,44H
        MVI     C,45H
        MVI     D,46H
        MVI     E,47H
        MVI     H,0
        MVI     L,4EH
        MOV     M,B
        MVI     B,0
        MOV     B,M
        MVI     A,44H
        CMP     B
        CNZ     0
        MOV     M,C
        MVI     C,0
        MOV     C,M
        MVI     A,45H
        CMP     C
        CNZ     0
        MOV     M,D
        MVI     D,0
        MOV     D,M
        MVI     A,46H
        CMP     D
        CNZ     0
        MOV     M,E
        MVI     E,0
        MOV     E,M
        MVI     A,47H
        CMP     E
LB18:
        CNZ     0
        MOV     M,H
        MVI     H,0
        MVI     L,4EH
        MOV     H,M
        MVI     A,0
        CMP     H
        CNZ     0
        MOV     M,L
        MVI     H,0
        MVI     L,4EH
        MOV     L,M
        MVI     A,4EH
        CMP     L
        CNZ     0
        MVI     H,0
        MVI     L,4EH
        MVI     A,32H
        MOV     M,A
        CMP     M
        CNZ     0
        ADD     M
        CPI     64H
        CNZ     0
        XRA     A
        MOV     A,M
        CPI     32H
        CNZ     0
        MVI     A,11H
        MVI     B,22H
        MVI     C,33H
        MVI     D,10H
        MVI     E,3
        MVI     H,5
        MVI     L,7
        NOP
        MOV     A,A
        NOP
        MOV     B,B
        NOP
        MOV     C,C
        NOP
        MOV     D,D
        NOP
        MOV     E,E
        NOP
        MOV     H,H
        NOP
        MOV     L,L
        ADD     B
        ADD     C
        ADD     D
        ADD     E
        ADD     H
        ADD     L
        CPI     85H
        CNZ     0
        MVI     H,0
        MVI     L,4EH
        MOV     A,M
        SUB     M
        CNZ     0
        MVI     A,80H
        ADD     A
        ADC     M
        CPI     33H
        CNZ     0
        MVI     A,80H
        ADD     A
        SBB     M
        CPI     0CDH
        CNZ     0
        ANA     M
        CNZ     0
        MVI     A,25H
        ORA     M
        CPI     37H
        CNZ     0
        XRA     M
        CPI     5
        CNZ     0
        MVI     A,22H
        MVI     M,55H
        INR     A
        INR     M
        DCR     A
        DCR     M
        ADD     M
        CPI     77H
        CNZ     0
        LXI     B,12FFH
        LXI     D,12FFH
        LXI     H,12FFH
        INX     B
        INX     D
        INX     H
        MVI     A,13H
        CMP     B
        CNZ     0
        CMP     D
        CNZ     0
        CMP     H
        CNZ     0
        MVI     A,0
        CMP     C
        CNZ     0
        CMP     E
        CNZ     0
        CMP     L
        CNZ     0
        DCX     B
        DCX     D
        DCX     H
        MVI     A,12H
        CMP     B
        CNZ     0
        CMP     D
        CNZ     0
        CMP     H
        CNZ     0
        MVI     A,0FFH
        CMP     C
        CNZ     0
        CMP     E
        CNZ     0
        CMP     L
        CNZ     0
        MVI     A,55H
        STA     WLOC2
        XRA     A
        LDA     WLOC2
        CPI     55H
        CNZ     0
        LHLD    WLOC1
        SHLD    WLOC2
        LDA     WLOC1
        MOV     B,A
        LDA     WLOC2
        CMP     B
        CNZ     0
        LDA     WLOC1+1
        MOV     B,A
        LDA     WLOC2+1
        CMP     B
        CNZ     0
        MVI     A,0AAH
        STA     WLOC2
        LXI     B,0
        MOV     B,H
        MOV     C,L
        XRA     A
        LDAX    B
        CPI     0AAH
        CNZ     0
        MVI     A,0FFH
        STAX    B
        XRA     A
        LDA     WLOC2
        CPI     0FFH
        CNZ     0
        MVI     A,77H
        STA     WLOC2
        LHLD    WLOC1
        LXI     D,0
        XCHG
        XRA     A
        LDAX    D
        CPI     77H
        CNZ     0
        XRA     A
        ADD     H
        ADD     L
        CNZ     0
        MVI     A,0CCH
        STAX    D
        XRA     A
        LDA     WLOC2
        CPI     0CCH
        CNZ     0
        LXI     H,7777H
        DAD     H
        MVI     A,0EEH
        CMP     H
        CNZ     0
        CMP     L
        CNZ     0
        LXI     H,5555H
        LXI     B,0FFFFH
        DAD     B
        MVI     A,55H
        CNC     0
        CMP     H
        CNZ     0
        MVI     A,54H
        CMP     L
        CNZ     0
        LXI     H,0AAAAH
        LXI     D,3333H
        DAD     D
        MVI     A,0DDH
        CMP     H
        CNZ     0
        CMP     L
        CNZ     0
        STC
        CNC     0
        CMC
        CC      0
        MVI     A,55H
        CMA
        CPI     0AAH
        CNZ     0
        XRA     A
        MVI     A,55H
        DAA
        CPI     55H
        CNZ     0
        MVI     A,88H
        ADD     A
        DAA
        CPI     76H
        CNZ     0
        XRA     A
        MVI     A,0AAH
        DAA
        CNC     0
        CPI     10H
        CNZ     0
        XRA     A
        MVI     A,9AH
        DAA
        CNC     0
        CNZ     0
        STC
        MVI     A,42H
        RLC
        CC      0
        RLC
        CNC     0
        CPI     9
        CNZ     0
        RRC
        CNC     0
        RRC
        CPI     42H
        CNZ     0
        RAL
        RAL
        CNC     0
        CPI     8
        CNZ     0
        RAR
        RAR
        CC      0
        CPI     2
        CNZ     0
        LXI     B,1234H
        LXI     D,0AAAAH
        LXI     H,5555H
        XRA     A
        PUSH    B
        PUSH    D
        PUSH    H
        PUSH    PSW
        LXI     B,0
        LXI     D,0
        LXI     H,0
        MVI     A,0C0H
        ADI     0F0H
        POP     PSW
        POP     H
        POP     D
        POP     B
        CC      0
        CNZ     0
        CPO     0
        CM      0
        MVI     A,12H
        CMP     B
        CNZ     0
        MVI     A,34H
        CMP     C
        CNZ     0
        MVI     A,0AAH
        CMP     D
        CNZ     0
        CMP     E
        CNZ     0
        MVI     A,55H
        CMP     H
        CNZ     0
        CMP     L
        CNZ     0
        LXI     H,0
        DAD     SP
        SHLD    SPLOC
        LXI     SP,STACK
        DCX     SP
        DCX     SP
        INX     SP
        DCX     SP
        MVI     A,55H
        STA     STACK-2
        CMA
        STA     STACK-1
        POP     B
        CMP     B
        CNZ     0
        CMA
        CMP     C
        CNZ     0
        LXI     H,STACK
        SPHL
        LXI     H,7733H
        DCX     SP
        DCX     SP
        XTHL
        LDA     STACK-1
        CPI     77H
        CNZ     0
        LDA     STACK-2
        CPI     33H
        CNZ     0
        MVI     A,55H
        CMP     L
        CNZ     0
        CMA
        CMP     H
        CNZ     0
        LHLD    SPLOC
        SPHL
        LXI     H,LB20
        PCHL
        CALL    0
LB20:
        LXI     H,RSTTBL
        LXI     D,0
        MVI     C,3BH
        CALL    XMOVE
        RST     0
        CPI     0
        JZ      LB21
        LXI     H,RSTTBL
        LXI     D,0
        MVI     C,3BH
        CALL    XMOVE
        CALL    0
LB21:
        RST     1
        CPI     1
        CNZ     0
        RST     2
        CPI     2
        CNZ     0
        RST     3
        CPI     3
        CNZ     0
        RST     4
        CPI     4
        CNZ     0
        RST     5
        CPI     5
        CNZ     0
        RST     6
        CPI     6
        CNZ     0
        RST     7
        CPI     7
        CNZ     0
        LXI     H,RSTTBL
        LXI     D,0
        MVI     C,3BH
        CALL    XMOVE

        LXI     H,JMPERR
        LXI     D,0
        MVI     C,3
        CALL    XMOVE
        CHANGE  DOSA,NDOS
        SENDMSG ENDMSG,NDOS
        RET

CPUERR:
        LXI     H,JMPERR
        LXI     D,0
        MVI     C,3
        CALL    XMOVE
        CHANGE  DOSA,NDOS
        SENDMSG CPUERM,NDOS
        POP     H
        CALL    DADR
        SENDMSG MSG,NDOS
        RET

XMOVE:
        MOV     A,M
        XCHG
        MOV     B,M
        MOV     M,A
        XCHG
        MOV     M,B
        INX     H
        INX     D
        DCR     C
        JNZ     XMOVE
        RET

WLOC1:
        DW      WLOC2
WLOC2:
        DS      2

        DS      5
        DS      1
        DS      1
STACK:
        DS      1
SPLOC:
        DS      2
JMPERR:
        JMP     CPUERR
RSTTBL:
        MVI     A,0
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,1
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,2
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,3
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,4
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,5
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,6
        RET
        NOP
        NOP
        NOP
        NOP
        NOP

        MVI     A,7
        RET

***********************************************************
;    

RAMLTEST:
        SENDMSG RAMLMSG,NDOS
        CHANGE  NDOS,DOSA
;     

        LXI     B,8004H
FLLOOP:
        DCX     B
        MVI     A,0FFH
        STAX    B
        MOV     A,C
        ORA     B
        JNZ     FLLOOP

        LXI     D,1
WALLOOP:
        LDAX    B
        CMA
        STAX    D
        CMA
        STAX    B
        LXI     H,1
RALLOOP:
        MOV     A,E
        CMP     L
        JNZ     RALL1
        MOV     A,D
        CMP     H
        JNZ     RALL1

        LDAX    B
        CMA
        CMP     M
        CNZ     RLAERR
        JMP     RALL2
RALL1:
        LDAX    B
        CMP     M
        CNZ     RLAERR
RALL2:
        DAD     H
        JNC     RALLOOP

        LDAX    B
        STAX    D
        XCHG
        DAD     H
        XCHG
        JNC     WALLOOP

        CHANGE  DOSA,NDOS
        MVI     A,'*'
        CALL    PUTCON
        SENDMSG MSG,NDOS
;     

RDLTEST:
        MVI     C,0FH
        XRA     A
        STA     PASSNUM
SPECL:
        PUSH    B
        SENDMSG PASSMSG,NDOS
        LDA     PASSNUM
        CALL    DBYTE
        MVI     A,TAB
        CALL    PUTCON
        POP     B
        CHANGE  NDOS,DOSA
        LXI     D,1
STEPL:
        LXI     H,8000H
WDLLOOP:
        DCX     H
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     A,C
        JZ      $+4
        CMA
        MOV     M,A
        MOV     A,H
        ORA     L
        JNZ     WDLLOOP

        LXI     H,208
        DCX     H
        MOV     A,H
        ORA     L
        JNZ     $-3

        LXI     H,8000H
RDLLOOP:
        DCX     H
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     B,M
        MOV     A,C
        JZ      $+4
        CMA
        CMP     B
        CNZ     RLDERR
        MOV     A,H
        ORA     L
        JNZ     RDLLOOP

        MOV     A,E
        ADD     A
        MOV     E,A
        JNZ     STEPL
        MOV     A,D
        RAL
        MOV     D,A
        ANI     80H
        JZ      STEPL

        CHANGE  DOSA,NDOS
        MVI     A,'*'
        CALL    PUTCON
        SENDMSG MSG,NDOS
        LXI     H,PASSNUM
        INR     M

        MOV     A,C
        RLC
        MOV     C,A
        CPI     0FH
        JNZ     SPECL
        RET

RLAERR:
        PUSH    B
        PUSH    D
        PUSH    H
        ORA     A
        MOV     A,M
        PUSH    PSW
        JNZ     $+5
        MOV     L,C
        MOV     H,B
        PUSH    H
        PUSH    D
        CHANGE  DOSA,NDOS
        SENDMSG RAMERM,NDOS
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     PSW
        CALL    DBYTE
        SENDMSG MSG,NDOS
        CHANGE  NDOS,DOSA
        POP     H
        POP     D
        POP     B
        RET

RLDERR:
        PUSH    D
        PUSH    B
        PUSH    PSW
        PUSH    H
        CHANGE  DOSA,NDOS
        SENDMSG RAMERM,NDOS
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     PSW
        CALL    DBYTE
        MVI     A,' '
        CALL    PUTCON
        POP     B
        MOV     A,B
        CALL    DBYTE
        PUSH    H
        SENDMSG MSG,NDOS
        CHANGE  NDOS,DOSA
        POP     H
        POP     D
        RET

PASSMSG:
        DB      TAB,' #',0
PASSNUM:
        DS      1

*********************************************************
;    

RAMHTEST:
        SENDMSG RAMHMSG,NDOS
        CALL    SAVESL
        CHANGE  NDOS,TRS80
;     
        LXI     B,7FFCH
        XRA     A
FHLOOP:
        STAX    B
        INX     B
        CMP     B
        JNZ     FHLOOP

        DCX     B
        LXI     D,0FFFEH
WAHLOOP:
        LDAX    B
        CMA
        STAX    D
        CMA
        STAX    B
        LXI     H,0FFFEH
RAHLOOP:
        MOV     A,E
        CMP     L
        JNZ     RAHL1
        MOV     A,D
        CMP     H
        JNZ     RAHL1

        LDAX    B
        CMA
        CMP     M
        CNZ     RHAERR
        JMP     RAHL2
RAHL1:
        LDAX    B
        CMP     M
        CNZ     RHAERR
RAHL2:
        STC
        MOV     A,L
        RAL
        MOV     L,A
        MOV     A,H
        RAL
        MOV     H,A
        JC      RAHLOOP

        LDAX    B
        STAX    D

        STC
        MOV     A,E
        RAL
        MOV     E,A
        MOV     A,D
        RAL
        MOV     D,A
        JC      WAHLOOP

        CHANGE  TRS80,NDOS
        CALL    SAVESL
        MVI     A,'*'
        CALL    PUTCON
        SENDMSG MSG,NDOS
;     

RDHTEST:
        MVI     C,0FH
        XRA     A
        STA     PASSNUM
SPECHL:
        PUSH    B
        SENDMSG PASSMSG,NDOS
        LDA     PASSNUM
        CALL    DBYTE
        MVI     A,TAB
        CALL    PUTCON
        CALL    SAVESL
        CHANGE  NDOS,TRS80
        POP     B
        LXI     D,1
STEPHL:
        LXI     H,8000H
WDHLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     A,C
        JZ      $+4
        CMA
        MOV     M,A
        INX     H
        MOV     A,H
        ORA     L
        JNZ     WDHLOOP

        LXI     H,208
        DCX     H
        MOV     A,H
        ORA     L
        JNZ     $-3

        LXI     H,8000H
RDHLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     B,M
        MOV     A,C
        JZ      $+4
        CMA
        CMP     B
        CNZ     RHDERR
        INX     H
        MOV     A,H
        ORA     L
        JNZ     RDHLOOP

        MOV     A,E
        ADD     A
        MOV     E,A
        JNZ     STEPHL
        MOV     A,D
        RAL
        MOV     D,A
        ANI     80H
        JZ      STEPHL

        PUSH    B
        CHANGE  TRS80,NDOS
        CALL    SAVESL
        MVI     A,'*'
        CALL    PUTCON
        SENDMSG MSG,NDOS
        LXI     H,PASSNUM
        INR     M
        POP     B
        MOV     A,C
        RLC
        MOV     C,A
        CPI     0FH
        JNZ     SPECHL
        RET

RHAERR:
        PUSH    B
        PUSH    D
        PUSH    H
        ORA     A
        MOV     A,M
        PUSH    PSW
        JZ      $+5
        MOV     L,C
        MOV     H,B
        PUSH    H
        PUSH    D
        CHANGE  TRS80,NDOS
        CALL    SAVESL
        SENDMSG RAMERM,NDOS
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     PSW
        CALL    DBYTE
        SENDMSG MSG,NDOS
        CALL    SAVESL
        CHANGE  NDOS,TRS80
        POP     H
        POP     D
        POP     B
        RET

SAVESL:
        LXI     H,BUFFER
        LXI     D,0F700H
        MVI     C,0
        CALL    XMOVE
        RET

RHDERR:
        PUSH    D
        PUSH    B
        PUSH    PSW
        PUSH    H
        CHANGE  TRS80,NDOS
        CALL    SAVESL
        SENDMSG RAMERM,NDOS
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     PSW
        CALL    DBYTE
        MVI     A,' '
        CALL    PUTCON
        POP     B
        MOV     A,B
        CALL    DBYTE
        PUSH    B
        PUSH    H
        SENDMSG MSG,NDOS
        CALL    SAVESL
        CHANGE  NDOS,TRS80
        POP     H
        POP     B
        POP     D
        RET

*************************************************************
;  

KS0     EQU     0FFH
KS1     EQU     0FFH
KS2     EQU     0FFH

ROMTEST:
        SENDMSG ROMMSG,NDOS
        CHANGE  NDOS,BASIC
        LXI     H,0
        LXI     D,1FFFH
        MOV     B,L

        CALL    SUM
        CPI     KS0
        JZ      $+7
        MOV     A,B
        ORI     1
        MOV     B,A
        MOV     A,D
        ADI     20H
        MOV     D,A

        CALL    SUM
        CPI     KS1
        JZ      $+7
        MOV     A,B
        ORI     2
        MOV     B,A
        MOV     A,D
        ADI     20H
        MOV     D,A

        CALL    SUM
        CPI     KS2
        JZ      $+7
        MOV     A,B
        ORI     4
        MOV     B,A

        MOV     A,B
        ORA     A
        PUSH    PSW

        CHANGE  BASIC,NDOS      
        SENDMSG ENDMSG,NDOS

        POP     PSW
        RZ

        MVI     C,3
        RRC
        CC      ROMERR
        DCR     C
        JNZ     $-5
        MVI     C,BEL
        CALL    CONOUT
        RET

ROMERR:
        PUSH    PSW
        PUSH    B
        SENDMSG ROMERM,NDOS
        POP     B
        PUSH    B
        MVI     A,3
        SUB     C
        CALL    CONV
        MOV     C,A
        CALL    CONOUT
        SENDMSG MSG,NDOS
        POP     B
        POP     PSW
        RET

************************************************************
GRAMTEST:
        SENDMSG GRMSG,NDOS
        CHANGE  NDOS,ROMB2
        SENDMSG GCONFM,ROMB2

        XRA     A
        STA     GCONF
        LXI     B,5546H
        LXI     D,NCREG+RGBASE1
        LXI     H,0C000H
GCONL1:
        MOV     A,C
        STAX    D
        MVI     M,0FFH
        INR     A
        STAX    D
        MOV     M,B
        MVI     M,0
        MOV     A,M
        CMP     B
        JNZ     GCONL2
        MVI     M,0FFH
        MOV     A,C
        STAX    D
        MOV     M,B
        MVI     M,0
        MOV     A,M
        CMA
        CMP     B
        MVI     M,0FFH
GCONL2:
        LDA     GCONF
        JNZ     $+5
        ORI     40H
        RLC
        RLC
        STA     GCONF
        
        MOV     A,C
        RRC
        ORI     8
        ANI     7EH
        MOV     C,A
        CPI     0EH
        JNZ     GCONL1

        LXI     B,PAGREG+PBASE1
        MVI     A,1CH
        STA     NCRCOPY
GCONL3:
        LDA     GCONF
        ANI     3
        JNZ     GCONL4
        PUSH    H
        SENDMSG ABSENT,ROMB2
        POP     H
        STC
        JMP     GCONL5
GCONL4:
        LDAX    B
        ORI     0C0H
        STAX    B
        LDA     NCRCOPY
        STAX    D
        MVI     M,0FFH
        INR     A
        STAX    D
        MVI     M,4

        LDAX    B
        ANI     7FH
        STAX    B
        LDA     NCRCOPY
        STAX    D
        MVI     M,0FFH
        INR     A
        STAX    D
        MVI     M,2

        LDAX    B
        ANI     3FH
        STAX    B
        LDA     NCRCOPY
        STAX    D
        MVI     M,0FFH
        INR     A
        STAX    D
        MVI     M,1

        LDAX    B
        ORI     0C0H
        STAX    B
        MOV     A,M
        PUSH    PSW
        CHANGE  ROMB2,NDOS
        POP     PSW
        PUSH    PSW
        ADI     '0'
        CALL    PUTCON
        PUSH    H
        SENDMSG x16k,NDOS
        POP     H
        CHANGE  NDOS,ROMB2
        POP     PSW
        CPI     2
GCONL5:
        PUSH    B
        LDA     GCONF
        JC      GCONL6
        MVI     C,2
        JNZ     $+4
        INR     C
        ANI     0FCH
        ORA     C
GCONL6:
        RRC
        RRC
        STA     GCONF
        POP     B
        LDA     NCRCOPY
        RLC
        ORI     2
        ANI     6EH
        STA     NCRCOPY
        CPI     0EH
        JNZ     GCONL3

        LDAX    B
        ANI     3CH
        STAX    B
        CHANGE  ROMB2,NDOS
        SENDMSG MSG,NDOS
        LDA     GCONF
        RRC
        RRC
        STA     GCONF
GRDTEST:
        XRA     A
        STA     PLNNUM
        MVI     A,1CH
        STA     NCRCOPY
GRTLOOP:
        LDA     GCONF
        ANI     3
        JZ      GRTEND

        SENDMSG PLAINM,NDOS
        LDA     PLNNUM
        ADI     '0'
        CALL    PUTCON
        MVI     A,TAB
        CALL    PUTCON
        CHANGE  NDOS,ROMB2
        MVI     C,0FH
SPECGL:
        LXI     D,1
STEPGL:
        MVI     B,0FFH
        LXI     H,0C000H
        LDA     NCRCOPY
        STA     NCREG+RGBASE1
FGLOOP:
        MOV     M,B
        INX     H
        MOV     A,L
        ORA     H
        JNZ     FGLOOP

        LXI     H,0C000H
        LDA     NCRCOPY
        INR     A
        STA     NCREG+RGBASE1
WDGLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     A,C
        JZ      $+4
        CMA
        MOV     M,A
        INX     H
        MOV     A,L
        ORA     H
        JNZ     WDGLOOP

        LXI     H,0C000H
RDGLOOP:
        MOV     A,E
        ANA     L
        JNZ     $+5
        MOV     A,D
        ANA     H
        MOV     B,M
        MOV     A,C
        JZ      $+4
        CMA
        CMP     B
        CNZ     GRDERR
        INX     H
        MOV     A,L
        ORA     H
        JNZ     RDGLOOP

        MOV     A,E
        ADD     A
        MOV     E,A
        JNZ     STEPGL
        MOV     A,D
        RAL
        MOV     D,A
        ANI     40H
        JZ      STEPGL

        MOV     A,C
        XRI     0FFH
        MOV     C,A
        JM      SPECGL
        CPI     0FH
        JNZ     $+8
        MVI     C,33H
        JMP     SPECGL
        CPI     33H
        JNZ     $+8
        MVI     C,55H
        JMP     SPECGL

        LDA     NCRCOPY
        STA     NCREG+RGBASE1
        MVI     B,0FFH
        LXI     H,0C000H
CLPLOOP:
        MOV     M,B
        INX     H
        MOV     A,L
        ORA     H
        JNZ     CLPLOOP

        CHANGE  ROMB2,NDOS
        SENDMSG ENDMSG+1,NDOS
GRTEND:
        LDA     NCRCOPY
        RLC
        ORI     2
        ANI     6EH
        STA     NCRCOPY
        LDA     GCONF
        RRC
        RRC
        STA     GCONF
        LDA     PLNNUM
        INR     A
        STA     PLNNUM
        CPI     3
        JC      GRTLOOP
        RET
GRDERR:
        PUSH    D
        PUSH    B
        PUSH    PSW
        PUSH    H
        CHANGE  ROMB2,NDOS
        SENDMSG GRDERM,NDOS
        POP     H
        CALL    DADR
        MVI     A,' '
        CALL    PUTCON
        POP     PSW
        CALL    DBYTE
        MVI     A,' '
        CALL    PUTCON
        POP     B
        MOV     A,B
        CALL    DBYTE
        PUSH    H
        SENDMSG MSG,NDOS
        CHANGE  NDOS,ROMB2
        POP     H
        POP     D
        RET

GRMSG:
        DB      ' ',CR,LF
        DB      0
GCONFM:
        DB      '    :       #0'
        DB      '      #1      #2'
        DB      CR,LF,TAB,TAB,TAB,0
ABSENT:
        DB      ' ',0
x16k:
        DB      'x16       ',0
PLAINM:
        DB      TAB,'   #',0
GRDERM:
        DB      TAB,' :   ',0

PLNNUM:
        DS      1
GCONF:
        DS      1
NCRCOPY:
        DS      1

************************************************************
PTTEST:
        SENDMSG PTMSG,NDOS
        SENDMSG SORRY,NDOS
        RET

PTMSG:
        DB      ' :',TAB
        DB      0

************************************************************
PICTEST:
        SENDMSG PICMSG,NDOS
        SENDMSG SORRY,NDOS
        RET

PICMSG:
        DB      ' :',TAB
        DB      0

************************************************************
SCRTEST:
        SENDMSG SCRMSG,NDOS
SCRT1:
        CALL    CONIN
        CPI     CR
        JNZ     SCRT1

        SENDMSG GRFMSG,NDOS
        CHANGE  NDOS,DOSG1
        MVI     A,COLORMD + WRMSK
        STA     NCREG+RGBASE3

        LXI     H,4000H
        LXI     D,40H
        LXI     B,0C000H
GLOOP1:
        MOV     M,B
        MOV     A,B
        RRC
        RRC
        MOV     B,A
        JNC     $+4
        INX     H
        DAD     D
        DCR     C
        JNZ     GLOOP1

        LXI     H,7FC0H
        LXI     D,-40H
        LXI     B,0C000H
GLOOP2:
        MOV     M,B
        MOV     A,B
        RRC
        RRC
        MOV     B,A
        JNC     $+4
        INX     H
        DAD     D
        DCR     C
        JNZ     GLOOP2

        MVI     A,0FFH
        LXI     H,5FDEH
        MOV     M,A
        INX     H
        MOV     M,A
        INX     H
        MOV     M,A
        INX     H
        MOV     M,A

        LXI     H,601EH
        MOV     M,A
        INX     H
        MOV     M,A
        INX     H
        MOV     M,A
        INX     H
        MOV     M,A

        LXI     H,601FH - 512
        LXI     D,40H
        LXI     B,110H
GLOOP3:
        MOV     M,B
        DAD     D
        DCR     C
        JNZ     GLOOP3

        LXI     H,6020H - 512
        LXI     B,8010H
GLOOP4:
        MOV     M,B
        DAD     D
        DCR     C
        JNZ     GLOOP4

        LXI     H,4000H
        MVI     C,8
GLOOP5:
        MOV     A,M
        ORA     A
        JNZ     GLOOP6
        INX     H
        JMP     GLOOP5
GLOOP6:
        MVI     M,0FFH
        INX     H
        MOV     A,M
        ORA     A
        JZ      GLOOP6

        MVI     M,0FFH
        MOV     B,A
        LXI     D,40H
GLOOP7:
        DAD     D
        MOV     A,M
        MOV     M,B
        ANI     3
        JZ      GLOOP7
GLOOP8:
        MVI     M,0FFH
        DCX     H
        MOV     A,M
        ORA     A
        JZ      GLOOP8

        MVI     M,0FFH
        MOV     B,A
        LXI     D,-40H
GLOOP9:
        DAD     D
        MOV     A,M
        MOV     M,B
        ANI     0C0H
        JZ      GLOOP9

        LXI     D,1024
        DAD     D
        INX     H
        DCR     C
        JNZ     GLOOP5

        CHANGE  DOSG1,NDOS
        SENDMSG CNTMSG,NDOS
SCRT2:
        CALL    CONIN
        CPI     CR
        JNZ     SCRT2

        CALL    CLRGR
        SENDMSG LUTMSG,NDOS
        CHANGE  NDOS,DOSG1

        LXI     H,400DH
        MVI     B,COLORMD+WRMSK
        MVI     C,8
GLOOP10:
        MOV     A,B
        STA     NCREG+RGBASE3
        MVI     D,20H
GLOOP11:
        MVI     E,20H
GLOOP12:
        MVI     M,0FFH
        INX     H
        DCR     E
        JNZ     GLOOP12
        MOV     A,L
        ADI     20H
        MOV     L,A
        MOV     A,H
        ACI     0
        MOV     H,A
        DCR     D
        JNZ     GLOOP11
        MOV     A,B
        SUI     2
        MOV     B,A
        DCR     C
        JNZ     GLOOP10

        CHANGE  DOSG1,NDOS
        RET

************************************************************
KBTEST:
        SENDMSG KBMSG,NDOS
        CALL    CLRGR

        CHANGE  NDOS,DOSG1
        MVI     A,COLORMD+WRMSK
        STA     NCREG+RGBASE3

        LXI     H,KBTBL
        MVI     C,NKEYS
KBT10:
        PUSH    B
        PUSH    H
        CALL    FKEY
        POP     H
        LXI     D,4
        DAD     D
        POP     B
        DCR     C
        JNZ     KBT10

        CHANGE  DOSG1,NDOS
        LXI     H,KEYTBL
        MVI     C,9
        MVI     M,0FFH
        INX     H
        DCR     C
        JNZ     $-4
        MVI     M,43H
        INX     H
        MVI     M,1FH

        SENDMSG KBMSG2,NDOS
KB1     EQU     KBBASE2+0FFH
KB2     EQU     KBBASE2+107H
INKEY:
        LXI     D,KB1
        LXI     H,KB2
        LDAX    D
        ORA     M
        JZ      INKEY
        XRA     A
        DCR     A
        JNZ     $-1
        LDAX    D
        ORA     M
        JZ      INKEY
        MVI     E,KB07
        LXI     H,KB06+KBBASE2
        LDAX    D
        RRC
        RRC
        RRC
        ANA     M
        ANI     4
        JNZ     EXIT

INK0:
        LXI     D,1
        LXI     B,0B00H
INK1:
        LXI     H,KBBASE2
        DAD     D
        MOV     A,M
        ORA     A
        JNZ     INK2
        MOV     A,E
        RLC
        MOV     E,A
        MOV     A,D
        ACI     0
        MOV     D,A
        INR     C
        DCR     B
        JNZ     INK1
        JMP     INKEY
INK2:
        PUSH    H
        LXI     H,KEYTBL
        MVI     B,0
        DAD     B
        MOV     B,A
        MOV     A,C
        RLC
        RLC
        RLC
        MOV     C,A
        MVI     E,1
INK3:
        MOV     A,E
        ANA     B
        JNZ     INK4
        INR     C
        MOV     A,E
        RLC
        MOV     E,A
        JNC     INK3
        POP     H
        JMP     INK0
INK4:
        PUSH    D
        MOV     A,M
        XRA     E
        MOV     M,A
        ANA     E
        MVI     A,COLORMD+WRMSK
        JNZ     $+5
        ANI     COLORMD+4
        STA     NCREG+RGBASE2
        CHANGE  NDOS,DOSG1
        LXI     H,KBTBL
        LXI     D,4
        MVI     B,80
INK10:
        MOV     A,M
        CMP     C
        JZ      INK11
        DAD     D
        DCR     B
        JNZ     INK10
        POP     D
        POP     H
        CHANGE  DOSG1,NDOS
        JMP     KBTEST
INK11:
        CALL    FKEY
        CHANGE  DOSG1,NDOS

        LXI     D,KB07+KBBASE2
        LXI     H,KB06+KBBASE2
        LDAX    D
        RRC
        RRC
        RRC
        ANA     M
        ANI     4
        POP     D
        POP     H
        JNZ     EXIT

INK12:
        LXI     B,0
INK13:
        MOV     A,M
        ANA     E
        JZ      INK14
        DCX     B
        MOV     A,C
        ORA     B
        JNZ     INK13
        JMP     INK15
INK14:
        DCR     A
        JNZ     $-1
        MOV     A,M
        ANA     E
        JNZ     INK12
INK15:
        LXI     H,KEYTBL
        MVI     C,11
INK16:
        ORA     M
        INX     H
        DCR     C
        JNZ     INK16
        ORA     A
        JNZ     INKEY
EXIT:
        MVI     A,CR
        CALL    PUTCON
        MVI     A,CLS
        CALL    PUTCON
        RET

FKEY:
        MVI     C,30
        INX     H
        MOV     E,M
        INX     H
        MOV     D,M
        INX     H
        MOV     B,M
        XCHG
        LXI     D,40H
FK1:
        PUSH    B
        PUSH    H
        MVI     M,0FFH
        INX     H
        DCR     B
        JNZ     $-4
        POP     H
        POP     B
        DAD     D
        DCR     C
        JNZ     FK1
        RET

KEYTBL:
        DS      11
KBMSG:
        DB      FF,CLS,TAB,TAB
        DB      '   '
        DB      CR,LF,LF
        DB      '   F6   F7   F8   F9  F10'
        DB      TAB,TAB,'       '
        DB      CR,LF
        DB      ' F1   F2   F3   F4   F5'
        DB      CR,LF
        DB      '  +  1  2  3  4  5  6  7 '
        DB      ' 8  9  0  -  _ '
        DB      CR,LF
        DB      '    ;  !  "  #  $  %  &  '
        DB      27H,'  (  )     =',TAB,TAB
        DB      '  7  8  9'
        DB      CR,LF
        DB      '                ['
        DB      ' ]     :'
        DB      CR,LF
        DB      '      J  C  U  K  E  N  G  {'
        DB      '  }  Z  H *   ',TAB
        DB      '  4  5  6'
        DB      CR,LF
        DB      '                '
        DB      '       \ .'
        DB      CR,LF
        DB      '       F  Y  W  A  P  R  O'
        DB      '  L  D  V  | >',TAB
        DB      '  1  2  3'
        DB      CR,LF
        DB      '      ^          '
        DB      '   @ ,  /   '
        DB      CR,LF
        DB      '        Q  ~  S  M  I  T  X'
        DB      '  B  ` <  ?',TAB,TAB
        DB      '  0   .'
        DB      CR,LF
        DB      '    ',TAB,TAB,TAB
        DB      '    '
        DB      CR,LF,LF
        DB      0
KBMSG2:
        DB      '   , '
        DB      '    .'
        DB      CR,LF
        DB      '    '
        DB      '     '
        DB      0

KBTBL:
;F1/F6
        DB      120O
        DW      4841H
        DB      4
;F2/F7
        DB      121O
        DW      4846H
        DB      4
;F3/F8
        DB      122O
        DW      484BH
        DB      4
;F4/F9
        DB      123O
        DW      4850H
        DB      4
;F5/F10
        DB      124O
        DW      4855H
        DB      4
;
        DB      62O
        DW      4869H
        DB      4
;
        DB      73O
        DW      5041H
        DB      2
;+/;
        DB      53O
        DW      5044H
        DB      2
;1/!
        DB      41O
        DW      5047H
        DB      2
;2/"
        DB      42O
        DW      504AH
        DB      2
;3/#
        DB      43O
        DW      504DH
        DB      2
;4/$
        DB      44O
        DW      5050H
        DB      2
;5/%
        DB      45O
        DW      5053H
        DB      2
;6/&
        DB      46O
        DW      5056H
        DB      2
;7/'
        DB      47O
        DW      5059H
        DB      2
;8/(
        DB      50O
        DW      505CH
        DB      2
;9/)
        DB      51O
        DW      505FH
        DB      2
;0/
        DB      40O
        DW      5062H
        DB      2
;-/=
        DB      55O
        DW      5065H
        DB      2
;/_
        DB      37O
        DW      5068H
        DB      2
;
        DB      65O
        DW      506BH
        DB      2
;
        DB      66O
        DW      5841H
        DB      3
;/J
        DB      12O
        DW      5845H
        DB      2
;/C
        DB      03O
        DW      5848H
        DB      2
;/U
        DB      25O
        DW      584BH
        DB      2
;/K
        DB      13O
        DW      584EH
        DB      2
;/E
        DB      05O
        DW      5851H
        DB      2
;/N
        DB      16O
        DW      5854H
        DB      2
;/G
        DB      07O
        DW      5857H
        DB      2
;/[
        DB      33O
        DW      585AH
        DB      2
;/]
        DB      35O
        DW      585DH
        DB      2
;/Z
        DB      32O
        DW      5860H
        DB      2
;/H
        DB      10O
        DW      5863H
        DB      2
;:/*
        DB      52O
        DW      5866H
        DB      2
;
        DB      60O
        DW      5869H
        DB      4
;
        DB      75O
        DW      6041H
        DB      4
;/F
        DB      06O
        DW      6046H
        DB      2
;/Y
        DB      31O
        DW      6049H
        DB      2
;/W
        DB      27O
        DW      604CH
        DB      2
;/A
        DB      01O
        DW      604FH
        DB      2
;/P
        DB      20O
        DW      6052H
        DB      2
;/R
        DB      22O
        DW      6055H
        DB      2
;/O
        DB      17O
        DW      6058H
        DB      2
;/L
        DB      14O
        DW      605BH
        DB      2
;/D
        DB      04O
        DW      605EH
        DB      2
;/V
        DB      26O
        DW      6061H
        DB      2
;/|
        DB      34O
        DW      6064H
        DB      2
;./>
        DB      56O
        DW      6067H
        DB      2
;-
        DB      70O
        DW      6841H
        DB      5
;/Q
        DB      21O
        DW      6847H
        DB      2
;/^
        DB      36O
        DW      684AH
        DB      2
;/S
        DB      23O
        DW      684DH
        DB      2
;/M
        DB      15O
        DW      6850H
        DB      2
;/I
        DB      11O
        DW      6853H
        DB      2
;/T
        DB      24O
        DW      6856H
        DB      2
;/X
        DB      30O
        DW      6859H
        DB      2
;/B
        DB      02O
        DW      685CH
        DB      2
;/@
        DB      0
        DW      685FH
        DB      2
;,/<
        DB      54O
        DW      6862H
        DB      2
;//?
        DB      57O
        DW      6865H
        DB      2
;-
        DB      77O
        DW      6868H
        DB      5
;
        DB      76O
        DW      7043H
        DB      4
;
        DB      71O
        DW      7048H
        DB      2
;
        DB      67O
        DW      704BH
        DB      23
;
        DB      72O
        DW      7063H
        DB      2
;
        DB      74O
        DW      7066H
        DB      4
;
        DB      63O
        DW      4871H
        DB      2
;
        DB      64O
        DW      4874H
        DB      2
;
        DB      61O
        DW      4877H
        DB      2
;7
        DB      107O
        DW      5071H
        DB      2
;8
        DB      110O
        DW      5074H
        DB      2
;9
        DB      111O
        DW      5077H
        DB      2
;4
        DB      104O
        DW      5871H
        DB      2
;5
        DB      105O
        DW      5874H
        DB      2
;6
        DB      106O
        DW      5877H
        DB      2
;1
        DB      101O
        DW      6071H
        DB      2
;2
        DB      102O
        DW      6074H
        DB      2
;3
        DB      103O
        DW      6077H
        DB      2
;0
        DB      100O
        DW      6871H
        DB      3
;.
        DB      116O
        DW      6875H
        DB      3

NKEYS   EQU     ($-KBTBL)/4

************************************************************
SNDTEST:
        SENDMSG SNDMSG,NDOS
        MVI     C,20H
SNDL:
        CALL    SBEEP
        MVI     A,BEL
        CALL    PUTCON
        DCR     C
        JNZ     SNDL

        SENDMSG ENDMSG,NDOS
        RET

SNDMSG:
        DB      '  :'
        DB      0

************************************************************
TAPTEST:
        SENDMSG TAPMSG,NDOS
        SENDMSG SORRY,NDOS
        RET

TAPMSG:
        DB      ' :'
        DB      0

************************************************************
LANTEST:
        SENDMSG LANMSG,NDOS
        CALL    CONIN
        ANI     5FH
        CPI     'D'
        JZ      LANT1
        SENDMSG ABTMSG,NDOS
        RET
LANT1:
        LDA     LANADR+PBASE2
        CMA
        ANI     ADRMSK
        RRC
        RRC
        RRC
        RRC
        STA     ADRRM
        ADI     0
        DAA
        PUSH    PSW
        SENDMSG ADRMSG,NDOS
        POP     PSW
        CALL    DBYTE
        SENDMSG MSG,NDOS

        LXI     H,LANC+PBASE2
        MVI     M,USRST
        NOP
        MVI     M,LANMD
        NOP
        MVI     M,TXEN + RXEN
        DCR     L
        MOV     A,M
        INR     L
        XRA     A
        DCR     A
        JNZ     $-1
        MOV     A,M
        CPI     TRDY + TXBE + DSR
        JZ      $+7
        CALL    LANSERR
        DB      1
        MVI     L,IRISRG
        MOV     A,M
        ANI     INT3
        JZ      $+7
        CALL    LANIERR
        DB      2
        MVI     L,LANC
        MVI     M,TXEN+RXEN+SBCH
        XRA     A
        DCR     A
        JNZ     $-1
        MOV     A,M
        CPI     TRDY+RRDY+TXBE+RPAR+ROV+RFR+40H+DSR
        JZ      $+7
        CALL    LANSERR
        DB      3
        MVI     L,IRISRG
        MOV     A,M
        ANI     INT3
        JNZ     $+7
        CALL    LANIERR
        DB      4

        MVI     C,0
        MVI     L,LANC
        MVI     M,TXEN + RXEN
        XRA     A
        DCR     A
        JNZ     $-1
        DCR     L
        MOV     A,M
        INR     L
        CMP     C
        JZ      $+7
        CALL    LANDERR
        DB      5
        MVI     M,CLERR+TXEN+RXEN
        XRA     A
        DCR     A
        JNZ     $-1
        MOV     A,M
        CPI     TRDY+TXBE+DSR
        JZ      LANT2
        CALL    LANSERR
        DB      6
        RET
LANT2:
        LXI     B,400H
LANT3:
        DCR     L
        MOV     M,C
        INR     L
        MOV     A,M
        ANI     TXBE
        JZ      $-3
        MOV     A,M
        CPI     RRDY+TRDY+TXBE+DSR
        JZ      $+7
        CALL    LANSERR
        DB      7
        DCR     L
        MOV     A,M
        INR     L
        CMP     C
        JZ      $+7
        CALL    LANDERR
        DB      8
        DCX     B
        MOV     A,C
        ORA     B
        JNZ     LANT3
        SENDMSG ENDMSG,NDOS
        RET

LANSERR:
LANIERR:
LANDERR:
        MOV     E,A
        PUSH    H
        SENDMSG LANERM,NDOS
        POP     H
        XTHL
        MOV     A,M
        INX     H
        XTHL
        CALL    DBYTE
        MVI     A,TAB
        CALL    PUTCON
        MOV     A,E
        CALL    DBYTE
        PUSH    H
        SENDMSG MSG,NDOS
        POP     H
        MOV     A,E
        RET

LANMSG:
        DB      '   '
        DB      CR,LF,TAB
        DB      '   ? (/):'
        DB      0
ADRMSG:
        DB      CR,LF,TAB
        DB      '  : '
        DB      0
LANERM:
        DB      '  ',0

************************************************************

BS      EQU     08H
HT      EQU     09H
LF      EQU     0AH
VT      EQU     0BH
SO      EQU     0EH
SI      EQU     0FH
DC2     EQU     12H
DC4     EQU     14H
CAN     EQU     18H

LSTTEST:
        SENDMSG LSTMSG,NDOS

        LDA     CONFIG
        ORA     A
        JZ      LSTT1
        SENDMSG NAVMSG,NDOS
        RET
LSTT1:
        SENDMSG LRDMSG,NDOS
        CALL    CONIN
        ANI     5FH
        CPI     'D'
        JNZ     LSTTA
        SENDMSG PRNMSG,NDOS

        LXI     H,LSTTAB
        LXI     B,LENLTB
LSTLOOP:
        PUSH    B
        MOV     C,M
        CALL    LISTOUT
        POP     B
        JZ      LSTNR
        INX     H
        DCX     B
        MOV     A,B
        ORA     C
        JNZ     LSTLOOP
        SENDMSG ENDMSG,NDOS
        RET
LSTTA:
        SENDMSG ABTMSG,NDOS
        RET
LSTNR:
        SENDMSG LNRMSG,NDOS
        RET

LSTMSG:
        DB      ' :'
        DB      0
NAVMSG:
        DB      TAB,' ',CR,LF,0
LRDMSG:
        DB      CR,LF,TAB
        DB      '   ? (/): ',0
PRNMSG:
        DB      CR,LF,TAB
        DB      '   :',0
ABTMSG:
        DB      CR,LF,TAB
        DB      ' '
        DB      CR,LF,0
LNRMSG:
        DB      '    ',CR,LF,0

LISTOUT:
        PUSH    D
        MVI     B,10
LO1:
        LXI     D,0
LO2:
        LDA     LSTSTS+PBASE2
        ANI     LSTRDY
        JNZ     LO3
        DCX     D
        MOV     A,E
        ORA     D
        JNZ     LO2
        DCR     B
        JNZ     LO1
        POP     D
        RET
LO3:
        POP     D
        MOV     A,C
        CMA
        STA     LSTDAT+PBASE2
        MVI     A,STBSET
        STA     LSTCTL+PBASE2
        MVI     A,STBRST
        STA     LSTCTL+PBASE2
        RET

LSTTAB:
        DB      ESC,':',0,0,0
        DB      ESC,'%',1,0
        DB      ESC,'&',0,0C0H,0FEH

        DB      8BH,0,3EH,0,08H,0,1CH,22H,0,22H,1CH,0   ; 
        DB      8BH,0,0,04H,0AH,20H,0AH,20H,1CH,02H,0,0 ; 
        DB      8BH,0,0,7CH,82H,20H,82H,20H,82H,1CH,0,0 ; 
        DB      8BH,0,0,3EH,0,02H,0,02H,3CH,03H,0,0     ; 
        DB      8BH,0,0,1CH,82H,20H,82H,20H,82H,7CH,0,0 ; 
        DB      8BH,0,0,1CH,22H,08H,22H,08H,22H,18H,0,0 ; 
        DB      8BH,0,18H,24H,0,24H,5BH,24H,0,24H,18H,0 ; 
        DB      8BH,0,0,3EH,0,20H,0,20H,0,20H,0,0       ; 
        DB      8BH,0,0,22H,14H,0,08H,0,14H,22H,0,0     ; 
        DB      8BH,0,0,3EH,0,04H,08H,10H,0,3EH,0,0     ; 
        DB      8BH,0,0,3EH,0,24H,48H,10H,0,3EH,0,0     ; 
        DB      8BH,0,0,3EH,0,08H,0,14H,0,22H,0,0       ; 
        DB      8BH,0,0,06H,08H,10H,20H,0,3EH,0,0,0     ; 
        DB      8BH,0,3EH,0,10H,0,08H,0,10H,0,3EH,0     ; 
        DB      8BH,0,0,3EH,0,08H,0,08H,0,3EH,0,0       ; 
        DB      8BH,0,0,1CH,22H,0,22H,0,22H,1CH,0,0     ; 
        DB      8BH,0,0,3EH,0,20H,0,20H,0,3EH,0,0       ; 
        DB      8BH,0,0,10H,2AH,04H,28H,0,28H,0,3EH,0   ; 
        DB      8BH,0,0,3FH,0,24H,0,24H,0,18H,0,0       ; 
        DB      8BH,0,0,1CH,0,22H,0,22H,0,22H,0,0       ; 
        DB      8BH,0,0,20H,0,20H,1EH,20H,0,20H,0,0     ; 
        DB      8BH,0,0,38H,01H,04H,01H,04H,01H,3EH,0,0 ; 
        DB      8BH,0,22H,14H,08H,0,3EH,0,08H,14H,22H,0 ; 
        DB      8BH,0,0,3EH,0,2AH,0,2AH,0,2AH,14H,0     ; 
        DB      8BH,0,0,3EH,0,0AH,0,0AH,0,0AH,04H,0     ; 
        DB      8BH,0,3EH,0,0AH,0,0AH,04H,0,0,3EH,0     ; 
        DB      8BH,0,0,14H,22H,0,2AH,0,2AH,14H,0,0     ; 
        DB      8BH,0,3EH,0,02H,0,3EH,0,02H,0,3EH,0     ; 
        DB      8BH,0,0,22H,0,2AH,0,2AH,0,1CH,0,0       ; 
        DB      8BH,0,3EH,0,02H,0,3EH,0,02H,0,3FH,0     ; 
        DB      8BH,0,0,38H,0,08H,0,08H,0,3EH,0,0       ; 
        DB      8BH,0,0,20H,0,3EH,0,0AH,0,0AH,04H,0     ; 

        DB      8BH,0,0FEH,0,10H,0,7CH,82H,0,82H,7CH,0  ; 
        DB      8BH,0,0EH,10H,28H,40H,88H,0,88H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,92H,0,92H,0,92H,0,8CH,0    ; 
        DB      8BH,0,0FEH,0,02H,0,02H,0,0FEH,0,03H,0   ; 
        DB      8BH,0,03H,0,3EH,40H,82H,0,0FEH,0,03H,0  ; 
        DB      8BH,0,0FEH,0,92H,0,92H,0,92H,0,82H,0    ; 
        DB      8BH,0,38H,44H,0,44H,0BAH,44H,0,44H,38H,0 ; 
        DB      8BH,0,0,0FEH,0,80H,0,80H,0,80H,0,0      ; 
        DB      8BH,0,0,82H,44H,28H,10H,28H,44H,82H,0,0 ; 
        DB      8BH,0,0FEH,0,04H,08H,10H,20H,40H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,04H,48H,90H,20H,40H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,10H,0,28H,0,44H,0,82H,0    ; 
        DB      8BH,0,0EH,10H,20H,40H,80H,0,80H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,40H,20H,10H,20H,40H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,10H,0,10H,0,10H,0,0FEH,0   ; 
        DB      8BH,0,7CH,0,82H,0,82H,0,82H,0,7CH,0     ; 
        DB      8BH,0,0FEH,0,80H,0,80H,0,80H,0,0FEH,0   ; 
        DB      8BH,0,60H,02H,94H,08H,90H,0,90H,0,0FEH,0 ; 
        DB      8BH,0,0FEH,0,90H,0,90H,0,90H,0,60H,0    ; 
        DB      8BH,0,7CH,0,82H,0,82H,0,82H,0,44H,0     ; 
        DB      8BH,0,80H,0,80H,0,0FEH,0,80H,0,80H,0    ; 
        DB      8BH,0,0E0H,02H,10H,02H,10H,02H,10H,02H,0FCH,0;
        DB      8BH,0,0C6H,28H,10H,0,0FEH,0,10H,28H,0C6H,0 ; 
        DB      8BH,0,0FEH,0,92H,0,92H,0,92H,0,6CH,0    ; 
        DB      8BH,0,0FEH,0,12H,0,12H,0,12H,0,0CH,0    ; 
        DB      8BH,0,0FEH,0,12H,0,12H,0CH,0,0,0FEH,0   ; 
        DB      8BH,0,44H,0,82H,0,92H,0,92H,0,6CH,0     ; 
        DB      8BH,0,0FEH,0,02H,0,0FEH,0,02H,0,0FEH,0  ; 
        DB      8BH,0,44H,0,92H,0,92H,0,92H,0,7CH,0     ; 
        DB      8BH,0,0FEH,0,02H,0,0FEH,0,02H,0,0FFH,0  ; 
        DB      8BH,0,0F0H,0,10H,0,10H,0,10H,0,0FEH,0   ; 

        DB      ESC,'l',3,SO,'   '
        DB      'RAVI 8010',CR,LF,LF
        DB      HT,'',HT,'',HT,'',HT,''
        DB      HT,'',CR,LF
        DB      '           ===='
        DB      '====',BS,BS,BS,BS,'////',CR,LF
        DB      '    ',CAN
        DB      CR,LF
        DB      '   ',SO,''
        DB      ' ',CR,LF
        DB      '   ',SI,SO
        DB      '   ',CR,LF
        DB      ESC,'-1',ESC,SI,'  '
        DB      ' , ',DC2,ESC,SO,'  '
        DB      DC4,' ',ESC,'-0',CR,LF
        DB      ESC,'E','  '
        DB      ESC,'F',CR,LF
        DB      ESC,'G','  '
        DB      ESC,'H',CR,LF
        DB      ESC,'E',ESC,'G','  '
        DB      ' ',ESC,'H',ESC,'F',CR,LF
        DB      ESC,'M',' 12 /',CR,LF
        DB      ESC,'P',' 10 /',CR,LF
        DB      '      Y=aX'
        DB      ESC,'S0','3',ESC,'T','+bX',ESC,'S0'
        DB      '2',ESC,'T','+c',CR,LF
        DB      '       H'
        DB      ESC,'S1','2',ESC,'T','SO'
        DB      ESC,'S1','4',ESC,'T',CR,LF
        DB      ESC,'A',5,ESC,'S0',HT
        DB      ' ',CR,LF
        DB      HT,'   ',CR,LF
        DB      HT,'5/72 ',ESC,'T',CR,LF,LF
        DB      ESC,'0','  1/8 ',CR,LF
        DB      '   ------------',CR,LF
        DB      '   ------------',CR,LF
        DB      ESC,'1','  7/72 ',CR,LF
        DB      '   ------------',CR,LF
        DB      '   ------------',CR,LF
        DB      ESC,'2','  1/6 ',CR,LF
        DB      '   ------------',CR,LF
        DB      '   ------------',CR,LF
        DB      ESC,'3',20,'  20/216 ',CR,LF
        DB      '   ------------',CR,LF
        DB      '   ------------',ESC,'2',CR,LF

LENLTB  EQU     $-LSTTAB

************************************************************
FDTEST:
        SENDMSG FDMSG,NDOS
        SENDMSG SORRY,NDOS
        RET
FDMSG:
        DB      ' :'
        DB      0

************************************************************
SERTEST:
        SENDMSG SERMSG,NDOS
        SENDMSG SORRY,NDOS
        RET
SERMSG:
        DB      '    2:'
        DB      0

************************************************************

DADR:
        MOV     A,H
        CALL    DBYTE
        MOV     A,L
DBYTE:
        PUSH    PSW
        RRC
        RRC
        RRC
        RRC
        CALL    CONV
        CALL    PUTCON
        POP     PSW
        CALL    CONV
PUTCON:
        PUSH    B
        PUSH    D
        PUSH    H
        MOV     C,A
        CALL    CONOUT
        LDA     KBBASE2+0FFH
        ORA     A
        JNZ     $-4
        POP     H
        POP     D
        POP     B
        RET

   ; /  

MSGOUT:
        MOV     A,M
        ORA     A
        RZ
        CALL    PUTCON
        INX     H
        JMP     MSGOUT

IMSG:
        DB      0CH,04H
        DB      '  8010, 8020'
        DB      CR,LF
        DB      '  07.12.86'
        DB      CR,LF
        DB      '    1.0'
MSG2:
        DB      CR,LF,LF,0
MENU:
        DB      TAB,TAB,'  :'
        DB      CR,LF,LF
        DB      '0 -   '
        DB      TAB,'6 -   '
        DB      CR,LF
        DB      '1 -  '
        DB      TAB,TAB,'7 -  '
        DB      CR,LF
        DB      '2 -  ',TAB
        DB      '8 -   '
        DB      CR,LF
        DB      '3 -  ',TAB,TAB
        DB      '9 -    '
        DB      CR,LF
        DB      '4 -  ',TAB,TAB
        DB      'A -  '
        DB      CR,LF
        DB      '5 -  ',TAB,TAB
;       DB      'B -  '
        DB      CR,LF
        DB      TAB,TAB,' -  '
        DB      ' '
        DB      CR,LF,LF,0
PROMPT:
        DB      TAB,'  : '
        DB      0

FMSG:
        DB      ' .'
        DB      0

VRTMSG:
        DB      ' :     ',0
RAMHMSG:
        DB      '   8000-FFFF:',TAB,0
RAMLMSG:
        DB      '   0000-7FFF:',TAB,0
RAMERM:
        DB      TAB,' :   ',0
MOVMSG:
        DB      ' :',0
MOVEND:
        DB      TAB,'',CR,LF,0
ROMMSG:
        DB      ' :      ',0
ROMERM:
        DB      TAB,TAB,'  #',0
PTBMSG:
        DB      ' :',0
CPUERM:
        DB      TAB,', PC=',0
ENDMSG:
        DB      TAB,'',CR,LF,0

SCRMSG:
        DB      0CH,04H,'      '
        DB      ' '
        DB      ' - '
        DB      '',CR,LF,LF

        DB      '    :',CR,LF
        DB      '        '
        DB      '        '
        DB      '        '
        DB      '  ',0FFH,'      '
        DB      CR,LF
        DB      '        '
        DB      '        '
        DB      '        '
        DB      '        '
        DB      CR,LF

        DB      '    :'
        DB      CR,LF
        DB      '@ A B C D E F G '
        DB      'H I J K L M N O '
        DB      'P Q R S T U V W '
        DB      'X Y Z [ \ ] ^ _ '
        DB      CR,LF
        DB      '` a b c d e f g '
        DB      'h i j k l m n o '
        DB      'p q r s t u v w '
        DB      'x y z { | } ~ ',10H,7FH
        DB      CR,LF

        DB      '     :'
        DB      CR,LF
        DB      '  ! " # $ % & ',27H,20H
        DB      '( ) * + , - . / '
        DB      '0 1 2 3 4 5 6 7 '
        DB      '8 9 : ; < = > ? '
        DB      CR,LF
        DB      10H,20H,20H,10H,1,20H
        DB      10H,2,20H,10H,3,20H
        DB      10H,4,20H,10H,5,20H
        DB      10H,6,20H,10H,7,20H
        DB      10H,8,20H,10H,9,20H
        DB      10H,0AH,20H,10H,0BH,20H
        DB      10H,0CH,20H,10H,0DH,20H
        DB      10H,0EH,20H,10H,0FH,20H
        DB      10H,10H,20H,10H,11H,20H
        DB      10H,12H,20H,10H,13H,20H
        DB      10H,14H,20H,10H,15H,20H
        DB      10H,16H,20H,10H,17H,20H
        DB      10H,18H,20H,10H,19H,20H
        DB      10H,1AH,20H,10H,1BH,20H
        DB      10H,1CH,20H,10H,1DH,20H
        DB      10H,1EH,20H,10H,1FH,20H
        DB      CR,LF,LF
        DB      '   :  '
        DB      80H,0A0H,96H,0A9H,98H,83H
        DB      0A4H,0B8H,87H,0A1H,0B2H,0ABH
        DB      0B6H,0B9H,90H,0B1H,0B5H,0BCH
        DB      9CH,8EH,9EH,0BEH,0BDH,80H
        DB      88H,99H,91H,80H
        DB      0AEH,0B3H,9DH,80H
        DB      0A8H,80H,94H,0AAH,95H
        DB      CR,LF
        DB      '                   '
        DB      80H,82H,0A5H,9AH,89H,0B0H,86H
        DB      8BH,0B4H,92H,0A3H,0BAH,0A7H
        DB      9BH,81H,93H,97H,8FH,8DH
        DB      0ACH,0ADH,0AFH,9FH,80H
        DB      0A2H,0A6H,84H,80H
        DB      0BBH,8CH,0B7H,80H
        DB      80H,0BFH,80H,85H,8AH
        DB      CR,LF,LF
CNTMSG:
        DB      BEL,'      '
        DB      '   '
        DB      '  <>:'
        DB      0
MSG:
        DB      CR,LF,0
GRFMSG:
        DB      FF,CLS,ESC,'6',' '
        DB      ESC,'Y _ ',ESC,'Y/  '
        DB      ESC,'Y/_ ',ESC,'7'
        DB      ESC,'Y !'
        DB      TAB,'  '
        DB      ' '
        DB      ESC,'Y/!',0
LUTMSG:
        DB      FF,CLS
        DB      ' : 7'
        DB      ESC,'Y O'
        DB      ': ',CR,LF,LF
        DB      ' : 6'
        DB      ESC,'Y"O'
        DB      ': ',CR,LF,LF
        DB      ' : 5'
        DB      ESC,'Y$O'
        DB      ': ',CR,LF,LF
        DB      ' : 4'
        DB      ESC,'Y&O'
        DB      ': ',CR,LF,LF
        DB      ' : 3'
        DB      ESC,'Y(O'
        DB      ': ',CR,LF,LF
        DB      ' : 2'
        DB      ESC,'Y*O'
        DB      ': ',CR,LF,LF
        DB      ' : 1'
        DB      ESC,'Y,O'
        DB      ': ',CR,LF,LF
        DB      ' : 0'
        DB      ESC,'Y.O'
        DB      ': ',CR,LF
        DB      0

FFMSG:
        DB      FF,CLS,0
SORRY:
        DB      TAB,' '
        DB      CR,LF,0

PRLTBL:

END
'
        DB      'x y z { | } ~ ',10H,7FH
        DB      CR,LF

        DB      '     :'
  