//
//   HOOK_DLL.cpp
//

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <fcntl.h>
#include <SYS\STAT.H>
#include <io.h>
#include <string>


//////////////////////////////////
typedef unsigned char        byte;
typedef unsigned short       word;
typedef unsigned long       dword;
typedef unsigned long long  qword;

#define BIT_0             01
#define BIT_1             02
#define BIT_2             04
#define BIT_3            010
#define BIT_4            020
#define BIT_5            040
#define BIT_6           0100
#define BIT_7           0200
#define BIT_8           0400
#define BIT_9          01000
#define BIT_10         02000
#define BIT_11         04000
#define BIT_12        010000
#define BIT_13        020000
#define BIT_14        040000
#define BIT_15       0100000
#define BIT_16       0200000
#define BIT_17       0400000
#define BIT_18      01000000
#define BIT_19      02000000
#define BIT_20      04000000
#define BIT_21     010000000
#define BIT_22     020000000
#define BIT_23     040000000
#define BIT_24    0100000000
#define BIT_25    0200000000
#define BIT_26    0400000000
#define BIT_27   01000000000
#define BIT_28   02000000000
#define BIT_29   04000000000
#define BIT_30  010000000000
#define BIT_31  020000000000

//////////////////////////////////

#define WH_KEYBOARD_LL 13

typedef struct tagKBDLLHOOKSTRUCT {
    dword   vkCode;
    dword   scanCode;
    dword   flags;
    dword   time;
    ULONG_PTR dwExtraInfo;
} KBDLLHOOKSTRUCT, FAR *LPKBDLLHOOKSTRUCT, *PKBDLLHOOKSTRUCT;


//////////////////////////////////

HHOOK  ghKeyboardHook = NULL; // hook handle
HWND   ghWndFocus     = NULL;

HINSTANCE ghInstance  = NULL;

int hFile = 0;

int  bVK_NUMLOCK_pressed = 0;

LRESULT CALLBACK KeyboardHook( int nCode, WPARAM wp, LPARAM lp ) 
{
	KBDLLHOOKSTRUCT *pkh = (KBDLLHOOKSTRUCT *) lp;
	dword wParam = pkh->vkCode;
	dword lParam = 1;
	dword lParamHi = pkh->scanCode;
	signed char cFlags = pkh->flags; 
	if( cFlags & 1 )
	{
		lParamHi |= BIT_8;
	}
	if( cFlags < 0 )
	{
		lParamHi |= BIT_14;
		lParamHi |= BIT_15;
	}
	
	if( hFile > 0 )
	{
		char str[512];
		sprintf(str, "wp[0x%X] ; vkCode[0x%X] ; scanCode[0x%X] ; flags[0x%X]\n", wp, pkh->vkCode, pkh->scanCode, pkh->flags );
		std::string sMes = str;
		write( hFile, sMes.c_str(), sMes.size() );
	}

	if( nCode==HC_ACTION )
	{
		if( wParam == VK_NUMLOCK )
		{
			/*
			if( cFlags < 0 )
			{
				bVK_NUMLOCK_pressed = 0;
				lParamHi <<= 16;
				lParam |= lParamHi;
				if( ghWndFocus ) { PostMessage( ghWndFocus, WM_KEYUP, wParam, lParam ); }
			}
			else
			{
				if( bVK_NUMLOCK_pressed ) { lParamHi |= BIT_14; } 
				bVK_NUMLOCK_pressed = 1;
				lParamHi <<= 16;
				lParam |= lParamHi;
				if( ghWndFocus ) { PostMessage( ghWndFocus, WM_KEYDOWN, wParam, lParam ); }
			}
			//*/
			return 1;
		}
	}
	
	return CallNextHookEx( ghKeyboardHook, nCode, wp, lp );
}


BOOL WINAPI DllMain ( HINSTANCE hInst, dword dwReason, LPVOID IpReserved ) 
{
	char         str[512];
	std::string  sMes;
	
	switch( dwReason ) 
	{ 
		case DLL_PROCESS_ATTACH:
		{
		 // Initialize once for each new process.
		 // Return FALSE to fail DLL load.

			hFile = open( "GlobalHook.log", O_RDWR | O_CREAT, S_IREAD|S_IWRITE );

			if( hFile <= 0 )
			{
				return FALSE;
			}

			ghInstance = hInst;

			sprintf(str, "ghInstance[0x%X]\n", ghInstance );
			sMes = str;
			write( hFile, sMes.c_str(), sMes.size() );
			
			ghKeyboardHook = SetWindowsHookEx( WH_KEYBOARD_LL, KeyboardHook, ghInstance, 0);
			
			if( !ghKeyboardHook ) 
			{
				sMes = "GlobalHook NOT installed..\n";
				write( hFile, sMes.c_str(), sMes.size() );
				close( hFile );
				return FALSE;
			}

			sprintf(str, "GlobalHook installed[0x%X]\n\n", ghKeyboardHook );
			sMes = str;
			write( hFile, sMes.c_str(), sMes.size() );
		}
		break;


		case DLL_THREAD_ATTACH:
		 // Do thread-specific initialization.
		break;

		case DLL_THREAD_DETACH:
		 // Do thread-specific cleanup.
		break;

		case DLL_PROCESS_DETACH:
		{
		 // Perform any necessary cleanup.
			UnhookWindowsHookEx( ghKeyboardHook );

			sMes = "\nGlobalHook Uninstalled..\n";
			write( hFile, sMes.c_str(), sMes.size() );
			close( hFile );
		}
		break;
	}

	return TRUE;
}


