------------------------------------------------------------------------------------------------------------------------
--      "divIDERUS"   "Super Joystick Port" V1.00.13                 : 130104  --
--                                                                                                                    --
--   EPM3128ATC100-10N (128 Macrocells,  TQFP-100),                                                         --
--     ZX-BUS,    SEGA                                             --
--                                                                                                                    --
--   : Quartus II Version 9.0 Web Edition                                                              --
--                                                                                                                    --
--  2012,2013 (C)   (zst)                                                                              --
------------------------------------------------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 31
-- Total macrocels = 96/128
-- Total pins      = 80/80

library IEEE; 
use IEEE.std_logic_1164.all; 
use IEEE.std_logic_unsigned.all;  

------------------------------------------------------------------------------------------------------------------------
--                                                                                 130104  --
------------------------------------------------------------------------------------------------------------------------
entity divIDERUS is 
port(
--   NemoBUS:
--    RESET            : in std_logic;  -- 0 =    Z80
    A                : in std_logic_vector(15 downto 0);
    MREQ             : in std_logic;  -- 0 =   Z80  
    IORQ             : in std_logic;  -- 0 =   Z80  
    RD               : in std_logic;  -- 0 =        Z80
    WR               : in std_logic;  -- 0 =    Z80    
    DOS              : in std_logic;  -- ,  0  TR-DOS - divIDERUS  Super Joystick  
    M1               : in std_logic;  -- 0 =    (1  )
    INT              : in std_logic;  -- 0 =  , 1     ( 20 )
    F14              : in std_logic;  --   14    
    ROMSEL           : in std_logic;  --     , 1 = BASIC 48, 0 =  128
    Z80_CLK          : in std_logic;  --  Z80,  3.5 ,     ZX SPECTRUM
    NMI_SW           : in std_logic;  -- 0 =        divIDERUS
    EPROM            : in std_logic;  -- 0 =    EPROM, 1 =   EPROM 
    
--  SEGA  -        DB-9M  
    SEGA_1           : in std_logic;  -- Z/UP
    SEGA_2           : in std_logic;  -- Y/DOWN
    SEGA_3           : in std_logic;  -- X/LEFT
    SEGA_4           : in std_logic;  -- SELECT/RIGHT
    SEGA_6           : in std_logic;  -- BUTTON A/BUTTON B
    SEGA_9           : in std_logic;  -- START/BUTTON C

    SEGA_7           : out std_logic; --    SEGA  
    IORQGE           : out std_logic; -- 1     NemoBUS/ZX-BUS
    ROMOFF1          : out std_logic; --     . 
    ROMOFF2          : out std_logic; --  ,      ZX-BUS   
    
    HDRD             : out std_logic; --     IDE
    HDWR             : out std_logic; --       IDE
    HA2              : out std_logic; --       IDE
    HA3              : out std_logic; -- 
    HA4              : out std_logic; -- 
    
    ADDR0            : out std_logic; --     RAM divIDE
    ADDR1            : out std_logic; -- 
    RAMOE            : out std_logic; --    SRAM 
    RAMWR            : out std_logic; --     SRAM 
    ROMOE            : out std_logic; --    EPROM
    ROMWR            : out std_logic; --     EPROM 
    
    NMI              : out std_logic; -- 0 =    Z80
    Z80_WAIT         : out std_logic; -- 0 =  Z80         
    
    RESET            : inout std_logic; -- 0 =    Z80
    H                : inout std_logic_vector(15 downto 0) := "ZZZZZZZZZZZZZZZZ"; --  IDE
    D                : inout std_logic_vector(7  downto 0) := "ZZZZZZZZ"  --   Z80

); 
end divIDERUS;  

------------------------------------------------------------------------------------------------------------------------
--                                                                          130104  --
------------------------------------------------------------------------------------------------------------------------
architecture divIDERUS_arch of divIDERUS is

signal INT_DELAY1         : std_logic := '1'; -- INT,     Z80_CLK
signal INT_DELAY2         : std_logic;        -- INT,     Z80_CLK
signal INT_BEGIN          : std_logic := '1'; -- 0    INT
signal SEGA_COUNT         : std_logic_vector(4 downto 0);  --     SEGA 
signal SEGA_SHIFT_REG     : std_logic_vector(7 downto 0) := "10000000"; --     

--    12  SEGA 
signal BUTTON_LEFT        : std_logic := '1';
signal BUTTON_RIGHT       : std_logic := '1';
signal BUTTON_DOWN        : std_logic := '1';
signal BUTTON_UP          : std_logic := '1';
signal BUTTON_A           : std_logic := '1';
signal BUTTON_B           : std_logic := '1';
signal BUTTON_C           : std_logic := '1';
signal BUTTON_X           : std_logic := '1';
signal BUTTON_Y           : std_logic := '1';
signal BUTTON_Z           : std_logic := '1';
signal BUTTON_SELECT      : std_logic := '1';
signal BUTTON_START       : std_logic := '1';


signal PRESS_XYZ          : std_logic; -- =0,      X, Y, Z
signal PRESS_ARROW        : std_logic; -- =0,     

signal KEYBOARD_ADDRESS   : std_logic; -- =1,     
signal KEMPSTON_ADDRESS   : std_logic; -- =1,    KEMPSTON 
signal IN_KEMPSTON        : std_logic; -- =0,     KEMPSTON 
signal IN_KEYBOARD        : std_logic; -- =0,     
signal KEMPSTON_IORQGE    : std_logic; -- =1,    ZX-BUS   KEMPSTON 
signal KEYBOARD_IORQGE    : std_logic; -- =1,    ZX-BUS   

signal JOYSTICK_SINCLAIR2 : std_logic := '0'; -- =0,   SINCLAIR2  ()
signal JOYSTICK_SINCLAIR1 : std_logic := '1'; -- =0,   SINCLAIR1  ()  
signal JOYSTICK_KEMPSTON  : std_logic := '1'; -- =0,   KEMPSTON  
signal JOYSTICK_CURSOR    : std_logic := '1'; -- =0,   CURSOR  (CS+)
signal JOYSTICK_QAOPM     : std_logic := '1'; -- =0,   QAOPM  (  )  
signal JOYSTICK_REZERV    : std_logic := '1'; -- =0,     

signal KEYBOARD_LEFT      : std_logic; -- =0,         
signal KEYBOARD_RIGHT     : std_logic; -- =0,        
signal ARROWS_DELAY1      : std_logic_vector(3 downto 0); --       INT    
signal ARROWS_DELAY2      : std_logic_vector(3 downto 0); --     INT    
signal KEYBOARD_OUT       : std_logic_vector(7 downto 0); --    


begin
------------------------------------------------------------------------------------------------------------------------
--                                                                     130104  --
------------------------------------------------------------------------------------------------------------------------

    ROMOFF1   <= 'Z';
    ROMOFF2   <= 'Z';
    
    HDRD      <= '1';
    HDWR      <= '1';
    HA2       <= '1';
    HA3       <= '1';
    HA4       <= '1';
    
    ADDR0     <= '1';
    ADDR1     <= '1';
    RAMOE     <= '1';
    RAMWR     <= '1';
    ROMOE     <= '1';
    ROMWR     <= '1';
    
    NMI       <= 'Z';
    Z80_WAIT  <= 'Z';
    
    H  (15 downto 0)      <=  "ZZZZZZZZZZZZZZZZ";
    
------------------------------------------------------------------------------------------------------------------------
--                                  SEGA                                          130104  --
------------------------------------------------------------------------------------------------------------------------
--     INT (   20 )     .
--    SEGA         9.14 . 
--     .

process (Z80_CLK)
begin
------------------------------------------------------------
  if (rising_edge(Z80_CLK))  then    --   :
    INT_DELAY1  <= INT;              -- INT,   Z80_CLK
    INT_DELAY2  <= INT_DELAY1;       -- INT,     Z80_CLK
  end if;
------------------------------------------------------------ 
  if (falling_edge(Z80_CLK)) then    --    :
    if (INT_BEGIN = '0') then        --    INT
      SEGA_COUNT <= (others => '0'); --   
    else
      SEGA_COUNT <= SEGA_COUNT + 1;  --  -  
    end if;
  end if;    
------------------------------------------------------------
end process;

------------------------------------------------------------------------------------------------------------------------
INT_BEGIN <= INT_DELAY1 or (not INT_DELAY2); --  0     INT
------------------------------------------------------------------------------------------------------------------------

process (SEGA_COUNT(4))
begin
  if (INT_BEGIN = '0') then          --    INT
    SEGA_SHIFT_REG <= "00000001";    --  0  .  -  ,  1  .  -  , 
  else                               --  -  " "       
    if (falling_edge(SEGA_COUNT(4)) and SEGA_SHIFT_REG(7) = '0') then --    
      SEGA_SHIFT_REG(0) <= '0'; 
      SEGA_SHIFT_REG(1) <= SEGA_SHIFT_REG(0);
      SEGA_SHIFT_REG(2) <= SEGA_SHIFT_REG(1);
      SEGA_SHIFT_REG(3) <= SEGA_SHIFT_REG(2);
      SEGA_SHIFT_REG(4) <= SEGA_SHIFT_REG(3);
      SEGA_SHIFT_REG(5) <= SEGA_SHIFT_REG(4);
      SEGA_SHIFT_REG(6) <= SEGA_SHIFT_REG(5);
      SEGA_SHIFT_REG(7) <= SEGA_SHIFT_REG(6);
      end if;
    end if;      
end process; --  end if;    

------------------------------------------------------------------------------------------------------------------------
 -- 4      SEGA 
SEGA_7 <= not (SEGA_SHIFT_REG(0) or SEGA_SHIFT_REG(2) or SEGA_SHIFT_REG(4) or SEGA_SHIFT_REG(6));

------------------------------------------------------------------------------------------------------------------------
--                               12  SEGA                             130104  --
------------------------------------------------------------------------------------------------------------------------

process (SEGA_SHIFT_REG(3))
begin
  if (falling_edge(SEGA_SHIFT_REG(3))) then       
    BUTTON_LEFT  <= SEGA_3; -- LEFT
    BUTTON_RIGHT <= SEGA_4; -- RIGHT
    BUTTON_DOWN  <= SEGA_2; -- DOWN
    BUTTON_UP    <= SEGA_1; -- UP
  end if;      
end process;
------------------------------------------------------------------------------------------------------------------------
process (SEGA_SHIFT_REG(4))
begin
  if (falling_edge(SEGA_SHIFT_REG(4))) then      
    BUTTON_A     <= SEGA_6; -- A
    BUTTON_START <= SEGA_9; -- START
  end if;      
end process;
------------------------------------------------------------------------------------------------------------------------
process (SEGA_SHIFT_REG(5))
begin
  if (falling_edge(SEGA_SHIFT_REG(5))) then     
    BUTTON_B     <= SEGA_6; -- B
    BUTTON_C     <= SEGA_9; -- C
    BUTTON_X     <= SEGA_3; -- X
    BUTTON_Y     <= SEGA_2; -- Y
    BUTTON_Z     <= SEGA_1; -- Z
    BUTTON_SELECT<= SEGA_4; -- SELECT
   end if;      
end process;

------------------------------------------------------------------------------------------------------------------------
--                                                                      121125  --
------------------------------------------------------------------------------------------------------------------------
PRESS_XYZ   <= (BUTTON_X and BUTTON_Y and BUTTON_Z); -- =0,      X, Y, Z
PRESS_ARROW <= (BUTTON_LEFT and BUTTON_RIGHT and BUTTON_DOWN and BUTTON_UP); -- =0,     

------------------------------------------------------------------------------------------------------------------------
--                                                                                          130104  --
------------------------------------------------------------------------------------------------------------------------
    
process(RESET, INT_DELAY1, BUTTON_X, BUTTON_Y, BUTTON_Z,BUTTON_A, BUTTON_B, BUTTON_C)
variable sel:std_logic_vector(5 downto 0);
begin
sel:= BUTTON_X & BUTTON_Y & BUTTON_Z & BUTTON_A & BUTTON_B & BUTTON_C ;
  if (falling_edge(INT_DELAY1)) then

--    ,  ,  CURSOR    
    if (RESET = '0') then 
      JOYSTICK_SINCLAIR2 <= '1';
      JOYSTICK_SINCLAIR1 <= '0'; 
      JOYSTICK_KEMPSTON  <= '1';
      JOYSTICK_CURSOR    <= '1'; 
      JOYSTICK_QAOPM     <= '1'; 
      JOYSTICK_REZERV    <= '1'; 
    else
  
  --    , START,   SELECT +    X,Y,Z,A,B,C -       
      if (PRESS_ARROW = '1' and BUTTON_START = '1' and BUTTON_SELECT = '0'
         and (sel="011111" or sel="101111" or sel="110111" or sel="111011" or sel="111101" or sel="111110")) then 
         
          JOYSTICK_SINCLAIR2 <= BUTTON_X; -- SELECT+X => SINCLAIR2  ()
          JOYSTICK_SINCLAIR1 <= BUTTON_Y; -- SELECT+Y => SINCLAIR1  ()  
          JOYSTICK_KEMPSTON  <= BUTTON_Z; -- SELECT+Z => KEMPSTON  
          JOYSTICK_CURSOR    <= BUTTON_A; -- SELECT+A => CURSOR  (CS+)
          JOYSTICK_QAOPM     <= BUTTON_B; -- SELECT+B => QAOPM  (  )  
          JOYSTICK_REZERV    <= BUTTON_C; -- SELECT+C =>    (  )  
         
      end if;
    end if;
  end if;
end process;

------------------------------------------------------------------------------------------------------------------------
RESET <= '0' when (BUTTON_SELECT = '0' and BUTTON_START = '0') else 'Z'; --    SELECT  START 

------------------------------------------------------------------------------------------------------------------------
--                                                               121125  --
------------------------------------------------------------------------------------------------------------------------
-- 0,         ,       SINCLAIR2  ()
KEYBOARD_LEFT  <= (JOYSTICK_SINCLAIR2 or
                  ((not PRESS_XYZ or A(11)) and (BUTTON_X or A(10)) and (BUTTON_Y or A(9))  and (BUTTON_Z or A(8))));
 
-- 0,       .  ,       SINCLAIR1  ()
KEYBOARD_RIGHT <= (JOYSTICK_SINCLAIR1 or
                  ((not PRESS_XYZ or A(12)) and (BUTTON_X or A(13)) and (BUTTON_Y or A(14)) and (BUTTON_Z or A(15))));

------------------------------------------------------------------------------------------------------------------------
--                                     CURSOR                                                 130104  --
------------------------------------------------------------------------------------------------------------------------
process (INT_DELAY1)
begin
  if (falling_edge(INT_DELAY1)) then  --       INT
    ARROWS_DELAY1 <= (BUTTON_LEFT & BUTTON_RIGHT & BUTTON_DOWN & BUTTON_UP);
 
    if (PRESS_ARROW = '1') then       --    -    
      ARROWS_DELAY2 <= "1111"; 
    else
      ARROWS_DELAY2 <= ARROWS_DELAY1; --        INT
    end if;
  end if;
end process;

------------------------------------------------------------------------------------------------------------------------
--                           Z80                                  130104  --
------------------------------------------------------------------------------------------------------------------------
KEYBOARD_OUT(0) <= (   (KEYBOARD_LEFT            or BUTTON_LEFT)      -- 1     
                   and (KEYBOARD_RIGHT           or BUTTON_A)         -- 0     
                   and (JOYSTICK_CURSOR or A(8)  or PRESS_ARROW)      -- CS (Caps Shift)  CURSOR 
                   and (JOYSTICK_CURSOR or A(14) or BUTTON_A)         -- ENTER (F   CURSOR )
                   and (JOYSTICK_QAOPM  or A(10) or BUTTON_UP)        -- Q (   QAOPM  )
                   and (JOYSTICK_QAOPM  or A(9)  or BUTTON_DOWN)      -- A (    QAOPM  )
                   and (JOYSTICK_QAOPM  or A(13) or BUTTON_RIGHT)     -- P (  QAOPM  )
                   and ((JOYSTICK_QAOPM and JOYSTICK_KEMPSTON) or A(12) or BUTTON_C) -- 0  QAOPM  KEMPSTON 
                   and ((JOYSTICK_QAOPM and JOYSTICK_KEMPSTON) or A(11) or BUTTON_X) -- 1  QAOPM  KEMPSTON 
                   and ((JOYSTICK_SINCLAIR2 and JOYSTICK_SINCLAIR1) or A(8)  or BUTTON_B) -- CS   
                   and ((JOYSTICK_QAOPM and JOYSTICK_KEMPSTON) or A(14) or BUTTON_B) -- ENTER  QAOPM  KEMPSTON .
                   );
                   
KEYBOARD_OUT(1) <= (   (KEYBOARD_LEFT            or BUTTON_RIGHT)     -- 2     
                   and (KEYBOARD_RIGHT           or BUTTON_UP)        -- 9     
                   and (JOYSTICK_QAOPM  or A(13) or BUTTON_LEFT)      -- O (   QAOPM  )
                   and ((JOYSTICK_QAOPM and JOYSTICK_KEMPSTON) or A(11) or BUTTON_Y) -- 2  QAOPM  KEMPSTON                   );
                   and ((JOYSTICK_SINCLAIR2 and JOYSTICK_SINCLAIR1) or A(15) or BUTTON_C) -- SS   
                   );
                   
KEYBOARD_OUT(2) <= (   (KEYBOARD_LEFT            or BUTTON_DOWN)      -- 3     
                   and (KEYBOARD_RIGHT           or BUTTON_DOWN)      -- 8     
                   and (JOYSTICK_CURSOR or A(12) or ARROWS_DELAY2(2)) -- 8 (  CURSOR )
                   and (JOYSTICK_QAOPM  or A(15) or BUTTON_A)         -- M (F       QAOPM  )
                   and ((JOYSTICK_QAOPM and JOYSTICK_KEMPSTON) or A(11) or BUTTON_z) -- 3  QAOPM  KEMPSTON 
                  );
                   
KEYBOARD_OUT(3) <= (   (KEYBOARD_LEFT            or BUTTON_UP)        -- 4     
                   and (KEYBOARD_RIGHT           or BUTTON_RIGHT)     -- 7     
                   and (JOYSTICK_CURSOR or A(12) or ARROWS_DELAY2(0)) -- 7 (   CURSOR )
                   );
                   
KEYBOARD_OUT(4) <= (   (KEYBOARD_LEFT            or BUTTON_A )        -- 5     
                   and (KEYBOARD_RIGHT           or BUTTON_LEFT )     -- 6     
                   and (JOYSTICK_CURSOR or A(11) or ARROWS_DELAY2(3)) -- 5 (   CURSOR )
                   and (JOYSTICK_CURSOR or A(12) or ARROWS_DELAY2(1)) -- 6 (    CURSOR )
                   );
                   
------------------------------------------------------------------------------------------------------------------------
--                                   SUPER JOYSTICK PORT                                     130104  --
------------------------------------------------------------------------------------------------------------------------
KEYBOARD_ADDRESS <= '1' when (DOS = '1' and  A(7 downto 0) = x"FE") else '0';
KEMPSTON_ADDRESS <= '1' when (DOS = '1' and  A(5 downto 0) = x"1F") else '0';

--    ZX-BUS,           (WR=1),
--  ,        A,B,C,X,Y,Z,     START  SELECT
KEYBOARD_IORQGE <= (WR and KEYBOARD_ADDRESS and (not (((PRESS_ARROW and BUTTON_A) or (not JOYSTICK_KEMPSTON)) 
                 and BUTTON_B and BUTTON_C and PRESS_XYZ)) and BUTTON_SELECT and BUTTON_START);

--    ZX-BUS,        KEMPSTON     (WR=1), 
--  ,        A       )
KEMPSTON_IORQGE <= (WR and KEMPSTON_ADDRESS and (not ((PRESS_ARROW and BUTTON_A) or JOYSTICK_KEMPSTON)));

--         ZX-BUS     
IORQGE <= KEYBOARD_IORQGE or KEMPSTON_IORQGE; 

--      KEMPSTON 
IN_KEYBOARD <= (not KEYBOARD_IORQGE or IORQ or RD);
IN_KEMPSTON <= (not KEMPSTON_IORQGE or IORQ or RD);

D(0) <= KEYBOARD_OUT(0) when (IN_KEYBOARD = '0') else (not BUTTON_RIGHT) when (IN_KEMPSTON = '0') else 'Z';
D(1) <= KEYBOARD_OUT(1) when (IN_KEYBOARD = '0') else (not BUTTON_LEFT)  when (IN_KEMPSTON = '0') else 'Z';
D(2) <= KEYBOARD_OUT(2) when (IN_KEYBOARD = '0') else (not BUTTON_DOWN)  when (IN_KEMPSTON = '0') else 'Z';
D(3) <= KEYBOARD_OUT(3) when (IN_KEYBOARD = '0') else (not BUTTON_UP)    when (IN_KEMPSTON = '0') else 'Z';
D(4) <= KEYBOARD_OUT(4) when (IN_KEYBOARD = '0') else (not BUTTON_A)     when (IN_KEMPSTON = '0') else 'Z';
D(5) <= '1'             when (IN_KEYBOARD = '0') else '0'                when (IN_KEMPSTON = '0') else 'Z';
D(6) <= '1'             when (IN_KEYBOARD = '0') else '0'                when (IN_KEMPSTON = '0') else 'Z';
D(7) <= '1'             when (IN_KEYBOARD = '0') else '0'                when (IN_KEMPSTON = '0') else 'Z';

end divIDERUS_arch;
