/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
 		/* Opcodes ED xx ohne Flagbeeinflussung */

		.data
jumptab2:	.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2

		.long EXIT2, EXIT2, ed42,  ed43,  ed44,  EXIT2, EXIT2, ed47
		.long EXIT2, EXIT2, ed4a,  ed4b,  EXIT2, opc9,  EXIT2, ed4f
		.long EXIT2, EXIT2, ed52,  ed53,  EXIT2, EXIT2, EXIT2, ed57
		.long EXIT2, EXIT2, ed5a,  ed5b,  EXIT2, EXIT2, EXIT2, ed5f
		.long EXIT2, EXIT2, ed62,  ed63,  EXIT2, EXIT2, EXIT2, ed67
		.long EXIT2, EXIT2, ed6a,  ed6b,  EXIT2, EXIT2, EXIT2, ed6f
		.long EXIT2, EXIT2, ed72,  ed73,  EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, ed7a,  ed7b,  EXIT2, EXIT2, EXIT2, EXIT2

		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long eda0,  eda1,  EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long eda8,  eda9,  EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long edb0,  edb1,  EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long edb8,  edb9,  EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2

		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2
		.long EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2, EXIT2

#define edcode(n) .align NALIGN,0x90

                edcode (0x42)		/* SBC HL,BC */
ed42:           orb $2,%ah
                sahf
                sbbw %cx,%bx
                jmp setaddadc

                edcode (0x43)		/* LD (nnnn),BC */
ed43:           movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw %cx,(%ebp,%edi)
                dispatch

                edcode (0x4a)		/* ADC HL,BC */
ed4a:           andb $0xd5,%ah
                sahf
                adcw %cx,%bx
                jmp setaddadc

                edcode (0x4b)		/* LD BC,(nnnn) */
ed4b:		movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw (%ebp,%edi),%cx
                dispatch

                edcode (0x52)		/* SBC HL,DE */
ed52:           orb $2,%ah
                sahf
                sbbw %dx,%bx
                jmp setaddadc

                edcode (0x53)		/* LD (nnnn),DE */
ed53:           movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw %dx,(%ebp,%edi)
                dispatch

                edcode (0x5a)		/* ADC HL,DE */
ed5a:           andb $0xd5,%ah
                sahf
                adcw %dx,%bx
                jmp setaddadc

                edcode (0x5b)		/* LD DE,(nnnn) */
ed5b:		movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw (%ebp,%edi),%dx
                dispatch

                edcode (0x62)		/* SBC HL,HL */
ed62:           orb $2,%ah
                sahf
                sbbw %bx,%bx
                jmp setaddadc

                edcode (0x63)		/* LD (nnnn),HL */
ed63:           movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw %bx,(%ebp,%edi)
                dispatch

                edcode (0x6a)		/* ADC HL,HL */
ed6a:           andb $0xd5,%ah
                sahf
                adcw %bx,%bx
                jmp setaddadc

                edcode (0x6b)		/* LD HL,(nnnn) */
ed6b:		movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw (%ebp,%edi),%bx
                dispatch

                edcode (0x72)		/* SBC HL,SP */
ed72:           orb $2,%ah
                sahf
                sbbw z80regs+4,%bx
                jmp setaddadc

                edcode (0x73)		/* LD (nnnn),SP */
ed73:           movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
		pushl %eax
		movw z80regs+4,%ax
                movw %ax,(%ebp,%edi)
		popl %eax
                dispatch

                edcode (0x7a)		/* ADC HL,SP */
ed7a:           andb $0xd5,%ah
                sahf
                adcw z80regs+4,%bx
                jmp setaddadc

                edcode (0x7b)		/* LD SP,(nnnn) */
ed7b:		movzwl (%esi,%ebp),%edi
                incl %esi
                incl %esi
                movw (%ebp,%edi),%di
		movw %di,z80regs+4
                dispatch


                edcode (0x44)		/* NEG */
ed44:           orb $2,%ah
                negb %al
		movl %eax,%edi
                lahf
                seto %al
                shlb $2,%al
                andb $0xd1,%ah
                orb %al,%ah
                andl $0x2ff,%edi
                xorb %al,%al
                orl %edi,%eax
                dispatch

	        edcode (0x47)		/* LD I,A */
ed47:           movb %al,z80regs+25
                dispatch
	        edcode (0x4f)		/* LD R,A */
ed4f:           movb %al,z80regs+24
                dispatch
	        edcode (0x57)		/* LD A,I */
ed57:           movb z80regs+25,%al
                dispatch
	        edcode (0x5f)		/* LD A,R */
ed5f:           movb z80regs+24,%al
                andb $0x7f,%al		/* is NOT random */
                dispatch



                edcode (0xa0)		/* LDI */
eda0:           pushl %eax
                movb (%ebp,%ebx),%al
                movb %al,(%ebp,%edx)
                incw %bx
                incw %dx
                decw %cx
                setnz %al
                shlb $2,%al
                andb $0xe9,%ah
                orb %al,%ah
                xorb %al,%al
                xchgl %eax,%edi
                popl %eax
                xorb %ah,%ah
                orl %edi,%eax
                dispatch

                edcode (0xa8)		/* LDD */
eda8:           pushl %eax
                movb (%ebp,%ebx),%al
                movb %al,(%ebp,%edx)
                decw %bx
                decw %dx
                decw %cx
                setnz %al
                shlb $2,%al
                andb $0xe9,%ah
                orb %al,%ah
                xorb %al,%al
                xchgl %eax,%edi
                popl %eax
                xorb %ah,%ah
                orl %edi,%eax
                dispatch

                edcode (0xb0)		/* LDIR */
edb0:           cld
                jmp do_ldir

                edcode (0xb8)           /* LDDR */
edb8:           std
do_ldir:        pushl %edi
                pushl %esi
                movl %ebx,%esi
                movl %edx,%edi
		addl %ebp,%esi
		addl %ebp,%edi
                rep
		movsb
		subl %ebp,%esi
		subl %ebp,%edi
                movl %esi,%ebx
                movl %edi,%edx
                popl %esi
                popl %edi
                andb $0xe9,%ah
                cld
                dispatch


                edcode (0xb1)	/* CPIR */
edb1:           movl %eax,%edi
		andw $0x29ff,%di
cpirloop:
                cmpb (%ebp,%ebx),%al
		lahf
		jz cpir1
                incw %bx
                decw %cx
		jnz cpirloop
		andb $0x90,%ah
		orb $0x02,%ah
		orw %di,%ax
		dispatch
		.align 2,0x90
cpir1:		incw %bx
cpirdr:         andb $0x90,%ah		/* get S and H flags */
		decw %cx
                setnz %al
                shlb $2,%al		/* set or not P/V flag */
		orb $0x42,%al		/* set N and Z flags */
		orb %al,%ah
		xorb %al,%al
		orw %di,%ax
		dispatch

                edcode (0xb9)	/* CPDR */
edb9:           movl %eax,%edi
		andw $0x29ff,%di	/* clear S, Z, H, P/V and N flags */
cpdrloop:
                cmpb (%ebp,%ebx),%al
		lahf
		jz cpdr1
                decw %bx
                decw %cx
		jnz cpdrloop
		andb $0x90,%ah		/* get S and H flags */
		orb $0x02,%ah		/* set N flag, reset Z and P/V flags */
		orw %di,%ax
		dispatch
		.align 2,0x90
cpdr1:		decw %bx
		jmp cpirdr



                edcode (0xa1)	/* CPI */
eda1:           movl %eax,%edi
		andw $0x29ff,%di
                cmpb (%ebp,%ebx),%al
		lahf
		andb $0xd0,%ah
                incw %bx
                decw %cx
                setnz %al
                shlb $2,%al
		orb $0x02,%al
		orb %al,%ah
		movb $0, %al		/* preserve A */
		orw %di,%ax
		dispatch

                edcode (0xa9)	/* CPD */
eda9:           movl %eax,%edi
		andw $0x29ff,%di	/* clear S, Z and H flags */
                cmpb (%ebp,%ebx),%al
		lahf
		andb $0xd0,%ah		/* clear C, N, P/V, b3, b5 */
                decw %bx		/* HL-- */
                decw %cx		/* BC-- */
                setnz %al
                shlb $2,%al		/* set or not flag P/V */
		orb $0x02,%al		/* set flag N */
		orb %al,%ah		/* put flags N and V in AH */
		movb $0, %al		/* preserve A */
		orw %di,%ax
		dispatch

                edcode (0x67)	/* RRD */
ed67:           movl %eax,%edi
                movb (%ebp,%ebx),%ah	/* AH = (HL), AL = A */
		rorw $4,%ax
		rorb $4,%al
                movb %ah,(%ebp,%ebx)
		orb %al,%al
		lahf
		andb $0xc4,%ah
		pushl %ecx
		movw %ax,%cx
		andb $0x28,%cl
		orb %cl,%ah
		popl %ecx
		andl $0x0100,%edi
		orw %edi,%eax
		dispatch

                edcode (0x6f)	/* RLD */
ed6f:           movl %eax,%edi
                movb (%ebp,%ebx),%ah
		rolb $4,%al
		rolw $4,%ax
                movb %ah,(%ebp,%ebx)
		orb %al,%al
		lahf
		andb $0xc4,%ah
		pushl %ecx
		movw %ax,%cx
		andb $0x28,%cl
		orb %cl,%ah
		popl %ecx
		andl $0x0100,%edi
		orw %edi,%eax
		dispatch

