/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
		.data
jumptabix:
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,ix09, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,ix19, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,ix21, ix22, ix23, ix24, ix25, ix26, EXIT2
		.long EXIT2,ix29, ix2a, ix2b, ix2c, ix2d, ix2e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ix34, ix35, ix36, EXIT2
		.long EXIT2,ix39, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2

		.long op00, op41, op42, op43, ix44, ix45, ix46, op47
		.long op48, op00, op4a, op4b, ix4c, ix4d, ix4e, op4f
		.long op50, op51, op00, op53, ix54, ix55, ix56, op57
		.long op58, op59, op5a, op00, ix5c, ix5d, ix5e, op5f
		.long ix60, ix61, ix62, ix63, ix64, ix65, ix66, ix67
		.long ix68, ix69, ix6a, ix6b, ix6c, ix6d, ix6e, ix6f
		.long ix70, ix71, ix72, ix73, ix74, ix75, EXIT2,ix77
		.long op78, op79, op7a, op7b, ix7c, ix7d, ix7e, op00

		.long EXIT2,EXIT2,EXIT2,EXIT2,ix84, ix85, ix86, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ix8c, ix8d, ix8e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ix94, ix95, ix96, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ix9c, ix9d, ix9e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ixa4, ixa5, ixa6, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ixac, ixad, ixae, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ixb4, ixb5, ixb6, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,ixbc, ixbd, ixbe, EXIT2

		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,ixcb, EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,ixe1, EXIT2,ixe3, EXIT2,ixe5, EXIT2,EXIT2
		.long EXIT2,ixe9, EXIT2,ixeb, EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,ixf9, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.text

		
		opcode (0x09)		/* ADD IX,BC */
ix09:           andb $0xec,%ah		/* ### H noch falsch */
		addw %cx,IX
		adcb $0,%ah		/* set carry flag if necessary (8 Byte) */
		dispatch

		opcode (0x19)		/* ADD IX,DE */
ix19:           andb $0xec,%ah		/* ### H noch falsch */
		addw %dx,IX
		adc $0,%ah
		dispatch

		opcode (0x21)		/* LD IX,nnnn */
ix21:           movw (%esi,%ebp),%di
		movw %di,IX
		incl %esi
		incl %esi
		dispatch

		opcode (0x22)           /* LD (nnnn),IX */
ix22:		movzwl (%esi,%ebp),%edi
		pushl %ebx
		movl IX,%ebx
		movw %bx,(%edi,%ebp)
		popl %ebx
		incl %esi
		incl %esi
		dispatch

		opcode (0x23)		/* INC IX */
ix23:           incw IX
		dispatch

ix24:		opcode (0x24)		/* INC IXh */
		inc8mac(IX+1)
		dispatch

ix25:		opcode (0x25)		/* DEC IXh */
		dec8mac(IX+1)
		dispatch

ix26:		opcode (0x26)		/* LD IXh, nn */
		pushl %ecx
		movw IX,%cx
		movb (%esi,%ebp),%ch
		movw %cx,IX
		popl %ecx
		incl %esi
		dispatch

ix2c:		opcode (0x2c)		/* INC IXl */
		inc8mac(IX)
		dispatch

ix2d:		opcode (0x2d)		/* DEC IXl */
		dec8mac(IX)
		dispatch

ix2e:		opcode (0x2e)		/* LD IXl, nn */
		pushl %ecx
		movw IX,%cx
		movb (%esi,%ebp),%cl
		movw %cx,IX
		popl %ecx
		incl %esi
		dispatch

		opcode (0x29)		/* ADD IX,IX */
ix29:           andb $0xec,%ah		/* clear some Flags  ### H noch falsch */
		movl IX,%edi
		addw %di,%di
		movl %edi,IX
		adc $0,%ah
		dispatch

		opcode (0x2a)		/* LD IX,(nnnn) */
ix2a:           movzwl (%esi,%ebp),%edi
		pushl %ebx
		movw (%edi,%ebp),%bx
		movw %bx,IX
		popl %ebx
		incl %esi
		incl %esi
		dispatch

		opcode (0x2b)		/* DEC IX */
ix2b:           decw IX
		dispatch

		opcode (0x34)           /* INC (IX+off) */
ix34:		GETIXOFF
		inc8mac((%ebp,%edi))
		dispatch

		opcode (0x35)	        /* DEC (IX+off) */
ix35:		GETIXOFF
		dec8mac((%ebp,%edi))
		dispatch

		opcode (0x36)		/* LD (IX+off),nn */
ix36:		GETIXOFF		/* erst offset, dann data! */
		pushl %eax
		movb (%esi,%ebp),%al
		incl %esi
		movb %al,(%edi,%ebp)
		popl %eax
		dispatch

		opcode (0x39)		/* ADD IX,SP */
ix39:           andb $0xec,%ah		/* clear some Flags  ### H noch falsch */
		movw z80regs+4,%di
		addw %di,IX
		adc $0,%ah
		dispatch

		opcode (0x44);		/* LD B,IXh */
ix44:		movb (IX+1),%ch
		dispatch

		opcode (0x45);		/* LD B,IXl */
ix45:		movb (IX),%ch
		dispatch

		opcode (0x4c);		/* LD C,IXh */
ix4c:		movb (IX+1),%cl
		dispatch

		opcode (0x4d);		/* LD C,IXl */
ix4d:		movb (IX),%cl
		dispatch

		opcode (0x54);		/* LD D,IXh */
ix54:		movb (IX+1),%dh
		dispatch

		opcode (0x55);		/* LD D,IXl */
ix55:		movb (IX),%dh
		dispatch

		opcode (0x5c);		/* LD E,IXh */
ix5c:		movb (IX+1),%dl
		dispatch

		opcode (0x5d);		/* LD E,IXl */
ix5d:		movb (IX),%dl
		dispatch

		opcode (0x60);		/* LD IXh,B */
ix60:		movb %ch,(IX+1)
		dispatch

		opcode (0x61);		/* LD IXh,C */
ix61:		movb %cl,(IX+1)
		dispatch

		opcode (0x62);		/* LD IXh,D */
ix62:		movb %dh,(IX+1)
		dispatch

		opcode (0x63);		/* LD IXh,E */
ix63:		movb %dl,(IX+1)
		dispatch

		opcode (0x64);		/* LD IXh,IXh */
ix64:		/* do nothing */
		dispatch

		opcode (0x65);		/* LD IXh,IXl */
ix65:		pushl %ecx
		movw IX,%cx
		movb %cl,%ch
		movw %cx,IX
		popl %ecx
		dispatch

		opcode (0x67);		/* LD IXh,A */
ix67:		movb %al,(IX+1)
		dispatch

		opcode (0x68);		/* LD IXl,B */
ix68:		movb %ch,(IX)
		dispatch

		opcode (0x69);		/* LD IXl,C */
ix69:		movb %cl,(IX)
		dispatch

		opcode (0x6a);		/* LD IXl,D */
ix6a:		movb %dh,(IX)
		dispatch

		opcode (0x6b);		/* LD IXl,E */
ix6b:		movb %dl,(IX)
		dispatch

		opcode (0x6c);		/* LD IXl,IXh */
ix6c:		pushl %ecx
		movw IX,%cx
		movb %ch,%cl
		movw %cx,IX
		popl %ecx
		dispatch

		opcode (0x65);		/* LD IXl,IXl */
ix6d:		/* do nothing */
		dispatch

		opcode (0x6f);		/* LD IXl,A */
ix6f:		movb %al,(IX)
		dispatch

		opcode (0x7c);		/* LD A,IXh */
ix7c:		movb (IX+1),%al
		dispatch

		opcode (0x7d);		/* LD A,IXl */
ix7d:		movb (IX),%al
		dispatch

                opcode (0x84)           /* ADD A,IXh */
ix84:           and $0xd5,%ah
                adcb (IX+1),%al
                jmp setaddadc

                opcode (0x85)           /* ADD A,IXl */
ix85:           and $0xd5,%ah
                adcb (IX),%al
                jmp setaddadc

                opcode (0x8c)           /* ADC A,IXh */
ix8c:           and $0xd5,%ah
                sahf
                adcb (IX+1),%al
                jmp setaddadc

                opcode (0x8d)           /* ADC A,IXl */
ix8d:           and $0xd5,%ah
                sahf
                adcb (IX),%al
                jmp setaddadc

ix94:		opcode (0x94)		/* SUB IXh */
		orb $2,%ah
		subb (IX+1),%al
		jmp setaddadc

ix95:		opcode (0x95)		/* SUB IXl */
		orb $2,%ah
		subb (IX),%al
		jmp setaddadc

ix9c:           opcode (0x9c)           /* SBC A,IXh */
                orb $2,%ah
                sahf
                sbbb (IX+1),%al
                jmp setaddadc
                
ix9d:           opcode (0x9d)           /* SBC A,IXl */
                orb $2,%ah
                sahf
                sbbb (IX),%al  
                jmp setaddadc

                opcode (0xa4)           /* AND IXh */
ixa4:           andb (IX+1),%al
                lahf
                incl %esi
                orb $0x10,%ah
                andb $0xd4,%ah
                dispatch

                opcode (0xa5)           /* AND IXl */
ixa5:           andb (IX),%al
                lahf
                orb $0x10,%ah
                andb $0xd4,%ah
                dispatch

                opcode (0xac)           /* XOR IXh */
ixac:           xorb (IX+1),%al
                lahf
                and $0xd4,%ah
                dispatch

                opcode (0xad)           /* XOR IXl */
ixad:           xorb (IX),%al
                lahf
                and $0xd4,%ah
                dispatch

                opcode (0xb4)           /* OR IXh */
ixb4:           orb (IX+1),%al
                lahf
                and $0xc4,%ah
                dispatch

                opcode (0xb5)           /* OR IXl */
ixb5:           orb (IX),%al
                lahf
                and $0xc4,%ah
                dispatch

                opcode (0xbc)           /* CP IXh */
ixbc:           orb $2,%ah
		cmpb (IX+1),%al
		jmp setaddadc

                opcode (0xbd)           /* CP IXl */
ixbd:           orb $2,%ah
		cmpb (IX),%al
		jmp setaddadc

                opcode(0xe1)		/* POP IX */
ixe1:		movl z80regs+4,%edi
		pushl %eax
		movw (%edi,%ebp),%ax
		incl %edi
		incl %edi
		movl %edi,z80regs+4
		movw %ax,IX
		popl %eax
		dispatch

                opcode (0xe5)		/* PUSH IX */
ixe5:		movl z80regs+4,%edi
		decw %di
		decw %di
		pushl %ebx
		movw IX,%bx
		movw %bx,(%ebp,%edi)
		popl %ebx
		movl %edi,z80regs+4
		dispatch

                opcode (0xe3)        	/* EX (SP),IX */
ixe3:		movl z80regs+4,%edi
		pushl %ebx
                movw (%edi,%ebp),%bx
		xchgw %bx,IX
		movw %bx,(%edi,%ebp)
		popl %ebx
	        dispatch

                opcode (0xe9)		/* JP (IX) */
ixe9:           movl IX,%esi
                dispatch

                opcode (0xeb)		/* EX DE,IX */
ixeb:           xchgl IX,%edx
                dispatch

                opcode (0xf9)		/* LD SP,IX */
ixf9:	        movl IX,%edi
		movl %edi,z80regs+4
                dispatch

