/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
		.data
jumptabiy:
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,iy09, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,iy19, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,iy21, iy22, iy23, iy24, iy25, iy26, EXIT2
		.long EXIT2,iy29, iy2a, iy2b, iy2c, iy2d, iy2e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iy34, iy35, iy36, EXIT2
		.long EXIT2,iy39, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2

		.long op00, op41, op42, op43 ,iy44, iy45, iy46, op47
		.long op48, op00, op4a, op4b, iy4c, iy4d, iy4e, op4f
		.long op50, op51, op00, op53, iy54, iy55, iy56, op57
		.long op58, op59, op5a, op00, iy5c, iy5d, iy5e, op5f
		.long iy60, iy61, iy62, iy63, iy64, iy65, iy66, iy67
		.long iy68, iy69, iy6a, iy6b, iy6c, iy6d, iy6e, iy6f
		.long iy70, iy71, iy72, iy73, iy74, iy75, EXIT2,iy77
		.long op78, op79, op7a, op7b, iy7c, iy7d, iy7e, op00

		.long EXIT2,EXIT2,EXIT2,EXIT2,iy84, iy85, iy86, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iy8c, iy8d, iy8e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iy94, iy95, iy96, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iy9c, iy9d, iy9e, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iya4, iya5, iya6, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iyac, iyad, iyae, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iyb4, iyb5, iyb6, EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,iybc, iybd, iybe, EXIT2

		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,iycb, EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,iye1, EXIT2,iye3, EXIT2,iye5, EXIT2,EXIT2
		.long EXIT2,iye9, EXIT2,iyeb, EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.long EXIT2,iyf9, EXIT2,EXIT2,EXIT2,EXIT2,EXIT2,EXIT2
		.text

		
		opcode (0x09)		/* ADD IY,BC */
iy09:           andb $0xec,%ah		/* ### H noch falsch */
		addw %cx,IY
		adcb $0,%ah		/* set carry flag if necessary (8 Byte) */
		dispatch
		opcode (0x19)		/* ADD IY,DE */
iy19:           andb $0xec,%ah		/* ### H noch falsch */
		addw %dx,IY
		adc $0,%ah
		dispatch

		opcode (0x21)		/* LD IY,nnnn */
iy21:           movw (%esi,%ebp),%di
		movw %di,IY
		incl %esi
		incl %esi
		dispatch

		opcode (0x22)           /* LD (nnnn),IY */
iy22:		movzwl (%esi,%ebp),%edi
		pushl %ebx
		movl IY,%ebx
		movw %bx,(%edi,%ebp)
		popl %ebx
		incl %esi
		incl %esi
		dispatch

		opcode (0x23)		/* INC IY */
iy23:           incw IY
		dispatch

iy24:           opcode (0x24)           /* INC IYh */
                inc8mac(IY+1)
                dispatch

iy25:           opcode (0x25)           /* DEC IYh */
                dec8mac(IY+1)
                dispatch
                
iy26:           opcode (0x26)           /* LD IYh, nn */
                pushl %ecx
                movw IY,%cx
                movb (%esi,%ebp),%ch
                movw %cx,IY
                popl %ecx  
                incl %esi 
                dispatch

iy2c:           opcode (0x2c)           /* INC IYl */
                inc8mac(IY)
                dispatch
                
iy2d:           opcode (0x2d)           /* DEC IYl */   
                dec8mac(IY)
                dispatch  
                
iy2e:           opcode (0x2e)           /* LD IYl, nn */
                pushl %ecx
                movw IY,%cx
                movb (%esi,%ebp),%cl
                movw %cx,IY
                popl %ecx  
                incl %esi
                dispatch

		opcode (0x29)		/* ADD IY,IY */
iy29:           andb $0xec,%ah		/* clear some Flags  ### H noch falsch */
		movl IY,%edi
		addw %di,%di
		movl %edi,IY
		adc $0,%ah
		dispatch

		opcode (0x2a)		/* LD IY,(nnnn) */
iy2a:           movzwl (%esi,%ebp),%edi
		pushl %ebx
		movw (%edi,%ebp),%bx
		movw %bx,IY
		popl %ebx
		incl %esi
		incl %esi
		dispatch

		opcode (0x2b)		/* DEC IY */
iy2b:           decw IY
		dispatch

		opcode (0x34)           /* INC (IY+off) */
iy34:		GETIYOFF
		inc8mac((%ebp,%edi))
		dispatch

		opcode (0x35)	        /* DEC (IY+off) */
iy35:		GETIYOFF
		dec8mac((%ebp,%edi))
		dispatch

		opcode (0x36)		/* LD (IY+off),nn */
iy36:		GETIYOFF
		pushl %eax
		movb (%esi,%ebp),%al
		incl %esi
		movb %al,(%edi,%ebp)
		popl %eax
		dispatch

		opcode (0x39)		/* ADD IY,SP */
iy39:           andb $0xec,%ah		/* clear some Flags  ### H noch falsch */
		movw z80regs+4,%di
		addw %di,IY
		adc $0,%ah
		dispatch

                opcode (0x44);          /* LD B,IYh */
iy44:           movb (IY+1),%ch
                dispatch
                
                opcode (0x45);          /* LD B,IYl */
iy45:           movb (IY),%ch
                dispatch
                
                opcode (0x4c);          /* LD C,IYh */
iy4c:           movb (IY+1),%cl
                dispatch

                opcode (0x4d);          /* LD C,IYl */
iy4d:           movb (IY),%cl
                dispatch  
                
                opcode (0x54);          /* LD D,IYh */
iy54:           movb (IY+1),%dh
                dispatch
                
                opcode (0x55);          /* LD D,IYl */
iy55:           movb (IY),%dh
                dispatch
                
                opcode (0x5c);          /* LD E,IYh */
iy5c:           movb (IY+1),%dl
                dispatch
                
                opcode (0x5d);          /* LD E,IYl */
iy5d:           movb (IY),%dl
                dispatch
                
                opcode (0x60);          /* LD IYh,B */
iy60:           movb %ch,(IY+1)
                dispatch
                
                opcode (0x61);          /* LD IYh,C */
iy61:           movb %cl,(IY+1)
                dispatch

                opcode (0x62);          /* LD IYh,D */
iy62:           movb %dh,(IY+1)
                dispatch
                
                opcode (0x63);          /* LD IYh,E */
iy63:           movb %dl,(IY+1)
                dispatch
                
                opcode (0x64);          /* LD IYh,IYh */
iy64:           /* do nothing */
                dispatch
                
                opcode (0x65);          /* LD IYh,IYl */
iy65:           pushl %ecx
                movw IY,%cx
                movb %cl,%ch
                movw %cx,IY
                popl %ecx
                dispatch
                
                opcode (0x67);          /* LD IYh,A */
iy67:           movb %al,(IY+1)
                dispatch
                
                opcode (0x68);          /* LD IYl,B */
iy68:           movb %ch,(IY)
                dispatch
                
                opcode (0x69);          /* LD IYl,C */
iy69:           movb %cl,(IY)
                dispatch  
                
                opcode (0x6a);          /* LD IYl,D */
iy6a:           movb %dh,(IY)
                dispatch 
                
                opcode (0x6b);          /* LD IYl,E */
iy6b:           movb %dl,(IY)
                dispatch
                
                opcode (0x6c);          /* LD IYl,IYh */
iy6c:           pushl %ecx
                movw IY,%cx  
                movb %ch,%cl
                movw %cx,IY
                popl %ecx
                dispatch
                
                opcode (0x65);          /* LD IYl,IYl */
iy6d:           /* do nothing */
                dispatch
                
                opcode (0x6f);          /* LD IYl,A */
iy6f:           movb %al,(IY)
                dispatch
                
                opcode (0x7c);          /* LD A,IYh */
iy7c:           movb (IY+1),%al
                dispatch  
                
                opcode (0x7d);          /* LD A,IYl */
iy7d:           movb (IY),%al
                dispatch                 

                opcode (0x84)           /* ADD A,IYh */
iy84:           and $0xd5,%ah
                adcb (IY+1),%al
                jmp setaddadc

                opcode (0x85)           /* ADD A,IYl */
iy85:           and $0xd5,%ah
                adcb (IY),%al
                jmp setaddadc
                
		opcode (0x8c)           /* ADC A,IYh */
iy8c:           and $0xd5,%ah
		sahf
		adcb (IY+1),%al
		jmp setaddadc

                opcode (0x8d)           /* ADC A,IYl */
iy8d:           and $0xd5,%ah
		sahf
		adcb (IY),%al
		jmp setaddadc

iy94:           opcode (0x94)           /* SUB IYh */
                orb $2,%ah
                subb (IY+1),%al
                jmp setaddadc
                
iy95:           opcode (0x95)           /* SUB IYl */
                orb $2,%ah
                subb (IY),%al
                jmp setaddadc

iy9c:           opcode (0x9c)           /* SBC A,IYh */
                orb $2,%ah
		sahf
                sbbb (IY+1),%al
                jmp setaddadc
                
iy9d:           opcode (0x9d)           /* SBC A,IYl */
                orb $2,%ah
		sahf
                sbbb (IY),%al
                jmp setaddadc

                opcode (0xa4)           /* AND IYh */  
iya4:           andb (IY+1),%al
                lahf
                incl %esi
                orb $0x10,%ah
                andb $0xd4,%ah
                dispatch  
                
                opcode (0xa5)           /* AND IYl */
iya5:           andb (IY),%al  
                lahf
                orb $0x10,%ah
                andb $0xd4,%ah
                dispatch
                
                opcode (0xac)           /* XOR IYh */
iyac:           xorb (IY+1),%al
                lahf
                and $0xd4,%ah  
                dispatch
                
                opcode (0xad)           /* XOR IYl */
iyad:           xorb (IY),%al 
                lahf
                and $0xd4,%ah
                dispatch

                opcode (0xb4)           /* OR IYh */
iyb4:           orb (IY+1),%al
                lahf
                and $0xc4,%ah
                dispatch
                
                opcode (0xb5)           /* OR IYl */
iyb5:           orb (IY),%al
                lahf
                and $0xc4,%ah
                dispatch
                
                opcode (0xbc)           /* CP IYh */
iybc:           orb $2,%ah
                cmpb (IY+1),%al
                jmp setaddadc

                opcode (0xbd)           /* CP IYl */
iybd:           orb $2,%ah
                cmpb (IY),%al
                jmp setaddadc

                opcode (0xe1)		/* POP IY */
iye1:		movl z80regs+4,%edi
		pushl %eax
		movw (%edi,%ebp),%ax
		incl %edi
		incl %edi
		movl %edi,z80regs+4
		movw %ax,IY
		popl %eax
		dispatch

                opcode (0xe5)		/* PUSH IY */
iye5:		movl z80regs+4,%edi
		decw %di
		decw %di
		pushl %ebx
		movw IY,%bx
		movw %bx,(%ebp,%edi)
		popl %ebx
		movl %edi,z80regs+4
		dispatch

                opcode (0xe3)        	/* EX (SP),IY */
iye3:		movl z80regs+4,%edi
		pushl %ebx
                movw (%edi,%ebp),%bx
		xchgw %bx,IY
		movw %bx,(%edi,%ebp)
		popl %ebx
	        dispatch

                opcode (0xe9)		/* JP (IY) */
iye9:           movl IY,%esi
                dispatch

                opcode (0xeb)		/* EX DE,IY */
iyeb:           xchgl IY,%edx
                dispatch

                opcode (0xf9)		/* LD SP,IY */
iyf9:	        movl IY,%edi
		movl %edi,z80regs+4
                dispatch

