#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

int
main(int argc, char **argv) {
  FILE *infile;
  char *shortname;
  const char *filename;
  int i;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s fntfile\nConverts an 8x16 fnt console font file to a bdf file.\n", argv[0]);
    return 2;
  }
  filename = argv[1];
  if ((argv[1][0] == '-') && ! argv[1][1]) {
    infile = stdin;
    filename = "stdin";
  } else if (! (infile = fopen(argv[1], "rb"))) {
    perror(filename);
    return 1;
  }
  if (! (shortname = strdup(filename))) {
    perror("strdup");
    exit (1);
  } else {
    int len = strlen(shortname);

    if ((len > 4) && ! strcasecmp(shortname + len - 4, ".fnt"))
      shortname[len - 4] = '\0';
  }
  printf("STARTFONT 2.1\n");
  printf("FONT %s\n", shortname);
  printf("SIZE 16 75 75\n");
  printf("FONTBOUNDINGBOX 8 16 0 -4\n");
  printf("STARTPROPERTIES 3\n");
  printf("FONT_DESCENT 4\n");
  printf("FONT_ASCENT 12\n");
  printf("DEFAULT_CHAR 0\n");
  printf("ENDPROPERTIES\n");
  printf("CHARS 256\n");
  for (i = 0; i < 256; i++) {
    int j;

    printf("STARTCHAR C%4.4x\n", i);
    printf("ENCODING %d\n", i);
    printf("SWIDTH 666 0\n");
    printf("DWIDTH 8 0\n");
    printf("BBX 8 16 0 -4\n");
    printf("BITMAP\n");
    for (j = 0; j < 16; j++) {
      int c;

      if ((c = fgetc(infile)) == EOF) {
	if (feof(infile))
	  fprintf(stderr, "%s: premature EOF\n", filename);
	else
	  perror(filename);
	return 1;
      }
      printf("%2.2x\n", c);
    }
    printf("ENDCHAR\n");
  }
  printf("ENDFONT\n");
  if (infile != stdin)
    fclose(infile);
  return 0;
}
