/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
#include "cpmemu.h"
#include <unistd.h>

int throttle = 1;
int debug = 0;
int prompt = 1;
int bdos_emulate = 1;	/* default = ON */
int silent_exit = 0;
int restricted_mode = 0;
int hardware_access = 0;
jmp_buf mainloop;

int main(int argc, char *argv[]) {
    int i;
    int nosys = 0;
    const char *systemfile = CPMLIBDIR "/cpm.sys";
    const char *load_file = NULL;
    const char *cpmtty = NULL;
    const char *startdir = NULL;
    /* which disk to use? */
    const char *imagefile = "/dev/fd1";	/* use setfdprm to set 10 sectors/track */
    /* when setting dpb, you may ignore the fields BLM, EXM, AL0, and AL1. They are set by bios.c */
    static struct dpb dpb0 = { 40, 4, 15, 0, 394, 255, 0xf0, 0x00, 64, 1 };

    for (i = 1; i < argc; ++i) {
	if (!strcmp(argv[i], "-?") || !strcmp(argv[i], "-h")) {
	    fprintf(stderr, "usage: cpm [options] CP/M-command\n"
		    "where options are\n"
		    "-h or -?        display this message\n"
		    "-s (systemfile) use a different CCP/BDOS\n"
		    "-i (imagefile)  use a different Cp/M disk image\n"
		    "-p              no debugging prompt (for batch)\n"
		    "-e              do not emulate BDOS (use imagefile)\n"
		    "-t (tty)        use (tty) for Cp/M console\n"
		    "-r              restricted mode: do not allow changing directories\n"
		    "-D (dir)        specify starting directory\n"
		    "-d              enter debugging mode at start\n"
                    "-f              do not use slowdown code\n"
                    "-v              display version and exit\n"
		    "-H		     direct hardware access\n"
		    "-l (file)       load file at 0x100 (do not execute it)\n"
		    "-x		     don't load CCP; CP/M command is a .COM file in current dir\n"
		    "Note: Pressing ctrl-@ will enter the debugger\n");
	    exit(0);
	} else if (!strcmp(argv[i], "-d"))
	    debug = 1;
	else if (!strcmp(argv[i], "-v"))
	  {
	    fprintf (stderr, "%s-%s\n", PACKAGE, VERSION);
	    exit (0);
	  }
	else if (!strcmp(argv[i], "-e"))
	    bdos_emulate ^= 1;
	else if (!strcmp(argv[i], "-r"))
	    restricted_mode ^= 1;
	else if (!strcmp(argv[i], "-p"))
	    prompt = 0;
        else if (!strcmp(argv[i], "-f"))
	    throttle = 0;
	else if (!strcmp(argv[i], "-H"))
	    hardware_access = 1;	/* must be root to use this! */
	else if (!strcmp(argv[i], "-t"))
	    cpmtty = argv[++i];
	else if (!strcmp(argv[i], "-l"))
	    load_file = argv[++i];
	else if (!strcmp(argv[i], "-s"))
	    systemfile = argv[++i];
	else if (!strcmp(argv[i], "-D"))
	    startdir = argv[++i];
	else if (!strcmp(argv[i], "-i"))
	    imagefile = argv[++i];
	else if (!strcmp(argv[i], "-x"))
	    nosys = 1;
	else
	    break;
    }

    /* setup BIOS part of memory image */
    benchmark(nosys | (argc-i) ? 0 : 1);
    if (hardware_access)
	lowlevel_init();
    cpm_init(imagefile, systemfile, &dpb0, nosys);
    setup_io(cpmtty);		/* setting I/O to no-echo */
    if (load_file)
	loadfile(load_file);
    if (!nosys) cpminit2(argc-i, argv+i);
    if (startdir)
	if (chdir(startdir)) {
	    fprintf(stderr, "Cannot change directory to %s\n", startdir);
	    exit(1);
	}
    if (nosys) cpminit3(argc-i, argv+i);
    for (;;) {
	while (setjmp(mainloop))
	    ;
	if (debug) {
	    debug = 1;
	    commandloop();
	} else {
    	    /* run until trap */
	    if (! throttle)
	      z80run();
	    else
	      run_at_2MHz();
	    debug = 1;
	    /* break; */
	}
    }
    return 0;
}
