@rem
@rem Batch file to compile an UZIX application under MSDOS using Z80MU
@rem (c) 2001 A&L Software
@rem
@rem This program is under GPL License.
@rem
@rem Z80MU can be found at http://www.simtel.net
@rem

@echo off
if "%1" == "" goto error
if not exist %1.c goto nofile

rem echo CPP -DMSX_UZIX_TARGET -DHI_TECH_C -Dz80 -I %1.c $C1.T 

sed "s/#asm/__asm/g;s/#endasm/__endasm/g" %1.c > %1.t1
gcc -P -x c -E -nostdinc -I./include -I. -DCPM -DHI_TECH_C -Dz80 %1.t1 > %1.t2 2>_gcc.out
sed "s/__asm/#asm/g;s/__endasm/#endasm/g" %1.t2 > C1.T

echo P1 C1.T C2.T C3.T > AUTOEXEC.Z80

echo CGEN C2.T C3.T >> AUTOEXEC.Z80
echo QUIT >> AUTOEXEC.Z80

z80mu
del AUTOEXEC.Z80

if "%2" == "-o" goto optim
echo ZAS -X -J -N -o%1.O C3.T >> AUTOEXEC.Z80

:compile

echo LINK -Z -X -Ptext=0,data,bss -C100H -O%1.COM CRTCPM.OBJ %1.O %2 %3 %4 %5 %6 %7 %8 %9 LIBC.LIB >> AUTOEXEC.Z80
echo QUIT >> AUTOEXEC.Z80

goto end

z80mu
if exist %1.t1 del %1.t1 > nul
if exist %1.t2 del %1.t2 > nul
if exist c1.t del c1.t > nul
if exist c2.t del c2.t > nul
if exist c3.t del c3.t > nul
if exist c4.t del c4.t > nul
del %1.o > nul
if exist %1.map del %1.map > nul
if exist CC.m ren CC.m %1.map > nul
rem del autoexec.z80 > nul
if exist CC.m del CC.m
goto end

:optim

echo OPTIM C3.T C4.T >> AUTOEXEC.Z80
echo ZAS -X -J -N -o%1.OBJ C4.T >> AUTOEXEC.Z80
goto compile

:nofile
echo Source file does not exist.
goto end

:error
echo usage: ucc sourcefile [-o] [library1] [library2...]
echo        source filename must be supplied without extension.
echo        option -o disables code optimization.
echo        library1, library2, etc are other libraries to link
echo        map file is automatically generated (sourcefile.map)

:end
