﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Text;

namespace ZXBYTE
{
    internal class LogAgent
    {
        public static void DumpArray<T>(string fileName, T[] array)
        {
            using (var fs = new FileStream(fileName, FileMode.Create, FileAccess.Write, FileShare.Read))
            using (var wr = new StreamWriter(fs))
            {
                for (var i = 0; i < array.Length; i++)
                {
                    wr.WriteLine("{0} = {1}", i, array[i]);
                }
            }
        }

        private static Dictionary<string, FileStream> s_fileCache = new Dictionary<string, FileStream>();
        
        public static void DumpAppend(
            string fileName,
            string format,
            params object[] args)
        {
            var key = fileName.ToLower();
            if (!s_fileCache.ContainsKey(key))
            {
                 s_fileCache.Add(key, new FileStream(fileName, FileMode.Create, FileAccess.Write, FileShare.Read));
            }
            var fs = s_fileCache[key];
            var msg = string.Format(format, args) + Environment.NewLine;
            var buf = Encoding.Default.GetBytes(msg);
            fs.Write(buf, 0, buf.Length);
        }

        public static void Finish()
        {
            foreach (var fs in s_fileCache.Values)
            {
                try
                {
                    fs.Flush();
                    fs.Close();
                }
                catch 
                { 
                }
            }
            s_fileCache.Clear();
        }
    }
}
