﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace ZXBYTE
{
    class Program
    {
        static void Main(string[] args)
        {
            var romDd10 = new byte[0x200];
            var romDd11 = new byte[0x200];
            using (var fs = new FileStream("DD10_RT5.BIN", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                fs.Read(romDd10, 0, romDd10.Length);
            }
            using (var fs = new FileStream("DD11_RT5.BIN", FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                fs.Read(romDd11, 0, romDd11.Length);
            }
            var fullOutput = args.Length > 0 &&
                args[0].ToLower() == "/f";
            
            Simulate(romDd10, romDd11, 69888*4, fullOutput);
            
            LogAgent.Finish();
        }

        private static void Simulate(
            byte[] romDd10, 
            byte[] romDd11, 
            int maximumTact,
            bool fullOutput)
        {
            var formatString = fullOutput ?
                "{0,5} = {1,5} {2,5} {3,5} {4,5} {5,5} {6,5} {7,5} {8,5} {9,5} {10,5} {11,5}" :
                "{0,5} = {1,5} {2,5} {3,5} {4,5}";
            if (fullOutput)
            {
                LogAgent.DumpAppend(
                    "_dd10log.txt",
                    formatString,
                    "tact", "hsync", "pre34", "blclk", "latch", "hretr",
                    "vsync", "pre56", "hlock", "vretr", "intrq", "bus23");
            }
            else
            {
                LogAgent.DumpAppend(
                    "_dd10log.txt",
                    formatString,
                    "tact", "vsync", "pre56", "hlock", "vretr");
            }
            const int dd3dd4set = 0x280 >> 1;
            const int dd5dd6set = 0x0F0;
            var dd10addr = dd3dd4set;
            var dd11addr = dd5dd6set;
            var lastHsync = (romDd10[dd3dd4set & 0x1FF] & 0x01) != 0;
            //var lastRetrace = (romDd10[dd3dd4set & 0x1FF] & 0x80) == 0;
            var lastResetTime = -1;
            var lastResetTime2 = -1;
            var intgt = true;
            for (var i = 0; i < maximumTact; i++)
            {
                #region Dump State
                
                if (fullOutput)
                {
                    var vsync = (romDd11[dd11addr & 0x1FF] & 1) != 0;
                    var pre56 = (romDd11[dd11addr & 0x1FF] & 2) != 0;
                    var hlock = (romDd11[dd11addr & 0x1FF] & 0x10) != 0;
                    var vretr = (romDd11[dd11addr & 0x1FF] & 0x20) != 0;
                    var bus75 = (romDd11[dd11addr & 0x1FF] & 0x80) != 0;

                    var dd10val = romDd10[dd10addr & 0x1FF];
                    var dd11val = romDd11[dd11addr & 0x1FF];
                    // D0 - ССИ (horizontal sync pulse)
                    var hsync = (dd10val & 1) != 0;
                    // D1 - preload DD3/DD4
                    var pre34 = (dd10val & 2) != 0;
                    // D2 - BUS20 = A1 for DD38-DD41 (vram address generator)
                    // D3 - RAS
                    // D4 - CAS
                    // D5 - BUS23 = block CLK when BUS23=1 and mem access #4000-7FFF
                    var blclk = (dd10val & 0x20) != 0;
                    // D6 - BUS24 = attr/pixel latch, BUS24=0 -> attr latch
                    var latch = (dd10val & 0x40) != 0;
                    // D7 - BUS142 = horizontal retrace
                    var hretr = (dd10val & 0x80) != 0;

                    if (hretr)                      // TM2 - always set on S=0
                    {
                        intgt = true;
                    }
                    else if (hsync && !lastHsync)   // TM2 - capture D on UP CLK transition
                    {
                        intgt = false;
                    }
                    var intrq = intgt | bus75;

                    var bus23 = blclk && !hlock;

                    lastHsync = hsync;

                    LogAgent.DumpAppend(
                        "_dd10log.txt",
                        formatString,
                        i,
                        hsync ? 1 : 0,
                        pre34 ? 1 : 0,
                        blclk ? 1 : 0,
                        latch ? 1 : 0,
                        hretr ? 1 : 0,
                        vsync ? 1 : 0,
                        pre56 ? 1 : 0,
                        hlock ? 1 : 0,
                        vretr ? 1 : 0,
                        intrq ? 1 : 0,
                        bus23 ? 1 : 0);
                }

                #endregion

                for (var j = 0; j < 2; j++)
                {
                    // DD2=#E=>#F -> UP-DOWN transition on DD3-C
                    // DD2=#F=>#0 -> DOWN-UP transition on DD3-C
                    var pre34 = (romDd10[dd10addr & 0x1FF] & 2) == 0;
                    var lastVblank = (romDd10[dd10addr & 0x1FF] & 0x80) == 0;
                    dd10addr++;
                    var dd3c = (dd10addr & 7) == 0;
                    var dd4c = dd3c && (dd10addr & 0x78) == 0;
                    if (dd3c && pre34)
                    {
                        dd10addr = (dd10addr & 0x187) | (dd3dd4set & 0x078);
                        if (fullOutput)
                        {
                            LogAgent.DumpAppend(
                                "_dd10log.txt",
                                "{0,5} = LOAD DD3",
                                i);
                        }
                    }
                    if (dd4c && pre34)
                    {
                        dd10addr = (dd10addr & 0x07F) | (dd3dd4set & 0x180);
                        if (fullOutput)
                        {
                            LogAgent.DumpAppend(
                                "_dd10log.txt",
                                "{0,5} = LOAD DD4 dt={1}",
                                i,
                                i - lastResetTime);
                        }
                        lastResetTime = i;
                    }
                    var pre56 = (romDd11[dd11addr & 0x1FF] & 2) == 0;
                    var vblank = (romDd10[dd10addr & 0x1FF] & 0x80) == 0;
                    if (pre56)
                    {
                        dd11addr = (dd11addr & 0x100) | (dd5dd6set & 0xFF);
                        var dt = i - lastResetTime2;
                        LogAgent.DumpAppend(
                            "_dd10log.txt",
                            "{0,5} = LOAD DD5/DD6 dt={1} [{2} lines]",
                            i,
                            dt,
                            dt / 224D);
                        lastResetTime2 = i;
                    }
                    else if (vblank && !lastVblank)
                    {
                        dd11addr++;
                    }
                    if (!fullOutput && (pre56 || (vblank && !lastVblank)))
                    {
                        var lvsync = (romDd11[dd11addr & 0x1FF] & 1) != 0;
                        var lpre56 = (romDd11[dd11addr & 0x1FF] & 2) != 0;
                        var lhlock = (romDd11[dd11addr & 0x1FF] & 0x10) != 0;
                        var lvretr = (romDd11[dd11addr & 0x1FF] & 0x20) != 0;
                        LogAgent.DumpAppend(
                            "_dd10log.txt",
                            formatString,
                            i,
                            lvsync ? 1 : 0,
                            lpre56 ? 1 : 0,
                            lhlock ? 1 : 0,
                            lvretr ? 1 : 0);
                    }
                }
            }
        }
    }
}
