using System;
using System.IO;

namespace Mons2Bin
{
	class Programm
	{
		static int FromHex(char ch)
		{
			switch (ch)
			{
				case '0': return 0;
				case '1': return 1;
				case '2': return 2;
				case '3': return 3;
				case '4': return 4;
				case '5': return 5;
				case '6': return 6;
				case '7': return 7;
				case '8': return 8;
				case '9': return 9;
				case 'a':
				case 'A': return 10;
				case 'b':
				case 'B': return 11;
				case 'c':
				case 'C': return 12;
				case 'd':
				case 'D': return 13;
				case 'e':
				case 'E': return 14;
				case 'f':
				case 'F': return 15;
			}

			return -1;
		}

		static bool IsSpc(char ch)
		{
			return (ch==' ' || ch=='\t');
		}

		[STAThread]
		static void Main(string[] args)
		{
			Console.WriteLine("Mons2Bin (c)restorer'o6");

			if (args.Length != 2)
			{
				Console.WriteLine("Usage: Mons2Bin <mons4_disasm_file> <output_file>");
				return;
			}

			Console.WriteLine("Convert " + args[0] + " to " + args[1]);

			try
			{
				string buf;
				StreamReader sr = new StreamReader(args[0]);
				FileStream fs = new FileStream(args[1], FileMode.CreateNew);
				BinaryWriter wr = new BinaryWriter(fs);

				int addr = -1;
				int line = 0;

				while ((buf = sr.ReadLine()) != null)
				{
					line++;
					int p = 0;
					int currAddr = 0;

					if (p >= buf.Length) continue;
					while (p<buf.Length && IsSpc(buf[p])) p++;
					if (p >= buf.Length) continue;

					if (buf[p] == ';') continue;

					for (int i = 0; i < 4; i++)
					{
						int n = FromHex(buf[p]);
						if (n < 0)
						{
							Console.WriteLine("E: Invalid address format at line " + line.ToString());
							goto exitLoop;
						}

						currAddr = currAddr * 0x10 + n;

						p++;
						if (p >= buf.Length)
						{
							Console.WriteLine("E: Invalid address format at line " + line.ToString());
							goto exitLoop;
						}
					}

					if (addr < 0) addr = currAddr;
					else
					if (addr != currAddr)
					{
						Console.WriteLine("W: Unexpected address at line " + line.ToString());
						addr = currAddr;
					}

					while (p<buf.Length && IsSpc(buf[p])) p++;
					if (p >= buf.Length)
					{
						Console.WriteLine("W: No data found at line " + line.ToString());
						continue;
					}

					while (p<buf.Length && !IsSpc(buf[p]))
					{
						if (buf[p] == '*')
						{
							p++;
							continue;
						}

						int h = FromHex(buf[p++]);
						if (p>=buf.Length || h<0)
						{
							Console.WriteLine("E: Invalid data format at line " + line.ToString());
							goto exitLoop;
						}

						int l = FromHex(buf[p++]);
						if (h < 0)
						{
							Console.WriteLine("E: Invalid data format at line " + line.ToString());
							goto exitLoop;
						}

						int n = h * 0x10 + l;

						wr.Write((byte)n);
						addr++;
					}
				}

				Console.WriteLine("Success");

			exitLoop:

				wr.Close();
				fs.Close();
				sr.Close();
			}
			catch (Exception ex)
			{
				Console.WriteLine("X: " + ex.Message);
			}
		}
	}
}
