#ifndef _AYCHIP_H_INCLUDED_
#define _AYCHIP_H_INCLUDED_ 1

#include "wavplay.h"
#include "sndrenderer.h"

const unsigned AYCHIP_VOL_AY[] =
{
	0x0000, 0x0000, 0x0340, 0x0340, 0x04C0, 0x04C0, 0x06F2, 0x06F2,
	0x0A44, 0x0A44, 0x0F13, 0x0F13, 0x1510, 0x1510, 0x227E, 0x227E,
	0x289F, 0x289F, 0x414E, 0x414E, 0x5B21, 0x5B21, 0x7258, 0x7258,
	0x905E, 0x905E, 0xB550, 0xB550, 0xD7A0, 0xD7A0, 0xFFFF, 0xFFFF
};

const unsigned AYCHIP_VOL_YM[] =
{
	0x0000, 0x0000, 0x00EF, 0x01D0, 0x0290, 0x032A, 0x03EE, 0x04D2,
	0x0611, 0x0782, 0x0912, 0x0A36, 0x0C31, 0x0EB6, 0x1130, 0x13A0,
    0x1751, 0x1BF5, 0x20E2, 0x2594, 0x2CA1, 0x357F, 0x3E45, 0x475E,
	0x5502, 0x6620, 0x7730, 0x8844, 0xA1D2, 0xC102, 0xE0A2, 0xFFFF
};

const unsigned AYCHIP_PAN_MONO[] = { 100,100, 100,100, 100,100 };
const unsigned AYCHIP_PAN_ABC[]  = { 100,10,  66,66,   10,100  };
const unsigned AYCHIP_PAN_ACB[]  = { 100,10,  10,100,  66,66   };
const unsigned AYCHIP_PAN_BAC[]  = { 66,66,   100,10,  10,100  };
const unsigned AYCHIP_PAN_BCA[]  = { 10,100,  100,10,  66,66   };
const unsigned AYCHIP_PAN_CAB[]  = { 66,66,   10,100,  100,10  };
const unsigned AYCHIP_PAN_CBA[]  = { 10,100,  66,66,   100,10  };

class C_AyChip
{
	public:

	enum AYCHIP_TYPE { AYCHIP_AY, AYCHIP_YM };

	C_AyChip();

	void StartFrame(s_waveSample *dst);
	unsigned EndFrame(unsigned clkTicks);

	static const char *GetChipName(AYCHIP_TYPE type);
	void SetChipType(AYCHIP_TYPE type);
	void SetTimings(unsigned systemClockRate, unsigned chipClockRate, unsigned sampleRate);
	void SetVolumes(unsigned globalVolume, const unsigned *volTab, const unsigned *panTab);

	void Reset(unsigned timestamp = 0);
	void ApplyRegs(unsigned timestamp = 0);

	void Select(BYTE reg);
	void Write(unsigned timestamp, BYTE val);
	BYTE Read(void);
	void Flush(unsigned chiptick);

	protected:

	AYCHIP_TYPE chipType;
	C_SndRenderer renderer;

	unsigned t, ta, tb, tc, tn, te, env, denv;
	unsigned bitA, bitB, bitC, bitN, ns;
	unsigned bit0, bit1, bit2, bit3, bit4, bit5;
	unsigned ea, eb, ec, va, vb, vc;
	unsigned multConst;

	unsigned activeReg;
	unsigned vols[6][32];
	BYTE regs[0x10];

	WORD r_fA, r_fB, r_fC;	// 0, 1, 2, 3, 4, 5
	BYTE r_noise, r_mix;	// 6, 7
	BYTE r_vA, r_vB, r_vC;	// 8, 9, 10
	WORD r_envT;			// 11, 12
	BYTE r_env;				// 13
	BYTE r_portA, r_portB;	// 14, 15

	unsigned chipClockRate, systemClockRate;
	__int64 passedChipTicks, passedClkTicks;
};

#endif
