#include "defines.h"

char* GetErrorMessage(void)
{
	static char msg[1024];

	if (!FormatMessage(
			FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
			(LPSTR)msg,
			sizeof(msg),
			NULL ))
	{
		strcpy(msg, "(!) FormatMessage error");
	}

	return msg;
}

int addLogFirst = 1;

void AddLog(char *fmt, ...)
{
	va_list argptr;
	char buf[0x800];
	FILE *fp;

	va_start(argptr, fmt);
	vsprintf(buf, fmt, argptr);
	va_end(argptr);

	if (addLogFirst)
	{
		fp = fopen("debuglog.txt", "wb");
		addLogFirst = 0;
	}
	else fp = fopen("debuglog.txt", "ab");

	if (fp != NULL)
	{
		fprintf(fp, "%s\n", buf);
		fclose(fp);
	}
}

void AddLogN(char *fmt, ...)
{
	va_list argptr;
	char buf[0x800];
	FILE *fp;

	va_start(argptr, fmt);
	vsprintf(buf, fmt, argptr);
	va_end(argptr);

	if (addLogFirst)
	{
		fp = fopen("debuglog.txt", "wb");
		addLogFirst = 0;
	}
	else fp = fopen("debuglog.txt", "ab");

	if (fp != NULL)
	{
		fprintf(fp, "%s", buf);
		fclose(fp);
	}
}
