#ifndef _SNDRENDERER_H_INCLUDED_
#define _SNDRENDERER_H_INCLUDED_ 1

#include "wavplay.h"

class C_SndRenderer
{
	public:

	C_SndRenderer();
	void SetTimings(unsigned clockRate, unsigned sampleRate);

	void StartFrame(s_waveSample *dst);
	void Update(unsigned timestamp, unsigned l, unsigned r);
	unsigned EndFrame(unsigned clkTicks);

	protected:

	void Flush(unsigned endTick);

	unsigned mixL, mixR;
	s_waveSample *dstPos, *dstStart;
	unsigned tick, baseTick;

	unsigned s1L, s1R;
	unsigned s2L, s2R;

	unsigned clockRate, sampleRate;
	__int64 passedClkTicks, passedSndTicks;
	unsigned multConst;
};

#endif
