#include "wavplay.h"

C_WavePlayer::C_WavePlayer()
{
	int i;
	MMRESULT res;
	WAVEFORMATEX wfx;

	hwo = NULL;
	curr = 0;

	for (i = 0; i < MAX_WAVE_BUFFERS; i++)
	{
		wh[i].dwFlags = WHDR_DONE;
		wh[i].lpData = NULL;
	}

	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;
	wfx.nSamplesPerSec = 44100;
	wfx.nBlockAlign = 4;
	wfx.wBitsPerSample = 16;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
	wfx.cbSize = sizeof(wfx);

	res = waveOutOpen(&hwo, WAVE_MAPPER, &wfx, NULL, NULL, CALLBACK_NULL);
	if (res != MMSYSERR_NOERROR) throw GetErrorMessage;
}

C_WavePlayer::~C_WavePlayer()
{
	int i;

	if (hwo != NULL)
	{
		waveOutClose(hwo);
		hwo = NULL;

		for (i = 0; i < MAX_WAVE_BUFFERS; i++)
		{
			if (wh[i].lpData != NULL)
			{
				waveOutUnprepareHeader(hwo, (LPWAVEHDR)&wh[i], sizeof(WAVEHDR));
				delete[] wh[i].lpData;
				wh[i].lpData = NULL;
			}
		}
	}
}

void C_WavePlayer::Play(s_waveSample *buf, unsigned int sz)
{
	while (!(wh[curr].dwFlags & WHDR_DONE)) Sleep(10);

	if (wh[curr].lpData != NULL)
	{
		waveOutUnprepareHeader(hwo, (LPWAVEHDR)&wh[curr], sizeof(WAVEHDR));
		delete[] wh[curr].lpData;
	}

	wh[curr].dwFlags = 0;

	wh[curr].dwBufferLength = sz * sizeof(s_waveSample);
	wh[curr].lpData = (LPSTR) new s_waveSample[sz];
	if (wh[curr].lpData == NULL) return;

	memcpy(wh[curr].lpData, buf, wh[curr].dwBufferLength);

	waveOutPrepareHeader(hwo, (LPWAVEHDR)&wh[curr], sizeof(WAVEHDR));
	waveOutWrite(hwo, (LPWAVEHDR)&wh[curr], sizeof(WAVEHDR));

	curr = (curr + 1) % MAX_WAVE_BUFFERS;
}
