;
;  monoloader generation
;

 			DEVICE	ZXSPECTRUM48

			EMPTYTRD "morphine.trd"

			ORG	51200
BinaryFile:		INCBIN	"morphine.megalz"
BinaryEnd:
FileLength:		EQU	BinaryEnd-BinaryFile
TempFileLength:		EQU	FileLength/256
			IF	FileLength=TempFileLength*256
SectorLength:		EQU	TempFileLength
			ELSE
SectorLength:		EQU	TempFileLength+1
			ENDIF
			DISPLAY	"chosen sector length is ", /D, SectorLength

			MACRO	BasicInteger x
			db	14, 0, 0
			dw	x
			db	0
			ENDM

			DEFINE	BASIC_PROG 23867

			ORG	BASIC_PROG
BasicStart:		dw	1			; this is line "1"
			dw	BasicEnd-BasicStart	; length of the current line
			db	253, '0'		; "CLEAR 0"...
			BasicInteger 24575		; which is actually 24575
			db	':'
			db	253, 192, '0'		; "CLEAR USR 0"...
			BasicInteger AsmLoader
			db	':'
			db	249, 192, '0'		; "RANDOMIZE USR 0"...
			BasicInteger 15619		; which is actually 15619
			db	':'
			db	234, ':', 247		; REM: RUN "        "
			db	'"'
NameToRun:		db	"        "
			db	'"'
			db	':'
			db	234, "introspec ", 127, "2013", 16, 7, 17, 7

AsmLoader:		di
			ld	a, 1
			out	(254), a
			ld	hl, 22528+768-1
			ld	de, 22528+768-2
			ld	bc, 767
			ld	(hl), %00001001
			lddr
			ld	hl, 51200
			ld	de, (23796)		; the next sector
			ld	bc, 5+SectorLength*256
			call	15635
			ld	a, 1
			out	(254), a
			ld	hl, 51200
			ld	de, 24576
			call	Decompress
			exx
			push	hl
			push	iy
			call	28952
			ld	de, NameToRun
			ld	bc, 8
			ldir
			pop	iy
			pop	hl
			exx
			ld	bc, 65535
			ret

Decompress:		INCLUDE	"megalz.asm"

			db	#80, #AA, 1, 0		; tr-dos autostart, i think
BasicEnd:		EQU	$

			SAVETRD	"morphine.trd", "boot.B", BasicStart, BasicEnd-BasicStart
			SAVETRD	"morphine.trd", "morphine.C", BinaryFile, FileLength

			ORG	16384
FigureFile:		INCBIN	"figure.bin"
			SAVETRD	"morphine.trd", "figure.C", FigureFile, $-FigureFile
			ORG	16384
MusicFile:		INCBIN	"music.bin"
			SAVETRD	"morphine.trd", "music.C", MusicFile, $-MusicFile



